/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifiable;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.wso2.ballerinalang.compiler.util.Names;

public class FieldAccessCompletionResolver
extends NodeTransformer<Optional<TypeSymbol>> {
    private final PositionedOperationContext context;

    public FieldAccessCompletionResolver(PositionedOperationContext context) {
        this.context = context;
    }

    public Optional<TypeSymbol> transform(SimpleNameReferenceNode node) {
        Optional<TypeSymbol> typeSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node));
        if (typeSymbol.isPresent()) {
            return typeSymbol;
        }
        List visibleSymbols = this.context.visibleSymbols(this.context.getCursorPosition());
        return this.getSymbolByName(visibleSymbols, node.name().text()).flatMap(SymbolUtil::getTypeDescriptor);
    }

    public Optional<TypeSymbol> transform(FieldAccessExpressionNode node) {
        Optional typeSymbol = (Optional)node.expression().apply((NodeTransformer)this);
        NameReferenceNode fieldName = node.fieldName();
        if (fieldName.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE || typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        String name = ((SimpleNameReferenceNode)fieldName).name().text();
        List<Symbol> visibleEntries = this.getVisibleEntries((TypeSymbol)typeSymbol.get(), (Node)node.expression());
        Optional<Symbol> filteredSymbol = this.getSymbolByName(visibleEntries, name);
        if (filteredSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor(filteredSymbol.get());
    }

    public Optional<TypeSymbol> transform(OptionalFieldAccessExpressionNode node) {
        Optional resolvedType = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node));
        if (resolvedType.isPresent() && ((TypeSymbol)resolvedType.get()).typeKind() != TypeDescKind.COMPILATION_ERROR) {
            return SymbolUtil.getTypeDescriptor((Symbol)resolvedType.get());
        }
        Optional typeSymbol = (Optional)node.expression().apply((NodeTransformer)this);
        NameReferenceNode fieldName = node.fieldName();
        if (fieldName.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE || typeSymbol.isEmpty()) {
            return Optional.empty();
        }
        String name = ((SimpleNameReferenceNode)fieldName).name().text();
        List<Symbol> visibleEntries = this.getVisibleEntries((TypeSymbol)typeSymbol.get(), (Node)node.expression());
        Optional<Symbol> filteredSymbol = this.getSymbolByName(visibleEntries, name);
        if (filteredSymbol.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor(filteredSymbol.get());
    }

    public Optional<TypeSymbol> transform(FunctionCallExpressionNode node) {
        String functionName;
        List<Symbol> visibleEntries;
        NameReferenceNode nameRef = node.functionName();
        Predicate<Symbol> fSymbolPredicate = symbol -> symbol.kind() == SymbolKind.FUNCTION;
        Predicate<Symbol> fPointerPredicate = symbol -> symbol.kind() == SymbolKind.VARIABLE && CommonUtil.getRawType(((VariableSymbol)symbol).typeDescriptor()).typeKind() == TypeDescKind.FUNCTION;
        if (nameRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nameRef;
            visibleEntries = QNameRefCompletionUtil.getModuleContent(this.context, qNameRef, fSymbolPredicate.or(fPointerPredicate));
            functionName = qNameRef.identifier().text();
        } else if (nameRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            functionName = ((SimpleNameReferenceNode)nameRef).name().text();
            visibleEntries = this.context.visibleSymbols(this.context.getCursorPosition()).stream().filter(fSymbolPredicate.or(fPointerPredicate)).toList();
        } else {
            return Optional.empty();
        }
        Optional<Symbol> functionSymbol = this.getSymbolByName(visibleEntries, functionName);
        if (functionSymbol.isPresent() && fSymbolPredicate.test(functionSymbol.get())) {
            return ((FunctionSymbol)functionSymbol.get()).typeDescriptor().returnTypeDescriptor();
        }
        if (functionSymbol.isPresent() && fPointerPredicate.test(functionSymbol.get())) {
            TypeSymbol rawType = CommonUtil.getRawType(((VariableSymbol)functionSymbol.get()).typeDescriptor());
            return ((FunctionTypeSymbol)rawType).returnTypeDescriptor();
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(IndexedExpressionNode node) {
        Optional containerType = (Optional)node.containerExpression().apply((NodeTransformer)this);
        TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)containerType.orElseThrow());
        if (rawType.typeKind() == TypeDescKind.ARRAY) {
            return Optional.of(((ArrayTypeSymbol)rawType).memberTypeDescriptor());
        }
        if (rawType.typeKind() == TypeDescKind.MAP) {
            return Optional.of(((MapTypeSymbol)rawType).typeParam());
        }
        return ((SemanticModel)this.context.currentSemanticModel().get()).typeOf((Node)node);
    }

    public Optional<TypeSymbol> transform(BracedExpressionNode node) {
        return (Optional)node.expression().apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(TemplateExpressionNode templateExpressionNode) {
        return this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)templateExpressionNode)).map(CommonUtil::getRawType);
    }

    protected Optional<TypeSymbol> transformSyntaxNode(Node node) {
        if (node instanceof ExpressionNode) {
            return ((SemanticModel)this.context.currentSemanticModel().get()).typeOf(node);
        }
        return Optional.empty();
    }

    public List<Symbol> getVisibleEntries(Node node) {
        Optional<TypeSymbol> typeSymbol = this.getTypeSymbol(node);
        return typeSymbol.map(tSymbol -> this.getVisibleEntries((TypeSymbol)tSymbol, node)).orElse(Collections.emptyList());
    }

    public Optional<TypeSymbol> getTypeSymbol(Node node) {
        return (Optional)node.apply((NodeTransformer)this);
    }

    private Optional<Symbol> getSymbolByName(List<Symbol> visibleSymbols, String name) {
        return visibleSymbols.stream().filter(symbol -> symbol.nameEquals(name) && symbol.kind() != SymbolKind.TYPE_DEFINITION).findFirst();
    }

    private List<Symbol> getVisibleEntries(TypeSymbol typeSymbol, Node node) {
        ArrayList<Symbol> visibleEntries = new ArrayList();
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
        switch (rawType.typeKind()) {
            case RECORD: {
                ArrayList filteredEntries = new ArrayList(((RecordTypeSymbol)rawType).fieldDescriptors().values());
                visibleEntries.addAll(filteredEntries);
                break;
            }
            case OBJECT: {
                Optional<Package> currentPkg = this.context.workspace().project(this.context.filePath()).map(Project::currentPackage);
                Optional currentModule = this.context.currentModule();
                if (currentModule.isEmpty() || currentPkg.isEmpty()) break;
                ObjectTypeSymbol objTypeDesc = (ObjectTypeSymbol)rawType;
                visibleEntries.addAll(objTypeDesc.fieldDescriptors().values().stream().filter(objectFieldSymbol -> this.withValidAccessModifiers(node, (Symbol)objectFieldSymbol, (Package)currentPkg.get(), ((Module)currentModule.get()).moduleId())).toList());
                boolean isClient = SymbolUtil.isClient((Symbol)objTypeDesc);
                boolean isService = SymbolUtil.getTypeDescForObjectSymbol((Symbol)objTypeDesc).qualifiers().contains(Qualifier.SERVICE);
                List<MethodSymbol> methodSymbols = objTypeDesc.methods().values().stream().filter(methodSymbol -> (!isClient && !isService || !methodSymbol.qualifiers().contains(Qualifier.REMOTE)) && !methodSymbol.qualifiers().contains(Qualifier.RESOURCE) && this.withValidAccessModifiers(node, (Symbol)methodSymbol, (Package)currentPkg.get(), ((Module)currentModule.get()).moduleId())).toList();
                visibleEntries.addAll(methodSymbols);
                break;
            }
            case UNION: {
                List<TypeSymbol> members;
                if (node.parent().kind() != SyntaxKind.OPTIONAL_FIELD_ACCESS || ((UnionTypeSymbol)rawType).memberTypeDescriptors().size() != 2 || !(members = ((UnionTypeSymbol)rawType).memberTypeDescriptors().stream().map(CommonUtil::getRawType).toList()).stream().allMatch(member -> member.typeKind() == TypeDescKind.NIL || member.typeKind() == TypeDescKind.RECORD)) break;
                TypeSymbol recordType = members.stream().filter(member -> member.typeKind() == TypeDescKind.RECORD).findFirst().get();
                visibleEntries.addAll(new ArrayList(((RecordTypeSymbol)recordType).fieldDescriptors().values()));
                break;
            }
            case TYPE_REFERENCE: {
                visibleEntries = this.getVisibleEntries(rawType, node);
                break;
            }
        }
        visibleEntries.addAll(typeSymbol.langLibMethods());
        return visibleEntries;
    }

    private boolean withValidAccessModifiers(Node exprNode, Symbol symbol, Package currentPackage, ModuleId currentModule) {
        Optional project = this.context.workspace().project(this.context.filePath());
        Optional symbolModule = symbol.getModule();
        if (project.isEmpty() || symbolModule.isEmpty()) {
            return false;
        }
        boolean isPrivate = false;
        boolean isPublic = false;
        boolean isResource = false;
        if (symbol instanceof Qualifiable) {
            Qualifiable qSymbol = (Qualifiable)symbol;
            isPrivate = qSymbol.qualifiers().contains(Qualifier.PRIVATE);
            isPublic = qSymbol.qualifiers().contains(Qualifier.PUBLIC);
            isResource = qSymbol.qualifiers().contains(Qualifier.RESOURCE);
        }
        if (exprNode.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE && ((SimpleNameReferenceNode)exprNode).name().text().equals(Names.SELF.getValue()) && !isResource) {
            return true;
        }
        ModuleID objModuleId = ((ModuleSymbol)symbolModule.get()).id();
        return isPublic || !isPrivate && objModuleId.moduleName().equals(currentModule.moduleName()) && objModuleId.orgName().equals(currentPackage.packageOrg().value());
    }
}

