/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.completions.builder.CompletionItemBuilder;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextEdit;

public class SnippetBlock
extends CompletionItemBuilder {
    private final String label;
    private final String detail;
    private final String snippet;
    private final Kind kind;
    private final String filterText;
    private final Pair<String, String>[] imports;
    private String id;

    public SnippetBlock(String label, String filterText, String snippet, String detail, Kind kind) {
        this.label = label;
        this.filterText = filterText;
        this.snippet = snippet;
        this.detail = detail;
        this.kind = kind;
        this.imports = null;
    }

    public SnippetBlock(String label, String filterText, String snippet, String detail, Kind kind, Pair<String, String> ... importsByOrgAndAlias) {
        this.label = label;
        this.filterText = filterText;
        this.snippet = snippet;
        this.detail = detail;
        this.kind = kind;
        this.imports = importsByOrgAndAlias;
    }

    public CompletionItem build(BallerinaCompletionContext ctx) {
        CompletionItem completionItem = new CompletionItem();
        String insertText = this.snippet;
        if (this.imports != null) {
            ArrayList<TextEdit> importTextEdits = new ArrayList<TextEdit>();
            for (Pair<String, String> pair : this.imports) {
                Optional<ImportDeclarationNode> matchedImport = ModuleUtil.matchingImportedModule((DocumentServiceContext)ctx, (String)pair.getLeft(), (String)pair.getRight());
                if (matchedImport.isEmpty()) {
                    importTextEdits.addAll(CommonUtil.getAutoImportTextEdits((String)pair.getLeft(), (String)pair.getRight(), (DocumentServiceContext)ctx));
                    continue;
                }
                if (!matchedImport.get().prefix().isPresent()) continue;
                insertText = this.snippet.replace((String)pair.getRight() + ":", ((ImportPrefixNode)matchedImport.get().prefix().get()).prefix().text() + ":");
            }
            completionItem.setAdditionalTextEdits(importTextEdits);
        }
        completionItem.setInsertText(insertText);
        if (!this.label.isEmpty()) {
            completionItem.setLabel(this.label);
        }
        if (!this.detail.isEmpty()) {
            completionItem.setDetail(this.detail);
        }
        if (!this.filterText.isEmpty()) {
            completionItem.setFilterText(this.filterText);
        }
        completionItem.setKind(this.getKind(this));
        return completionItem;
    }

    public String getString() {
        return this.snippet;
    }

    public String getLabel() {
        return this.label;
    }

    public Kind kind() {
        return this.kind;
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public void setId(String id) {
        this.id = id;
    }

    public static enum Kind {
        KEYWORD,
        SNIPPET,
        STATEMENT,
        TYPE,
        VALUE;

    }
}

