/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import java.util.Arrays;
import java.util.List;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.completions.util.SnippetBlock;

public final class SnippetGenerator {
    private static final String FILTER_TEXT_SEPARATOR = "_";

    private SnippetGenerator() {
    }

    public static SnippetBlock getAnnotationDefSnippet() {
        String snippet = "annotation ${1:typeName} ${2:name} on ${3:attachmentPoint};";
        return new SnippetBlock("annotation", "annotation", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getOnSnippet() {
        return new SnippetBlock("on", "on", "on ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getNewKeywordSnippet() {
        return new SnippetBlock("new", "new", "new ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getDefaultKeywordSnippet() {
        return new SnippetBlock("default", "default", "default", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getAbstractKeywordSnippet() {
        return new SnippetBlock("abstract", "abstract", "abstract ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getClientKeywordSnippet() {
        return new SnippetBlock("client", "client", "client ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getReadonlyKeywordSnippet() {
        return new SnippetBlock("readonly", "readonly", "readonly ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getExternalKeywordSnippet() {
        return new SnippetBlock("external", "external", "external;", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getTypeofKeywordSnippet() {
        return new SnippetBlock("typeof", "typeof", "typeof ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getIsKeywordSnippet() {
        return new SnippetBlock("is", "is", "is", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getIfKeywordSnippet() {
        return new SnippetBlock("if", "if", "if", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getAscendingKeywordSnippet() {
        return new SnippetBlock("ascending", "ascending", "ascending", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getDescendingKeywordSnippet() {
        return new SnippetBlock("descending", "descending", "descending", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getTransactionalKeywordSnippet() {
        return new SnippetBlock("transactional", "transactional", "transactional", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getBreakSnippet() {
        return new SnippetBlock("break", "break", "break;", "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getCheckKeywordSnippet() {
        return new SnippetBlock("check", "check", "check ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getCheckPanicKeywordSnippet() {
        return new SnippetBlock("checkpanic", "checkpanic", "checkpanic ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getWaitKeywordSnippet() {
        return new SnippetBlock("wait", "wait", "wait ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getStartKeywordSnippet() {
        return new SnippetBlock("start", "start", "start ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getAsKeywordSnippet() {
        return new SnippetBlock("as", "as", "as ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getFromKeywordSnippet() {
        return new SnippetBlock("from", "from", "from ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getWhereKeywordSnippet() {
        return new SnippetBlock("where", "where", "where ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getJoinKeywordSnippet() {
        return new SnippetBlock("join", "join", "join ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getOuterKeywordSnippet() {
        return new SnippetBlock("outer", "outer", "outer ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getOrderByKeywordSnippet() {
        return new SnippetBlock("order by", "order by", "order by ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getGroupByKeywordSnippet() {
        return new SnippetBlock("group by", "group by", "group by ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getCollectKeywordSnippet() {
        return new SnippetBlock("collect", "collect", "collect ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getLimitKeywordSnippet() {
        return new SnippetBlock("limit", "limit", "limit ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getSelectKeywordSnippet() {
        return new SnippetBlock("select", "select", "select ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getEqualsKeywordSnippet() {
        return new SnippetBlock("equals", "equals", "equals ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getFlushKeywordSnippet() {
        return new SnippetBlock("flush", "flush", "flush ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getImportKeywordSnippet() {
        return new SnippetBlock("import", "import", "import ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getFunctionKeywordSnippet() {
        return new SnippetBlock("function", "function", "function ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getResourceKeywordSnippet() {
        return new SnippetBlock("resource", "resource", "resource ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getContinueStatmentSnippet() {
        return new SnippetBlock("continue", "continue", "continue;", "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getListenerKeywordSnippet() {
        return new SnippetBlock("listener", "listener", "listener ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getReturnsKeywordSnippet() {
        return new SnippetBlock("returns", "returns", "returns ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getUntaintKeywordSnippet() {
        return new SnippetBlock("untainted", "untainted", "untainted ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getForeachSnippet() {
        String snippet = "foreach ${1:var} ${2:item} in ${3:itemList} {" + CommonUtil.LINE_SEPARATOR + "\t${4}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("foreach", "foreach", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getForeachRangeExpressionSnippet() {
        String snippet = "foreach ${1:int} ${2:i} in ${3:0}...${4:9} {" + CommonUtil.LINE_SEPARATOR + "\t${5}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("foreach i", "foreach", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getForkStatementSnippet() {
        String snippet = "fork {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("fork", "fork", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getFunctionDefSnippet() {
        String snippet = "function ${1:name}(${2})${3} {" + CommonUtil.LINE_SEPARATOR + "\t${4}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("function", "function", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getExpressionBodiedFunctionDefSnippet() {
        String snippet = "function ${1:name}(${2})${3} => (${4});";
        return new SnippetBlock("function <name>(..) => <expression>", "function", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getResourceFunctionDefSnippet() {
        String snippet = "function ${1:accessor} ${2:path} (${3})${4} {" + CommonUtil.LINE_SEPARATOR + "\t${5}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("resource function", "function", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getResourceFunctionSignatureSnippet() {
        String snippet = "resource function ${1:accessor} ${2:path}(${3})${4} {" + CommonUtil.LINE_SEPARATOR + "\t${5}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("resource function", SnippetGenerator.generateFilterText(Arrays.asList("resource", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getFunctionSignatureSnippet() {
        String snippet = "function ${1:name}(${2})${3};";
        return new SnippetBlock("function <name>();", "function", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getIfStatementSnippet() {
        String snippet = "if ${1:true} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("if", "if", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getElseIfStatementSnippet() {
        String snippet = "else if ${1:true} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("else if", "else", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getElseStatementSnippet() {
        String snippet = "else {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("else", "else", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getLockStatementSnippet() {
        String snippet = "lock {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("lock", "lock", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getMatchStatementSnippet() {
        return new SnippetBlock("match", "match", "match ", "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getXMLNSDeclarationSnippet() {
        String snippet = "xmlns \"${1}\" as ${2:ns};";
        return new SnippetBlock("xmlns", "xmlns", snippet, "Snippet", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getObjectTypeDescSnippet() {
        String snippet = "object {${1}}";
        return new SnippetBlock("object {}", "object", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getObjectDefinitionSnippet() {
        String snippet = "type ${1:ObjectName} object {${2}};";
        return new SnippetBlock("type <ObjectName> object", SnippetGenerator.generateFilterText(Arrays.asList("type", "object")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getPublicKeywordSnippet() {
        return new SnippetBlock("public", "public", "public ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getIsolatedKeywordSnippet() {
        return new SnippetBlock("isolated", "isolated", "isolated ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getPrivateKeywordSnippet() {
        return new SnippetBlock("private", "private", "private ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getTypeKeywordSnippet() {
        return new SnippetBlock("type", "type", "type ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getRecordKeywordSnippet() {
        return new SnippetBlock("record", "record", "record ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getObjectKeywordSnippet() {
        return new SnippetBlock("object", "object", "object ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getAnnotationKeywordSnippet() {
        return new SnippetBlock("annotation", "annotation", "annotation ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getRecordTypeDescSnippet() {
        String snippet = "record {${1}}";
        return new SnippetBlock("record {}", "record", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getRecordDefinitionSnippet() {
        String snippet = "type ${1:RecordName} record {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "};";
        return new SnippetBlock("type <RecordName> record {}", SnippetGenerator.generateFilterText(Arrays.asList("type", "record")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getErrorTypeDefinitionSnippet() {
        String snippet = "type ${1:ErrorName} error<${2:map<anydata>}>;";
        return new SnippetBlock("type <ErrorName> error<?>", SnippetGenerator.generateFilterText(Arrays.asList("type", "error")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getErrorTypeDescSnippet() {
        String snippet = "error<${1:map<anydata>}>;";
        return new SnippetBlock("type <ErrorName> error<?>", "error", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getTableTypeDescSnippet() {
        String snippet = "type ${1:TypeName} table<${2}>;";
        return new SnippetBlock("type TypeName table<>;", SnippetGenerator.generateFilterText(Arrays.asList("type", "table")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getTableWithKeyTypeDescSnippet() {
        String snippet = "type ${1:TypeName} table<${2}> key${3}";
        return new SnippetBlock("type TypeName table<> key", SnippetGenerator.generateFilterText(Arrays.asList("type", "table", "key")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getStreamDefSnippet() {
        String snippet = "stream<${1}> ${2:streamName} = new;";
        return new SnippetBlock("stream<> streamName = new;", "stream", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getClosedRecordTypeDescSnippet() {
        String snippet = "record {|${1}|}";
        return new SnippetBlock("record {||}", "record", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getClosedRecordDefinitionSnippet() {
        String snippet = "type ${1:RecordName} record {|" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "|};";
        return new SnippetBlock("type <RecordName> record {||}", SnippetGenerator.generateFilterText(Arrays.asList("type", "record")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getReturnStatementSnippet() {
        return new SnippetBlock("return", "return", "return ", "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getReturnSCStatementSnippet() {
        return new SnippetBlock("return;", "return;", "return;", "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getCommonServiceSnippet() {
        String snippet = "service on ${1:listenerName} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("service", "service", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getClassDefSnippet() {
        String snippet = "class ${1:className} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("class", "class", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getEnumDefSnippet() {
        String snippet = "enum ${1:enumName} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("enum", "enum", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getErrorConstructorSnippet() {
        String snippet = "error(\"${1}\")";
        return new SnippetBlock("error constructor", "error", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getObjectConstructorSnippet() {
        String snippet = "object {${1}}";
        return new SnippetBlock("object constructor", "object", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getBase16LiteralSnippet() {
        String snippet = "base16 `${1}`";
        return new SnippetBlock("base16", "base16", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getBase64LiteralSnippet() {
        String snippet = "base64 `${1}`";
        return new SnippetBlock("base64", "base64", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getPanicStatementSnippet() {
        return new SnippetBlock("panic", "panic", "panic ", "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getConstKeywordSnippet() {
        return new SnippetBlock("const", "const", "const ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getFinalKeywordSnippet() {
        return new SnippetBlock("final", "final", "final ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getConfigurableKeywordSnippet() {
        return new SnippetBlock("configurable", "configurable", "configurable", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getFailKeywordSnippet() {
        return new SnippetBlock("fail", "fail", "fail ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getRemoteKeywordSnippet() {
        return new SnippetBlock("remote", "remote", "remote", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getTransactionStatementSnippet() {
        String snippet = "transaction {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("transaction", "transaction", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getRetryTransactionStatementSnippet() {
        String snippet = "retry transaction {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("retry transaction", SnippetGenerator.generateFilterText(Arrays.asList("retry", "transaction")), snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getRetryStatementSnippet() {
        String snippet = "retry {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("retry", "retry", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getTrapSnippet() {
        String snippet = "trap ";
        return new SnippetBlock("trap", "trap", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getVarKeywordSnippet() {
        return new SnippetBlock("var", "var", "var ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getInKeywordSnippet() {
        return new SnippetBlock("in", "in", "in ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getEnumKeywordSnippet() {
        return new SnippetBlock("enum", "enum", "enum ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getXMLNSKeywordSnippet() {
        return new SnippetBlock("xmlns", "xmlns", "xmlns ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getClassKeywordSnippet() {
        return new SnippetBlock("class", "class", "class ", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getDistinctKeywordSnippet() {
        return new SnippetBlock("distinct", "distinct", "distinct", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getRollbackStatementSnippet() {
        return new SnippetBlock("rollback", "rollback", "rollback;", "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getCommitStatementSnippet() {
        return new SnippetBlock("commit", "commit", "commit;", "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getWhileStatementSnippet() {
        String snippet = "while ${1:true} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("while", "while", snippet, "Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getDoStatementSnippet() {
        return SnippetGenerator.getDoSnippet("Statement", SnippetBlock.Kind.STATEMENT);
    }

    public static SnippetBlock getDoClauseSnippet() {
        return SnippetGenerator.getDoSnippet("Snippet", SnippetBlock.Kind.SNIPPET);
    }

    private static SnippetBlock getDoSnippet(String snippetType, SnippetBlock.Kind snippetBlockKind) {
        String snippet = "do {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("do", "do", snippet, snippetType, snippetBlockKind);
    }

    public static SnippetBlock getFromClauseSnippet() {
        String snippet = "from ${1:var} ${2:item} in ${3}";
        return new SnippetBlock("from clause", "from", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getLetClauseSnippet() {
        String snippet = "let ${1:var} ${2:varName} = ${3}";
        return new SnippetBlock("let clause", "let", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getGroupByClauseSnippet() {
        String snippet = "group by ${1:var} ${2:item} = ${3}";
        return new SnippetBlock("group by clause", "group by", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getJoinClauseSnippet() {
        String snippet = "join ${1:var} ${2:varName} in ${3:expr} on ${4:onExpr} equals ${5:equalsExpr}";
        return new SnippetBlock("join clause", "join", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getOnFailClauseSnippet() {
        String snippet = "on fail ${1:var} ${2:varName} {" + CommonUtil.LINE_SEPARATOR + "\t${3}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("on fail clause", SnippetGenerator.generateFilterText(Arrays.asList("on", "fail")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getOnConflictClauseSnippet() {
        String snippet = "on conflict ";
        return new SnippetBlock("on conflict", SnippetGenerator.generateFilterText(Arrays.asList("on", "conflict")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getWorkerDeclarationSnippet() {
        String snippet = "worker ${1:name} {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("worker", "worker", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getRemoteFunctionSnippet() {
        String snippet = "remote function ${1:name}(${2})${3} {" + CommonUtil.LINE_SEPARATOR + "\t${4}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("remote function <name>();", SnippetGenerator.generateFilterText(Arrays.asList("remote", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getRemoteMethodDeclSnippet() {
        String snippet = "remote function ${1:name}(${2})${3};";
        return new SnippetBlock("remote function <name>();", SnippetGenerator.generateFilterText(Arrays.asList("remote", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getInitFunctionSnippet() {
        String snippet = "function init(${1}) {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("init function", SnippetGenerator.generateFilterText(Arrays.asList("init", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getAttachFunctionSnippet() {
        String snippet = "public function attach(service ${1:s}, string? ${2:name} = ()) returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${3}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("attach function", SnippetGenerator.generateFilterText(Arrays.asList("attach", "public", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getStartFunctionSnippet() {
        String snippet = "public function 'start() returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("start function", SnippetGenerator.generateFilterText(Arrays.asList("start", "public", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getGracefulStopFunctionSnippet() {
        String snippet = "public function gracefulStop() returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("graceful stop function", SnippetGenerator.generateFilterText(Arrays.asList("gracefulStop", "public", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getImmediateStopFunctionSnippet() {
        String snippet = "public function immediateStop() returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("immediate stop function", SnippetGenerator.generateFilterText(Arrays.asList("immediateStop", "public", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getDetachFunctionSnippet() {
        String snippet = "public function __detach(service ${1:s}) returns error? {" + CommonUtil.LINE_SEPARATOR + "\t${2}" + CommonUtil.LINE_SEPARATOR + "}";
        return new SnippetBlock("detach function", SnippetGenerator.generateFilterText(Arrays.asList("detach", "public", "function")), snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getRegularExpressionSnippet() {
        String snippet = "re `${1}`";
        return new SnippetBlock("re ``", "re ``", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getStringSnippet() {
        String snippet = "string `${1}`";
        return new SnippetBlock("string ``", "string ``", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getXmlSnippet() {
        String snippet = "xml `${1}`";
        return new SnippetBlock("xml ``", "xml ``", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getNaturalSnippet() {
        String snippet = "natural (${1}) {${2}}";
        return new SnippetBlock("natural (..) {..}", "natural (..) {..}", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getParanthesisSnippet() {
        return new SnippetBlock("()", "()", "(${1})", "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getSquareBracketSnippet() {
        return new SnippetBlock("[]", "[]", "[${1}]", "Snippet", SnippetBlock.Kind.SNIPPET);
    }

    public static SnippetBlock getTableKeywordSnippet() {
        return new SnippetBlock("table", "table", "table", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getServiceKeywordSnippet() {
        return new SnippetBlock("service", "service", "service", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getStringKeywordSnippet() {
        return new SnippetBlock("string", "string", "string", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getXMLKeywordSnippet() {
        return new SnippetBlock("xml", "xml", "xml", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getLetKeywordSnippet() {
        return new SnippetBlock("let", "let", "let", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getKeyKeywordSnippet() {
        return new SnippetBlock("key", "key", "key", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getTrapKeywordSnippet() {
        return new SnippetBlock("trap", "trap", "trap", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getErrorKeywordSnippet() {
        return new SnippetBlock("error", "error", "error", "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static SnippetBlock getMapTypeSnippet() {
        return new SnippetBlock("map", "map", "map", "type ", SnippetBlock.Kind.TYPE);
    }

    public static SnippetBlock getKeywordSnippet(String keyword) {
        return new SnippetBlock(keyword, keyword, keyword, "Keyword", SnippetBlock.Kind.KEYWORD);
    }

    public static String generateFilterText(List<String> filters) {
        return String.join((CharSequence)FILTER_TEXT_SEPARATOR, filters);
    }
}

