/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.FutureTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeDescTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Project;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.FunctionPointerCompletionItem;
import org.ballerinalang.langserver.completions.ObjectFieldCompletionItem;
import org.ballerinalang.langserver.completions.RecordFieldCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.TypeCompletionItem;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SnippetBlock;
import org.eclipse.lsp4j.CompletionItemKind;

public final class SortingUtil {
    private static final int RANK_UPPER_BOUNDARY = 64;
    private static final int RANK_LOWER_BOUNDARY = 90;
    private static final int RANK_RANGE = 25;
    private static final String BALLERINA_ORG = "ballerina";
    private static final String LANG_LIB_PKG_PREFIX = "lang.";
    private static final String LANG_LIB_LABEL_PREFIX = "ballerina/lang.";
    private static final String BAL_LIB_LABEL_PREFIX = "ballerina/";

    private SortingUtil() {
    }

    public static boolean isModuleCompletionItem(LSCompletionItem item) {
        return item instanceof SymbolCompletionItem && ((SymbolCompletionItem)item).getSymbol().orElse(null) instanceof ModuleSymbol || item instanceof StaticCompletionItem && (((StaticCompletionItem)item).kind() == StaticCompletionItem.Kind.MODULE || ((StaticCompletionItem)item).kind() == StaticCompletionItem.Kind.LANG_LIB_MODULE);
    }

    public static boolean isTypeCompletionItem(LSCompletionItem item) {
        if (item.getType() == LSCompletionItem.CompletionItemType.SYMBOL) {
            SymbolCompletionItem symbolCompletionItem = (SymbolCompletionItem)item;
            Optional<Symbol> symbol = symbolCompletionItem.getSymbol();
            return symbol.isPresent() && (symbol.get().kind() == SymbolKind.TYPE || symbol.get().kind() == SymbolKind.TYPE_DEFINITION || symbol.get().kind() == SymbolKind.CLASS || symbol.get().kind() == SymbolKind.CONSTANT);
        }
        if (item.getType() == LSCompletionItem.CompletionItemType.STATIC && ((StaticCompletionItem)item).kind() == StaticCompletionItem.Kind.TYPE) {
            return true;
        }
        return item.getType() == LSCompletionItem.CompletionItemType.TYPE || item instanceof TypeCompletionItem;
    }

    public static boolean isLangLibModuleCompletionItem(LSCompletionItem item) {
        if (item.getType() == LSCompletionItem.CompletionItemType.SYMBOL && ((SymbolCompletionItem)item).getSymbol().filter(symbol -> symbol.kind() == SymbolKind.MODULE).isPresent()) {
            Optional<Symbol> symbol2 = ((SymbolCompletionItem)item).getSymbol();
            return symbol2.isPresent() && CommonUtil.isLangLib(((ModuleSymbol)symbol2.get()).id());
        }
        return false;
    }

    public static String genSortTextForModule(BallerinaCompletionContext context, LSCompletionItem item) {
        Optional currentProject = context.workspace().project(context.filePath());
        String currentOrg = ((Project)currentProject.get()).currentPackage().packageOrg().value();
        String currentPkgName = ((Project)currentProject.get()).currentPackage().packageName().value();
        String label = item.getCompletionItem().getLabel();
        int rank = -1;
        if (item instanceof SymbolCompletionItem && ((SymbolCompletionItem)item).getSymbol().isPresent() && ((SymbolCompletionItem)item).getSymbol().get().kind() == SymbolKind.MODULE) {
            ModuleSymbol moduleSymbol = (ModuleSymbol)((SymbolCompletionItem)item).getSymbol().get();
            String orgName = moduleSymbol.id().orgName();
            String moduleName = moduleSymbol.id().moduleName();
            rank = currentOrg.equals(orgName) && moduleName.startsWith(currentPkgName + ".") ? 1 : (BALLERINA_ORG.equals(orgName) && !moduleName.startsWith(LANG_LIB_PKG_PREFIX) ? 2 : (BALLERINA_ORG.equals(orgName) ? 3 : 4));
        } else if (label.startsWith(LANG_LIB_LABEL_PREFIX)) {
            rank = 5;
        } else if (label.startsWith(BAL_LIB_LABEL_PREFIX)) {
            rank = 6;
        }
        rank = rank < 0 ? 7 : rank;
        return SortingUtil.genSortText(rank);
    }

    public static String genSortTextForTypeDescContext(BallerinaCompletionContext context, LSCompletionItem item) {
        if (item.getType() == LSCompletionItem.CompletionItemType.SYMBOL) {
            String moduleName;
            Optional<Symbol> symbol = ((SymbolCompletionItem)item).getSymbol();
            if (symbol.isEmpty()) {
                return SortingUtil.genSortText(7);
            }
            Optional currentProject = context.workspace().project(context.filePath());
            String currentOrg = ((Project)currentProject.get()).currentPackage().packageOrg().value();
            String currentPkgName = ((Project)currentProject.get()).currentPackage().packageName().value();
            Optional symbolModule = symbol.get().getModule();
            String orgName = symbolModule.isPresent() ? ((ModuleSymbol)symbolModule.get()).id().orgName() : "";
            String string = moduleName = symbolModule.isPresent() ? ((ModuleSymbol)symbolModule.get()).id().moduleName() : "";
            if (CommonUtil.isLangLib(orgName, moduleName) && !moduleName.equals("lang.annotations")) {
                return SortingUtil.genSortText(7);
            }
            if (symbol.get().kind() == SymbolKind.CONSTANT) {
                return SortingUtil.genSortText(4);
            }
            if (symbol.get().kind() == SymbolKind.ENUM) {
                return SortingUtil.genSortText(5);
            }
            if (symbol.get().kind() == SymbolKind.ENUM_MEMBER) {
                return SortingUtil.genSortText(5);
            }
            String sortPrefix = currentOrg.equals(orgName) && currentPkgName.equals(moduleName) ? SortingUtil.genSortText(1) : SortingUtil.genSortText(2);
            return sortPrefix + SortingUtil.genSortText(SortingUtil.toRank(context, item));
        }
        if (SortingUtil.isModuleCompletionItem(item)) {
            return SortingUtil.genSortText(3) + SortingUtil.genSortTextForModule(context, item);
        }
        if (item.getType() == LSCompletionItem.CompletionItemType.SNIPPET && ((SnippetCompletionItem)item).kind() == SnippetBlock.Kind.TYPE) {
            return SortingUtil.genSortText(8);
        }
        return SortingUtil.genSortText(SortingUtil.toRank(context, item, 8));
    }

    public static String genSortTextByAssignability(BallerinaCompletionContext context, LSCompletionItem completionItem, TypeSymbol typeSymbol) {
        if (SortingUtil.isCompletionItemAssignable(completionItem, typeSymbol)) {
            return SortingUtil.genSortText(1) + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem));
        }
        if (typeSymbol.typeKind() == TypeDescKind.FUNCTION) {
            CompletionItemKind completionItemKind = completionItem.getCompletionItem().getKind();
            if (completionItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL && completionItemKind == CompletionItemKind.Function) {
                return SortingUtil.genSortText(2) + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem));
            }
            if (completionItem.getType() == LSCompletionItem.CompletionItemType.SNIPPET) {
                if (((SnippetCompletionItem)completionItem).id().equals("function (..) {..}")) {
                    return SortingUtil.genSortText(3) + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem));
                }
                if (((SnippetCompletionItem)completionItem).id().equals(Snippet.KW_FUNCTION.name())) {
                    return SortingUtil.genSortText(4) + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem));
                }
            }
        }
        return SortingUtil.genSortText(SortingUtil.toRank(context, completionItem, 4));
    }

    public static boolean isCompletionItemAssignable(LSCompletionItem completionItem, TypeSymbol typeSymbol) {
        Optional<TypeSymbol> optionalTypeParamTypeSymbol;
        Optional<Symbol> optionalSymbol;
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
        if (rawType.typeKind() == TypeDescKind.TYPEDESC && completionItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL && (optionalSymbol = ((SymbolCompletionItem)completionItem).getSymbol()).isPresent() && (optionalSymbol.get().kind() == SymbolKind.TYPE_DEFINITION || optionalSymbol.get().kind() == SymbolKind.TYPE || optionalSymbol.get().kind() == SymbolKind.CLASS) && (optionalTypeParamTypeSymbol = SortingUtil.getTypeParameterFromTypeSymbol(rawType)).isPresent()) {
            Optional<TypeSymbol> optionalTypeSymbol = SortingUtil.getSymbolFromCompletionItem(completionItem);
            return optionalTypeSymbol.isPresent() && optionalTypeSymbol.get().subtypeOf(optionalTypeParamTypeSymbol.get());
        }
        if (completionItem.getCompletionItem().getKind() == CompletionItemKind.TypeParameter) {
            return false;
        }
        Optional<TypeSymbol> optionalTypeSymbol = SortingUtil.getSymbolFromCompletionItem(completionItem);
        return optionalTypeSymbol.isPresent() && optionalTypeSymbol.get().subtypeOf(rawType);
    }

    public static Optional<TypeSymbol> getTypeParameterFromTypeSymbol(TypeSymbol typeSymbol) {
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.TYPEDESC -> ((TypeDescTypeSymbol)typeSymbol).typeParameter();
            case TypeDescKind.FUTURE -> ((FutureTypeSymbol)typeSymbol).typeParameter();
            default -> Optional.empty();
        };
    }

    public static boolean isCompletionItemAssignableWithCheck(LSCompletionItem completionItem, TypeSymbol typeSymbol) {
        Optional<TypeSymbol> optionalTypeSymbol = SortingUtil.getSymbolFromCompletionItem(completionItem);
        if (optionalTypeSymbol.isEmpty() || optionalTypeSymbol.get().typeKind() != TypeDescKind.UNION) {
            return false;
        }
        TypeSymbol rawTypeSymbol = CommonUtil.getRawType(typeSymbol);
        UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)optionalTypeSymbol.get();
        return CodeActionUtil.hasErrorMemberType(unionTypeSymbol) && unionTypeSymbol.memberTypeDescriptors().stream().map(CommonUtil::getRawType).anyMatch(type -> type.subtypeOf(rawTypeSymbol));
    }

    public static Optional<TypeSymbol> getSymbolFromCompletionItem(LSCompletionItem completionItem) {
        Optional<Object> optionalTypeSymbol = Optional.empty();
        switch (completionItem.getType()) {
            case SYMBOL: {
                optionalTypeSymbol = ((SymbolCompletionItem)completionItem).getSymbol().flatMap(symbol -> SymbolUtil.getTypeDescriptor(symbol).flatMap(typeDesc -> {
                    if (symbol instanceof FunctionSymbol) {
                        return ((FunctionTypeSymbol)typeDesc).returnTypeDescriptor();
                    }
                    return Optional.of(typeDesc);
                }));
                break;
            }
            case OBJECT_FIELD: {
                ObjectFieldSymbol fieldSymbol = ((ObjectFieldCompletionItem)completionItem).getFieldSymbol();
                optionalTypeSymbol = SymbolUtil.getTypeDescriptor((Symbol)fieldSymbol);
                break;
            }
            case RECORD_FIELD: {
                RecordFieldSymbol fieldSymbol = ((RecordFieldCompletionItem)completionItem).getFieldSymbol();
                optionalTypeSymbol = SymbolUtil.getTypeDescriptor((Symbol)fieldSymbol);
                break;
            }
            case FUNCTION_POINTER: {
                optionalTypeSymbol = ((FunctionPointerCompletionItem)completionItem).getSymbol().flatMap(SymbolUtil::getTypeDescriptor);
            }
        }
        return optionalTypeSymbol;
    }

    public static String genSortText(int rank) {
        if (rank < 1) {
            throw new IllegalArgumentException("Rank should be greater than zero");
        }
        int suffixValue = rank % 25;
        String suffix = suffixValue == 0 ? "" : String.valueOf((char)(64 + suffixValue));
        String prefix = String.join((CharSequence)"", Collections.nCopies((rank - suffixValue) / 25, "Z"));
        return prefix + suffix;
    }

    public static Optional<TypeSymbol> getAssignableType(BallerinaCompletionContext context, Node owner) {
        Optional<TypeDescriptorNode> typeDesc;
        switch (owner.kind()) {
            case LISTENER_DECLARATION: {
                typeDesc = Optional.ofNullable(((ListenerDeclarationNode)owner).typeDescriptor().orElse(null));
                break;
            }
            case LOCAL_VAR_DECL: {
                typeDesc = Optional.ofNullable(((VariableDeclarationNode)owner).typedBindingPattern().typeDescriptor());
                break;
            }
            case MODULE_VAR_DECL: {
                typeDesc = Optional.ofNullable(((ModuleVariableDeclarationNode)owner).typedBindingPattern().typeDescriptor());
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        if (typeDesc.isEmpty()) {
            return Optional.empty();
        }
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        if (((Node)typeDesc.get()).kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)typeDesc.get();
            String alias = QNameRefCompletionUtil.getAlias(qNameRef);
            Optional<ModuleSymbol> moduleSymbol = ModuleUtil.searchModuleForAlias((PositionedOperationContext)context, alias);
            if (moduleSymbol.isEmpty()) {
                return Optional.empty();
            }
            String identifier = qNameRef.identifier().text();
            return ModuleUtil.getTypeFromModule(context, alias, identifier);
        }
        if (((Node)typeDesc.get()).kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            String nameRef = ((SimpleNameReferenceNode)typeDesc.get()).name().text();
            for (Symbol symbol : visibleSymbols) {
                if (symbol.kind() != SymbolKind.TYPE_DEFINITION || !((String)symbol.getName().get()).equals(nameRef)) continue;
                TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)symbol;
                return Optional.of(typeDefinitionSymbol.typeDescriptor());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static void toDefaultSorting(BallerinaCompletionContext context, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem item : completionItems) {
            int rank = SortingUtil.toRank(context, item);
            item.getCompletionItem().setSortText(SortingUtil.genSortText(rank));
        }
    }

    public static int toRank(BallerinaCompletionContext context, LSCompletionItem completionItem) {
        return SortingUtil.toRank(context, completionItem, 0);
    }

    public static int toRank(BallerinaCompletionContext context, LSCompletionItem completionItem, int rankOffset) {
        boolean onQnameRef = QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor());
        int rank = -1;
        CompletionItemKind completionItemKind = completionItem.getCompletionItem().getKind();
        block0 : switch (completionItem.getType()) {
            case SYMBOL: 
            case FUNCTION_POINTER: {
                if (completionItemKind == null) break;
                switch (completionItemKind) {
                    case Constant: {
                        rank = onQnameRef ? 2 : 1;
                        break block0;
                    }
                    case Variable: {
                        rank = onQnameRef ? 3 : 2;
                        break block0;
                    }
                    case Function: {
                        rank = onQnameRef ? 1 : 3;
                        rank = completionItem.getCompletionItem().getLabel().startsWith("main(") ? 25 : rank;
                        break block0;
                    }
                    case Method: {
                        rank = 4;
                        break block0;
                    }
                    case Constructor: {
                        rank = 5;
                        break block0;
                    }
                    case EnumMember: {
                        rank = 8;
                        break block0;
                    }
                    case Enum: {
                        rank = 9;
                        break block0;
                    }
                    case Class: {
                        rank = 10;
                        break block0;
                    }
                    case Interface: {
                        rank = 11;
                        break block0;
                    }
                    case Event: {
                        rank = 12;
                        break block0;
                    }
                    case Struct: {
                        rank = 13;
                        break block0;
                    }
                    case TypeParameter: {
                        rank = 14;
                        break block0;
                    }
                    case Module: {
                        rank = 15;
                        break block0;
                    }
                }
                break;
            }
            case SNIPPET: {
                if (completionItemKind == null) break;
                rank = switch (completionItemKind) {
                    case CompletionItemKind.TypeParameter -> 14;
                    case CompletionItemKind.Snippet -> 16;
                    case CompletionItemKind.Keyword -> 17;
                    default -> rank;
                };
                break;
            }
            case OBJECT_FIELD: {
                rank = 6;
                break;
            }
            case RECORD_FIELD: {
                rank = 7;
            }
        }
        rank = rank == -1 ? 18 : rankOffset + rank;
        return rank;
    }

    public static boolean isSymbolCItemWithinNodeAndCursor(BallerinaCompletionContext context, LSCompletionItem lsCItem, Node startNode) {
        if (lsCItem.getType() != LSCompletionItem.CompletionItemType.SYMBOL || ((SymbolCompletionItem)lsCItem).getSymbol().isEmpty()) {
            return false;
        }
        return ((SymbolCompletionItem)lsCItem).getSymbol().get().getLocation().filter(location -> startNode.textRange().startOffset() < location.textRange().startOffset()).filter(location -> location.textRange().endOffset() < context.getCursorPositionInTree()).isPresent();
    }

    public static Optional<QueryExpressionNode> getTheOutermostQueryExpressionNode(Node clauseNode) {
        Node evalNode1 = clauseNode;
        Node evalNode2 = clauseNode;
        while (evalNode1.parent() != null) {
            if (evalNode1.kind() == SyntaxKind.QUERY_EXPRESSION) {
                evalNode2 = evalNode1;
            }
            evalNode1 = evalNode1.parent();
        }
        if (evalNode2.kind() == SyntaxKind.QUERY_EXPRESSION) {
            return Optional.of((QueryExpressionNode)evalNode2);
        }
        return Optional.empty();
    }

    public static void sortCompletionsAfterConfigurableQualifier(CompletionContext context, List<LSCompletionItem> completionItems, Boolean onQualifiedNamedIdentifier) {
        if (onQualifiedNamedIdentifier.booleanValue()) {
            completionItems.forEach(lsCompletionItem -> {
                Optional<TypeSymbol> typeSymbol;
                String sortText = SortingUtil.genSortText(2);
                Types types = ((SemanticModel)context.currentSemanticModel().get()).types();
                if (lsCompletionItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL && (typeSymbol = SortingUtil.getSymbolFromCompletionItem(lsCompletionItem)).isPresent() && typeSymbol.get().subtypeOf(types.ANYDATA)) {
                    sortText = SortingUtil.genSortText(1);
                }
                lsCompletionItem.getCompletionItem().setSortText(sortText);
            });
            return;
        }
        TypeSymbol anydataType = ((SemanticModel)context.currentSemanticModel().get()).types().ANYDATA;
        completionItems.forEach(lsCompletionItem -> {
            Optional<Symbol> symbol;
            String sortText = lsCompletionItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL ? ((symbol = ((SymbolCompletionItem)((Object)lsCompletionItem)).getSymbol()).isPresent() && symbol.get() instanceof TypeSymbol && ((TypeSymbol)symbol.get()).subtypeOf(anydataType) ? SortingUtil.genSortText(1) : SortingUtil.genSortText(3)) : (lsCompletionItem.getCompletionItem().getKind() == CompletionItemKind.TypeParameter || lsCompletionItem.getCompletionItem().getKind() == CompletionItemKind.Struct ? SortingUtil.genSortText(2) : (lsCompletionItem.getCompletionItem().getKind() == CompletionItemKind.Module ? SortingUtil.genSortText(3) : SortingUtil.genSortText(4)));
            lsCompletionItem.getCompletionItem().setSortText(sortText);
        });
    }
}

