/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.contexts;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.DiagnosticState;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.WorkspaceServiceContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Position;

public class AbstractWorkspaceServiceContext
implements WorkspaceServiceContext {
    private final LSOperation operation;
    private final WorkspaceManager workspaceManager;
    private final LanguageServerContext languageServerContext;
    private final Map<String, List<Symbol>> visibleSymbols = new HashMap<String, List<Symbol>>();

    AbstractWorkspaceServiceContext(LSOperation operation, WorkspaceManager wsManager, LanguageServerContext serverContext) {
        this.operation = operation;
        this.workspaceManager = wsManager;
        this.languageServerContext = serverContext;
    }

    public LSOperation operation() {
        return this.operation;
    }

    public LanguageServerContext languageServercontext() {
        return this.languageServerContext;
    }

    public List<Symbol> visibleSymbols(Path filePath, Position position) {
        return this.visibleSymbols.computeIfAbsent(filePath.toUri().toString(), k -> {
            Optional semanticModel = this.workspaceManager.semanticModel(filePath);
            Optional srcFile = this.workspaceManager.document(filePath);
            if (semanticModel.isEmpty() || srcFile.isEmpty()) {
                return Collections.emptyList();
            }
            return ((SemanticModel)semanticModel.get()).visibleSymbols((Document)srcFile.get(), LinePosition.from((int)position.getLine(), (int)position.getCharacter()), new DiagnosticState[]{DiagnosticState.VALID, DiagnosticState.REDECLARED});
        });
    }

    public WorkspaceManager workspace() {
        return this.workspaceManager;
    }

    protected static abstract class AbstractContextBuilder<T extends AbstractContextBuilder<T>> {
        protected final LSOperation operation;
        protected WorkspaceManager wsManager;
        protected LanguageServerContext serverContext;

        public AbstractContextBuilder(LSOperation lsOperation, LanguageServerContext serverContext) {
            this.operation = lsOperation;
            this.serverContext = serverContext;
        }

        public T withWorkspaceManager(WorkspaceManager workspaceManager) {
            this.wsManager = workspaceManager;
            return this.self();
        }

        public WorkspaceServiceContext build() {
            return new AbstractWorkspaceServiceContext(this.operation, this.wsManager, this.serverContext);
        }

        public abstract T self();
    }
}

