/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.eventsync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.eventsync.EventKind;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.eventsync.spi.EventSubscriber;
import org.ballerinalang.langserver.eventsync.EventPublisher;

public class EventSyncPubSubHolder {
    private static final LanguageServerContext.Key<EventSyncPubSubHolder> SUBSCRIBERS_HOLDER_KEY = new LanguageServerContext.Key();
    private static final Map<EventKind, EventPublisher> publisherMap = new HashMap<EventKind, EventPublisher>();

    private EventSyncPubSubHolder(LanguageServerContext serverContext) {
        LSClientLogger lsClientLogger = LSClientLogger.getInstance(serverContext);
        this.initialize(lsClientLogger);
        serverContext.put(SUBSCRIBERS_HOLDER_KEY, (Object)this);
    }

    private void initialize(LSClientLogger lsClientLogger) {
        HashMap<EventKind, List> eventSubscribersMap = new HashMap<EventKind, List>();
        ServiceLoader<EventSubscriber> subscribers = ServiceLoader.load(EventSubscriber.class);
        for (EventSubscriber eventSubscriber : subscribers) {
            EventKind eventKind = eventSubscriber.eventKind();
            eventSubscribersMap.computeIfAbsent(eventKind, k -> new ArrayList());
            ((List)eventSubscribersMap.get(eventKind)).add(eventSubscriber);
        }
        ServiceLoader<EventPublisher> publishers = ServiceLoader.load(EventPublisher.class);
        publishers.forEach(eventPublisher -> {
            publisherMap.put(eventPublisher.getKind(), (EventPublisher)eventPublisher);
            for (EventSubscriber eventSubscriber : (List)eventSubscribersMap.get(eventPublisher.getKind())) {
                eventPublisher.subscribe(eventSubscriber);
                lsClientLogger.logTrace(String.format("%s subscribed to %s", eventSubscriber.getName(), eventPublisher.getName()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventSyncPubSubHolder getInstance(LanguageServerContext serverContext) {
        EventSyncPubSubHolder subscribersHolder = (EventSyncPubSubHolder)serverContext.get(SUBSCRIBERS_HOLDER_KEY);
        if (subscribersHolder == null) {
            LanguageServerContext.Key<EventSyncPubSubHolder> key = SUBSCRIBERS_HOLDER_KEY;
            synchronized (key) {
                subscribersHolder = (EventSyncPubSubHolder)serverContext.get(SUBSCRIBERS_HOLDER_KEY);
                if (subscribersHolder == null) {
                    subscribersHolder = new EventSyncPubSubHolder(serverContext);
                }
            }
        }
        return subscribersHolder;
    }

    public EventPublisher getPublisher(EventKind eventKind) throws EventSyncException {
        if (!publisherMap.containsKey(eventKind)) {
            throw new EventSyncException("No publishers for the event kind");
        }
        return publisherMap.get(eventKind);
    }

    public List<EventPublisher> getPublishers(List<EventKind> eventKinds) throws EventSyncException {
        ArrayList<EventPublisher> eventPublishers = new ArrayList<EventPublisher>();
        for (EventKind eventKind : eventKinds) {
            if (!publisherMap.containsKey(eventKind)) {
                throw new EventSyncException("No publishers for the event kind");
            }
            eventPublishers.add(publisherMap.get(eventKind));
        }
        return eventPublishers;
    }
}

