/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.document;

import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.syntaxapicallsgen.SyntaxApiCallsGen;
import io.ballerina.syntaxapicallsgen.config.SyntaxApiCallsGenConfig;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.diagramutil.DiagramUtil;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.command.executors.PullModuleExecutor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.BallerinaDefinitionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManagerProxy;
import org.ballerinalang.langserver.contexts.ContextBuilder;
import org.ballerinalang.langserver.definition.DefinitionUtil;
import org.ballerinalang.langserver.diagnostic.DiagnosticsHelper;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaLocateSyntaxTreeUtil;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaProjectParams;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaSyntaxTreeByNameRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaSyntaxTreeByRangeRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaSyntaxTreeModifyRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaSyntaxTreeRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaSyntaxTreeResponse;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaTreeModifyUtil;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaTriggerModifyRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaTriggerModifyUtil;
import org.ballerinalang.langserver.extensions.ballerina.document.DocumentContext;
import org.ballerinalang.langserver.extensions.ballerina.document.ExecutorPositionsResponse;
import org.ballerinalang.langserver.extensions.ballerina.document.ExecutorPositionsUtil;
import org.ballerinalang.langserver.extensions.ballerina.document.SyntaxApiCallsRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.SyntaxApiCallsResponse;
import org.ballerinalang.langserver.extensions.ballerina.document.SyntaxTreeNodeRequest;
import org.ballerinalang.langserver.extensions.ballerina.document.SyntaxTreeNodeResponse;
import org.ballerinalang.langserver.extensions.ballerina.document.visitor.FindNodes;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageMetadataResponse;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="ballerinaDocument")
public class BallerinaDocumentService
implements ExtendedLanguageServerService {
    protected static final String MINUTIAE = "WHITESPACE_MINUTIAE";
    private WorkspaceManagerProxy workspaceManagerProxy;
    private LSClientLogger clientLogger;
    private LanguageServerContext serverContext;

    public void init(LanguageServer langServer, WorkspaceManagerProxy workspaceManagerProxy, LanguageServerContext serverContext) {
        this.workspaceManagerProxy = workspaceManagerProxy;
        this.serverContext = serverContext;
        this.clientLogger = LSClientLogger.getInstance(serverContext);
    }

    @JsonRequest
    public CompletableFuture<SyntaxApiCallsResponse> syntaxApiCalls(SyntaxApiCallsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            SyntaxApiCallsResponse reply = new SyntaxApiCallsResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
            if (filePath.isEmpty()) {
                return reply;
            }
            try {
                Optional srcFile = this.workspaceManagerProxy.get().document(filePath.get());
                if (srcFile.isEmpty()) {
                    return reply;
                }
                SyntaxApiCallsGenConfig syntaxApiCallsGenConfig = new SyntaxApiCallsGenConfig.Builder().ignoreMinutiae(request.getIgnoreMinutiae()).build();
                String srcContent = ((Document)srcFile.get()).textDocument().toString();
                String javaCode = SyntaxApiCallsGen.generate((String)srcContent, (SyntaxApiCallsGenConfig)syntaxApiCallsGenConfig);
                reply.setSource(((Document)srcFile.get()).syntaxTree().toSourceCode());
                reply.setCode(javaCode);
                reply.setParseSuccess(reply.getCode() != null);
            }
            catch (Throwable e) {
                reply.setParseSuccess(false);
                String msg = "Operation 'ballerinaDocument/syntaxApiCalls' failed!";
                this.clientLogger.logError(DocumentContext.DC_SYNTAX_API_CALLS, msg, e, request.getDocumentIdentifier(), new Position[]{null});
            }
            return reply;
        });
    }

    @JsonRequest
    public CompletableFuture<BallerinaSyntaxTreeResponse> syntaxTree(BallerinaSyntaxTreeRequest request) {
        BallerinaSyntaxTreeResponse reply = new BallerinaSyntaxTreeResponse();
        String fileUri = request.getDocumentIdentifier().getUri();
        Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
        if (filePath.isEmpty()) {
            return CompletableFuture.supplyAsync(() -> reply);
        }
        try {
            Optional srcFile = this.workspaceManagerProxy.get().document(filePath.get());
            if (srcFile.isEmpty()) {
                return CompletableFuture.supplyAsync(() -> reply);
            }
            Optional semanticModel = this.workspaceManagerProxy.get().semanticModel(filePath.get());
            JsonElement jsonSyntaxTree = DiagramUtil.getSyntaxTreeJSON((Document)((Document)srcFile.get()), (SemanticModel)((SemanticModel)semanticModel.get()));
            reply.setSource(((Document)srcFile.get()).syntaxTree().toSourceCode());
            reply.setSyntaxTree(jsonSyntaxTree);
            reply.setParseSuccess(reply.getSyntaxTree() != null);
        }
        catch (Throwable e) {
            reply.setParseSuccess(false);
            String msg = "Operation 'ballerinaDocument/syntaxTree' failed!";
            this.clientLogger.logError(DocumentContext.DC_SYNTAX_TREE, msg, e, request.getDocumentIdentifier(), new Position[]{null});
        }
        return CompletableFuture.supplyAsync(() -> reply);
    }

    @JsonRequest
    public CompletableFuture<BallerinaSyntaxTreeResponse> syntaxTreeByRange(BallerinaSyntaxTreeByRangeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaSyntaxTreeResponse reply = new BallerinaSyntaxTreeResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
            if (filePath.isEmpty()) {
                return reply;
            }
            try {
                Optional srcFile = this.workspaceManagerProxy.get().document(filePath.get());
                if (srcFile.isEmpty()) {
                    return reply;
                }
                Optional semanticModel = this.workspaceManagerProxy.get().semanticModel(filePath.get());
                SyntaxTree syntaxTree = ((Document)srcFile.get()).syntaxTree();
                NonTerminalNode node = CommonUtil.findNode(request.getLineRange(), syntaxTree);
                JsonElement subSyntaxTreeJSON = DiagramUtil.getSyntaxTreeJSON((NonTerminalNode)node, (SemanticModel)((SemanticModel)semanticModel.get()));
                reply.setSource(node.toSourceCode());
                reply.setSyntaxTree(subSyntaxTreeJSON);
                reply.setParseSuccess(reply.getSyntaxTree() != null);
                return reply;
            }
            catch (Throwable e) {
                reply.setParseSuccess(false);
                String msg = "Operation 'ballerinaDocument/syntaxTreeByRange' failed!";
                this.clientLogger.logError(DocumentContext.DC_SYNTAX_TREE_BY_RANGE, msg, e, request.getDocumentIdentifier(), new Position[]{null});
                return reply;
            }
        });
    }

    @JsonRequest
    public CompletableFuture<BallerinaSyntaxTreeResponse> syntaxTreeLocate(BallerinaSyntaxTreeByRangeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaSyntaxTreeResponse reply = new BallerinaSyntaxTreeResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
            if (filePath.isEmpty()) {
                return reply;
            }
            try {
                Optional srcFile = this.workspaceManagerProxy.get().document(filePath.get());
                if (srcFile.isEmpty()) {
                    return reply;
                }
                Optional semanticModel = this.workspaceManagerProxy.get().semanticModel(filePath.get());
                SyntaxTree syntaxTree = ((Document)srcFile.get()).syntaxTree();
                JsonElement syntaxTreeJSON = DiagramUtil.getSyntaxTreeJSON((Document)((Document)srcFile.get()), (SemanticModel)((SemanticModel)semanticModel.get()));
                syntaxTreeJSON = BallerinaLocateSyntaxTreeUtil.mapNodePath(request.getLineRange(), syntaxTree, syntaxTreeJSON);
                reply.setSyntaxTree(syntaxTreeJSON);
                reply.setSource(((Document)srcFile.get()).syntaxTree().toSourceCode());
                reply.setParseSuccess(reply.getSyntaxTree() != null);
                return reply;
            }
            catch (Throwable e) {
                reply.setParseSuccess(false);
                String msg = "Operation 'ballerinaDocument/syntaxTreeLocate' failed!";
                this.clientLogger.logError(DocumentContext.DC_SYNTAX_TREE_LOCATE, msg, e, request.getDocumentIdentifier(), new Position[]{null});
                return reply;
            }
        });
    }

    @JsonRequest
    public CompletableFuture<BallerinaSyntaxTreeResponse> syntaxTreeModify(BallerinaSyntaxTreeModifyRequest request) {
        BallerinaSyntaxTreeResponse reply = new BallerinaSyntaxTreeResponse();
        String fileUri = request.getDocumentIdentifier().getUri();
        Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
        if (filePath.isEmpty()) {
            reply.setParseSuccess(false);
            return CompletableFuture.supplyAsync(() -> reply);
        }
        try {
            JsonElement syntaxTreeWithSource = BallerinaTreeModifyUtil.modifyTree(request.getAstModifications(), filePath.get(), this.workspaceManagerProxy.get());
            reply.setSource(syntaxTreeWithSource.getAsJsonObject().get("source").getAsString());
            reply.setSyntaxTree(syntaxTreeWithSource.getAsJsonObject().get("tree"));
            reply.setParseSuccess(reply.getSyntaxTree() != null);
        }
        catch (Throwable e) {
            reply.setParseSuccess(false);
            String msg = "Operation 'ballerinaDocument/syntaxTreeModify' failed!";
            this.clientLogger.logError(DocumentContext.DC_SYNTAX_TREE_MODIFY, msg, e, request.getDocumentIdentifier(), new Position[]{null});
        }
        return CompletableFuture.supplyAsync(() -> reply);
    }

    @JsonRequest
    public CompletableFuture<BallerinaSyntaxTreeResponse> triggerModify(BallerinaTriggerModifyRequest request) {
        BallerinaSyntaxTreeResponse reply = new BallerinaSyntaxTreeResponse();
        String fileUri = request.getDocumentIdentifier().getUri();
        Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
        if (filePath.isEmpty()) {
            return CompletableFuture.supplyAsync(() -> reply);
        }
        try {
            JsonElement syntaxTreeWithSource = BallerinaTriggerModifyUtil.modifyTrigger(request.getType(), request.getConfig(), filePath.get(), this.workspaceManagerProxy.get());
            reply.setSource(syntaxTreeWithSource.getAsJsonObject().get("source").getAsString());
            reply.setSyntaxTree(syntaxTreeWithSource.getAsJsonObject().get("tree"));
            reply.setParseSuccess(reply.getSyntaxTree() != null);
        }
        catch (Throwable e) {
            reply.setParseSuccess(false);
            String msg = "Operation 'ballerinaDocument/ast' failed!";
            this.clientLogger.logError(DocumentContext.DC_AST, msg, e, request.getDocumentIdentifier(), new Position[]{null});
        }
        return CompletableFuture.supplyAsync(() -> reply);
    }

    @JsonRequest
    public CompletableFuture<BallerinaSyntaxTreeResponse> syntaxTreeByName(BallerinaSyntaxTreeByNameRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaSyntaxTreeResponse reply = new BallerinaSyntaxTreeResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
            WorkspaceManager workspaceManager = this.workspaceManagerProxy.get(fileUri);
            try {
                Optional srcFile = workspaceManager.document(filePath.get());
                Optional semanticModel = workspaceManager.semanticModel(filePath.get());
                int lineValue = request.getLineRange().getStart().getLine();
                int charValue = request.getLineRange().getStart().getCharacter();
                Optional functionSymbol = ((SemanticModel)semanticModel.get()).symbol((Document)srcFile.get(), LinePosition.from((int)lineValue, (int)charValue));
                if (functionSymbol.isEmpty()) {
                    return reply;
                }
                String functionPath = ((Location)((Symbol)functionSymbol.get()).getLocation().get()).lineRange().fileName();
                Optional project = workspaceManager.project(filePath.get());
                ((Project)project.get()).currentPackage().modules().forEach(module -> module.documentIds().forEach(id -> {
                    Document document = module.document(id);
                    if (functionPath.equals(document.name())) {
                        SyntaxTree st = document.syntaxTree();
                        FindNodes findNodes = new FindNodes();
                        findNodes.visit((ModulePartNode)st.rootNode());
                        List<FunctionDefinitionNode> functionNodes = findNodes.getFunctionDefinitionNodes();
                        functionNodes.forEach(node -> {
                            boolean withinRange;
                            int nodeStartLine = node.lineRange().startLine().line();
                            int nodeEndLine = node.lineRange().endLine().line();
                            int symbolLine = ((Location)((Symbol)functionSymbol.get()).getLocation().get()).lineRange().startLine().line();
                            boolean bl = withinRange = nodeStartLine <= symbolLine && nodeEndLine >= symbolLine;
                            if (((Symbol)functionSymbol.get()).nameEquals(node.functionName().text()) && withinRange) {
                                PackageCompilation packageCompilation = document.module().packageInstance().getCompilation();
                                SemanticModel semanticModelNew = packageCompilation.getSemanticModel(document.module().moduleId());
                                Path defFilePathLocation = PathUtil.getPathFromLocation(module, (Location)node.location());
                                reply.setSource(node.toSourceCode());
                                reply.setSyntaxTree(DiagramUtil.getSyntaxTreeJSON((NonTerminalNode)node, (SemanticModel)semanticModelNew));
                                reply.setParseSuccess(reply.getSyntaxTree() != null);
                                reply.setDefFilePath(defFilePathLocation.toUri().toString());
                            }
                        });
                    }
                }));
                return reply;
            }
            catch (Throwable e) {
                reply.setParseSuccess(false);
                String msg = "Operation 'ballerinaDocument/syntaxTreeByName' failed!";
                this.clientLogger.logError(DocumentContext.DC_SYNTAX_TREE_BY_NAME, msg, e, request.getDocumentIdentifier(), new Position[]{null});
                return reply;
            }
        });
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    @JsonRequest
    public CompletableFuture<PackageMetadataResponse> project(BallerinaProjectParams params) {
        return CompletableFuture.supplyAsync(() -> {
            PackageMetadataResponse ballerinaProject = new PackageMetadataResponse();
            try {
                Optional<Path> filePath = PathUtil.getPathFromURI(params.getDocumentIdentifier().getUri());
                if (filePath.isEmpty()) {
                    return ballerinaProject;
                }
                Optional project = this.workspaceManagerProxy.get().project(filePath.get());
                if (project.isEmpty()) {
                    return ballerinaProject;
                }
                ballerinaProject.setOrgName(((Project)project.get()).currentPackage().packageOrg().value());
                ballerinaProject.setPath(((Project)project.get()).sourceRoot().toString());
                ProjectKind projectKind = ((Project)project.get()).kind();
                if (projectKind != ProjectKind.SINGLE_FILE_PROJECT) {
                    ballerinaProject.setPackageName(((Project)project.get()).currentPackage().packageName().value());
                }
                ballerinaProject.setKind(projectKind.name());
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaDocument/project' failed!";
                this.clientLogger.logError(DocumentContext.DC_PROJECT, msg, e, params.getDocumentIdentifier(), new Position[]{null});
            }
            return ballerinaProject;
        });
    }

    @JsonRequest
    public CompletableFuture<List<PublishDiagnosticsParams>> diagnostics(BallerinaProjectParams params) {
        return CompletableFuture.supplyAsync(() -> {
            String fileUri = URLDecoder.decode(params.getDocumentIdentifier().getUri(), StandardCharsets.UTF_8);
            try {
                DocumentServiceContext context = ContextBuilder.buildDocumentServiceContext(fileUri, this.workspaceManagerProxy.get(fileUri), LSContextOperation.DOC_DIAGNOSTICS, this.serverContext);
                DiagnosticsHelper diagnosticsHelper = DiagnosticsHelper.getInstance(this.serverContext);
                return diagnosticsHelper.getLatestDiagnostics(context).entrySet().stream().filter(entry -> fileUri.equals(entry.getKey())).map(entry -> new PublishDiagnosticsParams((String)entry.getKey(), (List)entry.getValue())).toList();
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaDocument/diagnostics' failed!";
                this.clientLogger.logError(DocumentContext.DC_DIAGNOSTICS, msg, e, params.getDocumentIdentifier(), new Position[]{null});
                return Collections.emptyList();
            }
        });
    }

    @JsonRequest
    public CompletableFuture<SyntaxTreeNodeResponse> syntaxTreeNode(SyntaxTreeNodeRequest params) {
        return CompletableFuture.supplyAsync(() -> {
            SyntaxTreeNodeResponse syntaxTreeNodeResponse = new SyntaxTreeNodeResponse();
            try {
                Optional<Path> filePath = PathUtil.getPathFromURI(params.getDocumentIdentifier().getUri());
                if (filePath.isEmpty()) {
                    return syntaxTreeNodeResponse;
                }
                SyntaxTree syntaxTree = (SyntaxTree)this.workspaceManagerProxy.get().syntaxTree(filePath.get()).orElseThrow();
                NonTerminalNode currentNode = CommonUtil.findNode(params.getRange(), syntaxTree);
                LinePosition startLine = currentNode.lineRange().startLine();
                LinePosition endLine = currentNode.lineRange().endLine();
                Range cursor = params.getRange();
                if ((startLine.line() < cursor.getStart().getLine() || startLine.line() == cursor.getStart().getLine() && startLine.offset() < cursor.getStart().getCharacter()) && (endLine.line() > cursor.getEnd().getLine() || endLine.line() == cursor.getEnd().getLine() && endLine.offset() > cursor.getEnd().getCharacter())) {
                    syntaxTreeNodeResponse.setKind(currentNode.kind().name());
                } else {
                    syntaxTreeNodeResponse.setKind(MINUTIAE);
                }
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaDocument/syntaxTreeNode' failed!";
                this.clientLogger.logError(DocumentContext.DC_SYNTAX_TREE_NODE, msg, e, params.getDocumentIdentifier(), new Position[]{null});
            }
            return syntaxTreeNodeResponse;
        });
    }

    @JsonRequest
    public CompletableFuture<ExecutorPositionsResponse> executorPositions(BallerinaProjectParams params) {
        return CompletableFuture.supplyAsync(() -> {
            ExecutorPositionsResponse response = new ExecutorPositionsResponse();
            try {
                String fileUri = params.getDocumentIdentifier().getUri();
                Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
                if (filePath.isEmpty()) {
                    return response;
                }
                response.setExecutorPositions(ExecutorPositionsUtil.getExecutorPositions(this.workspaceManagerProxy.get(), filePath.get()));
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaDocument/executorPositions' failed!";
                this.clientLogger.logError(DocumentContext.DC_EXEC_POSITION, msg, e, params.getDocumentIdentifier(), new Position[]{null});
            }
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<BallerinaSyntaxTreeResponse> resolveMissingDependencies(BallerinaSyntaxTreeRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaSyntaxTreeResponse reply = new BallerinaSyntaxTreeResponse();
            String fileUri = request.getDocumentIdentifier().getUri();
            Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
            if (filePath.isEmpty()) {
                return reply;
            }
            try {
                Optional semanticModel = this.workspaceManagerProxy.get().semanticModel(filePath.get());
                if (semanticModel.isEmpty()) {
                    reply.setParseSuccess(false);
                    return reply;
                }
                if (!CommonUtil.hasUnresolvedModules((SemanticModel)semanticModel.get())) {
                    reply.setParseSuccess(true);
                    return reply;
                }
                PullModuleExecutor.resolveModules(fileUri, (ExtendedLanguageClient)this.serverContext.get(ExtendedLanguageClient.class), this.workspaceManagerProxy.get(fileUri), this.serverContext);
                reply.setParseSuccess(true);
            }
            catch (Throwable e) {
                reply.setParseSuccess(false);
                String msg = "Operation 'ballerinaDocument/resolveMissingDependencies' failed!";
                this.clientLogger.logError(DocumentContext.DC_RESOLVE_MISSING_DEPENDENCIES, msg, e, request.getDocumentIdentifier(), new Position[]{null});
            }
            return reply;
        });
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<BallerinaSyntaxTreeResponse> syntaxTreeNodeByPosition(TextDocumentPositionParams params) {
        BallerinaSyntaxTreeResponse reply = new BallerinaSyntaxTreeResponse();
        return CompletableFutures.computeAsync(cancelChecker -> {
            try {
                BallerinaDefinitionContext defContext = ContextBuilder.buildDefinitionContext(PathUtil.convertUriSchemeFromBala(params.getTextDocument().getUri()), this.workspaceManagerProxy.get(), this.serverContext, params.getPosition(), cancelChecker);
                Either getLocationPositionList = Either.forLeft(DefinitionUtil.getDefinition(defContext, params.getPosition()));
                List leftLocations = (List)getLocationPositionList.getLeft();
                org.eclipse.lsp4j.Location location = (org.eclipse.lsp4j.Location)leftLocations.get(0);
                String fileUri = location.getUri();
                Optional<Path> filePath = PathUtil.getPathFromURI(fileUri);
                Optional srcFile = this.workspaceManagerProxy.get().document(filePath.get());
                Optional semanticModel = this.workspaceManagerProxy.get().semanticModel(filePath.get());
                SyntaxTree syntaxTree = ((Document)srcFile.get()).syntaxTree();
                NonTerminalNode node = CommonUtil.findNode(location.getRange(), syntaxTree);
                JsonElement subSyntaxTreeJSON = DiagramUtil.getSyntaxTreeJSON((NonTerminalNode)node, (SemanticModel)((SemanticModel)semanticModel.get()));
                reply.setSource(node.toSourceCode());
                reply.setSyntaxTree(subSyntaxTreeJSON);
                reply.setParseSuccess(reply.getSyntaxTree() != null);
                reply.setDefFilePath(fileUri);
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaDocument/syntaxTreeNodeByPosition' failed!";
                this.clientLogger.logError(DocumentContext.DC_NODE_DEFINITION_BY_POSITION, msg, e, params.getTextDocument(), params.getPosition());
            }
            return reply;
        });
    }
}

