/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.packages;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.tools.text.LineRange;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.extensions.ballerina.packages.DataObject;
import org.ballerinalang.langserver.extensions.ballerina.packages.MapperObject;
import org.ballerinalang.langserver.extensions.ballerina.packages.ModuleObject;

public class DocumentComponentTransformer
extends NodeTransformer<Optional<MapperObject>> {
    private final ModuleObject module;

    DocumentComponentTransformer(ModuleObject moduleObject) {
        this.module = moduleObject;
    }

    public ModuleObject getModuleObject(Node node) {
        this.transformSyntaxNode(node);
        return this.module;
    }

    public Optional<MapperObject> transformSyntaxNode(Node node) {
        if (!(node instanceof NonTerminalNode)) {
            return Optional.empty();
        }
        NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
        nonTerminalNode.children().forEach(child -> {
            Optional mapperObject = (Optional)child.apply((NodeTransformer)this);
            if (mapperObject != null) {
                mapperObject.ifPresent(this.module::addDataObject);
            }
        });
        return Optional.empty();
    }

    public Optional<MapperObject> transform(FunctionDefinitionNode functionDefinitionNode) {
        if (functionDefinitionNode.functionName().text().equals("main")) {
            return Optional.of(new MapperObject("automations", this.createDataObject("main", (Node)functionDefinitionNode)));
        }
        return Optional.of(new MapperObject("functions", this.createDataObject(functionDefinitionNode.functionName().text(), (Node)functionDefinitionNode)));
    }

    public Optional<MapperObject> transform(ListenerDeclarationNode listenerDeclarationNode) {
        return Optional.of(new MapperObject("listeners", this.createDataObject(listenerDeclarationNode.variableName().text(), (Node)listenerDeclarationNode)));
    }

    public Optional<MapperObject> transform(ServiceDeclarationNode serviceDeclarationNode) {
        String name = serviceDeclarationNode.absoluteResourcePath().stream().map(node -> String.join((CharSequence)"_", node.toString())).collect(Collectors.joining());
        if (name.isEmpty()) {
            name = serviceDeclarationNode.typeDescriptor().map(typeDescriptorNode -> typeDescriptorNode.toSourceCode().strip()).orElse("");
        }
        DataObject dataObject = this.createDataObject(name, (Node)serviceDeclarationNode);
        serviceDeclarationNode.members().forEach(member -> {
            if (member.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)member;
                String resourceName = functionDefinitionNode.functionName().text() + "-" + functionDefinitionNode.relativeResourcePath().stream().map(Node::toSourceCode).collect(Collectors.joining(""));
                dataObject.addResource(this.createDataObject(resourceName, (Node)member));
            } else if (member.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION) {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)member;
                String functionName = functionDefinitionNode.functionName().text();
                dataObject.addFunction(this.createDataObject(functionName, (Node)member));
            }
        });
        return Optional.of(new MapperObject("services", dataObject));
    }

    public Optional<MapperObject> transform(ClassDefinitionNode classDefinitionNode) {
        DataObject dataObject = this.createDataObject(classDefinitionNode.className().text(), (Node)classDefinitionNode);
        classDefinitionNode.members().forEach(member -> {
            if (member.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION) {
                dataObject.addFunction(this.createDataObject(((FunctionDefinitionNode)member).functionName().text(), (Node)member));
            }
        });
        return Optional.of(new MapperObject("classes", dataObject));
    }

    public Optional<MapperObject> transform(TypeDefinitionNode typeDefinitionNode) {
        if (typeDefinitionNode.typeDescriptor().kind() == SyntaxKind.RECORD_TYPE_DESC) {
            return Optional.of(new MapperObject("records", this.createDataObject(typeDefinitionNode.typeName().text(), (Node)typeDefinitionNode)));
        }
        if (typeDefinitionNode.typeDescriptor().kind() == SyntaxKind.OBJECT_TYPE_DESC) {
            return Optional.of(new MapperObject("objects", this.createDataObject(typeDefinitionNode.typeName().text(), (Node)typeDefinitionNode)));
        }
        return Optional.of(new MapperObject("types", this.createDataObject(typeDefinitionNode.typeName().text(), (Node)typeDefinitionNode)));
    }

    public Optional<MapperObject> transform(ModuleVariableDeclarationNode moduleVariableDeclarationNode) {
        Optional<Token> isConfigurable = moduleVariableDeclarationNode.qualifiers().stream().filter(qualifier -> qualifier.kind() == SyntaxKind.CONFIGURABLE_KEYWORD).findFirst();
        if (isConfigurable.isPresent()) {
            return Optional.of(new MapperObject("configurableVariables", this.createDataObject(moduleVariableDeclarationNode.typedBindingPattern().bindingPattern().toString(), (Node)moduleVariableDeclarationNode)));
        }
        return Optional.of(new MapperObject("moduleVariables", this.createDataObject(moduleVariableDeclarationNode.typedBindingPattern().bindingPattern().toString(), (Node)moduleVariableDeclarationNode)));
    }

    public Optional<MapperObject> transform(ConstantDeclarationNode constantDeclarationNode) {
        return Optional.of(new MapperObject("constants", this.createDataObject(constantDeclarationNode.variableName().text(), (Node)constantDeclarationNode)));
    }

    public Optional<MapperObject> transform(EnumDeclarationNode enumDeclarationNode) {
        return Optional.of(new MapperObject("enums", this.createDataObject(enumDeclarationNode.identifier().text(), (Node)enumDeclarationNode)));
    }

    private DataObject createDataObject(String name, Node node) {
        LineRange lineRange = node.lineRange();
        return new DataObject(name, lineRange.fileName(), lineRange.startLine().line(), lineRange.startLine().offset(), lineRange.endLine().line(), lineRange.endLine().offset());
    }
}

