/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.runner;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.extensions.ballerina.runner.BallerinaRunnerUtil;
import org.ballerinalang.langserver.extensions.ballerina.runner.MainFunctionParamsRequest;
import org.ballerinalang.langserver.extensions.ballerina.runner.ProjectDiagnosticsRequest;
import org.ballerinalang.langserver.extensions.ballerina.runner.ProjectDiagnosticsResponse;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="ballerinaRunner")
public class BallerinaRunnerService
implements ExtendedLanguageServerService {
    private WorkspaceManager workspaceManager;
    private LSClientLogger clientLogger;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager, LanguageServerContext serverContext) {
        this.workspaceManager = workspaceManager;
        this.clientLogger = LSClientLogger.getInstance(serverContext);
    }

    @JsonRequest
    public CompletableFuture<ProjectDiagnosticsResponse> diagnostics(ProjectDiagnosticsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ProjectDiagnosticsResponse projectDiagnosticsResponse = new ProjectDiagnosticsResponse();
                Optional<Path> filePath = PathUtil.getPathFromURI(request.getProjectRootIdentifier().getUri());
                if (filePath.isEmpty()) {
                    return projectDiagnosticsResponse;
                }
                Project project = this.workspaceManager.loadProject(filePath.get());
                Map<String, List<Diagnostic>> errorDiagnosticMap = BallerinaRunnerUtil.getErrorDiagnosticMap(this.workspaceManager, project, filePath.get());
                projectDiagnosticsResponse.setErrorDiagnosticMap(errorDiagnosticMap);
                return projectDiagnosticsResponse;
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaRunner/diagnostics' failed!";
                this.clientLogger.logError(RunnerContext.RUNNER_DIAGNOSTICS, msg, e, request.getProjectRootIdentifier(), new Position[]{null});
                return new ProjectDiagnosticsResponse();
            }
        });
    }

    @JsonRequest
    public CompletableFuture<MainFunctionParamsResponse> mainFunctionParams(MainFunctionParamsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Optional<Path> filePath = PathUtil.getPathFromURI(request.getProjectRootIdentifier().getUri());
                if (filePath.isEmpty()) {
                    return new MainFunctionParamsResponse(false, null, null);
                }
                Project project = this.workspaceManager.loadProject(filePath.get());
                Package currentPackage = project.currentPackage();
                for (DocumentId documentId : currentPackage.getDefaultModule().documentIds()) {
                    Document document = currentPackage.getDefaultModule().document(documentId);
                    Node node = document.syntaxTree().rootNode();
                    if (!(node instanceof ModulePartNode)) continue;
                    ModulePartNode modulePartNode = (ModulePartNode)node;
                    for (ModuleMemberDeclarationNode member : modulePartNode.members()) {
                        FunctionDefinitionNode functionDefinitionNode;
                        if (member.kind() != SyntaxKind.FUNCTION_DEFINITION || !(functionDefinitionNode = (FunctionDefinitionNode)member).functionName().text().equals("main")) continue;
                        ArrayList<TypeBindingPair> params = new ArrayList<TypeBindingPair>();
                        for (ParameterNode param : functionDefinitionNode.functionSignature().parameters()) {
                            if (param.kind() == SyntaxKind.REST_PARAM) {
                                return new MainFunctionParamsResponse(true, params, BallerinaRunnerUtil.extractParamDetails(param));
                            }
                            params.add(BallerinaRunnerUtil.extractParamDetails(param));
                        }
                        return new MainFunctionParamsResponse(true, params, null);
                    }
                }
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaRunner/mainFunctionParams' failed!";
                this.clientLogger.logError(RunnerContext.RUNNER_MAIN_FUNCTION_PARAMS, msg, e, request.getProjectRootIdentifier(), new Position[]{null});
            }
            return new MainFunctionParamsResponse(false, null, null);
        });
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    public record MainFunctionParamsResponse(boolean hasMain, List<TypeBindingPair> params, TypeBindingPair restParams) {
    }

    public record TypeBindingPair(String type, String paramName, String defaultValue) {
    }

    private static enum RunnerContext implements LSOperation
    {
        RUNNER_DIAGNOSTICS("ballerinaRunner/diagnostics"),
        RUNNER_MAIN_FUNCTION_PARAMS("ballerinaRunner/mainFunctionParams");

        private final String name;

        private RunnerContext(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

