/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.hover;

import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.HoverContext;
import org.ballerinalang.langserver.hover.HoverUtil;
import org.ballerinalang.langserver.util.MarkupUtils;
import org.eclipse.lsp4j.Hover;

public class HoverObjectResolver {
    private final HoverContext context;

    public HoverObjectResolver(HoverContext context) {
        this.context = context;
    }

    public Hover getHoverObjectForSymbol(Symbol symbol) {
        return switch (symbol.kind()) {
            case SymbolKind.FUNCTION -> this.getHoverObjectForSymbol((FunctionSymbol)symbol);
            case SymbolKind.METHOD -> this.getHoverObjectForSymbol((FunctionSymbol)((MethodSymbol)symbol));
            case SymbolKind.RESOURCE_METHOD -> this.getHoverObjectForSymbol((FunctionSymbol)((ResourceMethodSymbol)symbol));
            case SymbolKind.TYPE_DEFINITION -> this.getHoverObjectForSymbol((TypeDefinitionSymbol)symbol);
            case SymbolKind.CLASS -> this.getHoverObjectForSymbol((ClassSymbol)symbol);
            case SymbolKind.VARIABLE -> this.getHoverObjectForSymbol((VariableSymbol)symbol);
            case SymbolKind.PARAMETER -> this.getHoverObjectForSymbol((ParameterSymbol)symbol);
            case SymbolKind.TYPE -> {
                if (symbol instanceof TypeReferenceTypeSymbol) {
                    TypeReferenceTypeSymbol refTypeSymbol = (TypeReferenceTypeSymbol)symbol;
                    yield this.getHoverObjectForSymbol(refTypeSymbol.definition());
                }
                yield HoverUtil.getHoverObject();
            }
            default -> HoverUtil.getDescriptionOnlyHoverObject(symbol);
        };
    }

    private Hover getHoverObjectForSymbol(VariableSymbol variableSymbol) {
        TypeSymbol varTypeSymbol;
        Optional documentation = variableSymbol.documentation();
        ArrayList<Object> hoverContent = new ArrayList<Object>();
        if (documentation.isPresent() && ((Documentation)documentation.get()).description().isPresent()) {
            hoverContent.add((String)((Documentation)documentation.get()).description().get());
        }
        if ((varTypeSymbol = variableSymbol.typeDescriptor()).typeKind() != TypeDescKind.COMPILATION_ERROR) {
            String type = varTypeSymbol.signature();
            String varName = variableSymbol.getName().isPresent() ? " " + (String)variableSymbol.getName().get() : "";
            String modifiedVariable = MarkupUtils.quotedString(type) + CommonUtil.escapeEscapeCharsInIdentifier(varName);
            hoverContent.add(modifiedVariable);
        }
        return HoverUtil.getHoverObject(hoverContent.stream().collect(Collectors.joining(MarkupUtils.getHorizontalSeparator())));
    }

    private Hover getHoverObjectForSymbol(ParameterSymbol symbol) {
        Object hoverContent = "";
        TypeSymbol typeSymbol = symbol.typeDescriptor();
        if (typeSymbol.typeKind() == TypeDescKind.COMPILATION_ERROR) {
            return HoverUtil.getHoverObject((String)hoverContent);
        }
        String type = typeSymbol.signature();
        String parameterName = symbol.getName().isPresent() ? " " + (String)symbol.getName().get() : "";
        hoverContent = MarkupUtils.quotedString(type) + CommonUtil.escapeEscapeCharsInIdentifier(parameterName);
        return HoverUtil.getHoverObject((String)hoverContent);
    }

    private Hover getHoverObjectForSymbol(ClassSymbol symbol) {
        Optional documentation = symbol.documentation();
        if (documentation.isEmpty()) {
            return HoverUtil.getHoverObject();
        }
        return this.getHoverObjectForSymbol((ObjectTypeSymbol)symbol, (Documentation)documentation.get());
    }

    private Hover getHoverObjectForSymbol(TypeDefinitionSymbol symbol) {
        TypeSymbol rawType = CommonUtil.getRawType(symbol.typeDescriptor());
        Optional documentation = symbol.documentation();
        if (documentation.isEmpty()) {
            return HoverUtil.getHoverObject();
        }
        if (rawType.typeKind() == TypeDescKind.RECORD) {
            return this.getHoverObjectForSymbol((RecordTypeSymbol)rawType, (Documentation)documentation.get());
        }
        if (rawType.typeKind() == TypeDescKind.OBJECT) {
            return this.getHoverObjectForSymbol((ObjectTypeSymbol)rawType, (Documentation)documentation.get());
        }
        return HoverUtil.getDescriptionOnlyHoverObject((Documentation)documentation.get());
    }

    private Hover getHoverObjectForSymbol(FunctionSymbol functionSymbol) {
        boolean isResourceMethod;
        Optional documentation = functionSymbol.documentation();
        if (documentation.isEmpty()) {
            return HoverUtil.getHoverObject();
        }
        ArrayList<Object> hoverContent = new ArrayList<Object>();
        ((Documentation)documentation.get()).description().ifPresent(hoverContent::add);
        ArrayList<PathParameterSymbol> parameterSymbols = new ArrayList<PathParameterSymbol>();
        boolean bl = isResourceMethod = functionSymbol.kind() == SymbolKind.RESOURCE_METHOD;
        if (isResourceMethod) {
            ResourcePath resourcePath = ((ResourceMethodSymbol)functionSymbol).resourcePath();
            switch (resourcePath.kind()) {
                case PATH_SEGMENT_LIST: {
                    PathSegmentList pathSegmentList = (PathSegmentList)resourcePath;
                    List pathParameterSymbols = pathSegmentList.pathParameters();
                    parameterSymbols.addAll(pathParameterSymbols);
                    pathSegmentList.pathRestParameter().ifPresent(parameterSymbols::add);
                    break;
                }
                case PATH_REST_PARAM: {
                    parameterSymbols.add(((PathRestParam)resourcePath).parameter());
                    break;
                }
            }
        }
        Map paramsMap = ((Documentation)documentation.get()).parameterMap();
        ArrayList<Object> params = new ArrayList<Object>();
        if (!paramsMap.isEmpty() || !parameterSymbols.isEmpty()) {
            params.add(MarkupUtils.header(3, "Parameters") + CommonUtil.MD_LINE_SEPARATOR);
            params.addAll(parameterSymbols.stream().map(param -> {
                if (param.getName().isEmpty()) {
                    return MarkupUtils.quotedString(NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, param.typeDescriptor()));
                }
                String paramName = (String)param.getName().get();
                String desc = paramsMap.getOrDefault(paramName, "");
                return MarkupUtils.quotedString(NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, param.typeDescriptor())) + " " + MarkupUtils.italicString(MarkupUtils.boldString(paramName)) + " : " + desc;
            }).toList());
            params.addAll(((List)functionSymbol.typeDescriptor().params().get()).stream().map(param -> {
                if (param.getName().isEmpty()) {
                    return MarkupUtils.quotedString(NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, param.typeDescriptor()));
                }
                String paramName = (String)param.getName().get();
                String desc = paramsMap.getOrDefault(paramName, "");
                String defaultValueEdit = "";
                if (param.paramKind() == ParameterKind.DEFAULTABLE) {
                    Optional filePathForSymbol = this.context.workspace().project(this.context.filePath()).flatMap(project -> PathUtil.getFilePathForSymbol((Symbol)functionSymbol, project, (DocumentServiceContext)this.context));
                    Optional paramNode = this.context.workspace().syntaxTree((Path)filePathForSymbol.get()).flatMap(syntaxTree -> CommonUtil.findNode((Symbol)param, syntaxTree));
                    if (paramNode.isPresent() && ((NonTerminalNode)paramNode.get()).kind() == SyntaxKind.DEFAULTABLE_PARAM && !((DefaultableParameterNode)paramNode.get()).expression().isMissing()) {
                        DefaultableParameterNode node = (DefaultableParameterNode)paramNode.get();
                        defaultValueEdit = MarkupUtils.quotedString(String.format("(default: %s)", node.expression().toSourceCode()));
                    }
                }
                return MarkupUtils.quotedString(NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, param.typeDescriptor())) + " " + MarkupUtils.italicString(MarkupUtils.boldString(paramName)) + " : " + desc + defaultValueEdit;
            }).toList());
            Optional restParam = functionSymbol.typeDescriptor().restParam();
            if (restParam.isPresent()) {
                TypeSymbol typeSymbol = ((ParameterSymbol)restParam.get()).typeDescriptor();
                String modifiedTypeName = typeSymbol.typeKind() == TypeDescKind.ARRAY ? NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, ((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor()) : NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, typeSymbol);
                StringBuilder restParamBuilder = new StringBuilder(MarkupUtils.quotedString(modifiedTypeName + "..."));
                if (((ParameterSymbol)restParam.get()).getName().isPresent()) {
                    String paramName = (String)paramsMap.get(((ParameterSymbol)restParam.get()).getName().get());
                    if (paramName == null) {
                        paramName = "";
                    }
                    restParamBuilder.append(" ").append(MarkupUtils.italicString(MarkupUtils.boldString((String)((ParameterSymbol)restParam.get()).getName().get()))).append(" : ").append(paramName);
                }
                params.add(restParamBuilder.toString());
            }
            hoverContent.add(String.join((CharSequence)CommonUtil.MD_LINE_SEPARATOR, params));
        }
        if (((Documentation)documentation.get()).returnDescription().isPresent()) {
            TypeSymbol returnTypeDesc = (TypeSymbol)functionSymbol.typeDescriptor().returnTypeDescriptor().orElseThrow();
            String returnTypeName = MarkupUtils.quotedString(NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, returnTypeDesc));
            String returnDoc = MarkupUtils.header(3, "Return") + CommonUtil.MD_LINE_SEPARATOR + returnTypeName + " : " + (String)((Documentation)documentation.get()).returnDescription().get();
            hoverContent.add(returnDoc);
        }
        return HoverUtil.getHoverObject(hoverContent.stream().collect(Collectors.joining(MarkupUtils.getHorizontalSeparator())));
    }

    private Hover getHoverObjectForSymbol(RecordTypeSymbol recordType, Documentation documentation) {
        Map paramsMap;
        ArrayList<String> hoverContent = new ArrayList<String>();
        if (documentation.description().isPresent()) {
            hoverContent.add((String)documentation.description().get());
        }
        if (!(paramsMap = documentation.parameterMap()).isEmpty()) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(MarkupUtils.header(3, "Fields") + CommonUtil.MD_LINE_SEPARATOR);
            params.addAll(recordType.fieldDescriptors().entrySet().stream().map(fieldEntry -> {
                String desc = (String)paramsMap.get(fieldEntry.getKey());
                String typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, ((RecordFieldSymbol)fieldEntry.getValue()).typeDescriptor());
                return MarkupUtils.quotedString(typeName) + " " + MarkupUtils.italicString(MarkupUtils.boldString((String)fieldEntry.getKey())) + " : " + desc;
            }).toList());
            Optional restTypeDesc = recordType.restTypeDescriptor();
            restTypeDesc.ifPresent(typeSymbol -> params.add(MarkupUtils.quotedString(NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, typeSymbol) + "...")));
            hoverContent.add(String.join((CharSequence)CommonUtil.MD_LINE_SEPARATOR, params));
        }
        return HoverUtil.getHoverObject(hoverContent.stream().collect(Collectors.joining(MarkupUtils.getHorizontalSeparator())));
    }

    private Hover getHoverObjectForSymbol(ObjectTypeSymbol classSymbol, Documentation documentation) {
        ArrayList<String> hoverContent = new ArrayList<String>();
        if (documentation.description().isPresent()) {
            hoverContent.add((String)documentation.description().get());
        }
        Optional<Package> currentPackage = this.context.workspace().project(this.context.filePath()).map(Project::currentPackage);
        Optional currentModule = this.context.currentModule();
        if (currentModule.isPresent() && currentPackage.isPresent()) {
            Map paramsMap = documentation.parameterMap();
            if (!paramsMap.isEmpty()) {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(MarkupUtils.header(3, "Fields") + CommonUtil.MD_LINE_SEPARATOR);
                params.addAll(classSymbol.fieldDescriptors().entrySet().stream().filter(fieldEntry -> HoverUtil.withValidAccessModifiers((Symbol)fieldEntry.getValue(), (Package)currentPackage.get(), ((Module)currentModule.get()).moduleId(), this.context)).map(fieldEntry -> {
                    String desc = (String)paramsMap.get(fieldEntry.getKey());
                    String modifiedTypeName = NameUtil.getModifiedTypeName((DocumentServiceContext)this.context, ((ObjectFieldSymbol)fieldEntry.getValue()).typeDescriptor());
                    return MarkupUtils.quotedString(modifiedTypeName) + " " + MarkupUtils.italicString(MarkupUtils.boldString((String)fieldEntry.getKey())) + " : " + desc;
                }).toList());
                if (params.size() > 1) {
                    hoverContent.add(String.join((CharSequence)CommonUtil.MD_LINE_SEPARATOR, params));
                }
            }
            ArrayList<CallSite> methods = new ArrayList<CallSite>();
            classSymbol.methods().entrySet().stream().filter(methodSymbol -> HoverUtil.withValidAccessModifiers((Symbol)methodSymbol.getValue(), (Package)currentPackage.get(), ((Module)currentModule.get()).moduleId(), this.context)).forEach(methodEntry -> {
                MethodSymbol methodSymbol = (MethodSymbol)methodEntry.getValue();
                StringBuilder methodInfo = new StringBuilder();
                Optional methodDoc = methodSymbol.documentation();
                String signature = CommonUtil.getModifiedSignature((DocumentServiceContext)this.context, methodSymbol.signature());
                methodInfo.append(MarkupUtils.quotedString(signature));
                if (methodDoc.isPresent() && ((Documentation)methodDoc.get()).description().isPresent()) {
                    methodInfo.append(CommonUtil.MD_LINE_SEPARATOR).append((String)((Documentation)methodDoc.get()).description().get());
                }
                methods.add((CallSite)((Object)MarkupUtils.bulletItem(methodInfo.toString())));
            });
            if (!methods.isEmpty()) {
                methods.add(0, (CallSite)((Object)(MarkupUtils.header(3, "Methods") + CommonUtil.MD_LINE_SEPARATOR)));
                hoverContent.add(String.join((CharSequence)CommonUtil.MD_LINE_SEPARATOR, methods));
            }
        }
        return HoverUtil.getHoverObject(hoverContent.stream().collect(Collectors.joining(MarkupUtils.getHorizontalSeparator())));
    }

    public Hover getHoverObjectForExpression(Node exprNode) {
        switch (exprNode.kind()) {
            case IMPLICIT_NEW_EXPRESSION: 
            case EXPLICIT_NEW_EXPRESSION: {
                ClassSymbol classSymbol;
                Optional<TypeSymbol> optionalTypeSymbol = this.context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf(exprNode)).map(CommonUtil::getRawType);
                if (optionalTypeSymbol.isEmpty()) break;
                TypeSymbol typeSymbol = optionalTypeSymbol.get();
                if (typeSymbol.typeKind() == TypeDescKind.UNION) {
                    UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                    Optional<TypeSymbol> classTypeSymbol = unionTypeSymbol.memberTypeDescriptors().stream().map(CommonUtil::getRawType).filter(member -> member.typeKind() != TypeDescKind.ERROR).findFirst();
                    if (classTypeSymbol.isEmpty()) break;
                    typeSymbol = classTypeSymbol.get();
                }
                if (!(typeSymbol instanceof ClassSymbol) || (classSymbol = (ClassSymbol)typeSymbol).initMethod().isEmpty()) break;
                MethodSymbol initMethodSymbol = (MethodSymbol)classSymbol.initMethod().get();
                return this.getHoverObjectForSymbol((FunctionSymbol)initMethodSymbol);
            }
        }
        return HoverUtil.getHoverObject();
    }
}

