/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.inlayhint;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.RestArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.common.utils.TypeResolverUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.InlayHintContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class InlayHintProvider {
    private InlayHintProvider() {
    }

    public static List<InlayHint> getInlayHint(InlayHintContext context) {
        LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)context.languageServercontext().get(LSClientCapabilities.class);
        if (!lsClientCapabilities.getInitializationOptions().isEnableInlayHints() || context.currentDocument().isEmpty()) {
            return Collections.emptyList();
        }
        InvokableNodeFinder invokableNodeFinder = new InvokableNodeFinder();
        Node rootNode = ((Document)context.currentDocument().get()).syntaxTree().rootNode();
        rootNode.accept((NodeVisitor)invokableNodeFinder);
        List<NonTerminalNode> invokableNodeList = invokableNodeFinder.getInvokableNodeList();
        ArrayList<InlayHint> inlayHints = new ArrayList<InlayHint>();
        block0: for (NonTerminalNode invokableNode : invokableNodeList) {
            NonTerminalNode argument;
            InlayHintArgumentTypeFinder argumentTypeFinder = new InlayHintArgumentTypeFinder();
            invokableNode.accept((NodeVisitor)argumentTypeFinder);
            List<NonTerminalNode> argList = argumentTypeFinder.getArgumentList();
            if (argList.isEmpty()) continue;
            Map<NonTerminalNode, LineRange> inlayHintLocations = argumentTypeFinder.getInlayHintLocations();
            Pair<List<ParameterSymbol>, Optional<ParameterSymbol>> parameterSymbols = InlayHintProvider.getParameterSymbolsForInvokableNode(context, invokableNode);
            for (int argumentIndex = 0; argumentIndex < argList.size() && (argument = argList.get(argumentIndex)).kind() != SyntaxKind.NAMED_ARG; ++argumentIndex) {
                InlayHint inlayHint;
                Object label;
                LineRange lineRange = inlayHintLocations.get(argument);
                if (lineRange == null) {
                    return Collections.emptyList();
                }
                int startLine = lineRange.endLine().line();
                int startChar = lineRange.endLine().offset();
                Position position = new Position(startLine, startChar);
                if (argument.kind() == SyntaxKind.REST_ARG) {
                    if (((Optional)parameterSymbols.getRight()).isEmpty() || ((String)((ParameterSymbol)((Optional)parameterSymbols.getRight()).get()).getName().get()).startsWith("$")) continue block0;
                    label = "..." + (String)((ParameterSymbol)((Optional)parameterSymbols.getRight()).get()).getName().get();
                    inlayHint = new InlayHint(position, Either.forLeft((Object)((String)label + ": ")));
                    inlayHints.add(inlayHint);
                    continue block0;
                }
                if (((List)parameterSymbols.getLeft()).size() <= argumentIndex) {
                    if (!((Optional)parameterSymbols.getRight()).isPresent() || !((ParameterSymbol)((Optional)parameterSymbols.getRight()).get()).getName().isPresent()) continue block0;
                    label = "..." + (String)((ParameterSymbol)((Optional)parameterSymbols.getRight()).get()).getName().get();
                    inlayHint = new InlayHint(position, Either.forLeft((Object)((String)label + ": ")));
                    inlayHints.add(inlayHint);
                    continue block0;
                }
                if (((ParameterSymbol)((List)parameterSymbols.getLeft()).get(argumentIndex)).getName().isEmpty() || ((String)((ParameterSymbol)((List)parameterSymbols.getLeft()).get(argumentIndex)).getName().get()).startsWith("$")) continue block0;
                label = (String)((ParameterSymbol)((List)parameterSymbols.getLeft()).get(argumentIndex)).getName().get();
                inlayHint = new InlayHint(position, Either.forLeft((Object)((String)label + ": ")));
                inlayHints.add(inlayHint);
            }
        }
        return inlayHints;
    }

    private static Pair<List<ParameterSymbol>, Optional<ParameterSymbol>> getParameterSymbolsForInvokableNode(InlayHintContext context, NonTerminalNode invokableNode) {
        if (invokableNode.kind() == SyntaxKind.METHOD_CALL) {
            MethodCallExpressionNode methodCallExpressionNode = (MethodCallExpressionNode)invokableNode;
            Optional<FunctionTypeSymbol> libFunction = TypeResolverUtil.findMethodInLangLibFunctions(methodCallExpressionNode, (DocumentServiceContext)context);
            if (libFunction.isEmpty() || libFunction.get().params().isEmpty()) {
                return Pair.of(Collections.emptyList(), Optional.empty());
            }
            return Pair.of(((List)libFunction.get().params().get()).stream().skip(1L).toList(), (Object)libFunction.get().restParam());
        }
        if (invokableNode.kind() == SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION) {
            return ((SemanticModel)context.currentSemanticModel().get()).symbol((Node)invokableNode).map(symbol -> ((ResourceMethodSymbol)symbol).typeDescriptor()).map(typeSymbol -> Pair.of(typeSymbol.params().orElse(Collections.emptyList()), (Object)typeSymbol.restParam())).orElse(Pair.of(Collections.emptyList(), Optional.empty()));
        }
        if (invokableNode.kind() == SyntaxKind.REMOTE_METHOD_CALL_ACTION) {
            return ((SemanticModel)context.currentSemanticModel().get()).symbol((Node)invokableNode).map(symbol -> ((MethodSymbol)symbol).typeDescriptor()).map(typeSymbol -> Pair.of(typeSymbol.params().orElse(Collections.emptyList()), (Object)typeSymbol.restParam())).orElse(Pair.of(Collections.emptyList(), Optional.empty()));
        }
        if (invokableNode.kind() == SyntaxKind.IMPLICIT_NEW_EXPRESSION || invokableNode.kind() == SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            return InlayHintProvider.getParameterSymbolsForNewExpression(context, invokableNode);
        }
        FunctionCallExpressionNode functionCallExpressionNode = (FunctionCallExpressionNode)invokableNode;
        return InlayHintProvider.getParameterSymbolsForFunctionCall(context, functionCallExpressionNode);
    }

    private static Pair<List<ParameterSymbol>, Optional<ParameterSymbol>> getParameterSymbolsForNewExpression(InlayHintContext context, NonTerminalNode node) {
        Optional symbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node)).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).stream().findFirst();
        if (symbol.isEmpty()) {
            return Pair.of(Collections.emptyList(), Optional.empty());
        }
        return InlayHintProvider.getParametersOfNewExpression((TypeSymbol)symbol.get());
    }

    private static Pair<List<ParameterSymbol>, Optional<ParameterSymbol>> getParametersOfNewExpression(TypeSymbol symbol) {
        if (symbol.typeKind() == TypeDescKind.UNION) {
            symbol = ((UnionTypeSymbol)symbol).memberTypeDescriptors().stream().filter(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.OBJECT).map(CommonUtil::getRawType).findFirst().get();
        }
        TypeSymbol typeSymbol2 = CommonUtil.getRawType(symbol);
        Optional methodSymbol = ((ClassSymbol)typeSymbol2).initMethod();
        return methodSymbol.map(value -> Pair.of(value.typeDescriptor().params().orElse(Collections.emptyList()), (Object)value.typeDescriptor().restParam())).orElseGet(() -> Pair.of(Collections.emptyList(), Optional.empty()));
    }

    private static Pair<List<ParameterSymbol>, Optional<ParameterSymbol>> getParameterSymbolsForFunctionCall(InlayHintContext context, FunctionCallExpressionNode node) {
        List<Object> functionSymbols;
        String functionName;
        LineRange lineRange = node.lineRange();
        List visibleSymbols = context.visibleSymbols(new Position(lineRange.startLine().line(), lineRange.startLine().offset()));
        if (node.functionName().kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            functionName = ((QualifiedNameReferenceNode)node.functionName()).identifier().text();
            functionSymbols = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.MODULE).map(symbol -> (ModuleSymbol)symbol).filter(moduleSymbol -> moduleSymbol.getName().isPresent()).filter(moduleSymbol -> ((String)moduleSymbol.getName().get()).equals(((QualifiedNameReferenceNode)node.functionName()).modulePrefix().toString().strip())).findFirst().map(ModuleSymbol::functions).orElse(Collections.emptyList());
        } else if (node.functionName().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            functionSymbols = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.FUNCTION).map(symbol -> (FunctionSymbol)symbol).toList();
            functionName = ((SimpleNameReferenceNode)node.functionName()).name().text();
        } else {
            return Pair.of(Collections.emptyList(), Optional.empty());
        }
        return InlayHintProvider.findParameterSymbols(functionSymbols, functionName);
    }

    private static Pair<List<ParameterSymbol>, Optional<ParameterSymbol>> findParameterSymbols(List<FunctionSymbol> functionSymbols, String functionName) {
        Optional<FunctionTypeSymbol> functionTypeSymbol = functionSymbols.stream().filter(functionSymbol -> functionSymbol.getName().isPresent() && ((String)functionSymbol.getName().get()).equals(functionName.strip())).findFirst().flatMap(SymbolUtil::getTypeDescriptor).filter(typeDescriptor -> typeDescriptor instanceof FunctionTypeSymbol).map(typeDescriptor -> (FunctionTypeSymbol)typeDescriptor);
        return functionTypeSymbol.map(symbol -> Pair.of(symbol.params().orElse(Collections.emptyList()), (Object)symbol.restParam())).orElse(Pair.of(Collections.emptyList(), Optional.empty()));
    }

    private static class InvokableNodeFinder
    extends NodeVisitor {
        List<NonTerminalNode> invokableNodeList = new ArrayList<NonTerminalNode>();

        public List<NonTerminalNode> getInvokableNodeList() {
            return this.invokableNodeList;
        }

        public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
            this.invokableNodeList.add((NonTerminalNode)functionCallExpressionNode);
        }

        public void visit(MethodCallExpressionNode methodCallExpressionNode) {
            this.invokableNodeList.add((NonTerminalNode)methodCallExpressionNode);
        }

        public void visit(ClientResourceAccessActionNode clientResourceAccessActionNode) {
            this.invokableNodeList.add((NonTerminalNode)clientResourceAccessActionNode);
        }

        public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
            this.invokableNodeList.add((NonTerminalNode)remoteMethodCallActionNode);
        }

        public void visit(ImplicitNewExpressionNode implicitNewExpressionNode) {
            this.invokableNodeList.add((NonTerminalNode)implicitNewExpressionNode);
        }

        public void visit(ExplicitNewExpressionNode explicitNewExpressionNode) {
            this.invokableNodeList.add((NonTerminalNode)explicitNewExpressionNode);
        }
    }

    private static class InlayHintArgumentTypeFinder
    extends NodeVisitor {
        List<NonTerminalNode> argumentList = new ArrayList<NonTerminalNode>();
        Map<NonTerminalNode, LineRange> inlayHintLocations = new HashMap<NonTerminalNode, LineRange>();

        public List<NonTerminalNode> getArgumentList() {
            return this.argumentList;
        }

        public Map<NonTerminalNode, LineRange> getInlayHintLocations() {
            return this.inlayHintLocations;
        }

        public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
            this.findInlayHintLocationsFromArgs((SeparatedNodeList<FunctionArgumentNode>)functionCallExpressionNode.arguments(), functionCallExpressionNode.openParenToken());
        }

        public void visit(MethodCallExpressionNode methodCallExpressionNode) {
            this.findInlayHintLocationsFromArgs((SeparatedNodeList<FunctionArgumentNode>)methodCallExpressionNode.arguments(), methodCallExpressionNode.openParenToken());
        }

        public void visit(ParenthesizedArgList parenthesizedArgList) {
            this.findInlayHintLocationsFromArgs((SeparatedNodeList<FunctionArgumentNode>)parenthesizedArgList.arguments(), parenthesizedArgList.openParenToken());
        }

        public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
            this.findInlayHintLocationsFromArgs((SeparatedNodeList<FunctionArgumentNode>)remoteMethodCallActionNode.arguments(), remoteMethodCallActionNode.openParenToken());
        }

        public void visit(PositionalArgumentNode positionalArgumentNode) {
            this.argumentList.add((NonTerminalNode)positionalArgumentNode);
        }

        public void visit(RestArgumentNode restArgumentNode) {
            this.argumentList.add((NonTerminalNode)restArgumentNode);
        }

        private void findInlayHintLocationsFromArgs(SeparatedNodeList<FunctionArgumentNode> argumentNodes, Token openParenToken) {
            for (int i = 0; i < argumentNodes.size(); ++i) {
                FunctionArgumentNode argumentNode = (FunctionArgumentNode)argumentNodes.get(i);
                argumentNode.accept((NodeVisitor)this);
                if (!this.argumentList.contains(argumentNode)) continue;
                if (i == 0) {
                    this.inlayHintLocations.put((NonTerminalNode)argumentNode, openParenToken.lineRange());
                    continue;
                }
                this.inlayHintLocations.put((NonTerminalNode)argumentNode, argumentNodes.getSeparator(i - 1).lineRange());
            }
        }
    }
}

