/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.rename;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternNode;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternVarnameNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxInfo;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.codeaction.CodeActionModuleId;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.PrepareRenameContext;
import org.ballerinalang.langserver.commons.ReferencesContext;
import org.ballerinalang.langserver.commons.RenameContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.contexts.BallerinaContextUtils;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.ballerinalang.langserver.references.ReferencesUtil;
import org.eclipse.lsp4j.AnnotatedTextEdit;
import org.eclipse.lsp4j.ChangeAnnotation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class RenameUtil {
    private RenameUtil() {
    }

    public static Optional<Range> prepareRename(PrepareRenameContext context) {
        RenameUtil.fillTokenInfoAtCursor((ReferencesContext)context);
        context.checkCancelled();
        Token tokenAtCursor = PositionUtil.findTokenAtPosition((DocumentServiceContext)context, context.getCursorPosition()).filter(token -> token instanceof IdentifierToken).or(() -> {
            Position originalPos = context.getCursorPosition();
            Position newPos = new Position(originalPos.getLine(), originalPos.getCharacter() - 1);
            return PositionUtil.findTokenAtPosition((DocumentServiceContext)context, newPos);
        }).orElse(null);
        if (!(tokenAtCursor instanceof IdentifierToken) || SyntaxInfo.isKeyword((String)tokenAtCursor.text()) || RenameUtil.isSelfClassSymbol((ReferencesContext)context)) {
            return Optional.empty();
        }
        Optional<Symbol> symbolAtCursor = ReferencesUtil.getSymbolAtCursor((PositionedOperationContext)context);
        if (symbolAtCursor.isEmpty() || symbolAtCursor.get().kind() == SymbolKind.RESOURCE_METHOD || symbolAtCursor.get().kind() == SymbolKind.PATH_PARAMETER || symbolAtCursor.get().kind() == SymbolKind.PATH_NAME_SEGMENT) {
            return Optional.empty();
        }
        Optional document = context.currentDocument();
        if (document.isEmpty()) {
            return Optional.empty();
        }
        Range cursorPosRange = new Range(context.getCursorPosition(), context.getCursorPosition());
        NonTerminalNode nodeAtCursor = CommonUtil.findNode(cursorPosRange, ((Document)document.get()).syntaxTree());
        if (RenameUtil.onImportDeclarationNode((ReferencesContext)context, nodeAtCursor)) {
            return Optional.empty();
        }
        if (QNameRefCompletionUtil.onModulePrefix((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRefNode = (QualifiedNameReferenceNode)nodeAtCursor;
            Optional<ImportDeclarationNode> importDeclaration = RenameUtil.getImportDeclarationNodeForQNameReference((Document)document.get(), qNameRefNode);
            if (importDeclaration.isEmpty()) {
                return Optional.empty();
            }
        }
        return Optional.of(PositionUtil.toRange(tokenAtCursor.lineRange()));
    }

    private static Map<String, List<TextEdit>> getChanges(RenameContext context) {
        RenameUtil.fillTokenInfoAtCursor((ReferencesContext)context);
        String newName = context.getParams().getNewName();
        if (!SyntaxInfo.isIdentifier((String)newName) && !SyntaxInfo.isKeyword((String)newName)) {
            throw new UserErrorException("Invalid identifier provided");
        }
        Optional document = context.currentDocument();
        if (document.isEmpty()) {
            return Collections.emptyMap();
        }
        Range cursorPosRange = new Range(context.getCursorPosition(), context.getCursorPosition());
        NonTerminalNode nodeAtCursor = CommonUtil.findNode(cursorPosRange, ((Document)document.get()).syntaxTree());
        Optional<Symbol> symbolAtCursor = ReferencesUtil.getSymbolAtCursor((PositionedOperationContext)context);
        if (RenameUtil.onImportDeclarationNode((ReferencesContext)context, nodeAtCursor) || nodeAtCursor.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE && RenameUtil.isSelfClassSymbol((ReferencesContext)context) || symbolAtCursor.isPresent() && symbolAtCursor.get().kind() == SymbolKind.RESOURCE_METHOD) {
            return Collections.emptyMap();
        }
        if (QNameRefCompletionUtil.onModulePrefix((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            return RenameUtil.handleQNameReferenceRename(context, (Document)document.get(), nodeAtCursor);
        }
        if (RenameUtil.onImportPrefixNode((ReferencesContext)context, nodeAtCursor)) {
            return RenameUtil.handleImportPrefixRename(context, (Document)document.get(), nodeAtCursor);
        }
        Map<Module, List<Location>> locationMap = ReferencesUtil.getReferences((PositionedOperationContext)context);
        HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
        for (Map.Entry<Module, List<Location>> entry : locationMap.entrySet()) {
            Module module = entry.getKey();
            List<Location> locations = entry.getValue();
            for (Location location : locations) {
                String uri = PathUtil.getUriFromLocation(module, location);
                Range editRange = PathUtil.getRange(location);
                Path path = PathUtil.getPathFromLocation(module, location);
                Optional bindingPatternVarNode = context.workspace().syntaxTree(path).map(syntaxTree -> CommonUtil.findNode(editRange, syntaxTree)).flatMap(RenameUtil::getFieldBindingPatternVarNameNode);
                List textEdits = changes.computeIfAbsent(uri, k -> new ArrayList());
                if (context.getHonorsChangeAnnotations() && SyntaxInfo.isKeyword((String)newName)) {
                    Object escapedInsertText = CommonUtil.escapeReservedKeyword(newName);
                    Object insertText = newName;
                    if (bindingPatternVarNode.isPresent()) {
                        String currentName = ((FieldBindingPatternVarnameNode)bindingPatternVarNode.get()).variableName().name().text();
                        escapedInsertText = currentName + ": " + (String)escapedInsertText;
                        insertText = currentName + ": " + (String)insertText;
                    }
                    textEdits.add(new AnnotatedTextEdit(editRange, (String)escapedInsertText, RenameChangeAnnotation.QUOTED_KEYWORD.getID()));
                    textEdits.add(new AnnotatedTextEdit(editRange, (String)insertText, RenameChangeAnnotation.UNQUOTED_KEYWORD.getID()));
                    continue;
                }
                Object insertText = newName;
                if (bindingPatternVarNode.isPresent()) {
                    String currentName = ((FieldBindingPatternVarnameNode)bindingPatternVarNode.get()).variableName().name().text();
                    insertText = currentName + ": " + (String)insertText;
                }
                textEdits.add(new TextEdit(editRange, (String)insertText));
            }
        }
        return changes;
    }

    public static WorkspaceEdit rename(RenameContext context) {
        HashMap<String, ChangeAnnotation> changeAnnotationMap = new HashMap<String, ChangeAnnotation>();
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        Map<String, List<TextEdit>> changes = RenameUtil.getChanges(context);
        if (context.getHonorsChangeAnnotations() && SyntaxInfo.isKeyword((String)context.getParams().getNewName())) {
            changeAnnotationMap.put(RenameChangeAnnotation.QUOTED_KEYWORD.getID(), RenameChangeAnnotation.QUOTED_KEYWORD.getChangeAnnotation());
            changeAnnotationMap.put(RenameChangeAnnotation.UNQUOTED_KEYWORD.getID(), RenameChangeAnnotation.UNQUOTED_KEYWORD.getChangeAnnotation());
            ArrayList docEdits = new ArrayList();
            changes.entrySet().forEach(entry -> {
                TextDocumentEdit edit = new TextDocumentEdit();
                edit.setTextDocument(new VersionedTextDocumentIdentifier((String)entry.getKey(), null));
                edit.setEdits((List)entry.getValue());
                docEdits.add(Either.forLeft((Object)edit));
            });
            workspaceEdit.setDocumentChanges(docEdits);
            workspaceEdit.setChangeAnnotations(changeAnnotationMap);
        } else {
            workspaceEdit.setChanges(changes);
        }
        return workspaceEdit;
    }

    private static boolean onImportPrefixNode(ReferencesContext context, NonTerminalNode node) {
        if (node.kind() != SyntaxKind.IMPORT_PREFIX) {
            return false;
        }
        ImportPrefixNode importPrefixNode = (ImportPrefixNode)node;
        int cursor = context.getCursorPositionInTree();
        return importPrefixNode.prefix().textRange().startOffset() <= cursor && cursor <= importPrefixNode.prefix().textRange().endOffset();
    }

    private static Optional<FieldBindingPatternVarnameNode> getFieldBindingPatternVarNameNode(NonTerminalNode node) {
        if (node.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE || node.parent().kind() != SyntaxKind.FIELD_BINDING_PATTERN) {
            return Optional.empty();
        }
        FieldBindingPatternNode fieldBindingPatternNode = (FieldBindingPatternNode)node.parent();
        if (fieldBindingPatternNode instanceof FieldBindingPatternVarnameNode) {
            FieldBindingPatternVarnameNode fieldBindingPatternVarnameNode = (FieldBindingPatternVarnameNode)fieldBindingPatternNode;
            return Optional.of(fieldBindingPatternVarnameNode);
        }
        return Optional.empty();
    }

    private static boolean onImportDeclarationNode(ReferencesContext context, NonTerminalNode node) {
        int startOffset;
        while (node != null && node.kind() != SyntaxKind.IMPORT_DECLARATION) {
            node = node.parent();
        }
        if (node == null) {
            return false;
        }
        ImportDeclarationNode importDeclarationNode = (ImportDeclarationNode)node;
        int cursor = context.getCursorPositionInTree();
        SeparatedNodeList moduleNames = importDeclarationNode.moduleName();
        if (importDeclarationNode.orgName().isPresent()) {
            startOffset = ((ImportOrgNameNode)importDeclarationNode.orgName().get()).textRange().startOffset();
        } else if (!moduleNames.isEmpty()) {
            startOffset = ((IdentifierToken)moduleNames.get(0)).textRange().startOffset();
        } else {
            return false;
        }
        return !moduleNames.isEmpty() && startOffset <= cursor && cursor <= ((IdentifierToken)moduleNames.get(moduleNames.size() - 1)).textRange().endOffset();
    }

    private static Map<String, List<TextEdit>> handleQNameReferenceRename(RenameContext context, Document document, NonTerminalNode nodeAtCursor) {
        QualifiedNameReferenceNode qNameRefNode = (QualifiedNameReferenceNode)nodeAtCursor;
        Optional<ImportDeclarationNode> importDeclarationNode = RenameUtil.getImportDeclarationNodeForQNameReference(document, qNameRefNode);
        if (importDeclarationNode.isEmpty()) {
            return Collections.emptyMap();
        }
        return RenameUtil.handleImportDeclarationRename(context, document, importDeclarationNode.get());
    }

    private static Optional<ImportDeclarationNode> getImportDeclarationNodeForQNameReference(Document document, QualifiedNameReferenceNode qNameRefNode) {
        String moduleOrAlias = qNameRefNode.modulePrefix().text();
        ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
        return modulePartNode.imports().stream().filter(importDeclaration -> {
            CodeActionModuleId moduleId = CodeActionModuleId.from(importDeclaration);
            if (!StringUtils.isEmpty((CharSequence)moduleId.modulePrefix())) {
                return moduleId.modulePrefix().equals(moduleOrAlias);
            }
            return moduleId.moduleName().endsWith(moduleOrAlias);
        }).findFirst();
    }

    private static Map<String, List<TextEdit>> handleImportDeclarationRename(RenameContext context, Document document, ImportDeclarationNode importDeclaration) {
        Map<Module, List<Location>> locationMap = ReferencesUtil.getReferences((PositionedOperationContext)context);
        HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
        String newName = context.getParams().getNewName();
        locationMap.entrySet().stream().filter(moduleListEntry -> ((Module)moduleListEntry.getKey()).moduleId().equals((Object)document.documentId().moduleId())).forEach(moduleLocations -> {
            Module module = (Module)moduleLocations.getKey();
            List locations = (List)moduleLocations.getValue();
            locations.forEach(location -> {
                String fileUri = PathUtil.getUriFromLocation(module, location);
                if (!context.fileUri().equals(fileUri)) {
                    return;
                }
                Range editRange = PathUtil.getRange(location);
                if (PositionUtil.isWithinLineRange(location.lineRange(), importDeclaration.lineRange()) && importDeclaration.prefix().isEmpty()) {
                    SeparatedNodeList moduleNames = importDeclaration.moduleName();
                    LinePosition endPos = ((IdentifierToken)moduleNames.get(moduleNames.size() - 1)).lineRange().endLine();
                    Range range = new Range(PositionUtil.toPosition(endPos), PositionUtil.toPosition(endPos));
                    List textEdits = changes.computeIfAbsent(fileUri, k -> new ArrayList());
                    if (context.getHonorsChangeAnnotations() && SyntaxInfo.isKeyword((String)newName)) {
                        String escapedNewName = CommonUtil.escapeReservedKeyword(newName);
                        textEdits.add(new AnnotatedTextEdit(editRange, "as " + escapedNewName, RenameChangeAnnotation.QUOTED_KEYWORD.getID()));
                        textEdits.add(new AnnotatedTextEdit(editRange, "as " + newName, RenameChangeAnnotation.UNQUOTED_KEYWORD.getID()));
                    } else {
                        textEdits.add(new TextEdit(range, " as " + newName));
                    }
                } else {
                    List textEdits = changes.computeIfAbsent(fileUri, k -> new ArrayList());
                    if (context.getHonorsChangeAnnotations() && SyntaxInfo.isKeyword((String)newName)) {
                        String escapedNewName = CommonUtil.escapeReservedKeyword(newName);
                        textEdits.add(new AnnotatedTextEdit(editRange, escapedNewName, RenameChangeAnnotation.QUOTED_KEYWORD.getID()));
                        textEdits.add(new AnnotatedTextEdit(editRange, newName, RenameChangeAnnotation.UNQUOTED_KEYWORD.getID()));
                    } else {
                        textEdits.add(new TextEdit(PathUtil.getRange(location), newName));
                    }
                }
            });
        });
        return changes;
    }

    private static Map<String, List<TextEdit>> handleImportPrefixRename(RenameContext context, Document document, NonTerminalNode nodeAtCursor) {
        String newName = context.getParams().getNewName();
        Map<Module, List<Location>> locationMap = ReferencesUtil.getReferences((PositionedOperationContext)context);
        HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
        locationMap.entrySet().stream().filter(moduleListEntry -> ((Module)moduleListEntry.getKey()).moduleId().equals((Object)document.documentId().moduleId())).forEach(moduleLocations -> {
            Module module = (Module)moduleLocations.getKey();
            List locations = (List)moduleLocations.getValue();
            locations.forEach(location -> {
                String fileUri = PathUtil.getUriFromLocation(module, location);
                if (!context.fileUri().equals(fileUri)) {
                    return;
                }
                List textEdits = changes.computeIfAbsent(fileUri, k -> new ArrayList());
                Range editRange = PathUtil.getRange(location);
                if (context.getHonorsChangeAnnotations() && SyntaxInfo.isKeyword((String)newName)) {
                    String escapedNewName = ModuleUtil.escapeModuleName(newName);
                    textEdits.add(new AnnotatedTextEdit(editRange, escapedNewName, RenameChangeAnnotation.QUOTED_KEYWORD.getID()));
                    textEdits.add(new AnnotatedTextEdit(editRange, newName, RenameChangeAnnotation.UNQUOTED_KEYWORD.getID()));
                } else {
                    textEdits.add(new TextEdit(editRange, newName));
                }
            });
        });
        return changes;
    }

    private static void fillTokenInfoAtCursor(ReferencesContext context) {
        Optional document = context.currentDocument();
        if (document.isEmpty()) {
            throw new RuntimeException("Could not find a valid document");
        }
        TextDocument textDocument = ((Document)document.get()).textDocument();
        Position position = context.getCursorPosition();
        int txtPos = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        context.setCursorPositionInTree(txtPos);
    }

    private static boolean isSelfClassSymbol(ReferencesContext context) {
        Optional srcFile = context.currentDocument();
        Optional semanticModel = context.currentSemanticModel();
        if (srcFile.isEmpty() || semanticModel.isEmpty() || context.currentSyntaxTree().isEmpty()) {
            return false;
        }
        Position position = context.getCursorPosition();
        LinePosition linePosition = LinePosition.from((int)position.getLine(), (int)position.getCharacter());
        Optional symbol = ((SemanticModel)semanticModel.get()).symbol((Document)srcFile.get(), linePosition);
        if (symbol.isEmpty()) {
            return false;
        }
        Optional<ModuleMemberDeclarationNode> enclosingNode = BallerinaContextUtils.getEnclosingModuleMember((SyntaxTree)context.currentSyntaxTree().get(), context.getCursorPositionInTree());
        if (enclosingNode.isEmpty()) {
            return false;
        }
        return SymbolUtil.isSelfClassSymbol((Symbol)symbol.get(), (PositionedOperationContext)context, enclosingNode.get());
    }

    private static enum RenameChangeAnnotation {
        QUOTED_KEYWORD("Quoted Rename", "Rename to keyword with a quote", true, "quoted"),
        UNQUOTED_KEYWORD("Un-quoted Rename", "Rename to keyword without a quote", true, "unquoted");

        private final String id;
        private final String label;
        private final String description;
        private final Boolean needsConfirmation;

        private RenameChangeAnnotation(String label, String description, Boolean needsConfirmation, String id) {
            this.id = id;
            this.label = label;
            this.description = description;
            this.needsConfirmation = needsConfirmation;
        }

        public String getID() {
            return this.id;
        }

        public ChangeAnnotation getChangeAnnotation() {
            ChangeAnnotation changeAnnotation = new ChangeAnnotation(this.label);
            changeAnnotation.setDescription(this.description);
            changeAnnotation.setNeedsConfirmation(this.needsConfirmation);
            return changeAnnotation;
        }
    }
}

