/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.toml.ballerinatoml.completion;

import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.toml.TomlCompletionContext;
import org.ballerinalang.langserver.commons.toml.common.completion.TomlCompletionUtil;
import org.ballerinalang.langserver.toml.ballerinatoml.completion.BallerinaTomlSnippetManager;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class BallerinaTomlCompletionUtil {
    private BallerinaTomlCompletionUtil() {
    }

    public static List<CompletionItem> getCompletionItems(TomlCompletionContext ctx, LanguageServerContext serverContext) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        TomlCompletionUtil.fillNodeAtCursor((TomlCompletionContext)ctx);
        completionItems.addAll(BallerinaTomlCompletionUtil.getCompletionItemsBasedOnContext(ctx, serverContext));
        return completionItems;
    }

    public static List<CompletionItem> getCompletionItemsBasedOnContext(TomlCompletionContext ctx, LanguageServerContext serverContext) {
        Optional node = ctx.getNodeAtCursor();
        if (node.isEmpty()) {
            return Collections.emptyList();
        }
        Map snippets = BallerinaTomlSnippetManager.getInstance(serverContext).getCompletionProposals();
        for (Node reference = (Node)node.get(); reference != null; reference = reference.parent()) {
            switch (reference.kind()) {
                case TABLE: {
                    Map completions = TomlCompletionUtil.getFilteredCompletions((Either)Either.forLeft((Object)((TableNode)reference)), (Map)snippets);
                    return new ArrayList<CompletionItem>(completions.values());
                }
                case TABLE_ARRAY: {
                    Map completions = TomlCompletionUtil.getFilteredCompletions((Either)Either.forRight((Object)((TableArrayNode)reference)), (Map)snippets);
                    return new ArrayList<CompletionItem>(completions.values());
                }
                case MODULE_PART: {
                    HashMap completions = new HashMap();
                    TomlCompletionUtil.removeExistingTableKeys((Map)TomlCompletionUtil.addTopLevelNodeCompletions(snippets.keySet(), completions), (DocumentNode)((DocumentNode)reference));
                    return new ArrayList<CompletionItem>(completions.values());
                }
            }
        }
        return Collections.emptyList();
    }
}

