/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util;

import java.util.UUID;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;

public final class LSClientUtil {
    public static final String EXECUTE_COMMAND_CAPABILITY_ID = UUID.randomUUID().toString();

    private LSClientUtil() {
    }

    public static boolean isDynamicCommandRegistrationSupported(ClientCapabilities clientCapabilities) {
        WorkspaceClientCapabilities workspaceCapabilities = clientCapabilities.getWorkspace();
        return workspaceCapabilities != null && workspaceCapabilities.getExecuteCommand() != null && Boolean.TRUE.equals(workspaceCapabilities.getExecuteCommand().getDynamicRegistration());
    }

    public static boolean isDynamicSemanticTokensRegistrationSupported(TextDocumentClientCapabilities capabilities) {
        return capabilities != null && capabilities.getSemanticTokens() != null && Boolean.TRUE.equals(capabilities.getSemanticTokens().getDynamicRegistration());
    }

    public static boolean isDynamicHoverRegistrationSupported(TextDocumentClientCapabilities capabilities) {
        return capabilities != null && capabilities.getHover() != null && Boolean.TRUE.equals(capabilities.getHover().getDynamicRegistration());
    }

    public static boolean isDynamicDefinitionRegistrationSupported(TextDocumentClientCapabilities capabilities) {
        return capabilities != null && capabilities.getDefinition() != null && Boolean.TRUE.equals(capabilities.getDefinition().getDynamicRegistration());
    }

    public static boolean isDynamicReferencesRegistrationSupported(TextDocumentClientCapabilities capabilities) {
        return capabilities != null && capabilities.getReferences() != null && Boolean.TRUE.equals(capabilities.getReferences().getDynamicRegistration());
    }

    public static boolean isDynamicSynchronizationRegistrationSupported(TextDocumentClientCapabilities capabilities) {
        return capabilities != null && capabilities.getSynchronization() != null && Boolean.TRUE.equals(capabilities.getSynchronization().getDynamicRegistration());
    }

    public static boolean isDynamicCompletionRegistrationSupported(TextDocumentClientCapabilities capabilities) {
        return capabilities != null && capabilities.getCompletion() != null && Boolean.TRUE.equals(capabilities.getCompletion().getDynamicRegistration());
    }

    public static boolean isCodeActionResolveSupported(TextDocumentClientCapabilities capabilities) {
        return capabilities != null && capabilities.getCodeAction() != null && capabilities.getCodeAction().getResolveSupport() != null && capabilities.getCodeAction().getResolveSupport().getProperties().contains("edit");
    }

    public static boolean clientSupportsPrepareRename(ClientCapabilities clientCapabilities) {
        TextDocumentClientCapabilities textDocument = clientCapabilities.getTextDocument();
        return textDocument != null && textDocument.getRename() != null && Boolean.TRUE.equals(textDocument.getRename().getPrepareSupport());
    }
}

