/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.workspace;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import java.net.URI;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.workspace.BallerinaWorkspaceManager;
import org.ballerinalang.langserver.workspace.BallerinaWorkspaceManagerProxy;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;

public class BallerinaWorkspaceManagerProxyImpl
implements BallerinaWorkspaceManagerProxy {
    private final WorkspaceManager baseWorkspaceManager;
    private final ClonedWorkspace clonedWorkspaceManager;

    public BallerinaWorkspaceManagerProxyImpl(LanguageServerContext serverContext) {
        this.baseWorkspaceManager = new BallerinaWorkspaceManager(serverContext);
        this.clonedWorkspaceManager = new ClonedWorkspace(serverContext);
    }

    public WorkspaceManager get() {
        return this.baseWorkspaceManager;
    }

    public WorkspaceManager get(String fileUri) {
        return URI.create(fileUri).getScheme().equals("expr") ? this.clonedWorkspaceManager : this.baseWorkspaceManager;
    }

    @Override
    public void didOpen(DidOpenTextDocumentParams params) throws WorkspaceDocumentException {
        String uri = params.getTextDocument().getUri();
        Optional<Path> path = PathUtil.getPathFromURI(uri);
        if (path.isEmpty()) {
            return;
        }
        this.baseWorkspaceManager.didOpen(path.get(), params);
        if (this.isExprScheme(uri)) {
            Optional project = this.baseWorkspaceManager.project(path.get());
            project.ifPresent(this.clonedWorkspaceManager::open);
        }
    }

    @Override
    public void didChange(DidChangeTextDocumentParams params) throws WorkspaceDocumentException {
        String uri = params.getTextDocument().getUri();
        Optional<Path> path = PathUtil.getPathFromURI(uri);
        if (path.isEmpty()) {
            return;
        }
        if (!this.isExprScheme(uri)) {
            this.baseWorkspaceManager.didChange(path.get(), params);
        }
        this.clonedWorkspaceManager.didChange(path.get(), params);
    }

    @Override
    public void didClose(DidCloseTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        Optional<Path> path = PathUtil.getPathFromURI(uri);
        if (path.isEmpty()) {
            return;
        }
        if (this.isExprScheme(uri)) {
            this.clonedWorkspaceManager.didClose(path.get(), params);
            return;
        }
        this.baseWorkspaceManager.didClose(path.get(), params);
    }

    public void setBuildOptions(BuildOptions buildOptions) {
        ((BallerinaWorkspaceManager)this.baseWorkspaceManager).setBuildOptions(buildOptions);
        this.clonedWorkspaceManager.setBuildOptions(buildOptions);
    }

    private boolean isExprScheme(String uri) {
        return URI.create(uri).getScheme().equals("expr");
    }

    private static class ClonedWorkspace
    extends BallerinaWorkspaceManager {
        public ClonedWorkspace(LanguageServerContext serverContext) {
            super(serverContext);
        }

        public void open(Project project) {
            this.sourceRootToProject.put(project.sourceRoot(), BallerinaWorkspaceManager.ProjectContext.from(project.duplicate()));
        }

        @Override
        public void didClose(Path filePath, DidCloseTextDocumentParams params) {
            Optional<Project> project = this.project(filePath);
            if (project.isEmpty()) {
                return;
            }
            Path projectRoot = project.get().sourceRoot();
            this.sourceRootToProject.remove(projectRoot);
            this.clientLogger.logTrace("Operation '" + LSContextOperation.TXT_DID_CLOSE.getName() + "' {project: '" + projectRoot.toUri().toString() + "' kind: '" + project.get().kind().name().toLowerCase(Locale.getDefault()) + "'} removed");
        }

        @Override
        public String uriScheme() {
            return "expr";
        }
    }
}

