/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import java.io.IOException;

public class BuildConfigHandler
extends AbstractArtifactHandler {
    @Override
    public void createArtifacts() throws KubernetesPluginException {
        BuildConfig buildConfig = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildConfigSpecFluent.StrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigBuilder)((BuildConfigBuilder)new BuildConfigBuilder().withApiVersion("build.openshift.io/v1")).withKind("BuildConfig")).withNewMetadata().withName("dockerfile-binary-build")).endMetadata()).withNewSpec().withNewSource().withType("Binary")).endSource()).withNewStrategy().withType("Docker")).withNewDockerStrategy().withNoCache(false)).endDockerStrategy()).endStrategy()).withNewOutput().withNewTo().withKind("ImageStreamTag")).withName("dockerfile-app:latest")).endTo()).endOutput()).endSpec()).build();
        Object outputFileName = "_build_config.yaml";
        try {
            String buildConfigYAML = KubernetesUtils.asYaml(buildConfig);
            if (this.dataHolder.isSingleYaml()) {
                outputFileName = buildConfig.getMetadata().getName() + ".yaml";
            }
            OUT.println("\t@openshift:BuildConfig");
            KubernetesUtils.writeToFile(this.dataHolder.getOpenshiftArtifactOutputPath(), buildConfigYAML, (String)outputFileName);
        }
        catch (IOException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED, new NullLocation(), "buildConfig", outputFileName);
            throw new KubernetesPluginException(diagnostic);
        }
    }
}

