/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.models.ConfigMapModel;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.JobModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import java.io.IOException;
import java.util.Set;

public class ConfigMapHandler
extends AbstractArtifactHandler {
    private void generate(ConfigMapModel configMapModel) throws KubernetesPluginException {
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapModel.getName())).withNamespace(this.dataHolder.getNamespace())).endMetadata()).withData(configMapModel.getData())).build();
        try {
            String configMapContent = KubernetesUtils.asYaml(configMap);
            Object outputFileName = "_config_map.yaml";
            if (this.dataHolder.isSingleYaml()) {
                outputFileName = configMap.getMetadata().getName() + ".yaml";
            }
            KubernetesUtils.writeToFile(configMapContent, (String)outputFileName);
        }
        catch (IOException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED, new NullLocation(), "config map", configMapModel.getName());
            throw new KubernetesPluginException(diagnostic);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        Set<ConfigMapModel> configMapModels = this.dataHolder.getConfigMapModelSet();
        StringBuilder configTomlEnv = new StringBuilder();
        for (ConfigMapModel configMapModel : configMapModels) {
            if (configMapModel.isBallerinaConf()) {
                configTomlEnv.append(this.getBALConfigFiles(configMapModel));
            }
            this.generate(configMapModel);
        }
        if (configTomlEnv.length() > 0) {
            EnvVar ballerinaConfEnv = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("BAL_CONFIG_FILES")).withValue(configTomlEnv.toString())).build();
            if (this.dataHolder.getJobModel() == null) {
                DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
                deploymentModel.addEnv(ballerinaConfEnv);
                this.dataHolder.setDeploymentModel(deploymentModel);
            } else {
                JobModel jobModel = this.dataHolder.getJobModel();
                jobModel.addEnv(ballerinaConfEnv);
                this.dataHolder.setJobModel(jobModel);
            }
        }
        OUT.println("\t@kubernetes:ConfigMap");
    }

    private String getBALConfigFiles(ConfigMapModel configMapModel) {
        StringBuilder configPaths = new StringBuilder();
        for (String key : configMapModel.getData().keySet()) {
            configPaths.append(configMapModel.getMountPath()).append(key).append(":");
        }
        return configPaths.toString();
    }
}

