/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tasks;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.ballerina.c2c.ArtifactManager;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.models.KubernetesContext;
import io.ballerina.c2c.models.KubernetesDataHolder;
import io.ballerina.c2c.utils.DockerGenUtils;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.cli.utils.TestUtils;
import io.ballerina.projects.BalCommand;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.plugins.CompilerLifecycleEventContext;
import io.ballerina.projects.plugins.CompilerLifecycleTask;
import io.ballerina.toml.api.Toml;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2CCodeGeneratedTask
implements CompilerLifecycleTask<CompilerLifecycleEventContext> {
    private static final Logger pluginLog = LoggerFactory.getLogger(C2CCodeGeneratedTask.class);
    private final KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();

    public void perform(CompilerLifecycleEventContext compilerLifecycleEventContext) {
        Project project = compilerLifecycleEventContext.currentPackage().project();
        String cloud = project.buildOptions().cloud();
        if (cloud == null || !KubernetesUtils.isValidBuildOption(cloud)) {
            return;
        }
        BalCommand balCommand = compilerLifecycleEventContext.balCommand();
        Optional executablePath = compilerLifecycleEventContext.getGeneratedArtifactPath();
        Package currentPackage = compilerLifecycleEventContext.currentPackage();
        if (balCommand == BalCommand.BUILD) {
            this.setupForCreatingCloudBuildArtifacts(compilerLifecycleEventContext, currentPackage, executablePath, balCommand);
        } else if (balCommand == BalCommand.TEST) {
            if (cloud.equals("k8s")) {
                KubernetesUtils.printError("k8s cloud build only supported for build");
                pluginLog.error("k8s cloud build only supported for build");
                return;
            }
            this.setupForRunningTestsInCloud(compilerLifecycleEventContext, executablePath, project, currentPackage, balCommand);
        } else {
            KubernetesUtils.printError("unsupported command for c2c plugin: " + String.valueOf(balCommand));
            pluginLog.error("unsupported command for c2c plugin: " + String.valueOf(balCommand));
        }
    }

    private void setupForCreatingCloudBuildArtifacts(CompilerLifecycleEventContext compilerLifecycleEventContext, Package currentPackage, Optional<Path> executablePath, BalCommand balCommand) {
        PackageDescriptor descriptor = currentPackage.descriptor();
        executablePath.ifPresent(path -> {
            String executableJarName = "$anon".equals(descriptor.org().value()) ? path.getFileName().toString() : descriptor.org().value() + "-" + descriptor.name().value() + "-" + String.valueOf(descriptor.version().value()) + ".jar";
            String outputName = "$anon".equals(descriptor.org().value()) ? DockerGenUtils.extractJarName(path.getFileName()) : descriptor.name().value().toLowerCase(Locale.ROOT);
            this.dataHolder.setOutputName(outputName);
            this.addDependencyJars(compilerLifecycleEventContext.compilation(), executableJarName);
            this.dataHolder.setSourceRoot(((Path)executablePath.get()).getParent().getParent().getParent());
            this.codeGeneratedInternal(KubernetesUtils.getProjectID(currentPackage), (Path)path, compilerLifecycleEventContext.currentPackage(), balCommand);
        });
    }

    private void setupForRunningTestsInCloud(CompilerLifecycleEventContext compilerLifecycleEventContext, Optional<Path> executablePath, Project project, Package currentPackage, BalCommand balCommand) {
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)compilerLifecycleEventContext.compilation(), (JvmTarget)JvmTarget.JAVA_21);
        this.dataHolder.getDockerModel().setTest(true);
        executablePath.ifPresent(path -> {
            List<String> cmd;
            Map testSuiteMap;
            Path testsCachePath;
            Target target;
            try {
                target = new Target(project.targetDir());
                testsCachePath = target.getTestsCachePath();
            }
            catch (IOException e) {
                KubernetesUtils.printError("error while creating target directory: " + e.getMessage());
                pluginLog.error("error while creating target directory: " + e.getMessage());
                return;
            }
            Path jsonFilePath = testsCachePath.resolve("test_suit.json");
            if (!Files.exists(jsonFilePath, new LinkOption[0])) {
                KubernetesUtils.printError("error while finding the test suit json");
                pluginLog.error("error while finding the test suit json");
                return;
            }
            ArrayList<Path> classPaths = new ArrayList<Path>();
            List<Path> moduleJarPaths = TestUtils.getModuleJarPaths((JBallerinaBackend)jBallerinaBackend, (Package)currentPackage);
            moduleJarPaths = moduleJarPaths.stream().map(Path::getFileName).toList();
            try (BufferedReader br = Files.newBufferedReader(jsonFilePath, StandardCharsets.UTF_8);){
                Gson gson = new Gson();
                testSuiteMap = (Map)gson.fromJson((Reader)br, new TestSuiteTypeToken().getType());
                for (ModuleDescriptor moduleDescriptor : currentPackage.moduleDependencyGraph().toTopologicallySortedList()) {
                    this.addTestDependencyJars(project, compilerLifecycleEventContext.compilation(), moduleDescriptor, testSuiteMap, classPaths, moduleJarPaths);
                }
            }
            catch (IOException e) {
                KubernetesUtils.printError("error while reading the test suit json");
                pluginLog.error("error while reading the test suit json");
                return;
            }
            TestUtils.writeToTestSuiteJson((Map)testSuiteMap, (Path)testsCachePath);
            StringJoiner classPath = TestUtils.joinClassPaths(classPaths);
            this.dataHolder.getDockerModel().setTestSuiteJsonPath(jsonFilePath);
            this.dataHolder.getDockerModel().setClassPath(classPath.toString());
            this.dataHolder.getDockerModel().setSourceRoot(project.sourceRoot());
            this.dataHolder.getDockerModel().setTarget(target);
            this.dataHolder.getDockerModel().setTestConfigPaths(this.getTestConfigPaths(project));
            Path mainArgsPath = path.getParent().resolve("mainArgs.txt");
            try {
                cmd = Files.readAllLines(mainArgsPath);
            }
            catch (IOException e) {
                KubernetesUtils.printError("error while reading the mainArgs.txt");
                pluginLog.error("error while reading the mainArgs.txt");
                return;
            }
            cmd.set(1, Paths.get(DockerGenUtils.getTestSuiteJsonCopiedDir(), new String[0]).resolve("test_suit.json").toString());
            cmd.set(2, DockerGenUtils.getTargetDir());
            Path jacocoAgentJarPath = Path.of(TestUtils.getJacocoAgentJarPath(), new String[0]);
            cmd.set(3, C2CCodeGeneratedTask.getCopiedJarPath(jacocoAgentJarPath.getFileName()).toString());
            this.dataHolder.getDockerModel().setJacocoAgentJarPath(jacocoAgentJarPath);
            this.dataHolder.getDockerModel().setTestRunTimeCmdArgs(cmd);
            if (!project.kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT)) {
                this.dataHolder.setOutputName(project.currentPackage().packageName().toString().toLowerCase(Locale.ROOT) + "-testable");
            } else {
                this.dataHolder.setOutputName(DockerGenUtils.extractJarName(path.getFileName()) + "-testable");
            }
            this.dataHolder.setSourceRoot(project.sourceRoot());
            this.codeGeneratedInternal(KubernetesUtils.getProjectID(currentPackage), (Path)path, currentPackage, balCommand);
        });
    }

    private List<Path> getTestConfigPaths(Project project) {
        ArrayList<Path> paths = new ArrayList<Path>();
        project.currentPackage().modules().forEach(module -> {
            Path modulePath = !Objects.equals(module.moduleName().toString(), project.currentPackage().packageName().toString()) ? project.sourceRoot().resolve("modules").resolve(module.moduleName().moduleNamePart()) : project.sourceRoot();
            Path testConfigPath = modulePath.resolve("tests").resolve("Config.toml");
            if (Files.exists(testConfigPath, new LinkOption[0])) {
                paths.add(testConfigPath);
            }
        });
        return paths;
    }

    public void codeGeneratedInternal(PackageID packageId, Path executableJarFile, Package currentPackage, BalCommand balCommand) {
        Optional cloudToml = currentPackage.cloudToml();
        BuildOptions buildOptions = currentPackage.project().buildOptions();
        String buildType = buildOptions.cloud();
        this.dataHolder.getDockerModel().setFatJarPath(executableJarFile);
        String graalvmBuildArgs = buildOptions.graalVMBuildOptions();
        this.dataHolder.getDockerModel().setGraalvmBuildArgs(graalvmBuildArgs);
        KubernetesContext.getInstance().setCurrentPackage(packageId);
        this.dataHolder.setPackageID(packageId);
        this.dataHolder.getDockerModel().setGraalVMBuild(buildOptions.nativeImage());
        executableJarFile = executableJarFile.toAbsolutePath();
        if (null != executableJarFile.getParent() && Files.exists(executableJarFile.getParent(), new LinkOption[0])) {
            Path projectRoot;
            Path kubernetesOutputPath = executableJarFile.getParent().resolve("kubernetes");
            Path dockerOutputPath = executableJarFile.getParent().resolve("docker");
            Path openshiftOutputPath = executableJarFile.getParent().resolve("openshift");
            if (null != executableJarFile.getParent().getParent().getParent() && Files.exists(executableJarFile.getParent().getParent().getParent(), new LinkOption[0]) && Files.exists((projectRoot = currentPackage.project().sourceRoot()).resolve("Ballerina.toml"), new LinkOption[0])) {
                if (balCommand == BalCommand.TEST) {
                    kubernetesOutputPath = projectRoot.resolve("target").resolve("kubernetes").resolve("test").resolve(DockerGenUtils.extractJarName(executableJarFile));
                    dockerOutputPath = projectRoot.resolve("target").resolve("docker").resolve("test").resolve(DockerGenUtils.extractJarName(executableJarFile));
                    openshiftOutputPath = projectRoot.resolve("target").resolve("openshift").resolve("test").resolve(DockerGenUtils.extractJarName(executableJarFile));
                } else {
                    kubernetesOutputPath = projectRoot.resolve("target").resolve("kubernetes").resolve(DockerGenUtils.extractJarName(executableJarFile));
                    dockerOutputPath = projectRoot.resolve("target").resolve("docker").resolve(DockerGenUtils.extractJarName(executableJarFile));
                    openshiftOutputPath = projectRoot.resolve("target").resolve("openshift").resolve(DockerGenUtils.extractJarName(executableJarFile));
                }
                cloudToml.ifPresent(kubernetesToml -> this.dataHolder.setBallerinaCloud(new Toml(kubernetesToml.tomlAstNode())));
            }
            this.dataHolder.setK8sArtifactOutputPath(kubernetesOutputPath);
            this.dataHolder.setDockerArtifactOutputPath(dockerOutputPath);
            this.dataHolder.setOpenshiftArtifactOutputPath(openshiftOutputPath);
            ArtifactManager artifactManager = new ArtifactManager();
            try {
                KubernetesUtils.deleteDirectory(kubernetesOutputPath);
                KubernetesUtils.deleteDirectory(dockerOutputPath);
                artifactManager.populateDeploymentModel();
                artifactManager.createArtifacts(buildType, buildOptions.nativeImage());
            }
            catch (KubernetesPluginException e) {
                String errorMessage = "module [" + String.valueOf(packageId) + "] " + e.getMessage();
                KubernetesUtils.printError(errorMessage);
                if (!e.isSkipPrintTrace()) {
                    pluginLog.error(errorMessage, (Throwable)e);
                }
                try {
                    KubernetesUtils.deleteDirectory(kubernetesOutputPath);
                    KubernetesUtils.deleteDirectory(dockerOutputPath);
                }
                catch (KubernetesPluginException kubernetesPluginException) {}
            }
        } else {
            KubernetesUtils.printError("error in resolving Docker generation location.");
            pluginLog.error("error in resolving Docker generation location.");
        }
    }

    private void addTestDependencyJars(Project project, PackageCompilation compilation, ModuleDescriptor moduleDescriptor, Map<String, TestSuite> testSuiteMap, List<Path> classPaths, List<Path> moduleJarPaths) {
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)compilation, (JvmTarget)JvmTarget.JAVA_21);
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        Collection dependencies = jarResolver.getJarFilePathsRequiredForTestExecution(moduleDescriptor.name());
        this.dataHolder.getDockerModel().addDependencyJarPaths(dependencies.stream().map(JarLibrary::path).collect(Collectors.toSet()));
        Stream<Path> jarPaths = dependencies.stream().map(JarLibrary::path);
        Stream<Path> pathStream = jarPaths.map(jarPath -> {
            Path jarFileName = jarPath.getFileName();
            jarPath = C2CCodeGeneratedTask.getCopiedJarPath(jarFileName);
            if (!moduleJarPaths.contains(jarFileName)) {
                classPaths.add((Path)jarPath);
            }
            return jarPath;
        });
        Module module = project.currentPackage().module(moduleDescriptor.name());
        TestSuite suite = testSuiteMap.get(TestUtils.getResolvedModuleName((Module)module, (ModuleName)moduleDescriptor.name()));
        if (suite != null) {
            suite.addTestExecutionDependencies((Collection)pathStream.collect(Collectors.toCollection(ArrayList::new)));
        }
    }

    private static Path getCopiedJarPath(Path jarFileName) {
        StringBuilder newPath = new StringBuilder();
        Path jarPath = Path.of(newPath.append(DockerGenUtils.getWorkDir()).append("/jars/").append(jarFileName.toString()).toString(), new String[0]);
        return jarPath;
    }

    private void addDependencyJars(PackageCompilation compilation, String executableFatJar) {
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)compilation, (JvmTarget)JvmTarget.JAVA_21);
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        this.dataHolder.getDockerModel().addDependencyJarPaths(jarResolver.getJarFilePathsRequiredForExecution().stream().map(JarLibrary::path).collect(Collectors.toSet()));
        jarResolver.getJarFilePathsRequiredForExecution().stream().filter(jarLibrary -> jarLibrary.path().getFileName().toString().endsWith(executableFatJar)).findFirst().ifPresent(jarLibrary -> this.dataHolder.setJarPath(jarLibrary.path()));
    }

    private static class TestSuiteTypeToken
    extends TypeToken<Map<String, TestSuite>> {
        private TestSuiteTypeToken() {
        }
    }
}

