/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.util;

import io.ballerina.c2c.util.C2CVisitor;
import io.ballerina.c2c.util.ModuleLevelVariableExtractor;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.c2c.util.Task;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class ProjectServiceInfo {
    private final List<ServiceInfo> serviceList = new ArrayList<ServiceInfo>();
    private Task task = null;

    public ProjectServiceInfo(Project project) {
        this(project, new ArrayList<Diagnostic>());
    }

    public ProjectServiceInfo(Project project, List<Diagnostic> diagnostics) {
        Package currentPackage = project.currentPackage();
        Iterable modules = currentPackage.modules();
        for (Module module : modules) {
            NodeVisitor visitor;
            Node node;
            Document document;
            Collection documentIds = module.documentIds();
            HashMap<String, Node> moduleLevelVariables = new HashMap<String, Node>();
            SemanticModel semanticModel = module.getCompilation().getSemanticModel();
            for (DocumentId doc : documentIds) {
                document = module.document(doc);
                node = document.syntaxTree().rootNode();
                visitor = new ModuleLevelVariableExtractor(moduleLevelVariables);
                node.accept(visitor);
            }
            for (DocumentId doc : documentIds) {
                document = module.document(doc);
                node = document.syntaxTree().rootNode();
                visitor = new C2CVisitor(moduleLevelVariables, semanticModel, diagnostics);
                node.accept(visitor);
                this.serviceList.addAll(visitor.getServices());
                this.task = visitor.getTask();
            }
        }
    }

    public Optional<Task> getTask() {
        return Optional.ofNullable(this.task);
    }

    @Generated
    public List<ServiceInfo> getServiceList() {
        return this.serviceList;
    }
}

