/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.utils;

import io.ballerina.c2c.KubernetesConstants;
import io.ballerina.c2c.exceptions.DockerGenException;
import io.ballerina.c2c.models.CopyFileModel;
import io.ballerina.c2c.models.DockerModel;
import io.ballerina.c2c.utils.DockerGenUtils;
import io.ballerina.c2c.utils.DockerImageName;
import io.ballerina.cli.utils.DebugUtils;
import io.ballerina.cli.utils.TestUtils;
import io.ballerina.projects.JarResolver;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;

public class DockerGenerator {
    protected final DockerModel dockerModel;

    public DockerGenerator(DockerModel dockerModel) {
        String registry = dockerModel.getRegistry();
        Object imageName = dockerModel.getName();
        imageName = !DockerGenUtils.isBlank(registry) ? registry + "/" + (String)imageName + ":" + dockerModel.getTag() : (String)imageName + ":" + dockerModel.getTag();
        dockerModel.setName((String)imageName);
        this.dockerModel = dockerModel;
    }

    public void createArtifacts(PrintStream outStream, String logAppender, Path jarFilePath, Path outputDir) throws DockerGenException {
        try {
            if (!this.dockerModel.isThinJar()) {
                DockerGenUtils.writeToFile(this.generateDockerfile(), outputDir.resolve("Dockerfile"));
                DockerGenUtils.copyFileOrDirectory(this.dockerModel.getFatJarPath(), outputDir.resolve(this.dockerModel.getFatJarPath().getFileName()));
            } else {
                String dockerContent = this.generateDockerfile();
                this.copyNativeJars(outputDir);
                DockerGenUtils.writeToFile(dockerContent, outputDir.resolve("Dockerfile"));
                Path jarLocation = outputDir.resolve(DockerGenUtils.extractJarName(jarFilePath) + ".jar");
                DockerGenUtils.copyFileOrDirectory(jarFilePath, jarLocation);
            }
            this.copyExternalFiles(outputDir);
            if (this.dockerModel.isBuildImage()) {
                outStream.println("\nBuilding the docker image\n");
                this.buildImage(outputDir);
                outStream.println();
            }
        }
        catch (IOException e) {
            throw new DockerGenException("unable to write content to " + String.valueOf(outputDir));
        }
    }

    public void createTestArtifacts(PrintStream outStream, String logAppender, Path outputDir) throws DockerGenException {
        try {
            String dockerContent = this.generateTestDockerFile(this.dockerModel.getTestSuiteJsonPath(), this.dockerModel.getJacocoAgentJarPath());
            this.copyNativeJars(outputDir);
            DockerGenUtils.copyFileOrDirectory(this.dockerModel.getTestSuiteJsonPath(), outputDir);
            DockerGenUtils.copyFileOrDirectory(this.dockerModel.getJacocoAgentJarPath(), outputDir);
            DockerGenUtils.writeToFile(dockerContent, outputDir.resolve("Dockerfile"));
            DockerGenUtils.copyTestConfigFiles(outputDir, this.dockerModel);
            this.copyExternalFiles(outputDir);
            outStream.println("\nBuilding the docker image\n");
            this.buildImage(outputDir);
            outStream.println();
        }
        catch (IOException e) {
            throw new DockerGenException("unable to write content to " + String.valueOf(outputDir));
        }
    }

    private void copyExternalFiles(Path outputDir) throws DockerGenException {
        for (CopyFileModel copyFileModel : this.dockerModel.getCopyFiles()) {
            Path target = outputDir.resolve(Paths.get(copyFileModel.getSource(), new String[0]).getFileName());
            Path sourcePath = Paths.get(copyFileModel.getSource(), new String[0]);
            if (!sourcePath.isAbsolute()) {
                sourcePath = sourcePath.toAbsolutePath();
            }
            DockerGenUtils.copyFileOrDirectory(sourcePath, target);
        }
    }

    private void copyNativeJars(Path outputDir) throws DockerGenException {
        for (Path jarPath : this.dockerModel.getDependencyJarPaths()) {
            Path target = outputDir.resolve(jarPath.getFileName());
            Path sourcePath = jarPath;
            if (!sourcePath.isAbsolute()) {
                sourcePath = sourcePath.toAbsolutePath();
            }
            DockerGenUtils.copyFileOrDirectory(sourcePath, target);
        }
    }

    public void buildImage(Path dockerDir) throws DockerGenException {
        DockerImageName.validate(this.dockerModel.getName());
        DockerGenUtils.printDebug("building docker image `" + this.dockerModel.getName() + "` from directory `" + String.valueOf(dockerDir) + "`.");
        ProcessBuilder pb = new ProcessBuilder("docker", "build", "--no-cache", "--force-rm", "-t", this.dockerModel.getName(), dockerDir.toFile().toString());
        pb.inheritIO();
        try {
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new DockerGenException("docker build failed. refer to the build log");
            }
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            throw new DockerGenException(this.getErrorMessage(e.getMessage()));
        }
    }

    private String getErrorMessage(String message) {
        switch (message) {
            case "Cannot run program \"docker\": error=2, No such file or directory": 
            case "Cannot run program \"docker\": CreateProcess error=2, The system cannot find the file specified": {
                return "command not found: docker";
            }
        }
        return message;
    }

    private String generateDockerfile() {
        StringBuilder dockerfileContent = new StringBuilder();
        this.addInitialDockerContent(dockerfileContent);
        if (this.dockerModel.isThinJar()) {
            this.dockerModel.getDependencyJarPaths().stream().map(Path::getFileName).filter(path -> !path.toString().endsWith("-observability-symbols.jar") && !path.toString().endsWith(this.dockerModel.getJarFileName())).collect(Collectors.toCollection(TreeSet::new)).forEach(path -> {
                dockerfileContent.append("COPY ").append(path).append(" ").append(DockerGenUtils.getWorkDir()).append("/jars/ ").append(KubernetesConstants.LINE_SEPARATOR);
                boolean isCiBuild = "true".equals(System.getenv().get("CI_BUILD"));
                if (isCiBuild) {
                    dockerfileContent.append("RUN true ").append(KubernetesConstants.LINE_SEPARATOR);
                }
            });
            this.dockerModel.getDependencyJarPaths().forEach(path -> {
                if (path.toString().endsWith("observability-symbols.jar") || path.toString().endsWith(this.dockerModel.getJarFileName())) {
                    dockerfileContent.append("COPY ").append(path.getFileName()).append(" ").append(DockerGenUtils.getWorkDir()).append("/jars/ ").append(KubernetesConstants.LINE_SEPARATOR);
                }
            });
        } else {
            dockerfileContent.append("COPY ").append(this.dockerModel.getFatJarPath().getFileName()).append(" ").append(DockerGenUtils.getWorkDir()).append("/jars/ ").append(KubernetesConstants.LINE_SEPARATOR);
        }
        this.appendUser(dockerfileContent);
        dockerfileContent.append("WORKDIR ").append(DockerGenUtils.getWorkDir()).append(KubernetesConstants.LINE_SEPARATOR);
        this.appendCommonCommands(dockerfileContent);
        if (DockerGenUtils.isBlank(this.dockerModel.getEntryPoint())) {
            PackageID packageID = this.dockerModel.getPkgId();
            String mainClass = JarResolver.getQualifiedClassName((String)packageID.orgName.getValue(), (String)packageID.name.getValue(), (String)packageID.version.getValue(), (String)"$_init");
            ArrayList<String> args = new ArrayList<String>();
            args.add("java");
            args.add("-XX:+ExitOnOutOfMemoryError");
            args.add("-Xdiag");
            if (this.dockerModel.isEnableDebug()) {
                args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + this.dockerModel.getDebugPort());
            }
            args.add("-cp");
            args.add(this.dockerModel.getJarFileName() + ":jars/*");
            args.add(mainClass);
            dockerfileContent.append(this.entryPointArgBuilder(args));
        } else {
            dockerfileContent.append(this.dockerModel.getEntryPoint());
        }
        if (!DockerGenUtils.isBlank(this.dockerModel.getCommandArg())) {
            dockerfileContent.append(this.dockerModel.getCommandArg());
        }
        dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
        return dockerfileContent.toString();
    }

    private String entryPointArgBuilder(List<String> args) {
        return "ENTRYPOINT [" + String.join((CharSequence)",", (CharSequence[])args.stream().map(s -> "\"" + s + "\"").toArray(String[]::new)) + "]";
    }

    private void addInitialDockerContent(StringBuilder dockerfileContent) {
        dockerfileContent.append("# Auto Generated Dockerfile").append(KubernetesConstants.LINE_SEPARATOR);
        dockerfileContent.append("FROM ").append(this.dockerModel.getBaseImage()).append(KubernetesConstants.LINE_SEPARATOR);
        dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
        dockerfileContent.append("LABEL maintainer=\"dev@ballerina.io\"").append(KubernetesConstants.LINE_SEPARATOR);
    }

    private String generateTestDockerFile(Path testSuiteJsonPath, Path jacocoAgentJarPath) throws DockerGenException {
        StringBuilder testDockerFileContent = new StringBuilder();
        this.addInitialDockerContent(testDockerFileContent);
        testDockerFileContent.append("COPY ");
        Optional<Path> testSuiteJsonPathOptional = Optional.ofNullable(testSuiteJsonPath.getFileName());
        if (!testSuiteJsonPathOptional.isPresent()) {
            throw new DockerGenException("Test suite json path is not provided");
        }
        testDockerFileContent.append(testSuiteJsonPathOptional.get()).append(" ").append(DockerGenUtils.getTestSuiteJsonCopiedDir()).append("/ ").append(KubernetesConstants.LINE_SEPARATOR);
        new TreeSet<Path>(this.dockerModel.getDependencyJarPaths()).stream().map(Path::getFileName).forEach(path -> testDockerFileContent.append("COPY ").append(path).append(" ").append(DockerGenUtils.getWorkDir()).append("/jars/ ").append(KubernetesConstants.LINE_SEPARATOR));
        testDockerFileContent.append("COPY ");
        Optional<Path> jacocoAgentJarPathOptional = Optional.ofNullable(jacocoAgentJarPath.getFileName());
        if (!jacocoAgentJarPathOptional.isPresent()) {
            throw new DockerGenException("Jacoco agent jar path is not provided");
        }
        testDockerFileContent.append(jacocoAgentJarPathOptional.get()).append(" ").append(DockerGenUtils.getWorkDir()).append("/jars/ ").append(KubernetesConstants.LINE_SEPARATOR);
        Path projectSourceRoot = this.dockerModel.getSourceRoot();
        DockerGenUtils.addConfigTomls(testDockerFileContent, this.dockerModel, Paths.get(DockerGenUtils.getWorkDir(), new String[0]), projectSourceRoot.toString());
        this.appendUser(testDockerFileContent);
        testDockerFileContent.append("WORKDIR ").append(DockerGenUtils.getWorkDir()).append(KubernetesConstants.LINE_SEPARATOR);
        this.appendCommonCommands(testDockerFileContent);
        if (!DockerGenUtils.isBlank(this.dockerModel.getEntryPoint())) {
            testDockerFileContent.append(this.dockerModel.getEntryPoint()).append(KubernetesConstants.LINE_SEPARATOR);
        } else {
            this.addDockerTestEntryPoint(testDockerFileContent);
        }
        if (!DockerGenUtils.isBlank(this.dockerModel.getCommandArg())) {
            testDockerFileContent.append(this.dockerModel.getCommandArg()).append(" ");
        } else {
            this.addDockerTestCMDArgs(testDockerFileContent);
        }
        testDockerFileContent.append(KubernetesConstants.LINE_SEPARATOR);
        return testDockerFileContent.toString();
    }

    private void addDockerTestCMDArgs(StringBuilder testDockerFileContent) {
        if (this.dockerModel.getTestRunTimeCmdArgs() != null) {
            List<String> testRunTimeCmdArgs = this.dockerModel.getTestRunTimeCmdArgs();
            testDockerFileContent.append(KubernetesConstants.LINE_SEPARATOR);
            testDockerFileContent.append(this.buildCMDArgs(testRunTimeCmdArgs));
        }
    }

    protected String buildCMDArgs(List<String> args) {
        return "CMD [" + String.join((CharSequence)",", (CharSequence[])args.stream().map(s -> "\"" + s + "\"").toArray(String[]::new)) + "]";
    }

    private void addDockerTestEntryPoint(StringBuilder testDockerFileContent) {
        ArrayList<String> args = new ArrayList<String>(TestUtils.getInitialCmdArgs((String)"java", (String)DockerGenUtils.getWorkDir()));
        if (this.dockerModel.isEnableDebug()) {
            args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + this.dockerModel.getDebugPort());
        } else if (DebugUtils.isInDebugMode()) {
            args.add(DebugUtils.getDebugArgs((PrintStream)System.err));
        }
        if (!DockerGenUtils.isBlank(this.dockerModel.getClassPath())) {
            args.add("-cp");
            args.add(this.dockerModel.getClassPath());
        }
        args.add("org.ballerinalang.test.runtime.BTestMain");
        testDockerFileContent.append(this.entryPointArgBuilder(args));
    }

    protected void appendUser(StringBuilder dockerfileContent) {
        if (this.dockerModel.getBaseImage().equals("ballerina/jvm-runtime:3.0")) {
            dockerfileContent.append("RUN addgroup troupe \\").append(KubernetesConstants.LINE_SEPARATOR);
            dockerfileContent.append("    && adduser -S -s /bin/bash -g 'ballerina' -G troupe -D ballerina \\").append(KubernetesConstants.LINE_SEPARATOR);
            dockerfileContent.append("    && apk add --update --no-cache bash \\").append(KubernetesConstants.LINE_SEPARATOR);
            if (this.dockerModel.isTest()) {
                dockerfileContent.append("    && mkdir -p /home/ballerina/target \\").append(KubernetesConstants.LINE_SEPARATOR);
                dockerfileContent.append("    && chown -R ballerina:troupe /home/ballerina/target \\").append(KubernetesConstants.LINE_SEPARATOR);
                dockerfileContent.append("    && chmod -R 777 /home/ballerina/target \\").append(KubernetesConstants.LINE_SEPARATOR);
            }
            dockerfileContent.append("    && rm -rf /var/cache/apk/*").append(KubernetesConstants.LINE_SEPARATOR);
            dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
        }
    }

    protected void appendCommonCommands(StringBuilder dockerfileContent) {
        this.dockerModel.getEnv().forEach((key, value) -> dockerfileContent.append("ENV ").append((String)key).append("=").append((String)value).append(KubernetesConstants.LINE_SEPARATOR));
        this.dockerModel.getCopyFiles().forEach(file -> {
            String sourceFileName = String.valueOf(Paths.get(file.getSource(), new String[0]).getFileName());
            dockerfileContent.append("COPY ").append(sourceFileName).append(" ").append(file.getTarget()).append(KubernetesConstants.LINE_SEPARATOR);
        });
        dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
        if (this.dockerModel.isService() && this.dockerModel.getPorts().size() > 0) {
            dockerfileContent.append("EXPOSE");
            this.dockerModel.getPorts().forEach(port -> dockerfileContent.append(" ").append(port));
        }
        dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
        if (this.dockerModel.getBaseImage().equals("ballerina/jvm-runtime:3.0")) {
            dockerfileContent.append("USER ballerina").append(KubernetesConstants.LINE_SEPARATOR);
            dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
        }
    }
}

