/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.utils;

import io.ballerina.c2c.KubernetesConstants;
import io.ballerina.c2c.exceptions.DockerGenException;
import io.ballerina.c2c.models.CopyFileModel;
import io.ballerina.c2c.models.DockerModel;
import io.ballerina.c2c.utils.DockerGenUtils;
import io.ballerina.c2c.utils.DockerGenerator;
import io.ballerina.cli.utils.TestUtils;
import io.ballerina.projects.internal.model.Target;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class NativeDockerGenerator
extends DockerGenerator {
    public NativeDockerGenerator(DockerModel dockerModel) {
        super(dockerModel);
    }

    @Override
    public void createArtifacts(PrintStream outStream, String logAppender, Path jarFilePath, Path outputDir) throws DockerGenException {
        String dockerContent = this.generateMultiStageDockerfile();
        try {
            DockerGenUtils.writeToFile(dockerContent, outputDir.resolve("Dockerfile"));
            Path jarLocation = outputDir.resolve(DockerGenUtils.extractJarName(this.dockerModel.getFatJarPath()) + ".jar");
            DockerGenUtils.copyFileOrDirectory(this.dockerModel.getFatJarPath(), jarLocation);
            for (CopyFileModel copyFileModel : this.dockerModel.getCopyFiles()) {
                Path target = outputDir.resolve(Paths.get(copyFileModel.getSource(), new String[0]).getFileName());
                Path sourcePath = Paths.get(copyFileModel.getSource(), new String[0]);
                if (!sourcePath.isAbsolute()) {
                    sourcePath = sourcePath.toAbsolutePath();
                }
                DockerGenUtils.copyFileOrDirectory(sourcePath, target);
            }
            if (this.dockerModel.isBuildImage()) {
                outStream.println("Building the native image. This may take a while\n");
                this.buildImage(outputDir);
                outStream.println();
            }
        }
        catch (IOException e) {
            throw new DockerGenException("unable to write content to " + String.valueOf(outputDir));
        }
    }

    private String generateMultiStageDockerfile() {
        String fatJarFileName = this.dockerModel.getFatJarPath().getFileName().toString();
        String executableName = fatJarFileName.replaceFirst(".jar", "");
        StringBuilder dockerfileContent = this.getInitialDockerContent(fatJarFileName);
        this.appendUser(dockerfileContent);
        this.appendCommonCommands(dockerfileContent);
        dockerfileContent.append("COPY --from=build /app/build/").append(executableName).append(" .").append(KubernetesConstants.LINE_SEPARATOR).append(KubernetesConstants.LINE_SEPARATOR);
        if (DockerGenUtils.isBlank(this.dockerModel.getEntryPoint())) {
            dockerfileContent.append("ENTRYPOINT [\"./").append(executableName).append("\"]").append(KubernetesConstants.LINE_SEPARATOR);
        } else {
            dockerfileContent.append(this.dockerModel.getEntryPoint());
        }
        if (!DockerGenUtils.isBlank(this.dockerModel.getCommandArg())) {
            dockerfileContent.append(this.dockerModel.getCommandArg());
        }
        dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
        return dockerfileContent.toString();
    }

    @Override
    protected void appendUser(StringBuilder dockerfileContent) {
        dockerfileContent.append("WORKDIR ").append("/home/ballerina").append(KubernetesConstants.LINE_SEPARATOR);
    }

    @Override
    public void createTestArtifacts(PrintStream outStream, String logAppender, Path outputDir) throws DockerGenException {
        String dockerContent = this.generateTestMultiStageDockerfile();
        try {
            DockerGenUtils.writeToFile(dockerContent, outputDir.resolve("Dockerfile"));
            Path jarLocation = outputDir.resolve(DockerGenUtils.extractJarName(this.dockerModel.getFatJarPath()) + ".jar");
            DockerGenUtils.copyFileOrDirectory(this.dockerModel.getFatJarPath(), jarLocation);
            Target target = this.dockerModel.getTarget();
            DockerGenUtils.copyFileOrDirectory(target.getNativeConfigPath().resolve("reflect-config.json"), outputDir.resolve("reflect-config.json"));
            for (CopyFileModel copyFileModel : this.dockerModel.getCopyFiles()) {
                Path copyTarget = outputDir.resolve(Paths.get(copyFileModel.getSource(), new String[0]).getFileName());
                Path sourcePath = Paths.get(copyFileModel.getSource(), new String[0]);
                if (!sourcePath.isAbsolute()) {
                    sourcePath = sourcePath.toAbsolutePath();
                }
                DockerGenUtils.copyFileOrDirectory(sourcePath, copyTarget);
            }
            DockerGenUtils.copyTestConfigFiles(outputDir, this.dockerModel);
            outStream.println("Building the native image. This may take a while\n");
            this.buildImage(outputDir);
            outStream.println();
        }
        catch (IOException e) {
            throw new DockerGenException("unable to write content to " + String.valueOf(outputDir));
        }
    }

    private String generateTestMultiStageDockerfile() throws DockerGenException {
        String fatJarFileName = this.dockerModel.getFatJarPath().getFileName().toString();
        String executableName = fatJarFileName.replaceFirst(".jar", "");
        StringBuilder dockerfileContent = this.getInitialDockerContent(fatJarFileName);
        this.appendUser(dockerfileContent);
        this.appendCommonCommands(dockerfileContent);
        Path projectSourceRoot = this.dockerModel.getSourceRoot();
        DockerGenUtils.addConfigTomls(dockerfileContent, this.dockerModel, Paths.get(DockerGenUtils.getWorkDir(), new String[0]), projectSourceRoot.toString());
        dockerfileContent.append("COPY --from=build /app/build/").append(executableName).append(" .").append(KubernetesConstants.LINE_SEPARATOR).append(KubernetesConstants.LINE_SEPARATOR);
        if (DockerGenUtils.isBlank(this.dockerModel.getEntryPoint())) {
            dockerfileContent.append("ENTRYPOINT [\"./").append(executableName).append("\"]").append(KubernetesConstants.LINE_SEPARATOR);
        } else {
            dockerfileContent.append(this.dockerModel.getEntryPoint());
        }
        if (!DockerGenUtils.isBlank(this.dockerModel.getCommandArg())) {
            dockerfileContent.append(this.dockerModel.getCommandArg());
        } else {
            this.addTestArgs(dockerfileContent);
        }
        dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
        return dockerfileContent.toString();
    }

    private void addTestArgs(StringBuilder dockerfileContent) {
        if (this.dockerModel.getTestRunTimeCmdArgs() != null) {
            List<String> args = this.dockerModel.getTestRunTimeCmdArgs();
            args.set(0, "true");
            args.set(1, TestUtils.getJsonFilePathInFatJar((String)File.separator));
            dockerfileContent.append(KubernetesConstants.LINE_SEPARATOR);
            dockerfileContent.append(this.buildCMDArgs(args));
        }
    }

    private StringBuilder getInitialDockerContent(String fatJarFileName) {
        StringBuilder stringBuilder = new StringBuilder().append("# Auto Generated Dockerfile").append(KubernetesConstants.LINE_SEPARATOR).append("FROM ").append(this.dockerModel.getBuilderBase()).append(" as build").append(KubernetesConstants.LINE_SEPARATOR).append(KubernetesConstants.LINE_SEPARATOR).append("WORKDIR /app/build").append(KubernetesConstants.LINE_SEPARATOR).append(KubernetesConstants.LINE_SEPARATOR).append("COPY ").append(fatJarFileName).append(" .");
        if (this.dockerModel.isTest()) {
            stringBuilder.append(KubernetesConstants.LINE_SEPARATOR).append("COPY ").append("reflect-config.json").append(" .").append(KubernetesConstants.LINE_SEPARATOR);
        }
        stringBuilder.append(KubernetesConstants.LINE_SEPARATOR).append(KubernetesConstants.LINE_SEPARATOR).append("RUN ").append(this.dockerModel.getBuilderCmd());
        if (this.dockerModel.isTest()) {
            stringBuilder.append(" -H:IncludeResources=").append("excludedClasses.txt").append(" -H:IncludeResources=").append(TestUtils.getJsonFilePathInFatJar((String)File.separator)).append(" -H:ReflectionConfigurationFiles=").append("reflect-config.json");
        }
        stringBuilder.append(KubernetesConstants.LINE_SEPARATOR).append(KubernetesConstants.LINE_SEPARATOR).append("FROM ").append(this.dockerModel.getBaseImage()).append(KubernetesConstants.LINE_SEPARATOR).append(KubernetesConstants.LINE_SEPARATOR);
        return stringBuilder;
    }
}

