/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceRange;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceRangeFluent;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ResourceRangeFluentImpl;

public class ResourceRangeBuilder
extends ResourceRangeFluentImpl<ResourceRangeBuilder>
implements VisitableBuilder<ResourceRange, ResourceRangeBuilder> {
    ResourceRangeFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceRangeBuilder() {
        this(false);
    }

    public ResourceRangeBuilder(Boolean validationEnabled) {
        this(new ResourceRange(), validationEnabled);
    }

    public ResourceRangeBuilder(ResourceRangeFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceRangeBuilder(ResourceRangeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceRange(), validationEnabled);
    }

    public ResourceRangeBuilder(ResourceRangeFluent<?> fluent, ResourceRange instance) {
        this(fluent, instance, false);
    }

    public ResourceRangeBuilder(ResourceRangeFluent<?> fluent, ResourceRange instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withMax(instance.getMax());
            fluent.withMin(instance.getMin());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ResourceRangeBuilder(ResourceRange instance) {
        this(instance, (Boolean)false);
    }

    public ResourceRangeBuilder(ResourceRange instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withMax(instance.getMax());
            this.withMin(instance.getMin());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceRange build() {
        ResourceRange buildable = new ResourceRange(this.fluent.getMax(), this.fluent.getMin());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

