/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.config.v1.Infrastructure;
import io.fabric8.openshift.api.model.config.v1.InfrastructureFluent;
import io.fabric8.openshift.api.model.config.v1.InfrastructureFluentImpl;

public class InfrastructureBuilder
extends InfrastructureFluentImpl<InfrastructureBuilder>
implements VisitableBuilder<Infrastructure, InfrastructureBuilder> {
    InfrastructureFluent<?> fluent;
    Boolean validationEnabled;

    public InfrastructureBuilder() {
        this(false);
    }

    public InfrastructureBuilder(Boolean validationEnabled) {
        this(new Infrastructure(), validationEnabled);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Infrastructure(), validationEnabled);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent, Infrastructure instance) {
        this(fluent, instance, false);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent, Infrastructure instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public InfrastructureBuilder(Infrastructure instance) {
        this(instance, (Boolean)false);
    }

    public InfrastructureBuilder(Infrastructure instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Infrastructure build() {
        Infrastructure buildable = new Infrastructure(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

