/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3CloudFront;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3CloudFrontBuilder;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3CloudFrontFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigStorageS3Fluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ImageRegistryConfigStorageS3FluentImpl<A extends ImageRegistryConfigStorageS3Fluent<A>>
extends BaseFluent<A>
implements ImageRegistryConfigStorageS3Fluent<A> {
    private String bucket;
    private ImageRegistryConfigStorageS3CloudFrontBuilder cloudFront;
    private Boolean encrypt;
    private String keyID;
    private String region;
    private String regionEndpoint;
    private Boolean virtualHostedStyle;
    private Map<String, Object> additionalProperties;

    public ImageRegistryConfigStorageS3FluentImpl() {
    }

    public ImageRegistryConfigStorageS3FluentImpl(ImageRegistryConfigStorageS3 instance) {
        if (instance != null) {
            this.withBucket(instance.getBucket());
            this.withCloudFront(instance.getCloudFront());
            this.withEncrypt(instance.getEncrypt());
            this.withKeyID(instance.getKeyID());
            this.withRegion(instance.getRegion());
            this.withRegionEndpoint(instance.getRegionEndpoint());
            this.withVirtualHostedStyle(instance.getVirtualHostedStyle());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    @Override
    public A withBucket(String bucket) {
        this.bucket = bucket;
        return (A)this;
    }

    @Override
    public Boolean hasBucket() {
        return this.bucket != null;
    }

    @Override
    @Deprecated
    public ImageRegistryConfigStorageS3CloudFront getCloudFront() {
        return this.cloudFront != null ? this.cloudFront.build() : null;
    }

    @Override
    public ImageRegistryConfigStorageS3CloudFront buildCloudFront() {
        return this.cloudFront != null ? this.cloudFront.build() : null;
    }

    @Override
    public A withCloudFront(ImageRegistryConfigStorageS3CloudFront cloudFront) {
        this._visitables.get("cloudFront").remove(this.cloudFront);
        if (cloudFront != null) {
            this.cloudFront = new ImageRegistryConfigStorageS3CloudFrontBuilder(cloudFront);
            this._visitables.get("cloudFront").add(this.cloudFront);
        } else {
            this.cloudFront = null;
            this._visitables.get("cloudFront").remove(this.cloudFront);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCloudFront() {
        return this.cloudFront != null;
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> withNewCloudFront() {
        return new CloudFrontNestedImpl();
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> withNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
        return new CloudFrontNestedImpl(item);
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> editCloudFront() {
        return this.withNewCloudFrontLike(this.getCloudFront());
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> editOrNewCloudFront() {
        return this.withNewCloudFrontLike(this.getCloudFront() != null ? this.getCloudFront() : new ImageRegistryConfigStorageS3CloudFrontBuilder().build());
    }

    @Override
    public ImageRegistryConfigStorageS3Fluent.CloudFrontNested<A> editOrNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
        return this.withNewCloudFrontLike(this.getCloudFront() != null ? this.getCloudFront() : item);
    }

    @Override
    public Boolean getEncrypt() {
        return this.encrypt;
    }

    @Override
    public A withEncrypt(Boolean encrypt) {
        this.encrypt = encrypt;
        return (A)this;
    }

    @Override
    public Boolean hasEncrypt() {
        return this.encrypt != null;
    }

    @Override
    public String getKeyID() {
        return this.keyID;
    }

    @Override
    public A withKeyID(String keyID) {
        this.keyID = keyID;
        return (A)this;
    }

    @Override
    public Boolean hasKeyID() {
        return this.keyID != null;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public String getRegionEndpoint() {
        return this.regionEndpoint;
    }

    @Override
    public A withRegionEndpoint(String regionEndpoint) {
        this.regionEndpoint = regionEndpoint;
        return (A)this;
    }

    @Override
    public Boolean hasRegionEndpoint() {
        return this.regionEndpoint != null;
    }

    @Override
    public Boolean getVirtualHostedStyle() {
        return this.virtualHostedStyle;
    }

    @Override
    public A withVirtualHostedStyle(Boolean virtualHostedStyle) {
        this.virtualHostedStyle = virtualHostedStyle;
        return (A)this;
    }

    @Override
    public Boolean hasVirtualHostedStyle() {
        return this.virtualHostedStyle != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageRegistryConfigStorageS3FluentImpl that = (ImageRegistryConfigStorageS3FluentImpl)o;
        if (!Objects.equals(this.bucket, that.bucket)) {
            return false;
        }
        if (!Objects.equals(this.cloudFront, that.cloudFront)) {
            return false;
        }
        if (!Objects.equals(this.encrypt, that.encrypt)) {
            return false;
        }
        if (!Objects.equals(this.keyID, that.keyID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.regionEndpoint, that.regionEndpoint)) {
            return false;
        }
        if (!Objects.equals(this.virtualHostedStyle, that.virtualHostedStyle)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bucket, this.cloudFront, this.encrypt, this.keyID, this.region, this.regionEndpoint, this.virtualHostedStyle, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket != null) {
            sb.append("bucket:");
            sb.append(this.bucket + ",");
        }
        if (this.cloudFront != null) {
            sb.append("cloudFront:");
            sb.append(this.cloudFront + ",");
        }
        if (this.encrypt != null) {
            sb.append("encrypt:");
            sb.append(this.encrypt + ",");
        }
        if (this.keyID != null) {
            sb.append("keyID:");
            sb.append(this.keyID + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.regionEndpoint != null) {
            sb.append("regionEndpoint:");
            sb.append(this.regionEndpoint + ",");
        }
        if (this.virtualHostedStyle != null) {
            sb.append("virtualHostedStyle:");
            sb.append(this.virtualHostedStyle + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withEncrypt() {
        return this.withEncrypt(true);
    }

    @Override
    public A withVirtualHostedStyle() {
        return this.withVirtualHostedStyle(true);
    }

    class CloudFrontNestedImpl<N>
    extends ImageRegistryConfigStorageS3CloudFrontFluentImpl<ImageRegistryConfigStorageS3Fluent.CloudFrontNested<N>>
    implements ImageRegistryConfigStorageS3Fluent.CloudFrontNested<N>,
    Nested<N> {
        ImageRegistryConfigStorageS3CloudFrontBuilder builder;

        CloudFrontNestedImpl(ImageRegistryConfigStorageS3CloudFront item) {
            this.builder = new ImageRegistryConfigStorageS3CloudFrontBuilder(this, item);
        }

        CloudFrontNestedImpl() {
            this.builder = new ImageRegistryConfigStorageS3CloudFrontBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageRegistryConfigStorageS3FluentImpl.this.withCloudFront(this.builder.build());
        }

        @Override
        public N endCloudFront() {
            return this.and();
        }
    }
}

