/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpoints;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AlertmanagerEndpointsFluentImpl<A extends AlertmanagerEndpointsFluent<A>>
extends BaseFluent<A>
implements AlertmanagerEndpointsFluent<A> {
    private String apiVersion;
    private SafeAuthorizationBuilder authorization;
    private String bearerTokenFile;
    private String name;
    private String namespace;
    private String pathPrefix;
    private IntOrStringBuilder port;
    private String scheme;
    private String timeout;
    private TLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public AlertmanagerEndpointsFluentImpl() {
    }

    public AlertmanagerEndpointsFluentImpl(AlertmanagerEndpoints instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withAuthorization(instance.getAuthorization());
            this.withBearerTokenFile(instance.getBearerTokenFile());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withPathPrefix(instance.getPathPrefix());
            this.withPort(instance.getPort());
            this.withScheme(instance.getScheme());
            this.withTimeout(instance.getTimeout());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public SafeAuthorization getAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    @Override
    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    @Override
    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.get("authorization").remove(this.authorization);
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get("authorization").remove(this.authorization);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthorization() {
        return this.authorization != null;
    }

    @Override
    public AlertmanagerEndpointsFluent.AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNestedImpl();
    }

    @Override
    public AlertmanagerEndpointsFluent.AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNestedImpl(item);
    }

    @Override
    public AlertmanagerEndpointsFluent.AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(this.getAuthorization());
    }

    @Override
    public AlertmanagerEndpointsFluent.AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(this.getAuthorization() != null ? this.getAuthorization() : new SafeAuthorizationBuilder().build());
    }

    @Override
    public AlertmanagerEndpointsFluent.AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(this.getAuthorization() != null ? this.getAuthorization() : item);
    }

    @Override
    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    @Override
    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return (A)this;
    }

    @Override
    public Boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    @Override
    public A withPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return (A)this;
    }

    @Override
    public Boolean hasPathPrefix() {
        return this.pathPrefix != null;
    }

    @Override
    @Deprecated
    public IntOrString getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(IntOrString port) {
        this._visitables.get("port").remove(this.port);
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get("port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get("port").remove(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(Object value) {
        return this.withPort(new IntOrString(value));
    }

    @Override
    public AlertmanagerEndpointsFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public AlertmanagerEndpointsFluent.PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNestedImpl(item);
    }

    @Override
    public AlertmanagerEndpointsFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public AlertmanagerEndpointsFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new IntOrStringBuilder().build());
    }

    @Override
    public AlertmanagerEndpointsFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    @Override
    public Boolean hasScheme() {
        return this.scheme != null;
    }

    @Override
    public String getTimeout() {
        return this.timeout;
    }

    @Override
    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)this;
    }

    @Override
    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    @Override
    @Deprecated
    public TLSConfig getTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    @Override
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    @Override
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    @Override
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig());
    }

    @Override
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : new TLSConfigBuilder().build());
    }

    @Override
    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertmanagerEndpointsFluentImpl that = (AlertmanagerEndpointsFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Objects.equals(this.bearerTokenFile, that.bearerTokenFile)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.pathPrefix, that.pathPrefix)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.scheme, that.scheme)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.authorization, this.bearerTokenFile, this.name, this.namespace, this.pathPrefix, this.port, this.scheme, this.timeout, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.bearerTokenFile != null) {
            sb.append("bearerTokenFile:");
            sb.append(this.bearerTokenFile + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.pathPrefix != null) {
            sb.append("pathPrefix:");
            sb.append(this.pathPrefix + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TlsConfigNestedImpl<N>
    extends TLSConfigFluentImpl<AlertmanagerEndpointsFluent.TlsConfigNested<N>>
    implements AlertmanagerEndpointsFluent.TlsConfigNested<N>,
    Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        TlsConfigNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerEndpointsFluentImpl.this.withTlsConfig(this.builder.build());
        }

        @Override
        public N endTlsConfig() {
            return this.and();
        }
    }

    class PortNestedImpl<N>
    extends IntOrStringFluentImpl<AlertmanagerEndpointsFluent.PortNested<N>>
    implements AlertmanagerEndpointsFluent.PortNested<N>,
    Nested<N> {
        IntOrStringBuilder builder;

        PortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerEndpointsFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    class AuthorizationNestedImpl<N>
    extends SafeAuthorizationFluentImpl<AlertmanagerEndpointsFluent.AuthorizationNested<N>>
    implements AlertmanagerEndpointsFluent.AuthorizationNested<N>,
    Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNestedImpl(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        AuthorizationNestedImpl() {
            this.builder = new SafeAuthorizationBuilder(this);
        }

        @Override
        public N and() {
            return (N)AlertmanagerEndpointsFluentImpl.this.withAuthorization(this.builder.build());
        }

        @Override
        public N endAuthorization() {
            return this.and();
        }
    }
}

