/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.cli;

import com.google.protobuf.DescriptorProtos;
import io.ballerina.protoc.cli.utils.ProtocCommandBuilder;
import io.ballerina.protoc.core.BalFileGenerationUtils;
import io.ballerina.protoc.core.BalGenerationConstants;
import io.ballerina.protoc.core.descriptor.DescriptorMeta;
import io.ballerina.protoc.core.exception.CodeGeneratorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DescriptorsGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DescriptorsGenerator.class);
    private static final PrintStream outStream = System.out;

    DescriptorsGenerator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Set<DescriptorMeta> generateDependentDescriptor(String exePath, String protoFolderPath, String rootDescriptorPath) throws CodeGeneratorException {
        HashSet<DescriptorMeta> dependentDescSet = new HashSet<DescriptorMeta>();
        File tempDir = new File(BalGenerationConstants.TMP_DIRECTORY_PATH);
        File initialFile = new File(rootDescriptorPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            DescriptorProtos.FileDescriptorSet descSet = DescriptorProtos.FileDescriptorSet.parseFrom(targetStream);
            String originalProtoFolderPath = protoFolderPath;
            for (String dependentFilePath : descSet.getFile(0).getDependencyList()) {
                String protoPath;
                String descFilename;
                Path protoFilePath;
                protoFolderPath = originalProtoFolderPath;
                if (BalFileGenerationUtils.isWindows()) {
                    dependentFilePath = dependentFilePath.replaceAll("/", "\\\\");
                }
                if ((protoFilePath = Paths.get(dependentFilePath, new String[0]).getFileName()) == null) {
                    throw new CodeGeneratorException("Error occurred while reading proto descriptor. Dependent filepath is not defined properly. Filepath: " + dependentFilePath);
                }
                String protoFilename = protoFilePath.toString();
                String string = descFilename = protoFilename.endsWith(".proto") ? protoFilename.replace(".proto", ".desc") : null;
                if (descFilename == null) {
                    throw new CodeGeneratorException("Error occurred while reading proto descriptor. Dependent filepath is not defined properly. Filepath: " + dependentFilePath);
                }
                String relativeDescFilepath = BalGenerationConstants.META_DEPENDENCY_LOCATION + descFilename;
                File dependentDescFile = new File(tempDir, relativeDescFilepath);
                boolean isDirectoryCreated = dependentDescFile.getParentFile().mkdirs();
                if (!isDirectoryCreated) {
                    LOG.debug("Parent directories didn't create for the file '" + relativeDescFilepath);
                }
                if (!(dependentFilePath.contains(BalGenerationConstants.GOOGLE_STANDARD_LIB_PROTOBUF) || dependentFilePath.contains(BalGenerationConstants.GOOGLE_STANDARD_LIB_API) || dependentFilePath.contains(BalGenerationConstants.BALLERINA_STANDARD_LIB_PROTOBUF))) {
                    protoPath = new File(protoFolderPath, dependentFilePath).getAbsolutePath();
                } else {
                    protoPath = new File(tempDir, dependentFilePath).getAbsolutePath();
                    protoFolderPath = tempDir.getAbsolutePath();
                }
                String command = new ProtocCommandBuilder(exePath, BalFileGenerationUtils.escapeSpaces((String)protoPath), BalFileGenerationUtils.escapeSpaces((String)protoFolderPath), BalFileGenerationUtils.escapeSpaces((String)dependentDescFile.getAbsolutePath())).build();
                ArrayList protocOutput = BalFileGenerationUtils.generateDescriptor((String)command);
                File childFile = new File(tempDir, relativeDescFilepath);
                try (FileInputStream childStream = new FileInputStream(childFile);){
                    byte[] dependentDesc;
                    DescriptorProtos.FileDescriptorSet childDescSet = DescriptorProtos.FileDescriptorSet.parseFrom(childStream);
                    if (childDescSet.getFile(0).getDependencyCount() != 0) {
                        Set<DescriptorMeta> childList = DescriptorsGenerator.generateDependentDescriptor(exePath, protoFolderPath, childFile.getAbsolutePath());
                        dependentDescSet.addAll(childList);
                    }
                    if ((dependentDesc = childDescSet.getFile(0).toByteArray()).length == 0) {
                        throw new CodeGeneratorException("Error occurred at generating dependent proto descriptor for dependent proto '" + relativeDescFilepath + "'.");
                    }
                    dependentDescSet.add(new DescriptorMeta(BalFileGenerationUtils.escapeSpaces((String)protoPath), dependentDesc, DescriptorsGenerator.getUnusedImports(protocOutput)));
                }
                catch (IOException e) {
                    throw new CodeGeneratorException("Error extracting dependent bal. " + e.getMessage(), (Throwable)e);
                    return dependentDescSet;
                }
            }
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error parsing descriptor file " + String.valueOf(initialFile) + ". " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DescriptorMeta generateRootDescriptor(String exePath, String protoPath, String protoFolderPath, String descriptorPath) throws CodeGeneratorException {
        String command = new ProtocCommandBuilder(exePath, BalFileGenerationUtils.escapeSpaces((String)protoPath), BalFileGenerationUtils.escapeSpaces((String)protoFolderPath), BalFileGenerationUtils.escapeSpaces((String)descriptorPath)).build();
        ArrayList protocOutput = BalFileGenerationUtils.generateDescriptor((String)command);
        File initialFile = new File(descriptorPath);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom(targetStream);
            if (set.getFileList().size() <= 0) return new DescriptorMeta(protoPath, new byte[0], DescriptorsGenerator.getUnusedImports(protocOutput));
            DescriptorMeta descriptorMeta = new DescriptorMeta(protoPath, set.getFile(0).toByteArray(), DescriptorsGenerator.getUnusedImports(protocOutput));
            return descriptorMeta;
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error reading generated descriptor file '" + descriptorPath + "'. " + e.getMessage(), (Throwable)e);
        }
    }

    private static List<String> getUnusedImports(ArrayList<String> protocOutput) {
        ArrayList<String> unusedImportList = new ArrayList<String>();
        for (String line : protocOutput) {
            if (!line.contains("warning: Import ") || !line.contains(" is unused.")) continue;
            unusedImportList.add(line.split("warning: Import ")[1].split(" is unused.")[0]);
            outStream.println(line);
        }
        return unusedImportList;
    }
}

