/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.cli;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.protoc.cli.DescriptorsGenerator;
import io.ballerina.protoc.cli.OSDetector;
import io.ballerina.protoc.core.BalFileGenerationUtils;
import io.ballerina.protoc.core.BalGenerationConstants;
import io.ballerina.protoc.core.builder.BallerinaFileBuilder;
import io.ballerina.protoc.core.descriptor.DescriptorMeta;
import io.ballerina.protoc.core.exception.CodeBuilderException;
import io.ballerina.protoc.core.exception.CodeGeneratorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="grpc", description={"generate Ballerina gRPC client stub for gRPC service for a given gRPC protoc definition."})
public class GrpcCmd
implements BLauncherCmd {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcCmd.class);
    private static final int EXIT_CODE_0 = 0;
    private static final int EXIT_CODE_2 = 2;
    private static final ExitHandler DEFAULT_EXIT_HANDLER = code -> Runtime.getRuntime().exit(code);
    private PrintStream outStream;
    private static final String PROTO_EXTENSION = "proto";
    private CommandLine parentCmdParser;
    private final ExitHandler exitHandler;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true, usageHelp=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--input"}, description={"Input .proto file or a directory containing multiple .proto files"})
    private String protoPath;
    @CommandLine.Option(names={"--mode"}, description={"Ballerina source [service or client]"})
    private String mode = "stub";
    @CommandLine.Option(names={"--output"}, description={"Generated Ballerina source files location"})
    private String balOutPath;
    private String protocExePath;
    @CommandLine.Option(names={"--protoc-version"}, hidden=true)
    private String protocVersion = "3.21.7";
    @CommandLine.Option(names={"--proto-path"}, description={"Path to a directory in which to look for .proto files when resolving import directives"})
    private String importPath = "";

    public GrpcCmd() {
        this(System.out, DEFAULT_EXIT_HANDLER);
    }

    public GrpcCmd(PrintStream outStream) {
        this(outStream, DEFAULT_EXIT_HANDLER);
    }

    public GrpcCmd(PrintStream outStream, ExitHandler exitHandler) {
        this.outStream = outStream;
        this.exitHandler = exitHandler;
    }

    private void exit(int code) {
        this.exitHandler.exit(code);
    }

    private static void exportResource(String resourceName, ClassLoader classLoader) throws CodeGeneratorException {
        try (InputStream initialStream = classLoader.getResourceAsStream(resourceName);
             FileOutputStream resStreamOut = new FileOutputStream(new File(BalGenerationConstants.TMP_DIRECTORY_PATH, resourceName));){
            int readBytes;
            if (initialStream == null) {
                throw new CodeGeneratorException("Cannot get resource file \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            while ((readBytes = initialStream.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Cannot find '" + resourceName + "' file inside resources.", (Throwable)e);
        }
    }

    public void execute() {
        if (this.helpFlag) {
            this.printLongDesc(new StringBuilder());
            this.exit(0);
            return;
        }
        if (this.protoPath == null || this.protoPath.trim().isEmpty()) {
            this.printLongDesc(new StringBuilder());
            this.exit(2);
            return;
        }
        if (this.protoPath.endsWith("**.proto") || new File(this.protoPath).isDirectory()) {
            List<String> protoFiles;
            try {
                protoFiles = this.getProtoFiles(this.protoPath);
            }
            catch (IOException e) {
                String errorMessage = "Failed to find proto files in the directory. Please input a valid proto files directory.";
                this.outStream.println(errorMessage);
                return;
            }
            if (protoFiles.size() == 0) {
                String errorMessage = "Input directory does not contain any proto files. Please input a valid proto files directory.";
                this.outStream.println(errorMessage);
            } else {
                for (String protoFile : protoFiles) {
                    this.generateBalFile(protoFile);
                }
            }
        } else {
            Optional<String> pathExtension = this.getFileExtension(this.protoPath);
            if (pathExtension.isEmpty() || !PROTO_EXTENSION.equalsIgnoreCase(pathExtension.get())) {
                String errorMessage = "Invalid proto file path. Please input valid proto file location.";
                this.outStream.println(errorMessage);
                return;
            }
            this.generateBalFile(this.protoPath);
        }
    }

    private List<String> getProtoFiles(String path) throws IOException {
        if (path.endsWith("**.proto")) {
            try (Stream<Path> walk = Files.walk(Paths.get(path.substring(0, path.length() - 8), new String[0]), new FileVisitOption[0]);){
                List<String> list = this.walkInsideProtoDirectory(walk);
                return list;
            }
        }
        try (Stream<Path> walk = Files.walk(Paths.get(path, new String[0]), 1, new FileVisitOption[0]);){
            List<String> list = this.walkInsideProtoDirectory(walk);
            return list;
        }
    }

    private List<String> walkInsideProtoDirectory(Stream<Path> walk) {
        return walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(Path::toString).filter(f -> f.endsWith(".proto")).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateBalFile(String protoPath) {
        Set<DescriptorMeta> dependant;
        DescriptorMeta root;
        File protoFilePath;
        File importFilePath;
        if (!Files.isReadable(Paths.get(protoPath, new String[0]))) {
            String errorMessage = "Provided service proto file is not readable. Please input valid proto file location.";
            this.outStream.println(errorMessage);
            return;
        }
        if (!this.importPath.isBlank() && !GrpcCmd.isInSubDirectory(importFilePath = new File(this.importPath), protoFilePath = new File(protoPath))) {
            String errorMessage = "Input .proto file does not reside within the path specified using --proto-path. You must specify a --proto-path which encompasses the .proto file.";
            this.outStream.println(errorMessage);
            return;
        }
        if ("proxy".equals(this.mode)) {
            String errorMessage = "gRPC gateway proxy service generation is currently not supported.";
            this.outStream.println(errorMessage);
            return;
        }
        try {
            this.downloadProtocexe();
        }
        catch (CodeGeneratorException | IOException e) {
            String errorMessage = "Error while preparing the protoc executable. " + e.getMessage();
            LOG.error("Error while preparing the protoc executable.", e);
            this.outStream.println(errorMessage);
            return;
        }
        this.createProtoPackageDirectories();
        StringBuilder msg = new StringBuilder();
        LOG.debug("Initializing the ballerina code generation.");
        try {
            String errorMessage;
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                List<String> protoFiles = this.readProperties(classLoader);
                for (String file : protoFiles) {
                    GrpcCmd.exportResource(file, classLoader);
                }
            }
            catch (Exception e) {
                LOG.error("Error extracting the resource file. ", (Throwable)e);
                this.outStream.println("Error while reading the library files. " + e.getMessage());
                File tempDir = new File(BalGenerationConstants.TMP_DIRECTORY_PATH);
                BalFileGenerationUtils.delete((File)new File(tempDir, "desc_gen"));
                BalFileGenerationUtils.delete((File)new File(tempDir, "google"));
                BalFileGenerationUtils.delete((File)new File(tempDir, "ballerina"));
                LOG.debug("Successfully deleted temporary files.");
                return;
            }
            if (!msg.toString().isEmpty()) {
                this.outStream.println(msg);
                return;
            }
            this.outStream.println("Successfully extracted the library files.");
            Path descFilePath = this.createServiceDescriptorFile();
            try {
                root = this.importPath.isBlank() ? DescriptorsGenerator.generateRootDescriptor(this.protocExePath, this.getAbsolutePath(protoPath), this.getAbsolutePath(BalFileGenerationUtils.resolveProtoFolderPath((String)protoPath)), descFilePath.toAbsolutePath().toString()) : DescriptorsGenerator.generateRootDescriptor(this.protocExePath, this.getAbsolutePath(protoPath), this.getAbsolutePath(this.importPath), descFilePath.toAbsolutePath().toString());
            }
            catch (CodeGeneratorException e) {
                errorMessage = "An error occurred when generating the proto descriptor. " + e.getMessage();
                this.outStream.println(errorMessage);
                LOG.error("An error occurred when generating the proto descriptor.", (Throwable)e);
                File tempDir = new File(BalGenerationConstants.TMP_DIRECTORY_PATH);
                BalFileGenerationUtils.delete((File)new File(tempDir, "desc_gen"));
                BalFileGenerationUtils.delete((File)new File(tempDir, "google"));
                BalFileGenerationUtils.delete((File)new File(tempDir, "ballerina"));
                LOG.debug("Successfully deleted temporary files.");
                return;
            }
            if (root.getDescriptor().length == 0) {
                String errorMsg = "An error occurred when generating the proto descriptor.";
                this.outStream.println(errorMsg);
                LOG.error(errorMsg);
                return;
            }
            LOG.debug("Successfully generated the root descriptor.");
            try {
                dependant = this.importPath.isBlank() ? DescriptorsGenerator.generateDependentDescriptor(this.protocExePath, this.getAbsolutePath(BalFileGenerationUtils.resolveProtoFolderPath((String)protoPath)), descFilePath.toAbsolutePath().toString()) : DescriptorsGenerator.generateDependentDescriptor(this.protocExePath, this.getAbsolutePath(this.importPath), descFilePath.toAbsolutePath().toString());
            }
            catch (CodeGeneratorException e) {
                errorMessage = "An error occurred when generating the dependent proto descriptor. " + e.getMessage();
                this.outStream.println(errorMessage);
                LOG.error(errorMessage, (Throwable)e);
                File tempDir = new File(BalGenerationConstants.TMP_DIRECTORY_PATH);
                BalFileGenerationUtils.delete((File)new File(tempDir, "desc_gen"));
                BalFileGenerationUtils.delete((File)new File(tempDir, "google"));
                BalFileGenerationUtils.delete((File)new File(tempDir, "ballerina"));
                LOG.debug("Successfully deleted temporary files.");
                return;
            }
            LOG.debug("Successfully generated the dependent descriptor.");
        }
        finally {
            File tempDir = new File(BalGenerationConstants.TMP_DIRECTORY_PATH);
            BalFileGenerationUtils.delete((File)new File(tempDir, "desc_gen"));
            BalFileGenerationUtils.delete((File)new File(tempDir, "google"));
            BalFileGenerationUtils.delete((File)new File(tempDir, "ballerina"));
            LOG.debug("Successfully deleted temporary files.");
        }
        try {
            BallerinaFileBuilder ballerinaFileBuilder = this.balOutPath == null ? new BallerinaFileBuilder(root, dependant) : new BallerinaFileBuilder(root, dependant, this.balOutPath);
            ballerinaFileBuilder.build(this.mode);
        }
        catch (CodeBuilderException | CodeGeneratorException | IOException e) {
            msg.append("Error generating the Ballerina file.").append(e.getMessage()).append(BalGenerationConstants.NEW_LINE_CHARACTER);
            this.outStream.println(msg);
            LOG.error("Error generating the Ballerina file.", e);
            return;
        }
        msg.append("Successfully generated the Ballerina file.").append(BalGenerationConstants.NEW_LINE_CHARACTER);
        this.outStream.println(msg);
    }

    public static boolean isInSubDirectory(File dir, File file) {
        if (file == null) {
            return false;
        }
        if (file.equals(dir)) {
            return true;
        }
        return GrpcCmd.isInSubDirectory(dir, file.getParentFile());
    }

    private Path createServiceDescriptorFile() {
        Path descriptorDirPath = Paths.get(BalGenerationConstants.TMP_DIRECTORY_PATH, "desc_gen");
        try {
            Files.createDirectories(descriptorDirPath, new FileAttribute[0]);
            return Files.createFile(descriptorDirPath.resolve(this.getProtoFileName() + "-descriptor.desc"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create a temp directory: " + String.valueOf(descriptorDirPath.toAbsolutePath()) + " error: " + e.getMessage(), e);
        }
    }

    private void createProtoPackageDirectories() {
        Path protobufCompilerDirPath = Paths.get(BalGenerationConstants.TMP_DIRECTORY_PATH, "google", "protobuf", "compiler");
        Path protobufApiDirPath = Paths.get(BalGenerationConstants.TMP_DIRECTORY_PATH, "google", "api");
        Path ballerinaProtoDirPath = Paths.get(BalGenerationConstants.TMP_DIRECTORY_PATH, "ballerina", "protobuf");
        try {
            Files.createDirectories(protobufCompilerDirPath, new FileAttribute[0]);
            Files.createDirectories(protobufApiDirPath, new FileAttribute[0]);
            Files.createDirectories(ballerinaProtoDirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create directories for dependent proto files.  error: " + e.getMessage(), e);
        }
    }

    private Optional<String> getFileExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    private String getAbsolutePath(String protoPath) {
        return Paths.get(protoPath, new String[0]).toAbsolutePath().toString();
    }

    private void downloadProtocexe() throws IOException, CodeGeneratorException {
        if (this.protocExePath == null) {
            String protocFilename = "protoc-" + this.protocVersion + "-" + OSDetector.getDetectedClassifier() + ".exe";
            File protocExeFile = new File(BalGenerationConstants.TMP_DIRECTORY_PATH, protocFilename);
            this.protocExePath = protocExeFile.getAbsolutePath();
            if (!protocExeFile.exists()) {
                this.outStream.println("Downloading the protoc executor file - " + protocFilename);
                String protocDownloadurl = "https://repo1.maven.org/maven2/com/google/protobuf/protoc/" + this.protocVersion + "/" + protocFilename;
                File tempDownloadFile = new File(BalGenerationConstants.TMP_DIRECTORY_PATH, protocFilename + ".download");
                try {
                    BalFileGenerationUtils.downloadFile((URL)new URL(protocDownloadurl), (File)tempDownloadFile);
                    Files.move(tempDownloadFile.toPath(), protocExeFile.toPath(), new CopyOption[0]);
                    BalFileGenerationUtils.grantPermission((File)protocExeFile);
                }
                catch (CodeGeneratorException e) {
                    Files.deleteIfExists(Paths.get(this.protocExePath, new String[0]));
                    throw e;
                }
                this.outStream.println("Download successfully completed. Executor file path - " + protocExeFile.getPath());
            } else {
                BalFileGenerationUtils.grantPermission((File)protocExeFile);
                this.outStream.println("Continuing with the existing protoc executor file at " + protocExeFile.getPath());
            }
        } else {
            this.outStream.println("Continuing with the provided protoc executor file at " + this.protocExePath);
        }
    }

    public String getName() {
        return "grpc";
    }

    public void printLongDesc(StringBuilder out) {
        Class<GrpcCmd> cmdClass = GrpcCmd.class;
        ClassLoader classLoader = cmdClass.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("ballerina-grpc.help");
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String content = br.readLine();
            this.outStream.append(content);
            while ((content = br.readLine()) != null) {
                this.outStream.append('\n').append(content);
            }
            this.outStream.append('\n');
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("  ballerina grpc --input chat.proto\n");
    }

    private String getProtoFileName() {
        File file = new File(this.protoPath.replace("**", ""));
        return file.getName().replace(".proto", "");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }

    private List<String> readProperties(ClassLoader classLoader) throws CodeGeneratorException {
        ArrayList<String> protoFilesList = new ArrayList<String>();
        try (InputStream initialStream = classLoader.getResourceAsStream("standardProtos.properties");
             BufferedReader reader = new BufferedReader(new InputStreamReader(initialStream, StandardCharsets.UTF_8));){
            String fileName;
            while ((fileName = reader.readLine()) != null) {
                protoFilesList.add(fileName);
            }
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error while reading property file. " + e.getMessage(), (Throwable)e);
        }
        return protoFilesList;
    }

    public void setProtoPath(String protoPath) {
        this.protoPath = protoPath;
    }

    public void setBalOutPath(String balOutPath) {
        this.balOutPath = balOutPath;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setImportPath(String importPath) {
        this.importPath = importPath;
    }

    @FunctionalInterface
    public static interface ExitHandler {
        public void exit(int var1);
    }
}

