/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.datamapper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ChildNodeEntry;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticPropertyKind;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.datamapper.DataMapperNodeVisitor;
import org.ballerinalang.datamapper.config.ClientExtendedConfigImpl;
import org.ballerinalang.datamapper.utils.DefaultValueGenerator;
import org.ballerinalang.datamapper.utils.HttpClientRequest;
import org.ballerinalang.datamapper.utils.HttpResponse;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.config.LSClientConfigHolder;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

class AIDataMapperCodeActionUtil {
    private static final int HTTP_200_OK = 200;
    private static final int HTTP_422_UN_PROCESSABLE_ENTITY = 422;
    private static final int HTTP_500_INTERNAL_SERVER_ERROR = 500;
    private static final int MAXIMUM_CACHE_SIZE = 100;
    private static final int RIGHT_SYMBOL_INDEX = 1;
    private static final int LEFT_SYMBOL_INDEX = 0;
    private final Cache<Integer, String> mappingCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final HashMap<String, String> isOptionalMap = new HashMap();
    private final HashMap<String, String> leftFieldMap = new HashMap();
    private final HashMap<String, String> responseFieldMap = new HashMap();
    private HashMap<String, String> restFieldMap = new HashMap();
    private HashMap<String, Map<String, RecordFieldSymbol>> spreadFieldMap = new HashMap();
    private final HashMap<String, String> spreadFieldResponseMap = new HashMap();
    private final ArrayList<String> leftReadOnlyFields = new ArrayList();
    private ArrayList<String> rightSpecificFieldList = new ArrayList();
    private final ArrayList<String> optionalRightRecordFields = new ArrayList();
    private static final String SCHEMA = "schema";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String PROPERTIES = "properties";
    private static final String OPTIONAL = "optional";
    private static final String READONLY = "readonly";
    private static final String SIGNATURE = "signature";
    private static AIDataMapperCodeActionUtil dataMapperCodeAction;

    private AIDataMapperCodeActionUtil() {
    }

    public static AIDataMapperCodeActionUtil getInstance() {
        if (dataMapperCodeAction == null) {
            dataMapperCodeAction = new AIDataMapperCodeActionUtil();
        }
        return dataMapperCodeAction;
    }

    public List<TextEdit> getAIDataMapperCodeActionEdits(DiagBasedPositionDetails positionDetails, CodeActionContext context, Diagnostic diagnostic) throws IOException {
        String foundTypeRight;
        String foundTypeLeft;
        Symbol rhsTypeSymbol;
        Symbol lftTypeSymbol;
        Symbol symbolAtCursor;
        ArrayList<TextEdit> fEdits = new ArrayList<TextEdit>();
        Optional srcFile = context.workspace().document(context.filePath());
        if (srcFile.isEmpty()) {
            return fEdits;
        }
        List props = diagnostic.properties();
        if (((DiagnosticProperty)props.get(0)).kind() != DiagnosticPropertyKind.SYMBOLIC) {
            return fEdits;
        }
        TypeDescKind leftSymbolType = ((TypeSymbol)((DiagnosticProperty)props.get(0)).value()).typeKind();
        if (props.size() != 2 || ((DiagnosticProperty)props.get(1)).kind() != DiagnosticPropertyKind.SYMBOLIC || ((DiagnosticProperty)props.get(0)).kind() != DiagnosticPropertyKind.SYMBOLIC || leftSymbolType != TypeDescKind.TYPE_REFERENCE && leftSymbolType != TypeDescKind.RECORD && leftSymbolType != TypeDescKind.UNION) {
            return fEdits;
        }
        SemanticModel semanticModel = (SemanticModel)context.workspace().semanticModel(context.filePath()).orElseThrow();
        List fileContentSymbols = semanticModel.moduleSymbols();
        Range newTextRange = PositionUtil.toRange((LineRange)diagnostic.location().lineRange());
        LinePosition linePosition = diagnostic.location().lineRange().startLine();
        SyntaxTree syntaxTree = (SyntaxTree)context.workspace().syntaxTree(context.filePath()).get();
        Optional symbolFromModel = semanticModel.symbol((Document)srcFile.get(), linePosition);
        if (symbolFromModel.isPresent()) {
            symbolAtCursor = (Symbol)symbolFromModel.get();
            lftTypeSymbol = (Symbol)((DiagnosticProperty)props.get(0)).value();
            rhsTypeSymbol = (Symbol)((DiagnosticProperty)props.get(1)).value();
            foundTypeLeft = lftTypeSymbol.getName().orElse("");
            foundTypeRight = rhsTypeSymbol.getName().orElse("");
        } else {
            Optional<Node> nodeAtCursor = this.findExpressionInTypeCastNode(newTextRange, syntaxTree);
            if (nodeAtCursor.isEmpty()) {
                return fEdits;
            }
            symbolFromModel = semanticModel.symbol(nodeAtCursor.get());
            if (symbolFromModel.isEmpty()) {
                return fEdits;
            }
            symbolAtCursor = (Symbol)symbolFromModel.get();
            lftTypeSymbol = (Symbol)((DiagnosticProperty)props.get(1)).value();
            rhsTypeSymbol = (Symbol)((DiagnosticProperty)props.get(0)).value();
            foundTypeLeft = lftTypeSymbol.getName().orElse("");
            foundTypeRight = rhsTypeSymbol.getName().orElse("");
        }
        String symbolAtCursorName = symbolAtCursor.getName().orElse("");
        String symbolAtCursorType = "";
        symbolAtCursorType = SymbolUtil.getTypeDescriptor((Symbol)symbolAtCursor).isEmpty() ? symbolAtCursor.kind().name() : ((TypeSymbol)SymbolUtil.getTypeDescriptor((Symbol)symbolAtCursor).get()).typeKind().toString();
        switch (symbolAtCursorType) {
            case "RECORD": 
            case "TYPE_REFERENCE": {
                String generatedFunctionName;
                if (foundTypeRight.isEmpty()) {
                    generatedFunctionName = String.format("map%sTo%s(%s)", symbolAtCursorName, foundTypeLeft, symbolAtCursorName);
                    foundTypeRight = symbolAtCursorName;
                } else {
                    generatedFunctionName = String.format("map%sTo%s(%s)", foundTypeRight, foundTypeLeft, symbolAtCursorName);
                }
                fEdits.add(new TextEdit(newTextRange, generatedFunctionName));
                break;
            }
            case "FUNCTION": 
            case "MODULE": {
                boolean foundErrorLeft = false;
                boolean foundErrorRight = false;
                if (foundTypeLeft.isEmpty()) {
                    List leftTypeSymbols = ((UnionTypeSymbol)lftTypeSymbol).memberTypeDescriptors();
                    lftTypeSymbol = this.findSymbol(leftTypeSymbols);
                    foundTypeLeft = lftTypeSymbol.getName().orElse("");
                    foundErrorLeft = true;
                }
                if (foundTypeRight.isEmpty()) {
                    List rightTypeSymbols = ((UnionTypeSymbol)rhsTypeSymbol).memberTypeDescriptors();
                    rhsTypeSymbol = this.findSymbol(rightTypeSymbols);
                    foundTypeRight = rhsTypeSymbol.getName().orElse("");
                    foundErrorRight = true;
                }
                NonTerminalNode matchedNode = null;
                if (positionDetails.matchedNode().kind() == SyntaxKind.FUNCTION_CALL) {
                    matchedNode = positionDetails.matchedNode();
                    if (matchedNode.parent().kind() == SyntaxKind.CHECK_EXPRESSION) {
                        matchedNode = matchedNode.parent();
                    }
                } else if (positionDetails.matchedNode().kind() == SyntaxKind.TYPE_CAST_EXPRESSION && ((TypeCastExpressionNode)positionDetails.matchedNode()).expression().kind() == SyntaxKind.FUNCTION_CALL) {
                    matchedNode = ((TypeCastExpressionNode)positionDetails.matchedNode()).expression();
                }
                if (matchedNode == null) {
                    return fEdits;
                }
                String functionCall = matchedNode.toString();
                if (foundErrorRight && !foundErrorLeft) {
                    symbolAtCursorName = functionCall.trim();
                    String generatedFunctionName = String.format("map%sTo%s(check %s)", foundTypeRight, foundTypeLeft, symbolAtCursorName);
                    fEdits.add(new TextEdit(newTextRange, generatedFunctionName));
                    break;
                }
                if (foundErrorLeft && foundErrorRight) {
                    newTextRange = PositionUtil.toRange((LineRange)matchedNode.lineRange());
                    String generatedFunctionName = String.format("map%sTo%s(%s)", foundTypeRight, foundTypeLeft, functionCall);
                    fEdits.add(new TextEdit(newTextRange, generatedFunctionName));
                    break;
                }
                if (foundErrorLeft) {
                    Collection childEntries = matchedNode.childEntries();
                    for (ChildNodeEntry childEntry : childEntries) {
                        if (!childEntry.name().equals("expression")) continue;
                        functionCall = childEntry.node().isPresent() ? ((Node)childEntry.node().get()).toString() : null;
                    }
                    if (functionCall == null) {
                        return fEdits;
                    }
                    symbolAtCursorName = functionCall.trim();
                    String generatedFunctionName = String.format("map%sTo%s(%s)", foundTypeRight, foundTypeLeft, symbolAtCursorName);
                    fEdits.add(new TextEdit(newTextRange, generatedFunctionName));
                    break;
                }
                symbolAtCursorName = functionCall.trim();
                String generatedFunctionName = String.format("map%sTo%s(%s)", foundTypeRight, foundTypeLeft, symbolAtCursorName);
                fEdits.add(new TextEdit(newTextRange, generatedFunctionName));
                break;
            }
            default: {
                return fEdits;
            }
        }
        String functionName = String.format("map%sTo%s", foundTypeRight, foundTypeLeft);
        boolean found = fileContentSymbols.stream().anyMatch(p -> ((String)p.getName().get()).contains(functionName));
        if (found) {
            return fEdits;
        }
        syntaxTree = (SyntaxTree)context.workspace().syntaxTree(context.filePath()).get();
        TextDocument fileContentTextDocument = syntaxTree.textDocument();
        int numberOfLinesInFile = fileContentTextDocument.toString().split("\n").length;
        Position startPosOfLastLine = new Position(numberOfLinesInFile + 2, 0);
        Position endPosOfLastLine = new Position(numberOfLinesInFile + 2, 1);
        Range newFunctionRange = new Range(startPosOfLastLine, endPosOfLastLine);
        String mappingFromServer = this.getGeneratedRecordMapping(context, foundTypeLeft, foundTypeRight, lftTypeSymbol, rhsTypeSymbol, syntaxTree, semanticModel);
        String rightModule = null;
        String leftModule = null;
        Optional project = context.workspace().project(context.filePath());
        if (((Project)project.get()).kind() == ProjectKind.BUILD_PROJECT) {
            ModuleID lftModule;
            String moduleName = ((Document)srcFile.get()).module().moduleId().moduleName();
            ModuleID rhsModule = rhsTypeSymbol.getModule().isPresent() ? ((ModuleSymbol)rhsTypeSymbol.getModule().get()).id() : null;
            ModuleID moduleID = lftModule = lftTypeSymbol.getModule().isPresent() ? ((ModuleSymbol)lftTypeSymbol.getModule().get()).id() : null;
            if (rhsModule != null && !moduleName.equals(rhsModule.moduleName())) {
                rightModule = rhsModule.modulePrefix();
            }
            if (lftModule != null && !moduleName.equals(lftModule.moduleName())) {
                leftModule = lftModule.modulePrefix();
            }
        }
        String rhsSignature = "";
        if (symbolAtCursorName.equals(foundTypeRight)) {
            rhsSignature = ((TypeSymbol)SymbolUtil.getTypeDescriptor((Symbol)symbolAtCursor).get()).signature();
        }
        String generatedRecordMappingFunction = this.generateMappingFunction(mappingFromServer, foundTypeLeft, foundTypeRight, leftModule, rightModule, rhsSignature, syntaxTree);
        fEdits.add(new TextEdit(newFunctionRange, generatedRecordMappingFunction));
        return fEdits;
    }

    private Optional<Node> findExpressionInTypeCastNode(Range range, SyntaxTree syntaxTree) {
        TextDocument textDocument = syntaxTree.textDocument();
        Position rangeStart = range.getStart();
        Position rangeEnd = range.getEnd();
        int start = textDocument.textPositionFrom(LinePosition.from((int)rangeStart.getLine(), (int)rangeStart.getCharacter()));
        int end = textDocument.textPositionFrom(LinePosition.from((int)rangeEnd.getLine(), (int)rangeEnd.getCharacter()));
        NonTerminalNode nonTerminalNode = ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
        if (nonTerminalNode.kind() == SyntaxKind.TYPE_CAST_EXPRESSION) {
            return Optional.of(((TypeCastExpressionNode)nonTerminalNode).expression());
        }
        return Optional.empty();
    }

    public Symbol findSymbol(List<TypeSymbol> fileContentSymbols) {
        for (Symbol symbol : fileContentSymbols) {
            if ("ERROR".equals(symbol.getName().get())) continue;
            return symbol;
        }
        return null;
    }

    private String getGeneratedRecordMapping(CodeActionContext context, String foundTypeLeft, String foundTypeRight, Symbol lftTypeSymbol, Symbol rhsTypeSymbol, SyntaxTree syntaxTree, SemanticModel semanticModel) throws IOException {
        JsonObject rightRecordJSON = new JsonObject();
        JsonObject leftRecordJSON = new JsonObject();
        List<RecordTypeSymbol> symbolList = this.checkMappingCapability(lftTypeSymbol, rhsTypeSymbol);
        if (symbolList.size() == 2) {
            DataMapperNodeVisitor nodeVisitor = new DataMapperNodeVisitor(foundTypeRight);
            nodeVisitor.setModel(semanticModel);
            syntaxTree.rootNode().accept((NodeVisitor)nodeVisitor);
            this.restFieldMap = nodeVisitor.restFields;
            this.spreadFieldMap = nodeVisitor.spreadFields;
            this.rightSpecificFieldList = nodeVisitor.specificFieldList;
            Map rightSchemaFields = symbolList.get(0).fieldDescriptors();
            JsonObject rightSchema = (JsonObject)this.rightRecordToJSON(rightSchemaFields.values());
            if (!this.restFieldMap.isEmpty()) {
                rightSchema = this.insertRestFields(rightSchema, foundTypeRight);
            }
            if (!this.spreadFieldMap.isEmpty()) {
                for (Map.Entry<String, Map<String, RecordFieldSymbol>> field : this.spreadFieldMap.entrySet()) {
                    JsonObject spreadFieldDetails = new JsonObject();
                    spreadFieldDetails.addProperty(ID, ID);
                    spreadFieldDetails.addProperty(TYPE, "ballerina_type");
                    spreadFieldDetails.add(PROPERTIES, this.rightRecordToJSON(field.getValue().values()));
                    rightSchema.add(field.getKey(), (JsonElement)spreadFieldDetails);
                }
            }
            rightRecordJSON.addProperty(SCHEMA, foundTypeRight);
            rightRecordJSON.addProperty(ID, ID);
            rightRecordJSON.addProperty(TYPE, "object");
            rightRecordJSON.add(PROPERTIES, (JsonElement)rightSchema);
            Map rightSchemaMap = (Map)new Gson().fromJson((JsonElement)rightSchema, (TypeToken)new TypeToken<Map<String, Object>>(this){});
            this.isOptionalMap.clear();
            this.generateOptionalMap(rightSchemaMap, foundTypeRight);
            Map leftSchemaFields = symbolList.get(1).fieldDescriptors();
            JsonObject leftSchema = (JsonObject)this.leftRecordToJSON(leftSchemaFields.values());
            leftRecordJSON.addProperty(SCHEMA, foundTypeLeft);
            leftRecordJSON.addProperty(ID, ID);
            leftRecordJSON.addProperty(TYPE, "object");
            leftRecordJSON.add(PROPERTIES, (JsonElement)leftSchema);
            Map leftSchemaMap = (Map)new Gson().fromJson((JsonElement)leftSchema, (TypeToken)new TypeToken<Map<String, Object>>(this){});
            this.leftFieldMap.clear();
            this.getLeftFields(leftSchemaMap, "");
        }
        JsonArray schemas = new JsonArray();
        schemas.add((JsonElement)leftRecordJSON);
        schemas.add((JsonElement)rightRecordJSON);
        return this.getMapping(schemas, context);
    }

    private JsonObject insertRestFields(JsonObject rightSchema, String foundTypeRight) {
        HashMap<String, String> tempRestFieldMap = new HashMap<String, String>(this.restFieldMap);
        Set<Map.Entry<String, String>> entrySet = tempRestFieldMap.entrySet();
        for (Map.Entry<String, String> restField : entrySet) {
            JsonObject fieldDetails = new JsonObject();
            fieldDetails.addProperty(ID, ID);
            fieldDetails.addProperty(TYPE, restField.getValue());
            fieldDetails.addProperty(OPTIONAL, Boolean.valueOf(false));
            rightSchema.add(restField.getKey(), (JsonElement)fieldDetails);
            this.restFieldMap.put(foundTypeRight.toLowerCase() + "." + restField.getKey(), this.restFieldMap.remove(restField.getKey()));
        }
        return rightSchema;
    }

    private void generateOptionalMap(Map<String, Object> rightSchemaMap, String foundTypeRight) {
        for (Map.Entry<String, Object> field : rightSchemaMap.entrySet()) {
            StringBuilder optionalKey = new StringBuilder(foundTypeRight.toLowerCase());
            if (!((Map)field.getValue()).containsKey(OPTIONAL)) {
                optionalKey.append(".").append(field.getKey());
                this.generateOptionalMap((Map)((Map)field.getValue()).get(PROPERTIES), optionalKey.toString());
                continue;
            }
            if (!((Boolean)((Map)field.getValue()).get(OPTIONAL) | this.checkForOptionalRecordField(optionalKey.toString()) > 0)) continue;
            optionalKey.append(".").append(field.getKey());
            this.isOptionalMap.put(optionalKey.toString(), ((Map)field.getValue()).get(SIGNATURE).toString());
        }
    }

    private int checkForOptionalRecordField(String optionalKey) {
        for (String recordRecordField : this.optionalRightRecordFields) {
            if (!optionalKey.contains(recordRecordField)) continue;
            return optionalKey.indexOf(recordRecordField);
        }
        return -1;
    }

    private void getLeftFields(Map<String, Object> leftSchemaMap, String fieldName) {
        for (Map.Entry<String, Object> field : leftSchemaMap.entrySet()) {
            StringBuilder fieldKey = new StringBuilder();
            if (!fieldName.isEmpty()) {
                fieldKey.append(fieldName).append(".");
            }
            if (!((Map)field.getValue()).containsKey(READONLY)) {
                fieldKey.append(field.getKey());
                this.getLeftFields((Map)((Map)field.getValue()).get(PROPERTIES), fieldKey.toString());
                continue;
            }
            fieldKey.append(field.getKey());
            this.leftFieldMap.put(fieldKey.toString(), ((Map)field.getValue()).get(TYPE).toString());
            if (!((Map)field.getValue()).get(READONLY).toString().contains("true")) continue;
            this.leftReadOnlyFields.add(field.getKey());
        }
    }

    private void getSpreadFieldDetails(String key, Collection<RecordFieldSymbol> schemaFields) {
        Iterator<RecordFieldSymbol> iterator = schemaFields.iterator();
        while (iterator.hasNext()) {
            RecordFieldSymbol attribute = iterator.next();
            TypeSymbol attributeType = CommonUtil.getRawType((TypeSymbol)attribute.typeDescriptor());
            if (!((String)key).isEmpty() && ((String)key).charAt(((String)key).length() - 1) != '.') {
                key = (String)key + ".";
            }
            if (attributeType.typeKind() == TypeDescKind.RECORD) {
                Map recordFields = ((RecordTypeSymbol)attributeType).fieldDescriptors();
                key = (String)key + (String)attribute.getName().get();
                this.getSpreadFieldDetails((String)key, recordFields.values());
                continue;
            }
            if (attributeType.typeKind() == TypeDescKind.INTERSECTION) {
                List memberTypeList = ((IntersectionTypeSymbol)attribute.typeDescriptor()).memberTypeDescriptors();
                for (TypeSymbol attributeTypeReference : memberTypeList) {
                    TypeSymbol attributeTypeRecord;
                    if (attributeTypeReference.typeKind() != TypeDescKind.TYPE_REFERENCE || (attributeTypeRecord = ((TypeReferenceTypeSymbol)attributeTypeReference).typeDescriptor()).typeKind() != TypeDescKind.RECORD) continue;
                    Map recordFields = ((RecordTypeSymbol)attributeTypeRecord).fieldDescriptors();
                    key = (String)key + (String)attribute.getName().get();
                    this.getSpreadFieldDetails((String)key, recordFields.values());
                }
                continue;
            }
            this.spreadFieldResponseMap.put((String)key + (String)attribute.getName().get(), attributeType.typeKind().getName());
            if (iterator.hasNext()) continue;
            key = "";
        }
    }

    private void getResponseKeys(Map<String, Object> leftSchemaMap, String keyName) {
        for (Map.Entry<String, Object> field : leftSchemaMap.entrySet()) {
            StringBuilder fieldKey = new StringBuilder();
            Map treeMap = null;
            if (!keyName.isEmpty()) {
                fieldKey.append(keyName).append(".");
            }
            try {
                treeMap = (Map)field.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            fieldKey.append(field.getKey());
            if (treeMap != null) {
                this.getResponseKeys(treeMap, fieldKey.toString());
                continue;
            }
            this.responseFieldMap.put(fieldKey.toString(), field.getValue().toString());
        }
    }

    private String getMapping(JsonArray schemas, CodeActionContext context) throws IOException {
        int hashCode = schemas.hashCode();
        if (this.mappingCache.asMap().containsKey(hashCode)) {
            return (String)this.mappingCache.asMap().get(hashCode);
        }
        try {
            String mappingFromServer = this.getMappingFromServer(schemas, context.languageServercontext());
            this.mappingCache.put((Object)hashCode, (Object)mappingFromServer);
            return mappingFromServer;
        }
        catch (IOException e) {
            throw new IOException("Error connecting the AI service" + e.getMessage(), e);
        }
    }

    private JsonElement rightRecordToJSON(Collection<RecordFieldSymbol> schemaFields) {
        JsonObject properties = new JsonObject();
        for (RecordFieldSymbol attribute : schemaFields) {
            JsonObject fieldDetails = new JsonObject();
            if (attribute.isOptional() && !this.rightSpecificFieldList.contains(attribute.getName().get())) continue;
            fieldDetails.addProperty(ID, ID);
            TypeSymbol attributeType = CommonUtil.getRawType((TypeSymbol)attribute.typeDescriptor());
            if (attributeType.typeKind() == TypeDescKind.RECORD) {
                if (attribute.isOptional()) {
                    this.optionalRightRecordFields.add((String)attribute.getName().get());
                }
                Map recordFields = ((RecordTypeSymbol)attributeType).fieldDescriptors();
                fieldDetails.addProperty(TYPE, "ballerina_type");
                fieldDetails.add(PROPERTIES, this.rightRecordToJSON(recordFields.values()));
            } else if (attributeType.typeKind() == TypeDescKind.INTERSECTION) {
                List memberTypeList = ((IntersectionTypeSymbol)attribute.typeDescriptor()).memberTypeDescriptors();
                for (TypeSymbol attributeTypeReference : memberTypeList) {
                    TypeSymbol attributeTypeRecord;
                    if (attributeTypeReference.typeKind() != TypeDescKind.TYPE_REFERENCE || (attributeTypeRecord = ((TypeReferenceTypeSymbol)attributeTypeReference).typeDescriptor()).typeKind() != TypeDescKind.RECORD) continue;
                    if (attribute.isOptional()) {
                        this.optionalRightRecordFields.add((String)attribute.getName().get());
                    }
                    Map recordFields = ((RecordTypeSymbol)attributeTypeRecord).fieldDescriptors();
                    fieldDetails.addProperty(TYPE, "ballerina_type");
                    fieldDetails.add(PROPERTIES, this.rightRecordToJSON(recordFields.values()));
                }
            } else {
                fieldDetails.addProperty(TYPE, attributeType.typeKind().getName());
                fieldDetails.addProperty(OPTIONAL, Boolean.valueOf(attribute.isOptional()));
                fieldDetails.addProperty(SIGNATURE, attributeType.signature());
            }
            properties.add((String)attribute.getName().get(), (JsonElement)fieldDetails);
        }
        return properties;
    }

    private JsonElement leftRecordToJSON(Collection<RecordFieldSymbol> schemaFields) {
        JsonObject properties = new JsonObject();
        for (RecordFieldSymbol attribute : schemaFields) {
            JsonObject fieldDetails = new JsonObject();
            fieldDetails.addProperty(ID, ID);
            TypeSymbol attributeType = CommonUtil.getRawType((TypeSymbol)attribute.typeDescriptor());
            if (attributeType.typeKind() == TypeDescKind.RECORD) {
                Map recordFields = ((RecordTypeSymbol)attributeType).fieldDescriptors();
                fieldDetails.addProperty(TYPE, "ballerina_type");
                fieldDetails.add(PROPERTIES, this.leftRecordToJSON(recordFields.values()));
            } else if (attributeType.typeKind() == TypeDescKind.INTERSECTION) {
                List memberTypeList = ((IntersectionTypeSymbol)attribute.typeDescriptor()).memberTypeDescriptors();
                for (TypeSymbol attributeTypeReference : memberTypeList) {
                    TypeSymbol attributeTypeRecord;
                    if (attributeTypeReference.typeKind() != TypeDescKind.TYPE_REFERENCE || (attributeTypeRecord = ((TypeReferenceTypeSymbol)attributeTypeReference).typeDescriptor()).typeKind() != TypeDescKind.RECORD) continue;
                    Map recordFields = ((RecordTypeSymbol)attributeTypeRecord).fieldDescriptors();
                    fieldDetails.addProperty(TYPE, "ballerina_type");
                    fieldDetails.add(PROPERTIES, this.leftRecordToJSON(recordFields.values()));
                }
            } else {
                fieldDetails.addProperty(TYPE, attributeType.typeKind().getName());
                boolean readonlyCheck = false;
                if (!attribute.qualifiers().isEmpty()) {
                    for (Qualifier qualifier : attribute.qualifiers()) {
                        readonlyCheck = qualifier.getValue().contains(READONLY);
                        if (!readonlyCheck) continue;
                        TypeDescKind attributeTypeKind = attributeType.typeKind();
                        if (attributeTypeKind == TypeDescKind.XML | attributeTypeKind == TypeDescKind.ARRAY | attributeTypeKind == TypeDescKind.MAP | attributeTypeKind == TypeDescKind.TABLE | attributeTypeKind == TypeDescKind.OBJECT | attributeTypeKind == TypeDescKind.TUPLE) {
                            fieldDetails.addProperty(READONLY, Boolean.valueOf(true));
                            break;
                        }
                        readonlyCheck = false;
                    }
                }
                if (!readonlyCheck) {
                    fieldDetails.addProperty(READONLY, Boolean.valueOf(false));
                }
            }
            properties.add((String)attribute.getName().get(), (JsonElement)fieldDetails);
        }
        return properties;
    }

    private String getMappingFromServer(JsonArray dataToSend, LanguageServerContext serverContext) throws IOException {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json; utf-8");
            headers.put("Accept", "application/json");
            String url = ((ClientExtendedConfigImpl)((Object)LSClientConfigHolder.getInstance((LanguageServerContext)serverContext).getConfigAs(ClientExtendedConfigImpl.class))).getDataMapper().getUrl() + "/map/2.0.0";
            HttpResponse response = HttpClientRequest.doPost(url, dataToSend.toString(), headers);
            int responseCode = response.getResponseCode();
            if (responseCode != 200) {
                if (responseCode == 422) {
                    throw new IOException("Error: Un-processable data");
                }
                if (responseCode == 500) {
                    throw new IOException("Error: AI service error");
                }
            }
            return JsonParser.parseString((String)response.getData()).getAsJsonObject().get("answer").toString();
        }
        catch (IOException e) {
            throw new IOException("Error connecting the AI service" + e.getMessage(), e);
        }
    }

    private String generateMappingFunction(String mappingFromServer, String foundTypeLeft, String foundTypeRight, String leftModule, String rightModule, String rhsSignature, SyntaxTree syntaxTree) {
        Object leftType = foundTypeLeft;
        Object rightType = rhsSignature.isEmpty() ? foundTypeRight : rhsSignature;
        mappingFromServer = ((String)mappingFromServer).replace("\"", "");
        mappingFromServer = ((String)mappingFromServer).replace(",", ", ");
        mappingFromServer = ((String)mappingFromServer).replace(":", ": ");
        if (!this.spreadFieldMap.isEmpty()) {
            for (Map.Entry<String, Map<String, RecordFieldSymbol>> entry : this.spreadFieldMap.entrySet()) {
                if (((String)mappingFromServer).contains("." + entry.getKey() + ".")) {
                    this.getSpreadFieldDetails("", entry.getValue().values());
                    String commonString = foundTypeRight.toLowerCase() + "." + entry.getKey() + ".";
                    for (Map.Entry<String, String> spreadField : this.spreadFieldResponseMap.entrySet()) {
                        String targetString = commonString + spreadField.getKey();
                        String replaceString = "<" + spreadField.getValue() + "> " + foundTypeRight.toLowerCase() + "[\"" + spreadField.getKey() + "\"]";
                        mappingFromServer = ((String)mappingFromServer).replace(targetString, replaceString);
                    }
                }
                this.spreadFieldResponseMap.clear();
            }
            this.spreadFieldMap.clear();
        }
        if (!this.isOptionalMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.isOptionalMap.entrySet()) {
                if (!((String)mappingFromServer).contains(entry.getKey() + ",") && !((String)mappingFromServer).contains(entry.getKey() + "}")) continue;
                Object replacement = "";
                int recordFieldIndex = this.checkForOptionalRecordField(entry.getKey());
                if (recordFieldIndex > 0) {
                    String firstPrat = entry.getKey().substring(0, recordFieldIndex - 1);
                    splitKey = entry.getKey().substring(recordFieldIndex - 1).split("\\.");
                    replacement = firstPrat;
                    for (String key : splitKey) {
                        if (key.isEmpty()) continue;
                        replacement = (String)replacement + "?." + key;
                    }
                } else {
                    int i = entry.getKey().lastIndexOf(".");
                    splitKey = new String[]{entry.getKey().substring(0, i), entry.getKey().substring(i)};
                    replacement = splitKey[0] + "?" + splitKey[1];
                }
                mappingFromServer = ((String)mappingFromServer).replace(entry.getKey(), "<" + (String)entry.getValue() + "> " + (String)replacement);
            }
        }
        if (!this.restFieldMap.isEmpty()) {
            for (Map.Entry entry : this.restFieldMap.entrySet()) {
                if (!((String)mappingFromServer).contains((String)entry.getKey() + ",") && !((String)mappingFromServer).contains((String)entry.getKey() + "}")) continue;
                int i = ((String)entry.getKey()).lastIndexOf(".");
                String[] splitKey = new String[]{((String)entry.getKey()).substring(0, i), ((String)entry.getKey()).substring(i)};
                String replacement = splitKey[0] + "[\"" + splitKey[1].replace(".", "") + "\"]";
                mappingFromServer = ((String)mappingFromServer).replace((CharSequence)entry.getKey(), "<" + (String)entry.getValue() + "> " + replacement);
            }
            this.restFieldMap.clear();
        }
        if (!this.leftReadOnlyFields.isEmpty()) {
            for (String string : this.leftReadOnlyFields) {
                if (!((String)mappingFromServer).contains(string + ":")) continue;
                String[] splitArray = ((String)mappingFromServer).split(string + ":");
                int inputIndex = splitArray[1].indexOf(",");
                mappingFromServer = splitArray[0] + string + ":" + splitArray[1].substring(0, inputIndex) + ".cloneReadOnly()" + splitArray[1].substring(inputIndex);
                boolean replacement = false;
            }
            this.leftReadOnlyFields.clear();
        }
        try {
            Map responseMap = (Map)new Gson().fromJson((JsonElement)JsonParser.parseString((String)mappingFromServer).getAsJsonObject(), (TypeToken)new TypeToken<Map<String, Object>>(this){});
            this.getResponseKeys(responseMap, "");
            HashSet<String> hashSet = new HashSet<String>(this.responseFieldMap.keySet());
            hashSet.addAll(this.leftFieldMap.keySet());
            hashSet.removeAll(this.responseFieldMap.keySet());
            if (!hashSet.isEmpty()) {
                for (String key : hashSet) {
                    String defaultValue = DefaultValueGenerator.generateDefaultValues(this.leftFieldMap.get(key)).toString();
                    mappingFromServer = this.generateResponseWithDefaultValues(key, defaultValue, (String)mappingFromServer);
                }
            }
        }
        catch (Exception responseMap) {
            // empty catch block
        }
        this.leftFieldMap.clear();
        this.responseFieldMap.clear();
        this.optionalRightRecordFields.clear();
        this.rightSpecificFieldList.clear();
        this.isOptionalMap.clear();
        if (leftModule != null) {
            leftType = leftModule + ":" + foundTypeLeft;
        }
        if (rightModule != null) {
            rightType = rightModule + ":" + foundTypeRight;
        }
        String mappingFunction = "\nfunction map" + foundTypeRight + "To" + foundTypeLeft + " (" + (String)rightType + " " + foundTypeRight.toLowerCase() + ") returns " + (String)leftType + " {\n// Some record fields might be missing in the AI based mapping.\n\t" + (String)leftType + " " + foundTypeLeft.toLowerCase() + " = " + (String)mappingFromServer + ";\n\treturn " + foundTypeLeft.toLowerCase() + ";\n}\n";
        return mappingFunction;
    }

    private List<RecordTypeSymbol> checkMappingCapability(Symbol lftTypeSymbol, Symbol rhsTypeSymbol) {
        ArrayList<RecordTypeSymbol> symbolArrayList = new ArrayList<RecordTypeSymbol>();
        if (rhsTypeSymbol.getName().isEmpty()) {
            RecordTypeSymbol rightSymbol = (RecordTypeSymbol)rhsTypeSymbol;
            symbolArrayList.add(rightSymbol);
        } else {
            TypeSymbol rhsSymbol = ((TypeReferenceTypeSymbol)rhsTypeSymbol).typeDescriptor();
            if ("RECORD".equals(rhsSymbol.typeKind().name())) {
                RecordTypeSymbol rightSymbol = (RecordTypeSymbol)rhsSymbol;
                symbolArrayList.add(rightSymbol);
            }
        }
        TypeSymbol lftSymbol = ((TypeReferenceTypeSymbol)lftTypeSymbol).typeDescriptor();
        if ("RECORD".equals(lftSymbol.typeKind().name())) {
            RecordTypeSymbol leftSymbol = (RecordTypeSymbol)lftSymbol;
            symbolArrayList.add(leftSymbol);
        }
        return symbolArrayList;
    }

    private String generateResponseWithDefaultValues(String key, String defaultValue, String mappingFromServer) {
        if (key.contains(".")) {
            StringBuilder insertString = new StringBuilder();
            String[] keyArray = key.split("\\.");
            boolean foundKeyValue = false;
            int insertLocation = 0;
            for (String keyValue : keyArray) {
                if (((String)mappingFromServer).contains(keyValue)) {
                    foundKeyValue = true;
                    insertLocation = ((String)mappingFromServer).indexOf(keyValue) + keyValue.length() + 3;
                    continue;
                }
                if (keyValue == keyArray[keyArray.length - 1]) {
                    if (foundKeyValue) {
                        if (defaultValue.isEmpty()) {
                            insertString.append(keyValue).append(": ").append("\"\"");
                        } else {
                            insertString.append(keyValue).append(": ").append(defaultValue);
                        }
                        mappingFromServer = ((String)mappingFromServer).substring(0, insertLocation) + String.valueOf(insertString) + ", " + ((String)mappingFromServer).substring(insertLocation);
                        continue;
                    }
                    int lastIndex = ((String)mappingFromServer).lastIndexOf("}");
                    if (defaultValue.isEmpty()) {
                        insertString.append(keyValue).append(": ").append("\"\"");
                    } else {
                        insertString.append(keyValue).append(": ").append(defaultValue);
                    }
                    mappingFromServer = ((String)mappingFromServer).substring(0, lastIndex) + ", " + String.valueOf(insertString) + "}";
                    continue;
                }
                insertString.append(keyValue).append(": {");
            }
        } else {
            int lastIndex = ((String)mappingFromServer).lastIndexOf("}");
            mappingFromServer = defaultValue.isEmpty() ? ((String)mappingFromServer).substring(0, lastIndex) + ", " + key + ": \"\"}" : ((String)mappingFromServer).substring(0, lastIndex) + ", " + key + ": " + defaultValue + "}";
        }
        return mappingFromServer;
    }
}

