/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.langlib.array.utils.ArrayUtils;
import org.ballerinalang.langlib.array.utils.GetFunction;

public class Enumerate {
    private Enumerate() {
    }

    public static BArray enumerate(BArray arr) {
        TupleType elemType;
        Type arrType = TypeUtils.getImpliedType((Type)arr.getType());
        int size = arr.size();
        GetFunction getFn = switch (arrType.getTag()) {
            case 32 -> {
                elemType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, arr.getElementType()));
                yield BArray::get;
            }
            case 44 -> {
                TupleType tupleType = (TupleType)arrType;
                UnionType tupElemType = TypeCreator.createUnionType((List)tupleType.getTupleTypes(), (int)tupleType.getTypeFlags());
                elemType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, tupElemType));
                yield BArray::getRefValue;
            }
            default -> throw ArrayUtils.createOpNotSupportedError(arrType, "enumerate()");
        };
        ArrayType newArrType = TypeCreator.createArrayType((Type)elemType);
        BArray newArr = ValueCreator.createArrayValue((ArrayType)newArrType);
        for (int i = 0; i < size; ++i) {
            BArray entry = ValueCreator.createTupleValue((TupleType)elemType);
            entry.add(0L, (Object)i);
            entry.add(1L, getFn.get(arr, i));
            newArr.add((long)i, (Object)entry);
        }
        return newArr;
    }
}

