/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.openapi.cmd.BaseCmd;
import io.ballerina.openapi.cmd.CmdConstants;
import io.ballerina.openapi.cmd.CmdOptions;
import io.ballerina.openapi.cmd.CmdUtils;
import io.ballerina.openapi.cmd.OpenAPICmdToolException;
import io.ballerina.openapi.cmd.OpenApiCmd;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.KeyNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.Minutiae;
import io.ballerina.toml.syntax.tree.MinutiaeList;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import picocli.CommandLine;

@CommandLine.Command(name="add", description={"Update Ballerina.toml with the OpenAPI CLI code generation implementation"})
public class Add
implements BLauncherCmd {
    private static final String COMMAND_IDENTIFIER = "openapi-add";
    private final PrintStream outStream;
    private final boolean exitWhenFinish;
    private CmdConstants.Mode mode;
    @CommandLine.Mixin
    private final BaseCmd baseCmd = new BaseCmd();
    @CommandLine.ParentCommand
    private OpenApiCmd openApiMainCmd;
    @CommandLine.Option(names={"--module"}, description={"Location of the generated Ballerina client"})
    private String outputModule;
    @CommandLine.Option(names={"--id"}, description={"ID for the generated Ballerina client"})
    private String id;
    @CommandLine.Option(names={"-p", "--package"}, description={"Location for the Ballerina package"})
    private String packagePath;

    public Add() {
        this.outStream = System.err;
        this.exitWhenFinish = true;
    }

    public Add(PrintStream outStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    public void execute() {
        Path projectPath = this.packagePath != null ? Path.of(this.packagePath, new String[0]) : Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
        try {
            if (this.baseCmd.helpFlag) {
                String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)COMMAND_IDENTIFIER, (ClassLoader)Add.class.getClassLoader());
                this.outStream.println(commandUsageInfo);
                return;
            }
            Path ballerinaTomlPath = CmdUtils.getBallerinaTomlPath(projectPath);
            this.validateInputPath();
            Path tomlPath = projectPath.resolve(ballerinaTomlPath);
            TextDocument configDocument = TextDocuments.from((String)Files.readString(tomlPath));
            SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)configDocument);
            DocumentNode rootNode = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNode.members();
            NodeList<DocumentMemberDeclarationNode> moduleMembers = AbstractNodeFactory.createEmptyNodeList();
            for (DocumentMemberDeclarationNode node : nodeList) {
                moduleMembers = moduleMembers.add((Node)node);
            }
            this.createDefaultClientID();
            CmdOptions options = this.collectCLIOptions();
            moduleMembers = CmdUtils.addNewLine((NodeList)moduleMembers, 1);
            moduleMembers = this.populateOpenAPITomlConfig(options, moduleMembers);
            IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
            DocumentNode documentNode = NodeFactory.createDocumentNode(moduleMembers, (Token)eofToken);
            TextDocument textDocument = TextDocuments.from((String)documentNode.toSourceCode());
            String content = SyntaxTree.from((TextDocument)textDocument).toSourceCode();
            try (FileWriter writer = new FileWriter(tomlPath.toString(), StandardCharsets.UTF_8);){
                writer.write(content);
                this.outStream.print("The 'Ballerina.toml' file is updated successfully with the OpenAPI tool configuration.");
            }
        }
        catch (OpenAPICmdToolException | IOException e) {
            this.outStream.println(e.getMessage());
            CommandUtil.exitError((boolean)this.exitWhenFinish);
        }
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private void createDefaultClientID() {
        if (this.id == null || this.id.isBlank()) {
            String file = this.baseCmd.inputPath.substring(this.baseCmd.inputPath.lastIndexOf(47) + 1, this.baseCmd.inputPath.lastIndexOf(46));
            if (this.baseCmd.mode != null) {
                this.mode = CmdUtils.searchEnum(CmdConstants.Mode.class, this.baseCmd.mode);
                if (this.mode == null) {
                    this.outStream.printf("ERROR:Invalid value for option '--mode': expected one of [service, client] but was '%s'%n", this.baseCmd.mode);
                    CommandUtil.exitError((boolean)this.exitWhenFinish);
                }
            }
            this.id = String.format("oas_%s_%s", this.mode == null ? "client" : this.baseCmd.mode, file);
        }
    }

    private void validateInputPath() {
        if (this.baseCmd.inputPath == null || this.baseCmd.inputPath.isBlank()) {
            this.outStream.printf("ERROR: provide input oas contract path.%n%n", new Object[0]);
            CommandUtil.exitError((boolean)this.exitWhenFinish);
        }
    }

    private CmdOptions collectCLIOptions() {
        return new CmdOptions.CmdOptionsBuilder().withInput(this.baseCmd.inputPath).withId(this.id).withOutputModule(this.outputModule).withPackagePath(this.packagePath).withClientMethod(this.baseCmd.generateClientMethods).withMode(this.mode).withNullable(this.baseCmd.nullable).withOperations(this.getOperations()).withTags(this.getTags()).withLicensePath(this.baseCmd.licenseFilePath).withStatusCodeBinding(this.baseCmd.statusCodeBinding).withMock(this.baseCmd.mock).withSingleFile(this.baseCmd.singleFile).build();
    }

    private NodeList<DocumentMemberDeclarationNode> populateOpenAPITomlConfig(CmdOptions optionsBuilder, NodeList<DocumentMemberDeclarationNode> moduleMembers) {
        ArrayNode arrayNode;
        SeparatedNodeList value;
        Node[] arrayItems;
        TableNode openapiToolConfig = SampleNodeGenerator.createTable((String)"[tool.openapi]", null);
        moduleMembers = moduleMembers.add((Node)openapiToolConfig);
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"id", (String)optionsBuilder.getId(), null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"filePath", (String)optionsBuilder.getInput(), null));
        if (optionsBuilder.getOutputModule() != null) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"targetModule", (String)optionsBuilder.getOutputModule(), null));
        }
        if (optionsBuilder.getMode() != null) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"options.mode", (String)optionsBuilder.getMode().toString().toLowerCase(Locale.ENGLISH), null));
        }
        if (optionsBuilder.getTags() != null && !optionsBuilder.getTags().isEmpty()) {
            arrayItems = this.getArrayItemNodes(this.getTags());
            value = AbstractNodeFactory.createSeparatedNodeList((Node[])arrayItems);
            arrayNode = NodeFactory.createArrayNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), (SeparatedNodeList)value, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
            KeyValueNode tagNodes = NodeFactory.createKeyValueNode((KeyNode)Add.getKeyNode("options.tags"), (Token)Add.getAssignToken(), (ValueNode)arrayNode);
            moduleMembers = moduleMembers.add((Node)tagNodes);
            if (optionsBuilder.getOperations() != null && !optionsBuilder.getOperations().isEmpty()) {
                moduleMembers = CmdUtils.addNewLine(moduleMembers, 1);
            }
        }
        if (optionsBuilder.getOperations() != null && !optionsBuilder.getOperations().isEmpty()) {
            arrayItems = this.getArrayItemNodes(this.getOperations());
            value = AbstractNodeFactory.createSeparatedNodeList((Node[])arrayItems);
            arrayNode = NodeFactory.createArrayNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), (SeparatedNodeList)value, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
            KeyValueNode opsNodes = NodeFactory.createKeyValueNode((KeyNode)Add.getKeyNode("options.operations"), (Token)Add.getAssignToken(), (ValueNode)arrayNode);
            moduleMembers = moduleMembers.add((Node)opsNodes);
            moduleMembers = CmdUtils.addNewLine((NodeList)moduleMembers, 1);
        }
        if (optionsBuilder.isNullable()) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createBooleanKV((String)"options.nullable", (Boolean)optionsBuilder.isNullable(), null));
        }
        if (optionsBuilder.getClientMethod() != null) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"options.clientMethods", (String)optionsBuilder.getClientMethod(), null));
        }
        if (optionsBuilder.getLicensePath() != null && !optionsBuilder.getLicensePath().isBlank()) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"options.licensePath", (String)optionsBuilder.getLicensePath(), null));
        }
        if (optionsBuilder.getStatusCodeBinding()) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createBooleanKV((String)"options.statusCodeBinding", (Boolean)optionsBuilder.getStatusCodeBinding(), null));
        }
        if (optionsBuilder.getMock()) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createBooleanKV((String)"options.mock", (Boolean)optionsBuilder.getMock(), null));
        }
        if (optionsBuilder.getSingleFile()) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createBooleanKV((String)"options.singleFile", (Boolean)optionsBuilder.getSingleFile(), null));
        }
        moduleMembers = CmdUtils.addNewLine((NodeList)moduleMembers, 2);
        return moduleMembers;
    }

    private Node[] getArrayItemNodes(List<String> items) {
        ArrayList<Object> itemList = new ArrayList<Object>();
        IdentifierToken doubleQuotes = AbstractNodeFactory.createIdentifierToken((String)"\"");
        for (String item : items) {
            itemList.add(NodeFactory.createStringLiteralNode((Token)doubleQuotes, (Token)AbstractNodeFactory.createIdentifierToken((String)item), (Token)doubleQuotes));
            itemList.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        if (!itemList.isEmpty()) {
            itemList.remove(itemList.size() - 1);
        }
        return itemList.toArray(new Node[0]);
    }

    public String getName() {
        return "add";
    }

    public void printLongDesc(StringBuilder stringBuilder) {
    }

    public void printUsage(StringBuilder stringBuilder) {
    }

    public void setParentCmdParser(CommandLine commandLine) {
    }

    public List<String> getTags() {
        return this.baseCmd.tags == null ? new ArrayList<String>() : Arrays.asList(this.baseCmd.tags.split(","));
    }

    public List<String> getOperations() {
        return this.baseCmd.operations == null ? new ArrayList<String>() : Arrays.asList(this.baseCmd.operations.split(","));
    }

    private static KeyNode getKeyNode(String key) {
        return NodeFactory.createKeyNode((SeparatedNodeList)NodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createIdentifierToken((String)key)}));
    }

    private static Token getAssignToken() {
        MinutiaeList whitespaceMinList = NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")});
        return NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN, (MinutiaeList)whitespaceMinList, (MinutiaeList)whitespaceMinList);
    }
}

