/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import picocli.CommandLine;

public class BaseCmd {
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    public boolean helpFlag;
    @CommandLine.Option(names={"-i", "--input"}, description={"Generating the client and service both files"})
    public String inputPath;
    @CommandLine.Option(names={"--license"}, description={"Location of the file which contains the license header"})
    public String licenseFilePath;
    @CommandLine.Option(names={"--mode"}, description={"Generate only service file or client file according to the given mode type"})
    public String mode;
    @CommandLine.Option(names={"-n", "--nullable"}, description={"Generate the code by setting nullable true"})
    public boolean nullable;
    @CommandLine.Option(names={"--tags"}, description={"Tag that need to write service"})
    public String tags;
    @CommandLine.Option(names={"--operations"}, description={"Operations that need to write service"})
    public String operations;
    @CommandLine.Option(names={"--client-methods"}, hidden=true, description={"Generate the client methods with provided type . Only \"resource\"(default) and \"remote\" options are supported."})
    public String generateClientMethods;
    @CommandLine.Option(names={"--status-code-binding"}, description={"Generate the client methods with status code response binding"})
    public boolean statusCodeBinding;
    @CommandLine.Option(names={"--mock"}, hidden=true, description={"Generate mock client with given response example"})
    public boolean mock;
    @CommandLine.Option(names={"--single-file"}, description={"Generate all contents in a single file"})
    public boolean singleFile;
    @CommandLine.Option(names={"--use-sanitized-oas"}, hidden=true, description={"This option enables code generation by modifying the given OAS to follow the Ballerina language best practices."})
    public boolean useSanitized;

    public static void exitError(boolean exit) {
        BaseCmd.exit(1, exit);
    }

    static void exit(int code, boolean exit) {
        if (exit) {
            Runtime.getRuntime().exit(code);
        }
    }
}

