/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.openapi.service.mapper.ServiceToOpenAPIMapper;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.OASResult;
import io.ballerina.openapi.service.mapper.utils.CodegenUtils;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OASContractGenerator {
    private SyntaxTree syntaxTree;
    private SemanticModel semanticModel;
    private Project project;
    private List<OpenAPIMapperDiagnostic> diagnostics = new ArrayList<OpenAPIMapperDiagnostic>();
    private PrintStream outStream = System.out;
    private Boolean ballerinaExtension = false;

    public void setBallerinaExtension(Boolean ballerinaExtension) {
        if (Objects.nonNull(ballerinaExtension)) {
            this.ballerinaExtension = ballerinaExtension;
        }
    }

    public List<OpenAPIMapperDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public void generateOAS3DefinitionsAllService(Path servicePath, Path outPath, String serviceName, Boolean needJson) {
        Document doc;
        DocumentId docId;
        this.project = ProjectLoader.load((Path)servicePath).project();
        DiagnosticResult diagnosticsFromCodeGenAndModify = this.project.currentPackage().runCodeGenAndModifyPlugins();
        boolean hasErrorsFromCodeGenAndModify = diagnosticsFromCodeGenAndModify.diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (this.project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            docId = this.project.documentId(servicePath);
            ModuleId moduleId = docId.moduleId();
            doc = this.project.currentPackage().module(moduleId).document(docId);
        } else {
            Module currentModule = this.project.currentPackage().getDefaultModule();
            Iterator documentIterator = currentModule.documentIds().iterator();
            docId = (DocumentId)documentIterator.next();
            doc = currentModule.document(docId);
        }
        Optional path = this.project.documentPath(docId);
        Path inputPath = path.orElse(null);
        this.syntaxTree = doc.syntaxTree();
        PackageCompilation compilation = this.project.currentPackage().getCompilation();
        boolean hasCompilationErrors = compilation.diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (hasCompilationErrors || hasErrorsFromCodeGenAndModify) {
            this.outStream.println("openapi contract generation is skipped because of the Ballerina file/package has the following compilation error(s):");
            compilation.diagnosticResult().diagnostics().forEach(diagnostic -> this.outStream.println(diagnostic.toString()));
            return;
        }
        this.semanticModel = compilation.getSemanticModel(docId.moduleId());
        List openAPIDefinitions = ServiceToOpenAPIMapper.generateOAS3Definition((Project)this.project, (SyntaxTree)this.syntaxTree, (SemanticModel)this.semanticModel, (String)serviceName, (Boolean)needJson, (Path)inputPath, (Boolean)this.ballerinaExtension);
        if (!openAPIDefinitions.isEmpty()) {
            ArrayList<String> fileNames = new ArrayList<String>();
            for (OASResult definition : openAPIDefinitions) {
                try {
                    List definitionDiagnostics = definition.getDiagnostics();
                    boolean hasErrors = definitionDiagnostics.stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.getDiagnosticSeverity()));
                    this.diagnostics.addAll(definition.getDiagnostics());
                    if (hasErrors) {
                        this.outStream.println("openapi contract generation skipped due to the following code generation error(s):");
                        return;
                    }
                    if (!definition.getOpenAPI().isPresent()) continue;
                    Optional content = needJson != false ? definition.getJson() : definition.getYaml();
                    String fileName = CodegenUtils.resolveContractFileName((Path)outPath, (String)definition.getServiceName(), (Boolean)needJson);
                    CodegenUtils.writeFile((Path)outPath.resolve(fileName), (String)((String)content.get()));
                    fileNames.add(fileName);
                }
                catch (IOException e) {
                    ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_108, new String[]{e.getLocalizedMessage()});
                    this.diagnostics.add((OpenAPIMapperDiagnostic)error);
                }
            }
            if (fileNames.isEmpty()) {
                return;
            }
            this.outStream.println("OpenAPI definition(s) generated successfully and copied to :");
            Iterator iterator = fileNames.iterator();
            while (iterator.hasNext()) {
                this.outStream.println("-- " + (String)iterator.next());
            }
        } else {
            ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_115, new String[0]);
            this.diagnostics.add((OpenAPIMapperDiagnostic)error);
        }
    }
}

