/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp.compiler;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.udp.compiler.Utils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class UdpServiceValidator {
    private FunctionDefinitionNode onDatagramFunctionNode;
    private FunctionDefinitionNode onBytesFunctionNode;
    private FunctionDefinitionNode onErrorFunctionNode;
    private final String modulePrefix;
    private final SyntaxNodeAnalysisContext ctx;
    public static final String CODE_101 = "UDP_101";
    public static final String CODE_102 = "UDP_102";
    public static final String CODE_103 = "UDP_103";
    public static final String CODE_104 = "UDP_104";
    public static final String CODE_105 = "UDP_105";
    public static final String CODE_106 = "UDP_106";
    public static final String CODE_107 = "UDP_107";
    public static final String SERVICE_CANNOT_CONTAIN_BOTH_ON_DATAGRAM_0_AND_ON_BYTES_1_FUNCTIONS = "Service cannot contain both `onDatagram` {0} and `onBytes` {1} functions.";
    public static final String SERVICE_DOES_NOT_CONTAIN_ON_DATAGRAM_OR_ON_BYTES_FUNCTION = "Service does not contain `onDatagram` or `onBytes` function.";
    public static final String NO_PARAMETER_PROVIDED_FOR_0_FUNCTION_EXPECTS_1_AS_A_PARAMETER = "No parameter provided for `{0}`, function expects `{1}` as a parameter.";
    public static final String REMOTE_KEYWORD_EXPECTED_IN_0_FUNCTION_SIGNATURE = "`remote` keyword expected in `{0}` function signature.";
    public static final String INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2 = "Invalid parameter `{0}` provided for `{1}`, function expects `{2}`.";
    public static final String INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION = "Invalid parameter `{0}` provided for `{1}` function.";
    public static final String INVALID_RETURN_TYPE_0_FUNCTION_1_RETURN_TYPE_SHOULD_BE_A_SUBTYPE_OF_2 = "Invalid return type `{0}` provided for function `{1}`, return type should be a subtype of `{2}`";
    public static final String FUNCTION_0_NOT_ACCEPTED_BY_THE_SERVICE = "Function `{0}` not accepted by the service";
    public static final String PROVIDED_0_PARAMETERS_1_CAN_HAVE_ONLY_2_PARAMETERS = "Provided {0} parameters, `{1}` can have only {2} parameters";
    public static final String DATAGRAM_REMOTE_FUNCTION_GENERATION = "onDatagram remote function generation";
    public static final String BYTES_REMOTE_FUNCTION_GENERATION = "onBytes remote function generation";
    public static final String READONLY_INTERSECTION = "readonly & ";
    public static final String DATAGRAM = "Datagram";
    public static final String CALLER = "Caller";
    public static final String BYTE_ARRAY = "byte[]";
    public static final String ERROR = "Error";
    public static final String GENERIC_ERROR = "error";
    public static final String OPTIONAL = "?";
    public static final String NIL = "()";

    public UdpServiceValidator(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, String modulePrefixOrModuleName) {
        this.ctx = syntaxNodeAnalysisContext;
        this.modulePrefix = modulePrefixOrModuleName;
    }

    public void validate() {
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)this.ctx.node();
        boolean hasRemoteService = serviceDeclarationNode.members().stream().anyMatch(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION);
        if (serviceDeclarationNode.members().isEmpty() || !hasRemoteService) {
            DiagnosticInfo datagramDiagnosticInfo = new DiagnosticInfo(CODE_106, DATAGRAM_REMOTE_FUNCTION_GENERATION, DiagnosticSeverity.INTERNAL);
            DiagnosticInfo bytesDiagnosticInfo = new DiagnosticInfo(CODE_107, BYTES_REMOTE_FUNCTION_GENERATION, DiagnosticSeverity.INTERNAL);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)datagramDiagnosticInfo, (Location)serviceDeclarationNode.location(), (Object[])new Object[0]));
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)bytesDiagnosticInfo, (Location)serviceDeclarationNode.location(), (Object[])new Object[0]));
        }
        serviceDeclarationNode.members().stream().filter(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).forEach(node -> this.filterRemoteMethods((FunctionDefinitionNode)node));
        this.checkOnBytesAndOnDatagramFunctionExistence();
        this.validateFunctionSignature(this.onDatagramFunctionNode, "onDatagram");
        this.validateFunctionSignature(this.onBytesFunctionNode, "onBytes");
        this.validateFunctionSignature(this.onErrorFunctionNode, "onError");
    }

    private void filterRemoteMethods(FunctionDefinitionNode functionDefinitionNode) {
        String functionName = functionDefinitionNode.functionName().toString();
        if (this.hasRemoteKeyword(functionDefinitionNode) && !Utils.equals(functionName, "onDatagram") && !Utils.equals(functionName, "onBytes") && !Utils.equals(functionName, "onError")) {
            this.reportInvalidFunction(functionDefinitionNode);
        } else {
            this.onDatagramFunctionNode = Utils.equals(functionName, "onDatagram") ? functionDefinitionNode : this.onDatagramFunctionNode;
            this.onBytesFunctionNode = Utils.equals(functionName, "onBytes") ? functionDefinitionNode : this.onBytesFunctionNode;
            this.onErrorFunctionNode = Utils.equals(functionName, "onError") ? functionDefinitionNode : this.onErrorFunctionNode;
        }
    }

    private void reportInvalidFunction(FunctionDefinitionNode functionDefinitionNode) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_103, FUNCTION_0_NOT_ACCEPTED_BY_THE_SERVICE, DiagnosticSeverity.ERROR);
        this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)functionDefinitionNode.location(), (Object[])new Object[]{functionDefinitionNode.functionName().toString()}));
    }

    private void validateFunctionSignature(FunctionDefinitionNode functionDefinitionNode, String functionName) {
        if (functionDefinitionNode != null) {
            this.hasRemoteKeyword(functionDefinitionNode, functionName);
            SeparatedNodeList parameterNodes = functionDefinitionNode.functionSignature().parameters();
            if (!this.hasNoParameters((SeparatedNodeList<ParameterNode>)parameterNodes, functionDefinitionNode, functionName)) {
                this.validateParameter((SeparatedNodeList<ParameterNode>)parameterNodes, functionName);
            }
            this.validateFunctionReturnTypeDesc(functionDefinitionNode, functionName);
        }
    }

    private void checkOnBytesAndOnDatagramFunctionExistence() {
        if (this.onBytesFunctionNode != null && this.onDatagramFunctionNode != null) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_102, SERVICE_CANNOT_CONTAIN_BOTH_ON_DATAGRAM_0_AND_ON_BYTES_1_FUNCTIONS, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)this.ctx.node().location(), (Object[])new Object[]{this.onDatagramFunctionNode.location().lineRange(), this.onBytesFunctionNode.location().lineRange()}));
        } else if (this.onBytesFunctionNode == null && this.onDatagramFunctionNode == null) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_102, SERVICE_DOES_NOT_CONTAIN_ON_DATAGRAM_OR_ON_BYTES_FUNCTION, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)this.ctx.node().location(), (Object[])new Object[0]));
        }
    }

    private boolean hasRemoteKeyword(FunctionDefinitionNode functionDefinitionNode, String functionName) {
        boolean hasRemoteKeyword = this.hasRemoteKeyword(functionDefinitionNode);
        if (!hasRemoteKeyword) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_101, REMOTE_KEYWORD_EXPECTED_IN_0_FUNCTION_SIGNATURE, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)functionDefinitionNode.functionKeyword().location(), (Object[])new Object[]{functionName}));
        }
        return hasRemoteKeyword;
    }

    private boolean hasRemoteKeyword(FunctionDefinitionNode functionDefinitionNode) {
        return functionDefinitionNode.qualifierList().stream().filter(q -> q.kind() == SyntaxKind.REMOTE_KEYWORD).toArray().length == 1;
    }

    private boolean hasNoParameters(SeparatedNodeList<ParameterNode> parameterNodes, FunctionDefinitionNode functionDefinitionNode, String functionName) {
        if (parameterNodes.isEmpty()) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_104, NO_PARAMETER_PROVIDED_FOR_0_FUNCTION_EXPECTS_1_AS_A_PARAMETER, DiagnosticSeverity.ERROR);
            String expectedParameter = functionName.equals("onBytes") ? "readonly & byte[]" : (functionName.equals("onError") ? this.modulePrefix + ERROR : READONLY_INTERSECTION + this.modulePrefix + DATAGRAM);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)functionDefinitionNode.functionSignature().location(), (Object[])new Object[]{functionName, expectedParameter}));
            return true;
        }
        return false;
    }

    private void validateParameter(SeparatedNodeList<ParameterNode> parameterNodes, String functionName) {
        if (this.hasValidParameterCount(parameterNodes.size(), functionName)) {
            for (ParameterNode parameterNode : parameterNodes) {
                DiagnosticInfo diagnosticInfo;
                RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
                Node parameterTypeName = requiredParameterNode.typeName();
                boolean hasDatagram = parameterTypeName.toString().contains(this.modulePrefix + DATAGRAM);
                boolean hasCaller = parameterTypeName.toString().contains(this.modulePrefix + CALLER);
                boolean hasByteArray = parameterTypeName.toString().contains(BYTE_ARRAY);
                if (functionName.equals("onDatagram") && (parameterTypeName.kind() == SyntaxKind.INTERSECTION_TYPE_DESC && !hasDatagram || parameterTypeName.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE && !hasCaller)) {
                    if (hasDatagram) {
                        diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2, DiagnosticSeverity.ERROR);
                        this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName, READONLY_INTERSECTION + this.modulePrefix + DATAGRAM}));
                        continue;
                    }
                    diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION, DiagnosticSeverity.ERROR);
                    this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName}));
                    continue;
                }
                if (functionName.equals("onBytes") && (parameterTypeName.kind() == SyntaxKind.INTERSECTION_TYPE_DESC && !hasByteArray || parameterTypeName.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE && !hasCaller)) {
                    diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION, DiagnosticSeverity.ERROR);
                    this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName}));
                    continue;
                }
                if (functionName.equals("onError") && !parameterTypeName.toString().contains(this.modulePrefix + ERROR)) {
                    diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2, DiagnosticSeverity.ERROR);
                    this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName, this.modulePrefix + ERROR}));
                    continue;
                }
                if (parameterTypeName.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE || parameterTypeName.kind() == SyntaxKind.INTERSECTION_TYPE_DESC) continue;
                if (functionName.equals("onBytes") && hasByteArray) {
                    diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2, DiagnosticSeverity.ERROR);
                    this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName, READONLY_INTERSECTION + this.modulePrefix + BYTE_ARRAY}));
                    continue;
                }
                diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION, DiagnosticSeverity.ERROR);
                this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName}));
            }
        }
    }

    private boolean hasValidParameterCount(int parameterCount, String functionName) {
        if (functionName.equals("onBytes") && parameterCount > 2) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_104, PROVIDED_0_PARAMETERS_1_CAN_HAVE_ONLY_2_PARAMETERS, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)this.onBytesFunctionNode.location(), (Object[])new Object[]{parameterCount, functionName, 2}));
            return false;
        }
        if (functionName.equals("onDatagram") && parameterCount > 2) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_104, PROVIDED_0_PARAMETERS_1_CAN_HAVE_ONLY_2_PARAMETERS, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)this.onDatagramFunctionNode.location(), (Object[])new Object[]{parameterCount, functionName, 2}));
            return false;
        }
        if (functionName.equals("onError") && parameterCount > 1) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_104, PROVIDED_0_PARAMETERS_1_CAN_HAVE_ONLY_2_PARAMETERS, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)this.onErrorFunctionNode.location(), (Object[])new Object[]{parameterCount, functionName, 1}));
            return false;
        }
        return true;
    }

    private void validateFunctionReturnTypeDesc(FunctionDefinitionNode functionDefinitionNode, String functionName) {
        boolean isOnBytesOrOnDatagram;
        Optional returnTypeDescriptorNode = functionDefinitionNode.functionSignature().returnTypeDesc();
        if (returnTypeDescriptorNode.isEmpty()) {
            return;
        }
        Node returnTypeDescriptor = ((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get()).type();
        String returnTypeDescriptorType = returnTypeDescriptor.toString().stripTrailing();
        boolean bl = isOnBytesOrOnDatagram = functionName.equals("onDatagram") || functionName.equals("onBytes");
        if (this.validOnDataFunction(returnTypeDescriptor, returnTypeDescriptorType, isOnBytesOrOnDatagram)) {
            return;
        }
        if (functionName.equals("onError") && returnTypeDescriptor.kind() == SyntaxKind.OPTIONAL_TYPE_DESC && (Utils.equals(returnTypeDescriptorType, this.modulePrefix + "Error?") || Utils.equals(returnTypeDescriptorType, "error?"))) {
            return;
        }
        if (returnTypeDescriptor.kind() == SyntaxKind.NIL_TYPE_DESC) {
            return;
        }
        boolean hasInvalidUnionTypeDesc = false;
        boolean isUnionTypeDesc = false;
        if (isOnBytesOrOnDatagram && returnTypeDescriptor.kind() == SyntaxKind.UNION_TYPE_DESC) {
            isUnionTypeDesc = true;
            UnionTypeDescriptorNode unionTypeDescriptorNode = (UnionTypeDescriptorNode)returnTypeDescriptor;
            for (Node descriptor : unionTypeDescriptorNode.children()) {
                String descriptorType = descriptor.toString().stripTrailing();
                if (descriptor.kind() == SyntaxKind.PIPE_TOKEN || descriptor.kind() == SyntaxKind.ARRAY_TYPE_DESC && Utils.equals(descriptorType, BYTE_ARRAY) || descriptor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE && Utils.equals(descriptorType, this.modulePrefix + DATAGRAM) || descriptor.kind() == SyntaxKind.OPTIONAL_TYPE_DESC && (Utils.equals(descriptorType, this.modulePrefix + "Error?") || Utils.equals(descriptorType, this.modulePrefix + "Datagram?") || Utils.equals(descriptorType, "error?") || Utils.equals(descriptorType, "byte[]?"))) continue;
                hasInvalidUnionTypeDesc = true;
                break;
            }
        }
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_105, INVALID_RETURN_TYPE_0_FUNCTION_1_RETURN_TYPE_SHOULD_BE_A_SUBTYPE_OF_2, DiagnosticSeverity.ERROR);
        if (isOnBytesOrOnDatagram && (hasInvalidUnionTypeDesc || !isUnionTypeDesc)) {
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)returnTypeDescriptor.location(), (Object[])new Object[]{returnTypeDescriptor.toString(), functionName, "byte[] | " + this.modulePrefix + "Datagram | " + this.modulePrefix + "Error?"}));
        } else if (!isUnionTypeDesc) {
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)returnTypeDescriptor.location(), (Object[])new Object[]{returnTypeDescriptor.toString(), functionName, this.modulePrefix + "Error | ()"}));
        }
    }

    private boolean validOnDataFunction(Node returnTypeDescriptor, String returnTypeDescriptorType, boolean isOnBytesOrOnDatagram) {
        if (isOnBytesOrOnDatagram && returnTypeDescriptor.kind() == SyntaxKind.ARRAY_TYPE_DESC && Utils.equals(returnTypeDescriptorType, BYTE_ARRAY)) {
            return true;
        }
        if (isOnBytesOrOnDatagram && returnTypeDescriptor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE && Utils.equals(returnTypeDescriptorType, this.modulePrefix + DATAGRAM)) {
            return true;
        }
        return isOnBytesOrOnDatagram && returnTypeDescriptor.kind() == SyntaxKind.OPTIONAL_TYPE_DESC && (Utils.equals(returnTypeDescriptorType, this.modulePrefix + "Error?") || Utils.equals(returnTypeDescriptorType, this.modulePrefix + "Datagram?") || Utils.equals(returnTypeDescriptorType, "byte[]?") || Utils.equals(returnTypeDescriptorType, "error?"));
    }
}

