/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.converters.util;

import io.ballerina.converters.exception.JsonToRecordConverterException;
import io.ballerina.converters.util.Constants;
import io.ballerina.converters.util.ErrorMessages;
import java.util.Optional;

public final class ConverterUtils {
    private ConverterUtils() {
    }

    public static String convertOpenAPITypeToBallerina(String type) {
        if (type == null || type.isEmpty()) {
            return "json";
        }
        return switch (type) {
            case "integer" -> "int";
            case "string" -> "string";
            case "boolean" -> "boolean";
            case "array" -> "[]";
            case "object" -> "record";
            case "decimal", "number", "double" -> "decimal";
            case "float" -> "float";
            default -> "json";
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String escapeIdentifier(String identifier) {
        if (((String)identifier).matches("\\b[0-9]*\\b")) {
            return "'" + (String)identifier;
        }
        if (((String)identifier).matches("\\b[_a-zA-Z][_a-zA-Z0-9]*\\b")) {
            if (!Constants.BAL_KEYWORDS.stream().anyMatch(((String)identifier)::equals)) return identifier;
        }
        if (((String)identifier).equals("error")) {
            return "_error";
        }
        if (!((String)(identifier = ((String)identifier).replaceAll("([\\[\\]\\\\?!<>@#&~`*-=^+();:\\_{}\\s|.$])", "\\\\$1"))).endsWith("?")) return "'" + (String)identifier;
        if (((String)identifier).charAt(((String)identifier).length() - 2) == '\\') {
            StringBuilder stringBuilder = new StringBuilder((String)identifier);
            stringBuilder.deleteCharAt(((String)identifier).length() - 2);
            identifier = stringBuilder.toString();
        }
        if (!Constants.BAL_KEYWORDS.stream().anyMatch(Optional.ofNullable(identifier).filter(sStr -> !sStr.isEmpty()).map(sStr -> sStr.substring(0, sStr.length() - 1)).orElse((String)identifier)::equals)) return identifier;
        return "'" + (String)identifier;
    }

    public static String extractReferenceType(String referenceVariable) throws JsonToRecordConverterException {
        if (referenceVariable.startsWith("#") && referenceVariable.contains("/")) {
            String[] refArray = referenceVariable.split("/");
            return ConverterUtils.escapeIdentifier(refArray[refArray.length - 1]);
        }
        throw new JsonToRecordConverterException(ErrorMessages.invalidReference(referenceVariable));
    }
}

