/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.jsonmapper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.jsonmapper.JsonToRecordResponse;
import io.ballerina.jsonmapper.diagnostic.DiagnosticMessage;
import io.ballerina.jsonmapper.diagnostic.DiagnosticUtils;
import io.ballerina.jsonmapper.util.ConverterUtils;
import io.ballerina.jsonmapper.util.ListOperationUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.options.ForceFormattingOptions;
import org.ballerinalang.formatter.core.options.FormattingOptions;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;

public final class JsonToRecordMapper {
    private static final String NEW_RECORD_NAME = "NewRecord";
    private static final String ARRAY_RECORD_SUFFIX = "Item";

    private JsonToRecordMapper() {
    }

    @Deprecated
    public static JsonToRecordResponse convert(String jsonString, String recordName, boolean isRecordTypeDesc, boolean isClosed, boolean forceFormatRecordFields, String filePathUri, WorkspaceManager workspaceManager) {
        return JsonToRecordMapper.convert(jsonString, recordName, isRecordTypeDesc, isClosed, forceFormatRecordFields, filePathUri, workspaceManager, false);
    }

    public static JsonToRecordResponse convert(String jsonString, String recordName, boolean isRecordTypeDesc, boolean isClosed, boolean forceFormatRecordFields, String filePathUri, WorkspaceManager workspaceManager, boolean isNullAsOptional) {
        NodeList moduleMembers;
        List<String> existingFieldNames = ConverterUtils.getExistingTypeNames(workspaceManager, filePathUri);
        HashMap<String, String> updatedFieldNames = new HashMap<String, String>();
        LinkedHashMap<String, NonTerminalNode> recordToTypeDescNodes = new LinkedHashMap<String, NonTerminalNode>();
        LinkedHashMap<String, JsonElement> jsonFieldToElements = new LinkedHashMap<String, JsonElement>();
        ArrayList<DiagnosticMessage> diagnosticMessages = new ArrayList<DiagnosticMessage>();
        JsonToRecordResponse response = new JsonToRecordResponse();
        if (existingFieldNames.contains(recordName)) {
            DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter105(new String[]{recordName});
            diagnosticMessages.add(message);
            return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
        }
        try {
            JsonElement parsedJson = JsonParser.parseString(jsonString);
            if (parsedJson.isJsonObject()) {
                JsonToRecordMapper.generateRecords(parsedJson.getAsJsonObject(), null, isClosed, recordToTypeDescNodes, null, jsonFieldToElements, existingFieldNames, updatedFieldNames, diagnosticMessages, isNullAsOptional);
            } else if (parsedJson.isJsonArray()) {
                JsonObject object = new JsonObject();
                object.add(recordName == null || recordName.isEmpty() ? StringUtils.uncapitalize(NEW_RECORD_NAME) : StringUtils.uncapitalize(recordName), parsedJson);
                JsonToRecordMapper.generateRecords(object, null, isClosed, recordToTypeDescNodes, null, jsonFieldToElements, existingFieldNames, updatedFieldNames, diagnosticMessages, isNullAsOptional);
            } else {
                DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter101(null);
                diagnosticMessages.add(message);
                return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
            }
            if (recordName != null && recordToTypeDescNodes.containsKey(recordName)) {
                DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter104(new String[]{recordName});
                diagnosticMessages.add(message);
                return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
            }
        }
        catch (JsonSyntaxException e) {
            DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter100(new String[]{e.getMessage()});
            diagnosticMessages.add(message);
            return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
        }
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        List<TypeDefinitionNode> typeDefNodes = recordToTypeDescNodes.entrySet().stream().map(entry -> {
            Token typeKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD);
            String recordTypeName = entry.getKey() == null ? (recordName == null || recordName.isEmpty() ? ConverterUtils.getAndUpdateFieldNames(NEW_RECORD_NAME, false, existingFieldNames, updatedFieldNames) : ConverterUtils.escapeIdentifier(StringUtils.capitalize(recordName))) : (String)entry.getKey();
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)recordTypeName);
            Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
            return NodeFactory.createTypeDefinitionNode(null, null, (Token)typeKeyWord, (Token)typeName, (Node)((Node)entry.getValue()), (Token)semicolon);
        }).toList();
        if (isRecordTypeDesc) {
            Optional<TypeDefinitionNode> lastTypeDefNode = JsonToRecordMapper.convertToInlineRecord(typeDefNodes, diagnosticMessages);
            moduleMembers = lastTypeDefNode.map(xva$0 -> AbstractNodeFactory.createNodeList((Node[])new ModuleMemberDeclarationNode[]{xva$0})).orElseGet(AbstractNodeFactory::createEmptyNodeList);
        } else {
            moduleMembers = AbstractNodeFactory.createNodeList(new ArrayList<TypeDefinitionNode>(typeDefNodes));
        }
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (Token)eofToken);
        try {
            ForceFormattingOptions forceFormattingOptions = ForceFormattingOptions.builder().setForceFormatRecordFields(forceFormatRecordFields).build();
            FormattingOptions formattingOptions = FormattingOptions.builder().setForceFormattingOptions(forceFormattingOptions).build();
            response.setCodeBlock(Formatter.format((SyntaxTree)modulePartNode.syntaxTree(), (FormattingOptions)formattingOptions).toSourceCode());
        }
        catch (FormatterException e) {
            DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter102(null);
            diagnosticMessages.add(message);
        }
        if (!updatedFieldNames.isEmpty()) {
            updatedFieldNames.forEach((oldFieldName, updateFieldName) -> {
                DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter106(new String[]{oldFieldName, updateFieldName});
                diagnosticMessages.add(message);
            });
        }
        return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
    }

    private static void generateRecords(JsonObject jsonObject, String recordName, boolean isClosed, Map<String, NonTerminalNode> recordToTypeDescNodes, String moveBefore, Map<String, JsonElement> jsonNodes, List<String> existingFieldNames, Map<String, String> updatedFieldNames, List<DiagnosticMessage> diagnosticMessages, boolean isNullAsOptional) {
        Token recordKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD);
        Token bodyStartDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN);
        ArrayList<Node> recordFields = new ArrayList<Node>();
        if (recordToTypeDescNodes.containsKey(recordName)) {
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                if (entry.getValue().isJsonObject() || entry.getValue().isJsonArray()) {
                    JsonToRecordMapper.generateRecordForObjAndArray(entry.getValue(), entry.getKey(), isClosed, recordToTypeDescNodes, recordName, jsonNodes, existingFieldNames, updatedFieldNames, diagnosticMessages, false, isNullAsOptional);
                }
                jsonNodes.put(entry.getKey(), entry.getValue());
            }
            JsonToRecordMapper.prepareAndUpdateRecordFields(jsonObject, recordName, jsonNodes, recordToTypeDescNodes, diagnosticMessages, recordFields, existingFieldNames, updatedFieldNames, false, isNullAsOptional);
        } else {
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                if (entry.getValue().isJsonObject() || entry.getValue().isJsonArray()) {
                    JsonToRecordMapper.generateRecordForObjAndArray(entry.getValue(), entry.getKey(), isClosed, recordToTypeDescNodes, null, jsonNodes, existingFieldNames, updatedFieldNames, diagnosticMessages, false, isNullAsOptional);
                }
                jsonNodes.put(entry.getKey(), entry.getValue());
                Node recordField = JsonToRecordMapper.getRecordField(entry, existingFieldNames, updatedFieldNames, false);
                recordFields.add(recordField);
            }
            if (recordToTypeDescNodes.containsKey(recordName)) {
                recordFields.clear();
                JsonToRecordMapper.prepareAndUpdateRecordFields(jsonObject, recordName, jsonNodes, recordToTypeDescNodes, diagnosticMessages, recordFields, existingFieldNames, updatedFieldNames, true, isNullAsOptional);
            }
        }
        NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFields);
        Token bodyEndDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN);
        RecordRestDescriptorNode restDescriptorNode = isClosed ? null : NodeFactory.createRecordRestDescriptorNode((Node)NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)SyntaxKind.JSON_KEYWORD, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)recordKeyWord, (Token)bodyStartDelimiter, (NodeList)fieldNodes, restDescriptorNode, (Token)bodyEndDelimiter);
        if (moveBefore == null || moveBefore.equals(recordName)) {
            recordToTypeDescNodes.put(recordName, (NonTerminalNode)recordTypeDescriptorNode);
        } else {
            ArrayList<Map.Entry<String, NonTerminalNode>> typeDescNodes = new ArrayList<Map.Entry<String, NonTerminalNode>>(recordToTypeDescNodes.entrySet());
            List<String> recordNames = typeDescNodes.stream().map(Map.Entry::getKey).toList();
            typeDescNodes.add(recordNames.indexOf(moveBefore), Map.entry(recordName, recordTypeDescriptorNode));
            recordToTypeDescNodes.clear();
            typeDescNodes.forEach(node -> recordToTypeDescNodes.put((String)node.getKey(), (NonTerminalNode)node.getValue()));
        }
    }

    private static void generateRecordForObjAndArray(JsonElement jsonElement, String elementKey, boolean isClosed, Map<String, NonTerminalNode> recordToTypeDescNodes, String moveBefore, Map<String, JsonElement> jsonNodes, List<String> existingFieldNames, Map<String, String> updatedFieldNames, List<DiagnosticMessage> diagnosticMessages, boolean arraySuffixAdded, boolean isNullAsOptional) {
        if (jsonElement.isJsonObject()) {
            String type = ConverterUtils.escapeIdentifier(StringUtils.capitalize(elementKey));
            String updatedType = ConverterUtils.getAndUpdateFieldNames(type, arraySuffixAdded, existingFieldNames, updatedFieldNames);
            JsonToRecordMapper.generateRecords(jsonElement.getAsJsonObject(), updatedType, isClosed, recordToTypeDescNodes, moveBefore, jsonNodes, existingFieldNames, updatedFieldNames, diagnosticMessages, isNullAsOptional);
        } else if (jsonElement.isJsonArray()) {
            for (JsonElement element : jsonElement.getAsJsonArray()) {
                String arrayElementKey = elementKey + (arraySuffixAdded ? "" : ARRAY_RECORD_SUFFIX);
                JsonToRecordMapper.generateRecordForObjAndArray(element, arrayElementKey, isClosed, recordToTypeDescNodes, moveBefore, jsonNodes, existingFieldNames, updatedFieldNames, diagnosticMessages, true, isNullAsOptional);
            }
        }
    }

    private static void prepareAndUpdateRecordFields(JsonObject jsonObject, String recordName, Map<String, JsonElement> jsonNodes, Map<String, NonTerminalNode> recordToTypeDescNodes, List<DiagnosticMessage> diagnosticMessages, List<Node> recordFields, List<String> existingFieldNames, Map<String, String> updatedFieldNames, boolean prepareForNestedSameField, boolean isNullAsOptional) {
        RecordTypeDescriptorNode previousRecordTypeDescriptorNode = (RecordTypeDescriptorNode)recordToTypeDescNodes.get(recordName);
        List<RecordFieldNode> previousRecordFields = previousRecordTypeDescriptorNode.fields().stream().map(node -> (RecordFieldNode)node).toList();
        Map previousRecordFieldToNodes = previousRecordFields.stream().collect(Collectors.toMap(node -> node.fieldName().text(), Function.identity(), (val1, val2) -> val1, LinkedHashMap::new));
        Map newRecordFieldToNodes = jsonObject.entrySet().stream().map(entry -> (RecordFieldNode)JsonToRecordMapper.getRecordField(entry, existingFieldNames, updatedFieldNames, false)).toList().stream().collect(Collectors.toMap(node -> node.fieldName().text(), Function.identity(), (val1, val2) -> val1, LinkedHashMap::new));
        if (prepareForNestedSameField) {
            JsonToRecordMapper.updateRecordFields(jsonObject, jsonNodes, diagnosticMessages, recordFields, existingFieldNames, updatedFieldNames, newRecordFieldToNodes, previousRecordFieldToNodes, isNullAsOptional);
        } else {
            JsonToRecordMapper.updateRecordFields(jsonObject, jsonNodes, diagnosticMessages, recordFields, existingFieldNames, updatedFieldNames, previousRecordFieldToNodes, newRecordFieldToNodes, isNullAsOptional);
        }
    }

    private static void updateRecordFields(JsonObject jsonObject, Map<String, JsonElement> jsonNodes, List<DiagnosticMessage> diagnosticMessages, List<Node> recordFields, List<String> existingFieldNames, Map<String, String> updatedFieldNames, Map<String, RecordFieldNode> previousRecordFieldToNodes, Map<String, RecordFieldNode> newRecordFieldToNodes, boolean isNullAsOptional) {
        Map<String, String> jsonEscapedFieldToFields;
        Map<String, Map.Entry<RecordFieldNode, RecordFieldNode>> intersectingRecordFields = ListOperationUtils.intersection(previousRecordFieldToNodes, newRecordFieldToNodes);
        Map<String, RecordFieldNode> differencingRecordFields = ListOperationUtils.difference(previousRecordFieldToNodes, newRecordFieldToNodes);
        for (Map.Entry<String, Map.Entry<RecordFieldNode, RecordFieldNode>> entry : intersectingRecordFields.entrySet()) {
            boolean isOptional = entry.getValue().getKey().questionMarkToken().isPresent();
            jsonEscapedFieldToFields = jsonNodes.entrySet().stream().collect(Collectors.toMap(jsonEntry -> ConverterUtils.escapeIdentifier((String)jsonEntry.getKey()), Map.Entry::getKey));
            AbstractMap.SimpleEntry<String, JsonElement> jsonEntry2 = new AbstractMap.SimpleEntry<String, JsonElement>(jsonEscapedFieldToFields.get(entry.getKey()), jsonNodes.get(jsonEscapedFieldToFields.get(entry.getKey())));
            if (!entry.getValue().getKey().typeName().toSourceCode().equals(entry.getValue().getValue().typeName().toSourceCode())) {
                TypeDescriptorNode node1 = (TypeDescriptorNode)entry.getValue().getKey().typeName();
                TypeDescriptorNode node2 = (TypeDescriptorNode)entry.getValue().getValue().typeName();
                TypeDescriptorNode nonJsonDataNode = null;
                IdentifierToken optionalFieldName = null;
                boolean alreadyOptionalTypeDesc = false;
                if (node1.kind().equals((Object)SyntaxKind.OPTIONAL_TYPE_DESC)) {
                    optionalTypeDescNode = (OptionalTypeDescriptorNode)node1;
                    node1 = (TypeDescriptorNode)optionalTypeDescNode.typeDescriptor();
                    alreadyOptionalTypeDesc = true;
                } else if (node2.kind().equals((Object)SyntaxKind.OPTIONAL_TYPE_DESC)) {
                    optionalTypeDescNode = (OptionalTypeDescriptorNode)node2;
                    node2 = (TypeDescriptorNode)optionalTypeDescNode.typeDescriptor();
                    alreadyOptionalTypeDesc = true;
                } else if (node1.kind().equals((Object)SyntaxKind.JSON_KEYWORD) || node2.kind().equals((Object)SyntaxKind.JSON_KEYWORD)) {
                    if (isNullAsOptional) {
                        nonJsonDataNode = NodeParser.parseTypeDescriptor((String)(node1.kind().equals((Object)SyntaxKind.JSON_KEYWORD) ? node2.toSourceCode() : node1.toSourceCode()));
                        optionalFieldName = AbstractNodeFactory.createIdentifierToken((String)(entry.getKey() + SyntaxKind.QUESTION_MARK_TOKEN.stringValue()));
                    } else {
                        nonJsonDataNode = NodeParser.parseTypeDescriptor((String)(node1.kind().equals((Object)SyntaxKind.JSON_KEYWORD) ? node2.toSourceCode() + SyntaxKind.QUESTION_MARK_TOKEN.stringValue() : node1.toSourceCode() + SyntaxKind.QUESTION_MARK_TOKEN.stringValue()));
                    }
                }
                List<TypeDescriptorNode> typeDescNodesSorted = ConverterUtils.sortTypeDescriptorNodes(ConverterUtils.extractTypeDescriptorNodes(List.of(node1, node2)));
                TypeDescriptorNode unionTypeDescNode = JsonToRecordMapper.createUnionTypeDescriptorNode(typeDescNodesSorted, alreadyOptionalTypeDesc);
                RecordFieldNode recordField = (RecordFieldNode)JsonToRecordMapper.getRecordField(jsonEntry2, existingFieldNames, updatedFieldNames, isOptional);
                recordField = recordField.modify().withTypeName((Node)(nonJsonDataNode == null ? unionTypeDescNode : nonJsonDataNode)).withFieldName((Token)(optionalFieldName == null ? recordField.fieldName() : optionalFieldName)).apply();
                recordFields.add((Node)recordField);
                continue;
            }
            Node recordField = JsonToRecordMapper.getRecordField(jsonEntry2, existingFieldNames, updatedFieldNames, isOptional);
            recordFields.add(recordField);
        }
        for (Map.Entry<String, Map.Entry<RecordFieldNode, RecordFieldNode>> entry : differencingRecordFields.entrySet()) {
            AbstractMap.SimpleEntry<String, JsonElement> jsonEntry3;
            String jsonField = entry.getKey();
            jsonEscapedFieldToFields = jsonNodes.entrySet().stream().collect(Collectors.toMap(jsonEntry -> ConverterUtils.escapeIdentifier((String)jsonEntry.getKey()), Map.Entry::getKey));
            JsonElement jsonElement = jsonNodes.get(jsonEscapedFieldToFields.get(jsonField));
            Map.Entry<String, JsonElement> entry2 = jsonEntry3 = jsonElement != null ? new AbstractMap.SimpleEntry<String, JsonElement>(jsonEscapedFieldToFields.get(jsonField), jsonElement) : (Map.Entry)jsonObject.entrySet().stream().filter(elementEntry -> ConverterUtils.escapeIdentifier((String)elementEntry.getKey()).equals(jsonField)).findFirst().orElse(null);
            if (jsonEntry3 != null) {
                Node recordField = JsonToRecordMapper.getRecordField(jsonEntry3, existingFieldNames, updatedFieldNames, true);
                recordFields.add(recordField);
                continue;
            }
            DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter103(new String[]{jsonField});
            diagnosticMessages.add(message);
        }
    }

    private static Node getRecordField(Map.Entry<String, JsonElement> entry, List<String> existingFieldNames, Map<String, String> updatedFieldNames, boolean isOptionalField) {
        Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
        Token questionMarkToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        BuiltinSimpleNameReferenceNode fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier(entry.getKey().trim()));
        Token optionalFieldToken = isOptionalField ? questionMarkToken : null;
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        if (entry.getValue().isJsonPrimitive()) {
            typeName = ConverterUtils.getPrimitiveTypeName(entry.getValue().getAsJsonPrimitive());
            fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
            recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        } else if (entry.getValue().isJsonObject()) {
            String elementKey = entry.getKey().trim();
            String type = ConverterUtils.escapeIdentifier(StringUtils.capitalize(elementKey));
            String updatedType = ConverterUtils.getAndUpdateFieldNames(type, false, existingFieldNames, updatedFieldNames);
            typeName = AbstractNodeFactory.createIdentifierToken((String)updatedType);
            fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
            recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        } else if (entry.getValue().isJsonArray()) {
            Map.Entry<String, JsonArray> jsonArrayEntry = Map.entry(entry.getKey(), entry.getValue().getAsJsonArray());
            ArrayTypeDescriptorNode arrayTypeName = JsonToRecordMapper.getArrayTypeDescriptorNode(jsonArrayEntry, existingFieldNames, updatedFieldNames);
            recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)arrayTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        }
        return recordFieldNode;
    }

    private static Optional<TypeDefinitionNode> convertToInlineRecord(List<TypeDefinitionNode> typeDefNodes, List<DiagnosticMessage> diagnosticMessages) {
        LinkedHashMap<String, RecordTypeDescriptorNode> visitedRecordTypeDescNodeTypeToNodes = new LinkedHashMap<String, RecordTypeDescriptorNode>();
        for (TypeDefinitionNode typeDefNode : typeDefNodes) {
            RecordTypeDescriptorNode recordTypeDescNode = (RecordTypeDescriptorNode)typeDefNode.typeDescriptor();
            List<RecordFieldNode> recordFieldNodes = recordTypeDescNode.fields().stream().map(node -> (RecordFieldNode)node).toList();
            ArrayList<RecordFieldNode> intermediateRecordFieldNodes = new ArrayList<RecordFieldNode>();
            for (RecordFieldNode recordFieldNode : recordFieldNodes) {
                TypeDescriptorNode fieldTypeName = (TypeDescriptorNode)recordFieldNode.typeName();
                TypeDescriptorNode converted = JsonToRecordMapper.convertUnionTypeToInline(fieldTypeName, visitedRecordTypeDescNodeTypeToNodes);
                if (converted == null) {
                    DiagnosticMessage message = DiagnosticMessage.jsonToRecordConverter107(recordFieldNode.fieldName().text());
                    diagnosticMessages.add(message);
                    return Optional.empty();
                }
                Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
                RecordFieldNode updatedRecordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)converted, (Token)recordFieldNode.fieldName(), (Token)recordFieldNode.questionMarkToken().orElse(null), (Token)semicolonToken);
                intermediateRecordFieldNodes.add(updatedRecordFieldNode);
            }
            NodeList updatedRecordFieldNodes = AbstractNodeFactory.createNodeList(intermediateRecordFieldNodes);
            RecordTypeDescriptorNode updatedRecordTypeDescNode = recordTypeDescNode.modify().withFields(updatedRecordFieldNodes).apply();
            visitedRecordTypeDescNodeTypeToNodes.put(typeDefNode.typeName().toSourceCode(), updatedRecordTypeDescNode);
        }
        ArrayList visitedRecordTypeDescNodes = new ArrayList(visitedRecordTypeDescNodeTypeToNodes.entrySet());
        Map.Entry lastRecordTypeDescNode = (Map.Entry)visitedRecordTypeDescNodes.get(visitedRecordTypeDescNodes.size() - 1);
        Token typeKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD);
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier((String)lastRecordTypeDescNode.getKey()));
        Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return Optional.of(NodeFactory.createTypeDefinitionNode(null, null, (Token)typeKeyWord, (Token)typeName, (Node)((Node)lastRecordTypeDescNode.getValue()), (Token)semicolon));
    }

    private static ArrayTypeDescriptorNode getArrayTypeDescriptorNode(Map.Entry<String, JsonArray> entry, List<String> existingFieldNames, Map<String, String> updatedFieldNames) {
        Token openSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN);
        Token closeSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN);
        Iterator<JsonElement> iterator = entry.getValue().iterator();
        ArrayList<TypeDescriptorNode> typeDescriptorNodes = new ArrayList<TypeDescriptorNode>();
        while (iterator.hasNext()) {
            BuiltinSimpleNameReferenceNode tempTypeNode;
            Token tempTypeName;
            JsonElement element = iterator.next();
            if (element.isJsonPrimitive()) {
                tempTypeName = ConverterUtils.getPrimitiveTypeName(element.getAsJsonPrimitive());
                tempTypeNode = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)tempTypeName.kind(), (Token)tempTypeName);
                if (typeDescriptorNodes.stream().map(Node::toSourceCode).toList().contains(tempTypeNode.toSourceCode())) continue;
                typeDescriptorNodes.add((TypeDescriptorNode)tempTypeNode);
                continue;
            }
            if (element.isJsonNull()) {
                tempTypeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
                tempTypeNode = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)tempTypeName.kind(), (Token)tempTypeName);
                if (typeDescriptorNodes.stream().map(Node::toSourceCode).toList().contains(tempTypeNode.toSourceCode())) continue;
                typeDescriptorNodes.add((TypeDescriptorNode)tempTypeNode);
                continue;
            }
            if (element.isJsonObject()) {
                String elementKey = entry.getKey();
                String type = ConverterUtils.escapeIdentifier(StringUtils.capitalize(elementKey) + ARRAY_RECORD_SUFFIX);
                String updatedType = ConverterUtils.getAndUpdateFieldNames(type, true, existingFieldNames, updatedFieldNames);
                IdentifierToken tempTypeName2 = AbstractNodeFactory.createIdentifierToken((String)updatedType);
                BuiltinSimpleNameReferenceNode tempTypeNode2 = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)tempTypeName2.kind(), (Token)tempTypeName2);
                if (typeDescriptorNodes.stream().map(Node::toSourceCode).toList().contains(tempTypeNode2.toSourceCode())) continue;
                typeDescriptorNodes.add((TypeDescriptorNode)tempTypeNode2);
                continue;
            }
            if (!element.isJsonArray()) continue;
            AbstractMap.SimpleEntry<String, JsonArray> arrayEntry = new AbstractMap.SimpleEntry<String, JsonArray>(entry.getKey(), element.getAsJsonArray());
            tempTypeNode = JsonToRecordMapper.getArrayTypeDescriptorNode(arrayEntry, existingFieldNames, updatedFieldNames);
            if (typeDescriptorNodes.stream().map(Node::toSourceCode).toList().contains(tempTypeNode.toSourceCode())) continue;
            typeDescriptorNodes.add((TypeDescriptorNode)tempTypeNode);
        }
        List<TypeDescriptorNode> typeDescriptorNodesSorted = ConverterUtils.sortTypeDescriptorNodes(typeDescriptorNodes);
        TypeDescriptorNode fieldTypeName = JsonToRecordMapper.createUnionTypeDescriptorNode(typeDescriptorNodesSorted, false);
        NodeList arrayDimensions = NodeFactory.createEmptyNodeList();
        ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)openSBracketToken, null, (Token)closeSBracketToken);
        arrayDimensions = arrayDimensions.add((Node)arrayDimension);
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)fieldTypeName, (NodeList)arrayDimensions);
    }

    private static TypeDescriptorNode createUnionTypeDescriptorNode(List<TypeDescriptorNode> typeNames, boolean isOptional) {
        if (typeNames.isEmpty()) {
            Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
            return NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
        }
        if (typeNames.size() == 1) {
            return typeNames.get(0);
        }
        TypeDescriptorNode unionTypeDescNode = JsonToRecordMapper.joinToUnionTypeDescriptorNode(typeNames);
        Token openParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        Token closeParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        Token questionMarkToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        ParenthesisedTypeDescriptorNode parenTypeDescNode = NodeFactory.createParenthesisedTypeDescriptorNode((Token)openParenToken, (TypeDescriptorNode)unionTypeDescNode, (Token)closeParenToken);
        return isOptional ? NodeFactory.createOptionalTypeDescriptorNode((Node)parenTypeDescNode, (Token)questionMarkToken) : parenTypeDescNode;
    }

    private static TypeDescriptorNode joinToUnionTypeDescriptorNode(List<TypeDescriptorNode> typeNames) {
        Token pipeToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN);
        TypeDescriptorNode unionTypeDescNode = typeNames.get(0);
        for (int i = 1; i < typeNames.size(); ++i) {
            unionTypeDescNode = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)unionTypeDescNode, (Token)pipeToken, (TypeDescriptorNode)typeNames.get(i));
        }
        return unionTypeDescNode;
    }

    private static TypeDescriptorNode convertUnionTypeToInline(TypeDescriptorNode typeDescNode, Map<String, RecordTypeDescriptorNode> visitedRecordTypeDescNodeTypeToNodes) {
        List<TypeDescriptorNode> extractedTypeDescNodes = ConverterUtils.extractUnionTypeDescNode(ConverterUtils.extractArrayTypeDescNode(typeDescNode));
        ArrayList<TypeDescriptorNode> updatedTypeDescNodes = new ArrayList<TypeDescriptorNode>();
        if (extractedTypeDescNodes.size() == 1) {
            Object arrayExtractedNode = ConverterUtils.extractArrayTypeDescNode(typeDescNode);
            String fieldTypeNameText = arrayExtractedNode.toSourceCode();
            SyntaxKind fieldKind = arrayExtractedNode.kind();
            if (ConverterUtils.extractArrayTypeDescNode(typeDescNode).kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE)) {
                SimpleNameReferenceNode fieldNameRefNode = (SimpleNameReferenceNode)ConverterUtils.extractArrayTypeDescNode(typeDescNode);
                fieldTypeNameText = fieldNameRefNode.name().toSourceCode();
                fieldKind = fieldNameRefNode.name().kind();
            }
            if (fieldKind.equals((Object)SyntaxKind.IDENTIFIER_TOKEN) && (arrayExtractedNode = (TypeDescriptorNode)visitedRecordTypeDescNodeTypeToNodes.get(fieldTypeNameText)) == null) {
                return null;
            }
            updatedTypeDescNodes.add((TypeDescriptorNode)arrayExtractedNode);
        } else {
            for (TypeDescriptorNode extractedTypeDescNode : extractedTypeDescNodes) {
                TypeDescriptorNode updatedTypeDescNode = JsonToRecordMapper.convertUnionTypeToInline(extractedTypeDescNode, visitedRecordTypeDescNodeTypeToNodes);
                updatedTypeDescNodes.add(updatedTypeDescNode);
            }
        }
        List<TypeDescriptorNode> typeDescNodesSorted = ConverterUtils.sortTypeDescriptorNodes(updatedTypeDescNodes);
        TypeDescriptorNode unionTypeDescNode = JsonToRecordMapper.createUnionTypeDescriptorNode(typeDescNodesSorted, false);
        if (typeDescNode.kind().equals((Object)SyntaxKind.ARRAY_TYPE_DESC)) {
            Token openSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN);
            Token closeSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN);
            NodeList arrayDimensions = NodeFactory.createEmptyNodeList();
            ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)openSBracketToken, null, (Token)closeSBracketToken);
            int numberOfDimensions = ConverterUtils.getNumberOfDimensions((ArrayTypeDescriptorNode)typeDescNode);
            for (int i = 0; i < numberOfDimensions; ++i) {
                arrayDimensions = arrayDimensions.add((Node)arrayDimension);
            }
            unionTypeDescNode = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)unionTypeDescNode, (NodeList)arrayDimensions);
        }
        return unionTypeDescNode;
    }
}

