/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.jsonmapper.util;

import java.util.LinkedHashMap;
import java.util.Map;

public final class ListOperationUtils {
    private ListOperationUtils() {
    }

    public static <K, V> Map<K, Map.Entry<V, V>> intersection(Map<K, V> mapOne, Map<K, V> mapTwo) {
        LinkedHashMap<K, Map.Entry<V, V>> intersection = new LinkedHashMap<K, Map.Entry<V, V>>();
        for (Map.Entry<K, V> entry : mapOne.entrySet()) {
            if (!mapTwo.containsKey(entry.getKey())) continue;
            intersection.put(entry.getKey(), Map.entry(entry.getValue(), mapTwo.get(entry.getKey())));
        }
        return intersection;
    }

    public static <K, V> Map<K, V> union(Map<K, V> mapOne, Map<K, V> mapTwo) {
        LinkedHashMap<K, V> union = new LinkedHashMap<K, V>(mapOne);
        for (Map.Entry<K, V> entry : mapTwo.entrySet()) {
            if (mapOne.containsKey(entry.getKey())) continue;
            union.put(entry.getKey(), entry.getValue());
        }
        return union;
    }

    public static <K, V> Map<K, V> difference(Map<K, V> mapOne, Map<K, V> mapTwo) {
        Map<K, V> unionMap = ListOperationUtils.union(mapOne, mapTwo);
        Map<K, Map.Entry<V, V>> intersectionMap = ListOperationUtils.intersection(mapOne, mapTwo);
        for (K key : intersectionMap.keySet()) {
            unionMap.remove(key);
        }
        return unionMap;
    }
}

