/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.toml.common.completion;

import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.ValueNode;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.commons.toml.TomlCompletionContext;
import org.ballerinalang.langserver.commons.toml.common.TomlCommonUtil;
import org.ballerinalang.langserver.commons.toml.common.TomlSyntaxTreeUtil;
import org.ballerinalang.langserver.commons.toml.visitor.TomlNode;
import org.ballerinalang.langserver.commons.toml.visitor.TomlNodeType;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class TomlCompletionUtil {
    private TomlCompletionUtil() {
    }

    public static void fillNodeAtCursor(TomlCompletionContext context) {
        Optional<SyntaxTree> st = context.getTomlSyntaxTree();
        if (st.isEmpty()) {
            return;
        }
        Position position = context.getCursorPosition();
        TextDocument textDocument = st.get().textDocument();
        int txtPos = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        context.setCursorPositionInTree(txtPos);
        TextRange range = TextRange.from((int)txtPos, (int)0);
        NonTerminalNode nonTerminalNode = ((DocumentNode)st.get().rootNode()).findNode(range);
        while (nonTerminalNode.parent() != null && !TomlSyntaxTreeUtil.withinTextRange(txtPos, nonTerminalNode)) {
            nonTerminalNode = nonTerminalNode.parent();
        }
        context.setNodeAtCursor(nonTerminalNode);
    }

    public static Map<String, CompletionItem> getFilteredCompletions(Either<TableNode, TableArrayNode> topLevelNode, Map<TomlNode, Map<String, CompletionItem>> snippets) {
        DocumentNode documentNode;
        NodeList fields;
        String tableKey;
        if (topLevelNode.isLeft()) {
            tableKey = TomlSyntaxTreeUtil.toQualifiedName((SeparatedNodeList<ValueNode>)((TableNode)topLevelNode.getLeft()).identifier().value());
            fields = ((TableNode)topLevelNode.getLeft()).fields();
            documentNode = (DocumentNode)((TableNode)topLevelNode.getLeft()).parent();
        } else {
            tableKey = TomlSyntaxTreeUtil.toQualifiedName((SeparatedNodeList<ValueNode>)((TableArrayNode)topLevelNode.getRight()).identifier().value());
            fields = ((TableArrayNode)topLevelNode.getRight()).fields();
            documentNode = (DocumentNode)((TableArrayNode)topLevelNode.getRight()).parent();
        }
        HashMap<String, CompletionItem> completions = new HashMap<String, CompletionItem>(TomlCompletionUtil.findCompletionItemsFromQualifiedKey(snippets, tableKey));
        for (KeyValueNode field : fields) {
            String key = TomlSyntaxTreeUtil.toQualifiedName((SeparatedNodeList<ValueNode>)field.identifier().value());
            completions.remove(key);
        }
        TomlCompletionUtil.addTopLevelNodeCompletions(snippets.keySet(), completions);
        return TomlCompletionUtil.removeExistingTableKeys(completions, documentNode);
    }

    public static Map<String, CompletionItem> addTopLevelNodeCompletions(Set<TomlNode> topLevelNodes, Map<String, CompletionItem> completions) {
        for (TomlNode topLevelNode : topLevelNodes) {
            String key = topLevelNode.getKey();
            if (completions.containsKey(key) || topLevelNode.type() != TomlNodeType.TABLE && topLevelNode.type() != TomlNodeType.TABLE_ARRAY) continue;
            completions.put(key, TomlCompletionUtil.createTopLevelCompletionItem(topLevelNode));
        }
        return completions;
    }

    public static Map<String, CompletionItem> removeExistingTableKeys(Map<String, CompletionItem> completions, DocumentNode documentNode) {
        List<String> existingKeys = completions.keySet().stream().filter(key -> documentNode.members().stream().filter(node -> node.kind() == SyntaxKind.TABLE).map(node -> TomlSyntaxTreeUtil.toQualifiedName((SeparatedNodeList<ValueNode>)((TableNode)node).identifier().value())).collect(Collectors.toSet()).contains(key)).toList();
        for (String key2 : existingKeys) {
            completions.remove(key2);
        }
        return completions;
    }

    public static CompletionItem createTopLevelCompletionItem(TomlNode node) {
        CompletionItem item = new CompletionItem();
        item.setInsertText(node.getTomlSyntax());
        if (node.type() == TomlNodeType.TABLE) {
            item.setDetail("Table");
        } else if (node.type() == TomlNodeType.TABLE_ARRAY) {
            item.setDetail("Table Array");
        } else {
            item.setDetail("Top Level Node");
        }
        item.setLabel(node.getKey());
        item.setKind(CompletionItemKind.Snippet);
        item.setSortText(TomlCommonUtil.genSortText(3));
        return item;
    }

    public static Map<String, CompletionItem> findCompletionItemsFromQualifiedKey(Map<TomlNode, Map<String, CompletionItem>> snippets, String topLevelNodeKey) {
        List<Map.Entry> filteredMap = snippets.entrySet().stream().filter(entry -> topLevelNodeKey.equals(((TomlNode)entry.getKey()).getKey())).toList();
        if (filteredMap.size() == 1) {
            return (Map)filteredMap.get(0).getValue();
        }
        return Collections.emptyMap();
    }
}

