/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.toml.visitor;

import org.ballerinalang.langserver.commons.toml.common.TomlSyntaxTreeUtil;
import org.ballerinalang.langserver.commons.toml.visitor.TomlNode;
import org.ballerinalang.langserver.commons.toml.visitor.TomlNodeType;
import org.ballerinalang.langserver.commons.toml.visitor.ValueType;

public class KeyValuePair
implements TomlNode {
    private final String key;
    private final String defaultValue;
    private final int id;
    private final ValueType type;

    public KeyValuePair(String key, String defaultValue, int id, ValueType type) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.id = id;
        this.type = type;
    }

    public KeyValuePair(String key, ValueType type) {
        this.key = key;
        this.type = type;
        this.id = 1;
        this.defaultValue = TomlSyntaxTreeUtil.getDefaultValueForType(type);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public TomlNodeType type() {
        return TomlNodeType.KEY_VALUE;
    }

    @Override
    public String getTomlSyntax() {
        return this.key + "=" + this.type.getStartingSeparator() + "${" + this.id + ":" + this.defaultValue + "}" + this.type.getEndingSeparator();
    }
}

