/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.commons.workspace;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public record RunContext(Path balSourcePath, List<String> programArgs, Map<String, String> env, Integer debugPort) {

    public static class Builder {
        private final Path sourcePath;
        private List<String> programArgs = new ArrayList<String>();
        private Map<String, String> env = Map.of();
        private int debugPort = -1;

        public Builder(Path sourcePath) {
            this.sourcePath = sourcePath;
        }

        public Builder withProgramArgs(List<String> programArgs) {
            this.programArgs = programArgs;
            return this;
        }

        public Builder withEnv(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public Builder withDebugPort(int debugPort) {
            this.debugPort = debugPort;
            return this;
        }

        public RunContext build() {
            return new RunContext(this.sourcePath, this.programArgs, this.env, this.debugPort);
        }
    }
}

