/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.modelgenerator.commons.ParameterMemberTypeData;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;

public class DatabaseManager {
    private static final String INDEX_FILE_NAME = "central-index.sqlite";
    private static final Logger LOGGER = Logger.getLogger(DatabaseManager.class.getName());
    private final String dbPath;

    public static DatabaseManager getInstance() {
        return Holder.INSTANCE;
    }

    private DatabaseManager() {
        Path tempDir;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load SQLite JDBC driver", e);
        }
        try {
            tempDir = Files.createTempDirectory("central-index", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a temporary directory", e);
        }
        URL dbUrl = this.getClass().getClassLoader().getResource(INDEX_FILE_NAME);
        if (dbUrl == null) {
            throw new RuntimeException("Database resource not found: central-index.sqlite");
        }
        Path tempFile = tempDir.resolve(INDEX_FILE_NAME);
        try {
            Files.copy(dbUrl.openStream(), tempFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy the database file to the temporary directory", e);
        }
        this.dbPath = "jdbc:sqlite:" + tempFile.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public List<FunctionData> getAllFunctions(FunctionData.Kind kind, Map<String, String> queryMap) {
        String sql = "SELECT f.function_id, f.name AS function_name, f.description AS function_description, f.return_type, f.resource_path, f.kind, f.return_error, f.inferred_return_type, f.import_statements, p.name AS package_name, p.org, p.version FROM Function f JOIN Package p ON f.package_id = p.package_id WHERE f.kind = ? LIMIT ? OFFSET ?;";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<FunctionData> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, kind.name());
                    stmt.setString(2, queryMap.get("limit"));
                    stmt.setString(3, queryMap.get("offset"));
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<FunctionData> functionDataList = new ArrayList<FunctionData>();
                    while (rs.next()) {
                        FunctionData functionData = new FunctionData(rs.getInt("function_id"), rs.getString("function_name"), rs.getString("function_description"), rs.getString("return_type"), rs.getString("package_name"), rs.getString("org"), rs.getString("version"), rs.getString("resource_path"), FunctionData.Kind.valueOf(rs.getString("kind")), rs.getBoolean("return_error"), rs.getBoolean("inferred_return_type"), rs.getString("import_statements"));
                        functionDataList.add(functionData);
                    }
                    arrayList = functionDataList;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public List<FunctionData> getFunctionsByOrg(String orgName, FunctionData.Kind functionKind) {
        String sql = "SELECT f.function_id, f.name AS function_name, f.description AS function_description, f.return_type, f.kind, f.return_error, f.inferred_return_type, f.import_statements, f.resource_path, p.name AS package_name, p.org, p.version FROM Function f JOIN Package p ON f.package_id = p.package_id WHERE f.kind = ? AND p.org = ?;";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<FunctionData> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, functionKind.name());
                    stmt.setString(2, orgName);
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<FunctionData> functionDataList = new ArrayList<FunctionData>();
                    while (rs.next()) {
                        FunctionData functionData = new FunctionData(rs.getInt("function_id"), rs.getString("function_name"), rs.getString("function_description"), rs.getString("return_type"), rs.getString("package_name"), rs.getString("org"), rs.getString("version"), rs.getString("resource_path"), FunctionData.Kind.valueOf(rs.getString("kind")), rs.getBoolean("return_error"), rs.getBoolean("inferred_return_type"), rs.getString("import_statements"));
                        functionDataList.add(functionData);
                    }
                    arrayList = functionDataList;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public List<FunctionData> searchFunctions(Map<String, String> queryMap, FunctionData.Kind kind) {
        String sql = "SELECT f.function_id, f.name AS function_name, f.description AS function_description, f.return_type, f.resource_path, f.kind, f.return_error, f.inferred_return_type, f.import_statements, p.name AS package_name, p.org, p.version FROM Function f JOIN Package p ON f.package_id = p.package_id WHERE f.kind = ? AND (f.name LIKE ? OR p.name LIKE ? )LIMIT ? OFFSET ?;";
        String wildcardKeyword = "%" + queryMap.get("q") + "%";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<FunctionData> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, kind.name());
                    stmt.setString(2, wildcardKeyword);
                    stmt.setString(3, wildcardKeyword);
                    stmt.setString(4, queryMap.get("limit"));
                    stmt.setString(5, queryMap.get("offset"));
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<FunctionData> functionDataList = new ArrayList<FunctionData>();
                    while (rs.next()) {
                        FunctionData functionData = new FunctionData(rs.getInt("function_id"), rs.getString("function_name"), rs.getString("function_description"), rs.getString("return_type"), rs.getString("package_name"), rs.getString("org"), rs.getString("version"), rs.getString("resource_path"), FunctionData.Kind.valueOf(rs.getString("kind")), rs.getBoolean("return_error"), rs.getBoolean("inferred_return_type"), rs.getString("import_statements"));
                        functionDataList.add(functionData);
                    }
                    arrayList = functionDataList;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<FunctionData> getFunction(String org, String module, String symbol, FunctionData.Kind kind, String resourcePath) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append("f.function_id, ");
        sql.append("f.name AS function_name, ");
        sql.append("f.description AS function_description, ");
        sql.append("f.return_type, ");
        sql.append("f.resource_path, ");
        sql.append("f.kind, ");
        sql.append("f.return_error, ");
        sql.append("f.inferred_return_type, ");
        sql.append("f.import_statements, ");
        sql.append("p.name AS package_name, ");
        sql.append("p.org, ");
        sql.append("p.version ");
        sql.append("FROM Function f ");
        sql.append("JOIN Package p ON f.package_id = p.package_id ");
        sql.append("WHERE p.org = ? ");
        sql.append("AND p.name = ? ");
        sql.append("AND f.kind = ? ");
        sql.append("AND f.name = ? ");
        if (resourcePath != null) {
            sql.append("AND f.resource_path = ?");
        }
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            Optional<FunctionData> optional;
            block20: {
                PreparedStatement stmt;
                block18: {
                    Optional<FunctionData> optional2;
                    block19: {
                        stmt = conn.prepareStatement(sql.toString());
                        try {
                            ResultSet rs;
                            stmt.setString(1, org);
                            stmt.setString(2, module);
                            stmt.setString(3, kind.name());
                            stmt.setString(4, symbol);
                            if (resourcePath != null) {
                                stmt.setString(5, resourcePath);
                            }
                            if (!(rs = stmt.executeQuery()).next()) break block18;
                            optional2 = Optional.of(new FunctionData(rs.getInt("function_id"), rs.getString("function_name"), rs.getString("function_description"), rs.getString("return_type"), rs.getString("package_name"), rs.getString("org"), rs.getString("version"), rs.getString("resource_path"), FunctionData.Kind.valueOf(rs.getString("kind")), rs.getBoolean("return_error"), rs.getBoolean("inferred_return_type"), rs.getString("import_statements")));
                            if (stmt == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (stmt == null) break block20;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public Optional<FunctionData> getFunction(int functionId) {
        String sql = "SELECT f.function_id, f.name AS function_name, f.description AS function_description, f.return_type, p.name AS package_name, p.org, p.version, f.resource_path, f.kind, f.return_error, f.inferred_return_type FROM Function f JOIN Package p ON f.package_id = p.package_id WHERE f.function_id = ?;";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            Optional<FunctionData> optional;
            block18: {
                PreparedStatement stmt;
                block16: {
                    Optional<FunctionData> optional2;
                    block17: {
                        stmt = conn.prepareStatement(sql);
                        try {
                            stmt.setInt(1, functionId);
                            ResultSet rs = stmt.executeQuery();
                            if (!rs.next()) break block16;
                            optional2 = Optional.of(new FunctionData(rs.getInt("function_id"), rs.getString("function_name"), rs.getString("function_description"), rs.getString("return_type"), rs.getString("package_name"), rs.getString("org"), rs.getString("version"), rs.getString("resource_path"), FunctionData.Kind.valueOf(rs.getString("kind")), rs.getBoolean("return_error"), rs.getBoolean("inferred_return_type"), rs.getString("import_statements")));
                            if (stmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (stmt == null) break block18;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public List<ParameterData> getFunctionParameters(int functionId) {
        String sql = "SELECT p.parameter_id, p.name, p.type, p.kind, p.optional, p.default_value, p.description, p.import_statements FROM Parameter p WHERE p.function_id = ?;";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<ParameterData> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, functionId);
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<ParameterData> parameterResults = new ArrayList<ParameterData>();
                    while (rs.next()) {
                        ParameterData parameterData = new ParameterData(rs.getInt("parameter_id"), rs.getString("name"), rs.getString("type"), ParameterData.Kind.valueOf(rs.getString("kind")), rs.getString("default_value"), rs.getString("description"), "", rs.getBoolean("optional"), rs.getString("import_statements"), new ArrayList<ParameterMemberTypeData>());
                        parameterResults.add(parameterData);
                    }
                    arrayList = parameterResults;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public LinkedHashMap<String, ParameterData> getFunctionParametersAsMap(int functionId) {
        String sql = "SELECT p.parameter_id, p.name, p.type, p.kind, p.optional, p.default_value, p.description, p.import_statements, pmt.type AS member_type, pmt.kind AS member_kind, pmt.package AS member_package FROM Parameter p LEFT JOIN ParameterMemberType pmt ON p.parameter_id = pmt.parameter_id WHERE p.function_id = ?;";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            LinkedHashMap<String, ParameterData> linkedHashMap;
            block17: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, functionId);
                    ResultSet rs = stmt.executeQuery();
                    LinkedHashMap<String, ParameterDataBuilder> builders = new LinkedHashMap<String, ParameterDataBuilder>();
                    while (rs.next()) {
                        String paramName = rs.getString("name");
                        int parameterId = rs.getInt("parameter_id");
                        String type = rs.getString("type");
                        ParameterData.Kind kind = ParameterData.Kind.valueOf(rs.getString("kind"));
                        String defaultValue = rs.getString("default_value");
                        String description = rs.getString("description");
                        boolean optional = rs.getBoolean("optional");
                        String importStatements = rs.getString("import_statements");
                        String memberType = rs.getString("member_type");
                        String memberKind = rs.getString("member_kind");
                        String memberPackage = rs.getString("member_package");
                        ParameterDataBuilder builder = (ParameterDataBuilder)builders.get(paramName);
                        if (builder == null) {
                            builder = new ParameterDataBuilder();
                            builder.parameterId = parameterId;
                            builder.name = paramName;
                            builder.type = type;
                            builder.kind = kind;
                            builder.defaultValue = defaultValue;
                            builder.description = description;
                            builder.optional = optional;
                            builder.importStatements = importStatements;
                            builders.put(paramName, builder);
                        }
                        if (memberType == null) continue;
                        ParameterMemberTypeData memberData = new ParameterMemberTypeData(memberType, memberKind, memberPackage);
                        builder.typeMembers.add(memberData);
                    }
                    LinkedHashMap<String, ParameterData> parameterResults = new LinkedHashMap<String, ParameterData>();
                    for (ParameterDataBuilder builder : builders.values()) {
                        parameterResults.put(builder.name, builder.build());
                    }
                    linkedHashMap = parameterResults;
                    if (stmt == null) break block17;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return linkedHashMap;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return new LinkedHashMap<String, ParameterData>();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public List<FunctionData> getConnectorActions(int connectorId) {
        String sql = "SELECT f.function_id, f.name AS function_name, f.description, f.kind, f.return_type, f.resource_path, f.return_error, f.inferred_return_type FROM Function f JOIN FunctionConnector fc ON f.function_id = fc.function_id WHERE fc.connector_id = ?;";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<FunctionData> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, connectorId);
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<FunctionData> functionDataList = new ArrayList<FunctionData>();
                    while (rs.next()) {
                        FunctionData functionData = new FunctionData(rs.getInt("function_id"), rs.getString("function_name"), rs.getString("description"), rs.getString("return_type"), null, null, null, rs.getString("resource_path"), FunctionData.Kind.valueOf(rs.getString("kind")), rs.getBoolean("return_error"), rs.getBoolean("inferred_return_type"), rs.getString("import_statements"));
                        functionDataList.add(functionData);
                    }
                    arrayList = functionDataList;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<FunctionData> getMethods(String connectorName, String org, String packageName) {
        String sql = "SELECT f.function_id, f.name AS function_name, f.description, f.kind, p.version, f.return_type, f.resource_path, f.return_error, f.inferred_return_type, f.import_statements FROM Function f JOIN FunctionConnector fc ON f.function_id = fc.function_id JOIN Function c ON fc.connector_id = c.function_id JOIN Package p ON c.package_id = p.package_id WHERE c.name = ? AND p.org = ? AND p.name = ? AND c.kind = 'CONNECTOR';";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<FunctionData> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, connectorName);
                    stmt.setString(2, org);
                    stmt.setString(3, packageName);
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<FunctionData> functionDataList = new ArrayList<FunctionData>();
                    while (rs.next()) {
                        FunctionData functionData = new FunctionData(rs.getInt("function_id"), rs.getString("function_name"), rs.getString("description"), rs.getString("return_type"), packageName, org, rs.getString("version"), rs.getString("resource_path"), FunctionData.Kind.valueOf(rs.getString("kind")), rs.getBoolean("return_error"), rs.getBoolean("inferred_return_type"), rs.getString("import_statements"));
                        functionDataList.add(functionData);
                    }
                    arrayList = functionDataList;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public List<FunctionData> searchFunctionsInPackages(List<String> packageNames, Map<String, String> queryMap, FunctionData.Kind kind) {
        if (packageNames == null || packageNames.isEmpty()) {
            return List.of();
        }
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append("f.function_id, ");
        sql.append("f.name AS function_name, ");
        sql.append("f.description AS function_description, ");
        sql.append("f.return_type, ");
        sql.append("f.resource_path, ");
        sql.append("f.kind, ");
        sql.append("f.return_error, ");
        sql.append("f.inferred_return_type, ");
        sql.append("f.import_statements, ");
        sql.append("p.name AS package_name, ");
        sql.append("p.org, ");
        sql.append("p.version ");
        sql.append("FROM Function f ");
        sql.append("JOIN Package p ON f.package_id = p.package_id ");
        sql.append("WHERE p.name IN (");
        for (int i = 0; i < packageNames.size(); ++i) {
            sql.append("?");
            if (i >= packageNames.size() - 1) continue;
            sql.append(", ");
        }
        sql.append(") AND f.kind = ? ");
        boolean hasQuery = queryMap.containsKey("q");
        if (hasQuery) {
            sql.append("AND (f.name LIKE ? OR p.name LIKE ?) ");
        }
        sql.append("LIMIT ? OFFSET ?");
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<FunctionData> arrayList;
            block20: {
                PreparedStatement stmt = conn.prepareStatement(sql.toString());
                try {
                    int paramIndex = 1;
                    for (String packageName : packageNames) {
                        stmt.setString(paramIndex++, packageName);
                    }
                    stmt.setString(paramIndex++, kind.name());
                    if (hasQuery) {
                        String wildcardKeyword = "%" + queryMap.get("q") + "%";
                        stmt.setString(paramIndex++, wildcardKeyword);
                        stmt.setString(paramIndex++, wildcardKeyword);
                    }
                    stmt.setInt(paramIndex++, queryMap.containsKey("limit") ? Integer.parseInt(queryMap.get("limit")) : 10);
                    stmt.setInt(paramIndex, queryMap.containsKey("offset") ? Integer.parseInt(queryMap.get("offset")) : 0);
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<FunctionData> functionDataList = new ArrayList<FunctionData>();
                    while (rs.next()) {
                        FunctionData functionData = new FunctionData(rs.getInt("function_id"), rs.getString("function_name"), rs.getString("function_description"), rs.getString("return_type"), rs.getString("package_name"), rs.getString("org"), rs.getString("version"), rs.getString("resource_path"), FunctionData.Kind.valueOf(rs.getString("kind")), rs.getBoolean("return_error"), rs.getBoolean("inferred_return_type"), rs.getString("import_statements"));
                        functionDataList.add(functionData);
                    }
                    arrayList = functionDataList;
                    if (stmt == null) break block20;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    private static class Holder {
        private static final DatabaseManager INSTANCE = new DatabaseManager();

        private Holder() {
        }
    }

    private static class ParameterDataBuilder {
        int parameterId;
        String name;
        String type;
        ParameterData.Kind kind;
        String defaultValue;
        String description;
        boolean optional;
        String importStatements;
        List<ParameterMemberTypeData> typeMembers = new ArrayList<ParameterMemberTypeData>();

        private ParameterDataBuilder() {
        }

        ParameterData build() {
            return new ParameterData(this.parameterId, this.name, this.type, this.kind, this.defaultValue, this.description, null, this.optional, this.importStatements, this.typeMembers);
        }
    }
}

