/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import io.ballerina.centralconnector.RemoteCentral;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.DatabaseManager;
import io.ballerina.modelgenerator.commons.DefaultValueGeneratorUtil;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.modelgenerator.commons.ParameterMemberTypeData;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.eclipse.lsp4j.MessageType;

public class FunctionDataBuilder {
    public static final String DISPLAY_ANNOTATION = "display";
    public static final String LABEL = "label";
    private SemanticModel semanticModel;
    private TypeSymbol errorTypeSymbol;
    private Package resolvedPackage;
    private FunctionSymbol functionSymbol;
    private FunctionData.Kind functionKind;
    private String functionName;
    private String description;
    private ModuleInfo moduleInfo;
    private ModuleInfo userModuleInfo;
    private String resourcePath;
    private ObjectTypeSymbol parentSymbol;
    private String parentSymbolType;
    private LSClientLogger lsClientLogger;
    private Project project;
    private boolean isCurrentModule;
    public static final String REST_RESOURCE_PATH = "/path/to/subdirectory";
    public static final String REST_PARAM_PATH = "/path/to/resource";
    public static final String REST_RESOURCE_PATH_LABEL = "Remaining Resource Path";
    private static final String PULLING_THE_MODULE_MESSAGE = "Pulling the module '%s' from the central";
    private static final String MODULE_PULLING_FAILED_MESSAGE = "Failed to pull the module: %s";
    private static final String MODULE_PULLING_SUCCESS_MESSAGE = "Successfully pulled the module: %s";
    private static final String CLIENT_SYMBOL = "Client";

    public FunctionDataBuilder semanticModel(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
        this.errorTypeSymbol = semanticModel.types().ERROR;
        return this;
    }

    public FunctionDataBuilder resolvedPackage(Package resolvedPackage) {
        if (this.semanticModel == null) {
            this.semanticModel(PackageUtil.getCompilation(resolvedPackage).getSemanticModel(resolvedPackage.getDefaultModule().moduleId()));
        }
        this.resolvedPackage = resolvedPackage;
        return this;
    }

    public FunctionDataBuilder name(String name) {
        this.functionName = name;
        return this;
    }

    public FunctionDataBuilder moduleInfo(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
        return this;
    }

    public FunctionDataBuilder resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public FunctionDataBuilder functionSymbol(FunctionSymbol functionSymbol) {
        if (this.moduleInfo == null) {
            functionSymbol.getModule().ifPresent(module -> {
                this.moduleInfo = ModuleInfo.from(module.id());
            });
        }
        if (this.functionKind == null) {
            this.functionKind = this.getFunctionKind(functionSymbol);
        }
        this.functionSymbol = functionSymbol;
        return this;
    }

    public FunctionDataBuilder functionResultKind(FunctionData.Kind kind) {
        this.functionKind = kind;
        return this;
    }

    public FunctionDataBuilder userModuleInfo(ModuleInfo moduleInfo) {
        this.userModuleInfo = moduleInfo;
        return this;
    }

    public FunctionDataBuilder parentSymbolType(String parentSymbolType) {
        this.parentSymbolType = parentSymbolType;
        return this;
    }

    public FunctionDataBuilder parentSymbol(ObjectTypeSymbol parentSymbol) {
        if (this.moduleInfo == null) {
            parentSymbol.getModule().ifPresent(module -> {
                this.moduleInfo = ModuleInfo.from(module.id());
            });
        }
        this.parentSymbol = parentSymbol;
        return this;
    }

    public FunctionDataBuilder parentSymbol(SemanticModel semanticModel, Document document, LinePosition position, String parentSymbolName) {
        Stream<Symbol> symbolStream = document == null || position == null ? semanticModel.moduleSymbols().parallelStream() : semanticModel.visibleSymbols(document, position).parallelStream();
        this.setParentSymbol(symbolStream, parentSymbolName);
        return this;
    }

    public FunctionDataBuilder parentSymbol(SemanticModel semanticModel, String parentSymbolName) {
        this.setParentSymbol(semanticModel.moduleSymbols().parallelStream(), parentSymbolName);
        return this;
    }

    public FunctionDataBuilder lsClientLogger(LSClientLogger lsClientLogger) {
        this.lsClientLogger = lsClientLogger;
        return this;
    }

    public FunctionDataBuilder project(Project project) {
        this.project = project;
        return this;
    }

    private void setParentSymbol(Stream<Symbol> symbolStream, String parentSymbolName) {
        this.parentSymbol = symbolStream.filter(symbol -> symbol.kind() == SymbolKind.VARIABLE && symbol.nameEquals(parentSymbolName)).map(symbol -> CommonUtils.getRawType(((VariableSymbol)symbol).typeDescriptor())).filter(typeSymbol -> typeSymbol instanceof ObjectTypeSymbol).map(typeSymbol -> (ObjectTypeSymbol)typeSymbol).findFirst().orElse(null);
    }

    public FunctionData build() {
        Optional<FunctionData> indexedResult;
        if (this.functionName == null) {
            if (this.functionSymbol == null) {
                throw new IllegalStateException("Function symbol must be provided if function name is not given");
            }
            this.functionName = (String)this.functionSymbol.getName().orElseThrow(() -> new IllegalStateException("Function name not found"));
        }
        if (this.moduleInfo == null) {
            throw new IllegalStateException("Module information not found");
        }
        boolean bl = this.isCurrentModule = this.userModuleInfo != null && (!this.moduleInfo.isComplete() || this.userModuleInfo.equals(this.moduleInfo));
        if (this.functionKind == null) {
            this.functionKind = FunctionData.Kind.FUNCTION;
        }
        this.checkLocalModule();
        if (this.semanticModel == null) {
            if (this.moduleInfo.version() == null) {
                RemoteCentral centralApi = RemoteCentral.getInstance();
                this.moduleInfo = new ModuleInfo(this.moduleInfo.org(), this.moduleInfo.packageName(), this.moduleInfo.moduleName(), centralApi.latestPackageVersion(this.moduleInfo.org(), this.moduleInfo.packageName()));
            }
            if (this.moduleInfo.isComplete() && PackageUtil.isModuleUnresolved(this.moduleInfo.org(), this.moduleInfo.packageName(), this.moduleInfo.version())) {
                this.notifyClient(MessageType.Info, PULLING_THE_MODULE_MESSAGE);
                if (this.semanticModel == null) {
                    this.deriveSemanticModel();
                }
                if (this.semanticModel == null) {
                    this.notifyClient(MessageType.Error, MODULE_PULLING_FAILED_MESSAGE);
                } else {
                    this.notifyClient(MessageType.Info, MODULE_PULLING_SUCCESS_MESSAGE);
                }
            }
        }
        if ((indexedResult = this.getFunctionFromIndex()).isPresent()) {
            return indexedResult.get();
        }
        if (this.semanticModel == null) {
            this.deriveSemanticModel();
        }
        if (this.functionSymbol == null) {
            if (this.parentSymbol == null && this.parentSymbolType != null) {
                this.setParentSymbol();
            }
            if (this.parentSymbol == null) {
                FunctionSymbol fetchedSymbol = this.semanticModel.moduleSymbols().parallelStream().filter(moduleSymbol -> moduleSymbol.nameEquals(this.functionName) && moduleSymbol instanceof FunctionSymbol).map(moduleSymbol -> (FunctionSymbol)moduleSymbol).findFirst().orElseThrow(() -> new IllegalStateException("Function symbol not found"));
                this.functionSymbol(fetchedSymbol);
            } else if (this.functionKind == FunctionData.Kind.CONNECTOR) {
                if (this.parentSymbol.kind() != SymbolKind.CLASS || !this.parentSymbol.qualifiers().contains(Qualifier.CLIENT)) {
                    throw new IllegalStateException("The connector should be a client class");
                }
                classSymbol = (ClassSymbol)this.parentSymbol;
                initMethod = classSymbol.initMethod();
                if (initMethod.isEmpty()) {
                    String clientName = this.getFunctionName();
                    FunctionData functionData = new FunctionData(0, clientName, this.getDescription((Documentable)classSymbol), this.getTypeSignature(clientName), this.moduleInfo.packageName(), this.moduleInfo.org(), this.moduleInfo.version(), "", this.functionKind, false, false, null);
                    functionData.setParameters(Map.of());
                    return functionData;
                }
                this.functionSymbol = (FunctionSymbol)initMethod.get();
            } else {
                if (this.functionKind == FunctionData.Kind.RESOURCE) {
                    this.functionSymbol = this.parentSymbol.methods().values().parallelStream().filter(symbol -> symbol.kind() == SymbolKind.RESOURCE_METHOD && symbol.nameEquals(this.functionName) && this.buildResourcePathTemplate((FunctionSymbol)symbol).resourcePathTemplate().equals(this.resourcePath)).findFirst().orElse(null);
                } else if (this.functionKind == FunctionData.Kind.CLASS_INIT) {
                    if (this.parentSymbol.kind() != SymbolKind.CLASS) {
                        throw new IllegalStateException("Parent symbol should be a class symbol");
                    }
                    classSymbol = (ClassSymbol)this.parentSymbol;
                    initMethod = classSymbol.initMethod();
                    initMethod.ifPresent(methodSymbol -> {
                        this.functionSymbol = methodSymbol;
                    });
                } else {
                    this.functionSymbol = (FunctionSymbol)this.parentSymbol.methods().get(this.functionName);
                }
                if (this.functionSymbol == null) {
                    throw new IllegalStateException("Function symbol not found");
                }
            }
        }
        if (this.description == null) {
            FunctionSymbol documentable = this.functionKind == FunctionData.Kind.CONNECTOR ? (ClassSymbol)this.parentSymbol : this.functionSymbol;
            this.description = this.getDescription((Documentable)documentable);
        }
        FunctionTypeSymbol functionTypeSymbol = this.functionSymbol.typeDescriptor();
        ReturnData returnData = this.getReturnData(this.functionSymbol);
        ParamForTypeInfer paramForTypeInfer = returnData.paramForTypeInfer();
        LinkedHashMap<String, ParameterData> parameters = new LinkedHashMap<String, ParameterData>();
        if (this.functionKind == FunctionData.Kind.RESOURCE) {
            ResourcePathTemplate resourcePathTemplate = this.buildResourcePathTemplate(this.functionSymbol);
            this.resourcePath = resourcePathTemplate.resourcePathTemplate();
            resourcePathTemplate.pathParams().forEach(param -> parameters.put(param.name(), (ParameterData)param));
        }
        FunctionData functionData = new FunctionData(0, this.getFunctionName(), this.description, returnData.returnType(), this.moduleInfo.packageName(), this.moduleInfo.org(), this.moduleInfo.version(), this.resourcePath, this.functionKind, returnData.returnError(), paramForTypeInfer != null, returnData.importStatements());
        Types types = this.semanticModel.types();
        TypeBuilder builder = this.semanticModel.types().builder();
        UnionTypeSymbol union = builder.UNION_TYPE.withMemberTypes(new TypeSymbol[]{types.BOOLEAN, types.NIL, types.STRING, types.INT, types.FLOAT, types.DECIMAL, types.BYTE, types.REGEX, types.XML}).build();
        Map documentationMap = this.functionSymbol.documentation().map(Documentation::parameterMap).orElse(Map.of());
        functionTypeSymbol.params().ifPresent(paramList -> paramList.forEach(paramSymbol -> parameters.putAll(this.getParameters((ParameterSymbol)paramSymbol, documentationMap, paramForTypeInfer, union))));
        functionTypeSymbol.restParam().ifPresent(paramSymbol -> parameters.putAll(this.getParameters((ParameterSymbol)paramSymbol, documentationMap, paramForTypeInfer, union)));
        functionData.setParameters(parameters);
        return functionData;
    }

    private void checkLocalModule() {
        if (this.project != null && this.moduleInfo != null && this.isLocal()) {
            for (Module module : this.project.currentPackage().modules()) {
                ModuleName moduleName = module.moduleName();
                if (!(String.valueOf(moduleName.packageName()) + "." + moduleName.moduleNamePart()).equals(this.moduleInfo.moduleName())) continue;
                this.semanticModel(PackageUtil.getCompilation(this.project).getSemanticModel(module.moduleId()));
                break;
            }
        }
    }

    public boolean isLocal() {
        if (this.project != null && this.moduleInfo != null) {
            PackageDescriptor descriptor = this.project.currentPackage().descriptor();
            return this.moduleInfo.org().equals(descriptor.org().value()) && this.moduleInfo.packageName().startsWith(descriptor.name().value());
        }
        return false;
    }

    private ReturnData getReturnData(FunctionSymbol symbol) {
        FunctionTypeSymbol functionTypeSymbol = symbol.typeDescriptor();
        Optional returnTypeSymbol = functionTypeSymbol.returnTypeDescriptor();
        String returnType = returnTypeSymbol.map(typeSymbol -> {
            if (this.functionKind == FunctionData.Kind.CONNECTOR || this.functionKind == FunctionData.Kind.CLASS_INIT) {
                return CommonUtils.getClassType(this.moduleInfo.packageName(), this.parentSymbol.getName().orElse(CLIENT_SYMBOL));
            }
            return this.getTypeSignature((TypeSymbol)typeSymbol, true);
        }).orElse("");
        ParamForTypeInfer paramForTypeInfer = null;
        if (symbol.external()) {
            ArrayList paramNameList = new ArrayList();
            functionTypeSymbol.params().ifPresent(paramList -> paramList.stream().filter(paramSym -> paramSym.paramKind() == ParameterKind.DEFAULTABLE).forEach(paramSymbol -> paramNameList.add(paramSymbol.getName().orElse(""))));
            HashMap returnTypeMap = new HashMap();
            returnTypeSymbol.ifPresent(typeSymbol -> FunctionDataBuilder.allMembers(returnTypeMap, typeSymbol));
            for (String paramName : paramNameList) {
                if (!returnTypeMap.containsKey(paramName)) continue;
                TypeSymbol typeDescriptor = (TypeSymbol)returnTypeMap.get(paramName);
                String defaultValue = DefaultValueGeneratorUtil.getDefaultValueForType(typeDescriptor);
                paramForTypeInfer = new ParamForTypeInfer(paramName, defaultValue, CommonUtils.getTypeSignature(this.semanticModel, CommonUtils.getRawType(typeDescriptor), true));
                break;
            }
        }
        String importStatements = returnTypeSymbol.map(typeSymbol -> this.getImportStatements((TypeSymbol)returnTypeSymbol.get())).orElse(null);
        boolean returnError = returnTypeSymbol.map(returnTypeDesc -> CommonUtils.subTypeOf(returnTypeDesc, this.errorTypeSymbol)).orElse(false);
        return new ReturnData(returnType, paramForTypeInfer, returnError, importStatements);
    }

    private void setParentSymbol() {
        if (this.semanticModel == null) {
            this.deriveSemanticModel();
        }
        ObjectTypeSymbol fetchedParentTypeSymbol = this.semanticModel.moduleSymbols().parallelStream().filter(moduleSymbol -> moduleSymbol.nameEquals(this.parentSymbolType) && moduleSymbol instanceof ObjectTypeSymbol).map(moduleSymbol -> (ObjectTypeSymbol)moduleSymbol).findFirst().orElseThrow(() -> new IllegalStateException("Parent symbol not found"));
        this.parentSymbol(fetchedParentTypeSymbol);
    }

    private FunctionData.Kind getFunctionKind(FunctionSymbol symbol) {
        if (symbol.kind() == SymbolKind.METHOD) {
            List qualifiers = symbol.qualifiers();
            if (qualifiers.contains(Qualifier.REMOTE)) {
                return FunctionData.Kind.REMOTE;
            }
            if (qualifiers.contains(Qualifier.RESOURCE)) {
                return FunctionData.Kind.RESOURCE;
            }
        }
        if (symbol.kind() == SymbolKind.RESOURCE_METHOD) {
            return FunctionData.Kind.RESOURCE;
        }
        return FunctionData.Kind.FUNCTION;
    }

    private void deriveSemanticModel() {
        this.semanticModel(PackageUtil.getSemanticModel(this.moduleInfo.org(), this.moduleInfo.packageName(), this.moduleInfo.version()).orElseThrow(() -> new IllegalStateException("Semantic model not found")));
    }

    public List<FunctionData> buildChildNodes() {
        List<FunctionData> fetchedMethods;
        if (this.parentSymbolType != null && this.moduleInfo != null && !(fetchedMethods = this.getMethodsFromIndex()).isEmpty()) {
            return fetchedMethods;
        }
        if (this.parentSymbol == null && this.parentSymbolType == null) {
            throw new IllegalStateException("Parent symbol must be provided");
        }
        this.checkLocalModule();
        if (this.semanticModel == null) {
            this.deriveSemanticModel();
        }
        if (this.parentSymbol == null) {
            this.setParentSymbol();
        }
        if (this.parentSymbol.kind() != SymbolKind.CLASS) {
            throw new IllegalStateException("Parent symbol should be a class symbol");
        }
        ClassSymbol classSymbol = (ClassSymbol)this.parentSymbol;
        ArrayList<FunctionData> functionDataList = new ArrayList<FunctionData>();
        for (MethodSymbol methodSymbol : classSymbol.methods().values()) {
            String methodResourcePath;
            FunctionData.Kind methodKind;
            List qualifiers = methodSymbol.qualifiers();
            if (qualifiers.contains(Qualifier.PRIVATE) || (methodKind = this.getFunctionKind((FunctionSymbol)methodSymbol)) == FunctionData.Kind.FUNCTION && !qualifiers.contains(Qualifier.PUBLIC)) continue;
            ReturnData returnData = this.getReturnData((FunctionSymbol)methodSymbol);
            if (methodKind == FunctionData.Kind.RESOURCE) {
                ResourcePathTemplate resourcePathTemplate = this.buildResourcePathTemplate((FunctionSymbol)methodSymbol);
                methodResourcePath = resourcePathTemplate.resourcePathTemplate();
            } else {
                methodResourcePath = "";
            }
            FunctionData functionData = new FunctionData(0, methodSymbol.getName().orElse(""), this.getDescription((Documentable)methodSymbol), returnData.returnType(), this.moduleInfo.packageName(), this.moduleInfo.org(), this.moduleInfo.version(), methodResourcePath, methodKind, returnData.returnError(), returnData.paramForTypeInfer() != null, returnData.importStatements());
            functionDataList.add(functionData);
        }
        return functionDataList;
    }

    private Optional<FunctionData> getFunctionFromIndex() {
        DatabaseManager dbManager = DatabaseManager.getInstance();
        if (this.parentSymbolType != null && !this.parentSymbolType.isEmpty() && !CLIENT_SYMBOL.equals(this.parentSymbolType)) {
            return Optional.empty();
        }
        Optional<FunctionData> optFunctionResult = dbManager.getFunction(this.moduleInfo.org(), this.moduleInfo.packageName(), this.getFunctionName(), this.functionKind, this.resourcePath);
        if (optFunctionResult.isEmpty()) {
            return Optional.empty();
        }
        FunctionData functionData = optFunctionResult.get();
        LinkedHashMap<String, ParameterData> parameters = dbManager.getFunctionParametersAsMap(functionData.functionId());
        functionData.setParameters(parameters);
        return Optional.of(functionData);
    }

    private List<FunctionData> getMethodsFromIndex() {
        DatabaseManager dbManager = DatabaseManager.getInstance();
        List<FunctionData> methods = dbManager.getMethods(this.parentSymbolType, this.moduleInfo.org(), this.moduleInfo.packageName());
        if (methods.isEmpty()) {
            return new ArrayList<FunctionData>();
        }
        methods.parallelStream().forEach(method -> method.setParameters(dbManager.getFunctionParametersAsMap(method.functionId())));
        return methods;
    }

    private Map<String, ParameterData> getParameters(ParameterSymbol paramSymbol, Map<String, String> documentationMap, ParamForTypeInfer paramForTypeInfer, UnionTypeSymbol union) {
        Object paramType;
        String defaultValue;
        LinkedHashMap<String, ParameterData> parameters = new LinkedHashMap<String, ParameterData>();
        String paramName = paramSymbol.getName().orElse("");
        String paramDescription = documentationMap.get(paramName);
        ParameterData.Kind parameterKind = ParameterData.Kind.fromKind(paramSymbol.paramKind());
        boolean optional = true;
        TypeSymbol typeSymbol = paramSymbol.typeDescriptor();
        String importStatements = this.getImportStatements(typeSymbol);
        if (parameterKind == ParameterData.Kind.REST_PARAMETER) {
            defaultValue = DefaultValueGeneratorUtil.getDefaultValueForType(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor());
            paramType = this.getTypeSignature(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor());
        } else if (parameterKind == ParameterData.Kind.INCLUDED_RECORD) {
            HashMap<String, String> includedRecordParamDocs = new HashMap<String, String>();
            if (typeSymbol.getModule().isPresent() && typeSymbol.getName().isPresent()) {
                Object t;
                Optional typeByName;
                ModuleID id = ((ModuleSymbol)typeSymbol.getModule().get()).id();
                if (this.semanticModel != null && (typeByName = this.semanticModel.types().getTypeByName(id.orgName(), id.moduleName(), "", (String)typeSymbol.getName().get())).isPresent() && (t = typeByName.get()) instanceof TypeDefinitionSymbol) {
                    TypeDefinitionSymbol typeDefSymbol = (TypeDefinitionSymbol)t;
                    Optional documentation = typeDefSymbol.documentation();
                    documentation.ifPresent(documentation1 -> includedRecordParamDocs.putAll(documentation1.parameterMap()));
                }
            }
            paramType = this.getTypeSignature(typeSymbol);
            Map<String, ParameterData> includedParameters = this.getIncludedRecordParams((RecordTypeSymbol)CommonUtil.getRawType((TypeSymbol)typeSymbol), true, includedRecordParamDocs, union);
            parameters.putAll(includedParameters);
            defaultValue = DefaultValueGeneratorUtil.getDefaultValueForType(typeSymbol);
        } else if (parameterKind == ParameterData.Kind.REQUIRED) {
            if (this.isAgentModelType(paramName)) {
                ArrayList<String> memberTypes = new ArrayList<String>();
                TypeSymbol rawParamType = CommonUtils.getRawType(typeSymbol);
                if (rawParamType.typeKind() == TypeDescKind.UNION) {
                    UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)rawParamType;
                    for (TypeSymbol memType : unionTypeSymbol.userSpecifiedMemberTypes()) {
                        memberTypes.add(memType.signature());
                    }
                    paramType = memberTypes;
                } else {
                    paramType = this.getTypeSignature(typeSymbol);
                }
            } else {
                paramType = this.getTypeSignature(typeSymbol);
            }
            defaultValue = DefaultValueGeneratorUtil.getDefaultValueForType(typeSymbol);
            optional = false;
        } else {
            if (paramForTypeInfer != null && paramForTypeInfer.paramName().equals(paramName)) {
                String defaultValue2 = paramForTypeInfer.type();
                String paramType2 = paramForTypeInfer.type();
                parameters.put(paramName, ParameterData.from(paramName, paramDescription, paramType2, defaultValue2, ParameterData.Kind.PARAM_FOR_TYPE_INFER, optional, importStatements));
                return parameters;
            }
            defaultValue = this.getDefaultValue((Symbol)paramSymbol, typeSymbol);
            paramType = this.getTypeSignature(typeSymbol);
        }
        ParameterData parameterData = ParameterData.from(paramName, paramDescription, this.getLabel(paramSymbol.annotAttachments()), paramType, defaultValue, parameterKind, optional, importStatements);
        parameters.put(paramName, parameterData);
        FunctionDataBuilder.addParameterMemberTypes(typeSymbol, parameterData, union);
        return parameters;
    }

    private static void addParameterMemberTypes(TypeSymbol typeSymbol, ParameterData parameterData, UnionTypeSymbol union) {
        if (typeSymbol instanceof UnionTypeSymbol) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
            unionTypeSymbol.memberTypeDescriptors().forEach(memberType -> FunctionDataBuilder.addParameterMemberTypes(memberType, parameterData, union));
            return;
        }
        String packageIdentifier = "";
        ModuleInfo moduleInfo = null;
        if (typeSymbol.getModule().isPresent()) {
            ModuleID id = ((ModuleSymbol)typeSymbol.getModule().get()).id();
            packageIdentifier = "%s:%s:%s".formatted(id.orgName(), id.moduleName(), id.version());
            moduleInfo = ModuleInfo.from(id);
        }
        String type = CommonUtils.getTypeSignature(typeSymbol, moduleInfo);
        String kind = "OTHER";
        TypeSymbol rawType = CommonUtils.getRawType(typeSymbol);
        if (typeSymbol.subtypeOf((TypeSymbol)union)) {
            kind = "BASIC_TYPE";
        } else if (rawType instanceof TupleTypeSymbol) {
            kind = "TUPLE_TYPE";
        } else if (rawType instanceof ArrayTypeSymbol) {
            ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)rawType;
            kind = "ARRAY_TYPE";
            TypeSymbol memberType2 = arrayTypeSymbol.memberTypeDescriptor();
            if (memberType2.getModule().isPresent()) {
                ModuleID id = ((ModuleSymbol)memberType2.getModule().get()).id();
                packageIdentifier = "%s:%s:%s".formatted(id.orgName(), id.moduleName(), id.version());
                moduleInfo = ModuleInfo.from(id);
            }
            type = CommonUtils.getTypeSignature(memberType2, moduleInfo);
        } else if (rawType instanceof RecordTypeSymbol) {
            kind = typeSymbol instanceof RecordTypeSymbol ? "ANON_RECORD_TYPE" : "RECORD_TYPE";
        } else if (rawType instanceof MapTypeSymbol) {
            MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)rawType;
            kind = "MAP_TYPE";
            TypeSymbol typeParam = mapTypeSymbol.typeParam();
            if (typeParam.getModule().isPresent()) {
                ModuleID id = ((ModuleSymbol)typeParam.getModule().get()).id();
                packageIdentifier = "%s:%s:%s".formatted(id.orgName(), id.moduleName(), id.version());
                moduleInfo = ModuleInfo.from(id);
            }
            type = CommonUtils.getTypeSignature(typeSymbol, moduleInfo);
        } else if (rawType instanceof TableTypeSymbol) {
            TableTypeSymbol tableTypeSymbol = (TableTypeSymbol)rawType;
            kind = "TABLE_TYPE";
            TypeSymbol rowTypeParameter = tableTypeSymbol.rowTypeParameter();
            if (rowTypeParameter.getModule().isPresent()) {
                ModuleID id = ((ModuleSymbol)rowTypeParameter.getModule().get()).id();
                packageIdentifier = "%s:%s:%s".formatted(id.orgName(), id.moduleName(), id.version());
                moduleInfo = ModuleInfo.from(id);
            }
            type = CommonUtils.getTypeSignature(typeSymbol, moduleInfo);
        } else if (rawType instanceof StreamTypeSymbol) {
            kind = "STREAM_TYPE";
        } else if (rawType instanceof ObjectTypeSymbol) {
            kind = "OBJECT_TYPE";
        } else if (rawType instanceof FunctionTypeSymbol) {
            kind = "FUNCTION_TYPE";
        } else if (rawType instanceof ErrorTypeSymbol) {
            kind = "ERROR_TYPE";
        }
        String[] typeParts = type.split(":");
        if (typeParts.length > 1) {
            type = typeParts[1];
        }
        parameterData.typeMembers().add(new ParameterMemberTypeData(type, kind, packageIdentifier));
    }

    private Map<String, ParameterData> getIncludedRecordParams(RecordTypeSymbol recordTypeSymbol, boolean insert, Map<String, String> documentationMap, UnionTypeSymbol union) {
        LinkedHashMap<String, ParameterData> parameters = new LinkedHashMap<String, ParameterData>();
        recordTypeSymbol.typeInclusions().forEach(includedType -> {
            if (includedType.getModule().isPresent() && includedType.getName().isPresent()) {
                Object patt0$temp;
                Optional typeByName;
                ModuleID id = ((ModuleSymbol)includedType.getModule().get()).id();
                if (this.semanticModel != null && (typeByName = this.semanticModel.types().getTypeByName(id.orgName(), id.moduleName(), "", (String)includedType.getName().get())).isPresent() && (patt0$temp = typeByName.get()) instanceof TypeDefinitionSymbol) {
                    TypeDefinitionSymbol typeDefSymbol = (TypeDefinitionSymbol)patt0$temp;
                    Optional documentation = typeDefSymbol.documentation();
                    documentation.ifPresent(doc -> documentationMap.putAll(doc.parameterMap()));
                }
            }
            parameters.putAll(this.getIncludedRecordParams((RecordTypeSymbol)CommonUtils.getRawType(includedType), insert, documentationMap, union));
        });
        for (Map.Entry entry : recordTypeSymbol.fieldDescriptors().entrySet()) {
            RecordFieldSymbol recordFieldSymbol = (RecordFieldSymbol)entry.getValue();
            TypeSymbol typeSymbol2 = recordFieldSymbol.typeDescriptor();
            TypeSymbol fieldType = CommonUtil.getRawType((TypeSymbol)typeSymbol2);
            if (fieldType.typeKind() == TypeDescKind.NEVER) continue;
            String paramName = (String)entry.getKey();
            String paramDescription = this.getDescription((Documentable)entry.getValue());
            if (documentationMap.containsKey(paramName) && !paramDescription.isEmpty()) {
                documentationMap.put(paramName, paramDescription);
            } else if (!documentationMap.containsKey(paramName)) {
                documentationMap.put(paramName, paramDescription);
            }
            if (!insert) continue;
            String defaultValue = this.getDefaultValue((Symbol)recordFieldSymbol, fieldType);
            String paramType = this.getTypeSignature(typeSymbol2);
            boolean optional = recordFieldSymbol.isOptional() || recordFieldSymbol.hasDefaultValue();
            ParameterData parameterData = ParameterData.from(paramName, documentationMap.get(paramName), this.getLabel(recordFieldSymbol.annotAttachments()), paramType, defaultValue, ParameterData.Kind.INCLUDED_FIELD, optional, this.getImportStatements(typeSymbol2));
            parameters.put(paramName, parameterData);
            FunctionDataBuilder.addParameterMemberTypes(typeSymbol2, parameterData, union);
        }
        recordTypeSymbol.restTypeDescriptor().ifPresent(typeSymbol -> {
            String paramType = this.getTypeSignature((TypeSymbol)typeSymbol);
            String defaultValue = DefaultValueGeneratorUtil.getDefaultValueForType(typeSymbol);
            parameters.put("Additional Values", ParameterData.from("Additional Values", "Capture key value pairs", paramType, defaultValue, ParameterData.Kind.INCLUDED_RECORD_REST, true, this.getImportStatements((TypeSymbol)typeSymbol)));
        });
        return parameters;
    }

    private String getDefaultValue(Symbol paramSymbol, TypeSymbol typeSymbol) {
        ExpressionNode expression;
        String defaultValue = DefaultValueGeneratorUtil.getDefaultValueForType(typeSymbol);
        Optional symbolLocation = paramSymbol.getLocation();
        if (this.resolvedPackage == null || symbolLocation.isEmpty()) {
            return defaultValue;
        }
        Document document = this.findDocument(this.resolvedPackage, ((Location)symbolLocation.get()).lineRange().fileName());
        if (document == null) {
            return defaultValue;
        }
        ModulePartNode rootNode = (ModulePartNode)document.syntaxTree().rootNode();
        TextRange textRange = ((Location)symbolLocation.get()).textRange();
        NonTerminalNode node = rootNode.findNode(TextRange.from((int)textRange.startOffset(), (int)textRange.length()));
        switch (node.kind()) {
            case DEFAULTABLE_PARAM: {
                expression = (ExpressionNode)((DefaultableParameterNode)node).expression();
                break;
            }
            case RECORD_FIELD_WITH_DEFAULT_VALUE: {
                expression = ((RecordFieldWithDefaultValueNode)node).expression();
                break;
            }
            default: {
                return defaultValue;
            }
        }
        if (expression instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)expression;
            return this.resolvedPackage.packageName().value() + ":" + simpleNameReferenceNode.name().text();
        }
        if (expression instanceof QualifiedNameReferenceNode) {
            QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)expression;
            return qualifiedNameReferenceNode.modulePrefix().text() + ":" + qualifiedNameReferenceNode.identifier().text();
        }
        return expression.toSourceCode();
    }

    private Document findDocument(Package pkg, String path) {
        if (this.resolvedPackage == null) {
            return null;
        }
        Project project = pkg.project();
        Module defaultModule = pkg.getDefaultModule();
        String module = pkg.packageName().value();
        Path docPath = project.sourceRoot().resolve("modules").resolve(module).resolve(path);
        try {
            DocumentId documentId = project.documentId(docPath);
            return defaultModule.document(documentId);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public static void allMembers(Map<String, TypeSymbol> typeMap, TypeSymbol typeSymbol) {
        switch (typeSymbol.typeKind()) {
            case UNION: {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                unionTypeSymbol.memberTypeDescriptors().forEach(memberType -> FunctionDataBuilder.allMembers(typeMap, memberType));
                break;
            }
            case INTERSECTION: {
                IntersectionTypeSymbol intersectionTypeSymbol = (IntersectionTypeSymbol)typeSymbol;
                intersectionTypeSymbol.memberTypeDescriptors().forEach(memberType -> FunctionDataBuilder.allMembers(typeMap, memberType));
                break;
            }
            case STREAM: {
                StreamTypeSymbol streamTypeSymbol = (StreamTypeSymbol)typeSymbol;
                FunctionDataBuilder.allMembers(typeMap, streamTypeSymbol.typeParameter());
                FunctionDataBuilder.allMembers(typeMap, streamTypeSymbol.completionValueTypeParameter());
                break;
            }
            case ARRAY: {
                ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)typeSymbol;
                FunctionDataBuilder.allMembers(typeMap, arrayTypeSymbol.memberTypeDescriptor());
                break;
            }
            case MAP: {
                MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)typeSymbol;
                FunctionDataBuilder.allMembers(typeMap, mapTypeSymbol.typeParam());
                break;
            }
            case TABLE: {
                TableTypeSymbol tableTypeSymbol = (TableTypeSymbol)typeSymbol;
                FunctionDataBuilder.allMembers(typeMap, tableTypeSymbol.rowTypeParameter());
                tableTypeSymbol.keyConstraintTypeParameter().ifPresent(keyType -> FunctionDataBuilder.allMembers(typeMap, keyType));
                break;
            }
            case RECORD: {
                RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
                recordTypeSymbol.fieldDescriptors().forEach((key, value) -> FunctionDataBuilder.allMembers(typeMap, value.typeDescriptor()));
                recordTypeSymbol.restTypeDescriptor().ifPresent(restType -> FunctionDataBuilder.allMembers(typeMap, restType));
                break;
            }
            default: {
                typeMap.put(typeSymbol.getName().orElse(""), typeSymbol);
            }
        }
    }

    private ResourcePathTemplate buildResourcePathTemplate(FunctionSymbol functionSymbol) {
        Map documentationMap = functionSymbol.documentation().map(Documentation::parameterMap).orElse(Map.of());
        StringBuilder pathBuilder = new StringBuilder();
        ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)functionSymbol;
        ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
        ArrayList<ParameterData> pathParams = new ArrayList<ParameterData>();
        switch (resourcePath.kind()) {
            case PATH_SEGMENT_LIST: {
                PathSegmentList pathSegmentList = (PathSegmentList)resourcePath;
                for (Symbol pathSegment : pathSegmentList.list()) {
                    pathBuilder.append("/");
                    if (pathSegment instanceof PathParameterSymbol) {
                        PathParameterSymbol pathParameterSymbol = (PathParameterSymbol)pathSegment;
                        String defaultValue = DefaultValueGeneratorUtil.getDefaultValueForType(pathParameterSymbol.typeDescriptor());
                        String type = CommonUtils.getTypeSignature(this.semanticModel, pathParameterSymbol.typeDescriptor(), true);
                        String paramName = pathParameterSymbol.getName().orElse("");
                        String paramDescription = (String)documentationMap.get(paramName);
                        pathBuilder.append("[").append(paramName).append("]");
                        pathParams.add(ParameterData.from(paramName, type, ParameterData.Kind.PATH_PARAM, defaultValue, paramDescription, false));
                        continue;
                    }
                    pathBuilder.append(pathSegment.getName().orElse(""));
                }
                ((PathSegmentList)resourcePath).pathRestParameter().ifPresent(pathRestParameter -> pathParams.add(ParameterData.from(REST_RESOURCE_PATH_LABEL, "string", ParameterData.Kind.PATH_REST_PARAM, REST_PARAM_PATH, REST_RESOURCE_PATH_LABEL, false)));
                break;
            }
            case PATH_REST_PARAM: {
                pathBuilder.append(REST_RESOURCE_PATH);
                break;
            }
            case DOT_RESOURCE_PATH: {
                pathBuilder.append("/");
            }
        }
        return new ResourcePathTemplate(pathBuilder.toString(), pathParams);
    }

    private String getTypeSignature(TypeSymbol typeSymbol) {
        return this.getTypeSignature(typeSymbol, false);
    }

    private String getTypeSignature(TypeSymbol typeSymbol, boolean ignoreError) {
        if (this.userModuleInfo == null) {
            return CommonUtils.getTypeSignature(this.semanticModel, typeSymbol, ignoreError);
        }
        return CommonUtils.getTypeSignature(this.semanticModel, typeSymbol, ignoreError, this.userModuleInfo);
    }

    private String getTypeSignature(String type) {
        if (this.userModuleInfo == null) {
            return this.moduleInfo.moduleName() + ":" + type;
        }
        return type;
    }

    private String getFunctionName() {
        if (this.functionKind == FunctionData.Kind.CONNECTOR) {
            if (this.parentSymbolType != null) {
                return this.parentSymbolType;
            }
            if (this.parentSymbol != null) {
                return CommonUtils.getClassType(this.moduleInfo.packageName(), this.parentSymbol.getName().orElse(this.functionName));
            }
        }
        return this.functionName;
    }

    private String getDescription(Documentable documentable) {
        return documentable.documentation().flatMap(Documentation::description).orElse("");
    }

    private String getImportStatements(TypeSymbol typeSymbol) {
        if (this.isCurrentModule && typeSymbol.getModule().map(moduleSymbol -> ModuleInfo.from(moduleSymbol.id()).equals(this.userModuleInfo)).orElse(false).booleanValue()) {
            return null;
        }
        return CommonUtils.getImportStatements(typeSymbol, this.moduleInfo).orElse(null);
    }

    private void notifyClient(MessageType messageType, String message) {
        if (this.lsClientLogger != null) {
            String signature = String.format("%s/%s:%s", this.moduleInfo.org(), this.moduleInfo.packageName(), this.moduleInfo.version());
            this.lsClientLogger.notifyClient(messageType, String.format(message, signature));
        }
    }

    private String getLabel(List<AnnotationAttachmentSymbol> annotationAttachmentSymbols) {
        for (AnnotationAttachmentSymbol annotAttachment : annotationAttachmentSymbols) {
            AnnotationSymbol annotationSymbol = annotAttachment.typeDescriptor();
            Optional optName = annotationSymbol.getName();
            if (optName.isEmpty() || !((String)optName.get()).equals(DISPLAY_ANNOTATION)) continue;
            Optional optAttachmentValue = annotAttachment.attachmentValue();
            if (optAttachmentValue.isEmpty()) break;
            ConstantValue attachmentValue = (ConstantValue)optAttachmentValue.get();
            if (attachmentValue.valueType().typeKind() != TypeDescKind.RECORD) {
                throw new IllegalStateException("Annotation attachment value is not a record");
            }
            HashMap valueMap = (HashMap)attachmentValue.value();
            Object label = valueMap.get(LABEL);
            if (label == null) break;
            return label.toString();
        }
        return "";
    }

    private boolean isAgentModelType(String paramName) {
        return this.moduleInfo.org().equals("ballerinax") && this.moduleInfo.moduleName().equals("ai") && (this.functionKind == FunctionData.Kind.CLASS_INIT || this.functionKind == FunctionData.Kind.CONNECTOR) && paramName.equals("modelType");
    }

    private record ReturnData(String returnType, ParamForTypeInfer paramForTypeInfer, boolean returnError, String importStatements) {
    }

    private record ParamForTypeInfer(String paramName, String defaultValue, String type) {
    }

    public record ResourcePathTemplate(String resourcePathTemplate, List<ParameterData> pathParams) {
    }
}

