/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import io.ballerina.centralconnector.RemoteCentral;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.bala.BalaProject;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.environment.PackageMetadataResponse;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.repos.TempDirCompilationCache;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.MessageType;

public class PackageUtil {
    private static final String BALLERINA_HOME_PROPERTY = "ballerina.home";
    private static final BuildProject SAMPLE_PROJECT = PackageUtil.getSampleProject();
    private static final String PULLING_THE_MODULE_MESSAGE = "Pulling the module '%s' from the central";
    private static final String MODULE_PULLING_FAILED_MESSAGE = "Failed to pull the module: %s";
    private static final String MODULE_PULLING_SUCCESS_MESSAGE = "Successfully pulled the module: %s";
    private static final ConcurrentHashMap<Path, ReentrantLock> PROJECT_LOCKS = new ConcurrentHashMap();

    public static BuildProject getSampleProject() {
        String ballerinaHome = System.getProperty(BALLERINA_HOME_PROPERTY);
        if (ballerinaHome == null || ballerinaHome.isEmpty()) {
            Path currentPath = PackageUtil.getPath(Paths.get(PackageUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath(), new String[0]));
            Path distributionPath = PackageUtil.getParentPath(PackageUtil.getParentPath(PackageUtil.getParentPath(currentPath)));
            System.setProperty(BALLERINA_HOME_PROPERTY, distributionPath.toString());
        }
        try {
            Path tempDir = Files.createTempDirectory("ballerina-sample", new FileAttribute[0]);
            Path mainBalFile = tempDir.resolve("main.bal");
            Files.createFile(mainBalFile, new FileAttribute[0]);
            Path ballerinaTomlFile = tempDir.resolve("Ballerina.toml");
            String tomlContent = "[package]\norg = \"wso2\"\nname = \"sample\"\nversion = \"0.1.0\"\ndistribution = \"2201.12.0\"";
            Files.writeString(ballerinaTomlFile, (CharSequence)tomlContent, StandardOpenOption.CREATE);
            return BuildProject.load((Path)tempDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while creating the sample project", e);
        }
    }

    public static Optional<SemanticModel> getSemanticModel(String org, String name, String version) {
        return PackageUtil.getModulePackage(PackageUtil.getSampleProject(), org, name, version).map(pkg -> PackageUtil.getCompilation(pkg).getSemanticModel(pkg.getDefaultModule().moduleId()));
    }

    public static Optional<SemanticModel> getSemanticModel(String org, String name) {
        return PackageUtil.getModulePackage(PackageUtil.getSampleProject(), org, name).map(pkg -> PackageUtil.getCompilation(pkg).getSemanticModel(pkg.getDefaultModule().moduleId()));
    }

    public static Optional<Package> getModulePackage(BuildProject buildProject, String org, String name, String version) {
        ResolutionRequest resolutionRequest = ResolutionRequest.from((PackageDescriptor)PackageDescriptor.from((PackageOrg)PackageOrg.from((String)org), (PackageName)PackageName.from((String)name), (PackageVersion)PackageVersion.from((String)version)));
        Collection resolutionResponses = ((PackageResolver)buildProject.projectEnvironmentContext().getService(PackageResolver.class)).resolvePackages(Collections.singletonList(resolutionRequest), ResolutionOptions.builder().setOffline(false).setSticky(false).build());
        Optional resolutionResponse = resolutionResponses.stream().findFirst();
        if (resolutionResponse.isEmpty()) {
            return Optional.empty();
        }
        Path balaPath = ((ResolutionResponse)resolutionResponse.get()).resolvedPackage().project().sourceRoot();
        ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
        BalaProject balaProject = BalaProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)balaPath);
        return Optional.ofNullable(balaProject.currentPackage());
    }

    public static Optional<Package> getModulePackage(BuildProject buildProject, String org, String name) {
        ResolutionRequest resolutionRequest = ResolutionRequest.from((PackageDescriptor)PackageDescriptor.from((PackageOrg)PackageOrg.from((String)org), (PackageName)PackageName.from((String)name)));
        PackageResolver packageResolver = (PackageResolver)buildProject.projectEnvironmentContext().getService(PackageResolver.class);
        Collection packageMetadataResponses = packageResolver.resolvePackageMetadata(Collections.singletonList(resolutionRequest), ResolutionOptions.builder().setOffline(true).build());
        Optional pkgMetadata = packageMetadataResponses.stream().findFirst();
        if (pkgMetadata.isEmpty()) {
            return Optional.empty();
        }
        Collection resolutionResponses = packageResolver.resolvePackages(Collections.singletonList(ResolutionRequest.from((PackageDescriptor)((PackageMetadataResponse)pkgMetadata.get()).resolvedDescriptor())), ResolutionOptions.builder().setOffline(false).build());
        Optional resolutionResponse = resolutionResponses.stream().findFirst();
        if (resolutionResponse.isEmpty()) {
            return Optional.empty();
        }
        Path balaPath = ((ResolutionResponse)resolutionResponse.get()).resolvedPackage().project().sourceRoot();
        ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
        BalaProject balaProject = BalaProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)balaPath);
        return Optional.ofNullable(balaProject.currentPackage());
    }

    public static boolean isModuleUnresolved(String org, String name, String version) {
        ResolutionRequest resolutionRequest = ResolutionRequest.from((PackageDescriptor)PackageDescriptor.from((PackageOrg)PackageOrg.from((String)org), (PackageName)PackageName.from((String)name), (PackageVersion)PackageVersion.from((String)version)));
        PackageResolver packageResolver = (PackageResolver)SAMPLE_PROJECT.projectEnvironmentContext().getService(PackageResolver.class);
        return packageResolver.resolvePackageMetadata(Collections.singletonList(resolutionRequest), ResolutionOptions.builder().setOffline(true).build()).stream().findFirst().map(response -> response.resolutionStatus() == ResolutionResponse.ResolutionStatus.UNRESOLVED).orElse(false);
    }

    private static Path getPath(Path path) {
        return Objects.requireNonNull(path, "Path cannot be null");
    }

    private static Path getParentPath(Path path) {
        return Objects.requireNonNull(path, "Path cannot be null").getParent();
    }

    public static Project loadProject(WorkspaceManager workspaceManager, Path filePath) {
        try {
            return workspaceManager.loadProject(filePath);
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            throw new RuntimeException("Error loading project: " + e.getMessage());
        }
    }

    public static Optional<SemanticModel> getSemanticModelIfMatched(WorkspaceManager workspaceManager, Path filePath, String orgName, String packageName, String modulePartName, String version) {
        try {
            Project project = workspaceManager.loadProject(filePath);
            Package currentPackage = project.currentPackage();
            PackageDescriptor descriptor = currentPackage.descriptor();
            if (descriptor.org().value().equals(orgName) && descriptor.name().value().equals(packageName) && descriptor.version().value().toString().equals(version)) {
                ModuleId moduleId = currentPackage.getDefaultModule().moduleId();
                if (Objects.nonNull(modulePartName) && !modulePartName.isEmpty()) {
                    ModuleName subModuleName = ModuleName.from((PackageName)PackageName.from((String)packageName), (String)modulePartName);
                    Module module = currentPackage.module(subModuleName);
                    if (module == null) {
                        return Optional.empty();
                    }
                    moduleId = module.moduleId();
                }
                return Optional.of(PackageUtil.getCompilation(currentPackage).getSemanticModel(moduleId));
            }
        }
        catch (EventSyncException | WorkspaceDocumentException throwable) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static ModuleInfo fetchVersionIfNotExists(ModuleInfo moduleInfo) {
        if (moduleInfo.version() == null) {
            RemoteCentral centralApi = RemoteCentral.getInstance();
            return new ModuleInfo(moduleInfo.org(), moduleInfo.packageName(), moduleInfo.moduleName(), centralApi.latestPackageVersion(moduleInfo.org(), moduleInfo.packageName()));
        }
        return moduleInfo;
    }

    public static Optional<Package> pullModuleAndNotify(LSClientLogger lsClientLogger, ModuleInfo moduleInfo) {
        Optional<Package> modulePackage;
        ModuleInfo completeModuleInfo = PackageUtil.fetchVersionIfNotExists(moduleInfo);
        if (PackageUtil.isModuleUnresolved(completeModuleInfo.org(), completeModuleInfo.packageName(), completeModuleInfo.version())) {
            PackageUtil.notifyClient(lsClientLogger, completeModuleInfo, MessageType.Info, PULLING_THE_MODULE_MESSAGE);
            modulePackage = PackageUtil.getModulePackage(SAMPLE_PROJECT, completeModuleInfo.org(), completeModuleInfo.packageName(), completeModuleInfo.version());
            if (modulePackage.isEmpty()) {
                PackageUtil.notifyClient(lsClientLogger, completeModuleInfo, MessageType.Error, MODULE_PULLING_FAILED_MESSAGE);
            } else {
                PackageUtil.notifyClient(lsClientLogger, completeModuleInfo, MessageType.Info, MODULE_PULLING_SUCCESS_MESSAGE);
            }
        } else {
            modulePackage = PackageUtil.getModulePackage(SAMPLE_PROJECT, completeModuleInfo.org(), completeModuleInfo.packageName(), completeModuleInfo.version());
        }
        return modulePackage;
    }

    private static void notifyClient(LSClientLogger lsClientLogger, ModuleInfo moduleInfo, MessageType messageType, String message) {
        if (lsClientLogger != null) {
            String signature = String.format("%s/%s:%s", moduleInfo.org(), moduleInfo.packageName(), moduleInfo.version());
            lsClientLogger.notifyClient(messageType, String.format(message, signature));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageCompilation getCompilation(Package balPackage) {
        Path id = balPackage.project().sourceRoot();
        ReentrantLock lock = PROJECT_LOCKS.computeIfAbsent(id, k -> new ReentrantLock());
        lock.lock();
        try {
            PackageCompilation packageCompilation = balPackage.getCompilation();
            return packageCompilation;
        }
        finally {
            lock.unlock();
        }
    }

    public static PackageCompilation getCompilation(Project project) {
        return PackageUtil.getCompilation(project.currentPackage());
    }
}

