/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import io.ballerina.modelgenerator.commons.SearchResult;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class SearchDatabaseManager {
    private static final String INDEX_FILE_NAME = "search-index.sqlite";
    private static final Logger LOGGER = Logger.getLogger(SearchDatabaseManager.class.getName());
    private final String dbPath;

    public static SearchDatabaseManager getInstance() {
        return Holder.INSTANCE;
    }

    private SearchDatabaseManager() {
        Path tempDir;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load SQLite JDBC driver", e);
        }
        try {
            tempDir = Files.createTempDirectory("central-index", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a temporary directory", e);
        }
        URL dbUrl = this.getClass().getClassLoader().getResource(INDEX_FILE_NAME);
        if (dbUrl == null) {
            throw new RuntimeException("Database resource not found: search-index.sqlite");
        }
        Path tempFile = tempDir.resolve(INDEX_FILE_NAME);
        try {
            Files.copy(dbUrl.openStream(), tempFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy the database file to the temporary directory", e);
        }
        this.dbPath = "jdbc:sqlite:" + String.valueOf(tempFile);
    }

    public List<SearchResult> searchFunctions(String q, int limit, int offset) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String sql = "SELECT\n    f.id,\n    f.name AS function_name,\n    f.description AS function_description,\n    f.package_id,\n    p.name AS package_name,\n    p.org AS package_org,\n    p.version AS package_version,\n    fts.rank\nFROM FunctionFTS AS fts\nJOIN Function AS f ON fts.rowid = f.id\nJOIN Package AS p ON f.package_id = p.id\nWHERE fts.FunctionFTS MATCH ?\nORDER BY fts.rank\nLIMIT ?\nOFFSET ?;\n";
        try (Connection conn = DriverManager.getConnection(this.dbPath);
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, SearchDatabaseManager.sanitizeQuery(q) + "*");
            stmt.setInt(2, limit);
            stmt.setInt(3, offset);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String functionName = rs.getString("function_name");
                    String description = rs.getString("function_description");
                    String packageName = rs.getString("package_name");
                    String org = rs.getString("package_org");
                    String version = rs.getString("package_version");
                    SearchResult result = SearchResult.from(org, packageName, version, functionName, description);
                    results.add(result);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.severe("Error searching functions: " + e.getMessage());
            throw new RuntimeException("Failed to search functions", e);
        }
        catch (NumberFormatException e) {
            LOGGER.severe("Invalid number format in query parameters: " + e.getMessage());
            throw new RuntimeException("Invalid limit or offset value", e);
        }
        return results;
    }

    public List<SearchResult> searchConnectors(String q, int limit, int offset) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String sql = "SELECT\n    c.id,\n    c.name AS connector_name,\n    c.description AS connector_description,\n    c.package_id,\n    p.name AS package_name,\n    p.org AS package_org,\n    p.version AS package_version,\n    fts.rank\nFROM ConnectorFTS AS fts\nJOIN Connector AS c ON fts.rowid = c.id\nJOIN Package AS p ON c.package_id = p.id\nWHERE fts.ConnectorFTS MATCH ?\nORDER BY fts.rank\nLIMIT ?\nOFFSET ?;\n";
        try (Connection conn = DriverManager.getConnection(this.dbPath);
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, SearchDatabaseManager.sanitizeQuery(q) + "*");
            stmt.setInt(2, limit);
            stmt.setInt(3, offset);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String connectorName = rs.getString("connector_name");
                    String description = rs.getString("connector_description");
                    String packageName = rs.getString("package_name");
                    String org = rs.getString("package_org");
                    String version = rs.getString("package_version");
                    SearchResult result = SearchResult.from(org, packageName, version, connectorName, description);
                    results.add(result);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.severe("Error searching connectors: " + e.getMessage());
            throw new RuntimeException("Failed to search connectors", e);
        }
        catch (NumberFormatException e) {
            LOGGER.severe("Invalid number format in query parameters: " + e.getMessage());
            throw new RuntimeException("Invalid limit or offset value", e);
        }
        return results;
    }

    public List<SearchResult> searchFunctionsByPackages(List<String> packageNames, List<String> functionNames, int limit, int offset) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ").append("f.name AS function_name, ").append("f.description AS function_description, ").append("f.package_id, ").append("p.name AS package_name, ").append("p.org AS package_org, ").append("p.version AS package_version ").append("FROM Package p ").append("JOIN Function f ON p.id = f.package_id");
        boolean whereAdded = false;
        if (!packageNames.isEmpty()) {
            sqlBuilder.append(" WHERE p.name IN (").append(String.join((CharSequence)",", Collections.nCopies(packageNames.size(), "?"))).append(")");
            whereAdded = true;
        }
        if (!functionNames.isEmpty()) {
            sqlBuilder.append(whereAdded ? " AND" : " WHERE").append(" f.name IN (").append(String.join((CharSequence)",", Collections.nCopies(functionNames.size(), "?"))).append(")");
        }
        sqlBuilder.append(" LIMIT ? OFFSET ?");
        try (Connection conn = DriverManager.getConnection(this.dbPath);
             PreparedStatement stmt = conn.prepareStatement(sqlBuilder.toString());){
            int paramIndex = 1;
            for (String packageName : packageNames) {
                stmt.setString(paramIndex++, packageName);
            }
            for (String functionName : functionNames) {
                stmt.setString(paramIndex++, functionName);
            }
            stmt.setInt(paramIndex++, limit);
            stmt.setInt(paramIndex, offset);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("function_name");
                    String description = rs.getString("function_description");
                    String org = rs.getString("package_org");
                    String pkgName = rs.getString("package_name");
                    String version = rs.getString("package_version");
                    SearchResult.Package packageInfo = new SearchResult.Package(org, pkgName, version);
                    results.add(SearchResult.from(packageInfo, name, description));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.severe("Error searching functions: " + e.getMessage());
            throw new RuntimeException("Failed to search functions", e);
        }
        return results;
    }

    public List<SearchResult> searchConnectorsByPackage(List<String> packageConnectorMap, int limit, int offset) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ").append("c.name AS connector_name, ").append("c.description AS connector_description, ").append("c.package_id, ").append("p.name AS package_name, ").append("p.org AS package_org, ").append("p.version AS package_version ").append("FROM Package p ").append("JOIN Connector c ON p.id = c.package_id");
        if (!packageConnectorMap.isEmpty()) {
            sqlBuilder.append(" WHERE (");
            for (int i = 0; i < packageConnectorMap.size(); ++i) {
                if (i > 0) {
                    sqlBuilder.append(" OR ");
                }
                sqlBuilder.append("(p.name = ? AND c.name = ?)");
            }
            sqlBuilder.append(")");
        }
        sqlBuilder.append(" LIMIT ? OFFSET ?");
        try (Connection conn = DriverManager.getConnection(this.dbPath);
             PreparedStatement stmt = conn.prepareStatement(sqlBuilder.toString());){
            int paramIndex = 1;
            for (String mapping : packageConnectorMap) {
                String[] mappingTuple = mapping.split(":");
                stmt.setString(paramIndex++, mappingTuple[0]);
                stmt.setString(paramIndex++, mappingTuple[1]);
            }
            stmt.setInt(paramIndex++, limit);
            stmt.setInt(paramIndex, offset);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("connector_name");
                    String description = rs.getString("connector_description");
                    String org = rs.getString("package_org");
                    String pkgName = rs.getString("package_name");
                    String version = rs.getString("package_version");
                    SearchResult.Package packageInfo = new SearchResult.Package(org, pkgName, version);
                    results.add(SearchResult.from(packageInfo, name, description));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.severe("Error searching connectors: " + e.getMessage());
            throw new RuntimeException("Failed to search connectors", e);
        }
        return results;
    }

    public List<SearchResult> searchTypes(String q, int limit, int offset) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String sql = "SELECT\n    t.id,\n    t.name AS type_name,\n    t.description AS type_description,\n    t.package_id,\n    p.name AS package_name,\n    p.org AS package_org,\n    p.version AS package_version,\n    fts.rank\nFROM TypeFTS AS fts\nJOIN Type AS t ON fts.rowid = t.id\nJOIN Package AS p ON t.package_id = p.id\nWHERE fts.TypeFTS MATCH ?\nORDER BY fts.rank\nLIMIT ?\nOFFSET ?;\n";
        try (Connection conn = DriverManager.getConnection(this.dbPath);
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, SearchDatabaseManager.sanitizeQuery(q) + "*");
            stmt.setInt(2, limit);
            stmt.setInt(3, offset);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String typeName = rs.getString("type_name");
                    String description = rs.getString("type_description");
                    String packageName = rs.getString("package_name");
                    String org = rs.getString("package_org");
                    String version = rs.getString("package_version");
                    SearchResult result = SearchResult.from(org, packageName, version, typeName, description);
                    results.add(result);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.severe("Error searching types: " + e.getMessage());
            throw new RuntimeException("Failed to search types", e);
        }
        catch (NumberFormatException e) {
            LOGGER.severe("Invalid number format in query parameters: " + e.getMessage());
            throw new RuntimeException("Invalid limit or offset value", e);
        }
        return results;
    }

    public List<SearchResult> searchTypesByPackages(List<String> packageNames, int limit, int offset) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT ").append("t.name AS type_name, ").append("t.description AS type_description, ").append("t.package_id, ").append("p.name AS package_name, ").append("p.org AS package_org, ").append("p.version AS package_version ").append("FROM Package p ").append("JOIN Type t ON p.id = t.package_id");
        sqlBuilder.append(" WHERE p.name IN (").append(String.join((CharSequence)",", Collections.nCopies(packageNames.size(), "?"))).append(")");
        sqlBuilder.append(" LIMIT ? OFFSET ?");
        try (Connection conn = DriverManager.getConnection(this.dbPath);
             PreparedStatement stmt = conn.prepareStatement(sqlBuilder.toString());){
            int paramIndex = 1;
            for (String packageName : packageNames) {
                stmt.setString(paramIndex++, packageName);
            }
            stmt.setInt(paramIndex++, limit);
            stmt.setInt(paramIndex, offset);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("type_name");
                    String description = rs.getString("type_description");
                    String org = rs.getString("package_org");
                    String pkgName = rs.getString("package_name");
                    String version = rs.getString("package_version");
                    SearchResult.Package packageInfo = new SearchResult.Package(org, pkgName, version);
                    results.add(SearchResult.from(packageInfo, name, description));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.severe("Error searching types: " + e.getMessage());
            throw new RuntimeException("Failed to search types", e);
        }
        return results;
    }

    private static String sanitizeQuery(String q) {
        if (q == null || q.trim().isEmpty()) {
            return "";
        }
        return q.replaceAll("(?i)\\b(UNION|SELECT|FROM|OR|AND|WHERE|MATCH|NEAR|NOT)\\b|[^a-zA-Z0-9\\s]", " ").trim();
    }

    private static class Holder {
        private static final SearchDatabaseManager INSTANCE = new SearchDatabaseManager();

        private Holder() {
        }
    }
}

