/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives.io;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileUtils {
    private FileUtils() {
    }

    public static void writeContent(BString targetPath, BString content) throws Exception {
        Pattern pattern = Pattern.compile("[\n\t]");
        Matcher matcher = pattern.matcher(content.getValue());
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            switch (matcher.group()) {
                case "\n": {
                    matcher.appendReplacement(stringBuilder, "\\\\n");
                    break;
                }
                case "\t": {
                    matcher.appendReplacement(stringBuilder, "\\\\t");
                }
            }
        }
        matcher.appendTail(stringBuilder);
        File jsonFile = new File(Path.of(targetPath.getValue(), new String[0]).toString());
        jsonFile.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(jsonFile);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            writer.write(new String(stringBuilder.toString().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            ((Writer)writer).flush();
        }
    }

    public static BString readContent(BString targetPath) {
        if (FileUtils.fileExists(targetPath)) {
            try {
                String readString = Files.readString(Path.of(targetPath.getValue(), new String[0]));
                return StringUtils.fromString((String)readString);
            }
            catch (IOException e) {
                throw ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.OPERATION_NOT_SUPPORTED_ERROR, (Object[])new Object[0]);
            }
        }
        throw ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.OPERATION_NOT_SUPPORTED_ERROR, (Object[])new Object[0]);
    }

    public static boolean fileExists(BString filePath) {
        return Files.exists(Path.of(filePath.getValue(), new String[0]), new LinkOption[0]);
    }
}

