/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api;

import java.util.Objects;

public class Module {
    private final String org;
    private final String name;
    private final String majorVersion;
    private final boolean isTestPkg;
    private final int hashCode;

    public Module(String org, String name, String majorVersion, boolean isTestPkg) {
        this.org = org;
        this.name = name;
        this.majorVersion = majorVersion;
        this.isTestPkg = isTestPkg;
        this.hashCode = Objects.hash(org, name, majorVersion);
    }

    public Module(String org, String name, String majorVersion) {
        this(org, name, majorVersion, false);
    }

    public Module(String org, String name) {
        this(org, name, "", false);
    }

    public String getOrg() {
        return this.org;
    }

    public String getName() {
        return this.name;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public boolean isTestPkg() {
        return this.isTestPkg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module bPackage = (Module)o;
        return Objects.equals(this.org, bPackage.org) && Objects.equals(this.name, bPackage.name) && Objects.equals(this.majorVersion, bPackage.majorVersion);
    }

    public String toString() {
        if (".".equals(this.name)) {
            return this.name;
        }
        Object orgName = "";
        if (this.org != null && !this.org.equals("$anon")) {
            orgName = this.org + "/";
        }
        if (this.majorVersion == null || this.majorVersion.equals("")) {
            return (String)orgName + this.name;
        }
        return (String)orgName + this.name + ":" + this.majorVersion;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

