/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

public final class BasicTypeCode {
    public static final int CODE_NIL = 0;
    public static final int CODE_BOOLEAN = 1;
    public static final int CODE_INT = 2;
    public static final int CODE_FLOAT = 3;
    public static final int CODE_DECIMAL = 4;
    public static final int CODE_STRING = 5;
    public static final int CODE_ERROR = 6;
    public static final int CODE_TYPEDESC = 7;
    public static final int CODE_HANDLE = 8;
    public static final int CODE_FUNCTION = 9;
    public static final int CODE_REGEXP = 10;
    public static final int CODE_FUTURE = 11;
    public static final int CODE_STREAM = 12;
    public static final int CODE_LIST = 13;
    public static final int CODE_MAPPING = 14;
    public static final int CODE_TABLE = 15;
    public static final int CODE_XML = 16;
    public static final int CODE_OBJECT = 17;
    public static final int CODE_CELL = 18;
    public static final int CODE_UNDEF = 19;
    public static final BasicTypeCode BT_NIL = BasicTypeCode.get(0);
    public static final BasicTypeCode BT_BOOLEAN = BasicTypeCode.get(1);
    public static final BasicTypeCode BT_INT = BasicTypeCode.get(2);
    public static final BasicTypeCode BT_FLOAT = BasicTypeCode.get(3);
    public static final BasicTypeCode BT_DECIMAL = BasicTypeCode.get(4);
    public static final BasicTypeCode BT_STRING = BasicTypeCode.get(5);
    public static final BasicTypeCode BT_ERROR = BasicTypeCode.get(6);
    public static final BasicTypeCode BT_TYPEDESC = BasicTypeCode.get(7);
    public static final BasicTypeCode BT_HANDLE = BasicTypeCode.get(8);
    public static final BasicTypeCode BT_FUNCTION = BasicTypeCode.get(9);
    public static final BasicTypeCode BT_REGEXP = BasicTypeCode.get(10);
    public static final BasicTypeCode BT_FUTURE = BasicTypeCode.get(11);
    public static final BasicTypeCode BT_STREAM = BasicTypeCode.get(12);
    public static final BasicTypeCode BT_LIST = BasicTypeCode.get(13);
    public static final BasicTypeCode BT_MAPPING = BasicTypeCode.get(14);
    public static final BasicTypeCode BT_TABLE = BasicTypeCode.get(15);
    public static final BasicTypeCode BT_XML = BasicTypeCode.get(16);
    public static final BasicTypeCode BT_OBJECT = BasicTypeCode.get(17);
    public static final BasicTypeCode BT_CELL = BasicTypeCode.get(18);
    public static final BasicTypeCode BT_UNDEF = BasicTypeCode.get(19);
    static final int VT_COUNT = 18;
    public static final int BASIC_TYPE_MASK = 63;
    public static final int VT_MASK = 262143;
    static final int VT_COUNT_INHERENTLY_IMMUTABLE = 11;
    public static final int VT_INHERENTLY_IMMUTABLE = 2047;
    private final int code;

    private BasicTypeCode(int code) {
        this.code = code;
    }

    public static BasicTypeCode get(int code) {
        if (BasicTypeCodeCache.isCached(code)) {
            return BasicTypeCodeCache.cache[code];
        }
        return new BasicTypeCode(code);
    }

    public int code() {
        return this.code;
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicTypeCode) {
            BasicTypeCode other = (BasicTypeCode)obj;
            return this.code == other.code;
        }
        return false;
    }

    private static final class BasicTypeCodeCache {
        private static final BasicTypeCode[] cache = new BasicTypeCode[21];

        private BasicTypeCodeCache() {
        }

        private static boolean isCached(int code) {
            return 0 < code && code < 18;
        }

        static {
            for (int i = 0; i < 20; ++i) {
                BasicTypeCodeCache.cache[i] = new BasicTypeCode(i);
            }
        }
    }
}

