/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.toml;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectableReferenceType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.types.BAnydataType;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlDoubleValueNodeNode;
import io.ballerina.toml.semantic.ast.TomlInlineTableValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Utils {
    private static final Type TYPE_READONLY_ANYDATA_INTERSECTION = new BIntersectionType(null, new Type[]{PredefinedTypes.TYPE_READONLY_ANYDATA}, (IntersectableReferenceType)((Object)PredefinedTypes.TYPE_READONLY_ANYDATA), 0, true);

    private Utils() {
    }

    static Object getTomlTypeString(TomlNode tomlNode) {
        return switch (tomlNode.kind()) {
            case TomlType.STRING -> "string";
            case TomlType.INTEGER -> "int";
            case TomlType.DOUBLE -> "float";
            case TomlType.BOOLEAN -> "boolean";
            case TomlType.ARRAY -> "array";
            case TomlType.TABLE, TomlType.INLINE_TABLE -> "record";
            case TomlType.TABLE_ARRAY -> "table";
            case TomlType.KEY_VALUE -> Utils.getTomlTypeString((TomlNode)((TomlKeyValueNode)tomlNode).value());
            default -> "unsupported type";
        };
    }

    static Object getBalValueFromToml(TomlNode tomlNode, Set<TomlNode> visitedNodes, BUnionType unionType, Set<LineRange> invalidTomlLines, String variableName) {
        visitedNodes.add(tomlNode);
        return switch (tomlNode.kind()) {
            case TomlType.STRING -> Utils.validateAndGetStringValue((TomlStringValueNode)tomlNode, unionType, invalidTomlLines, variableName);
            case TomlType.INTEGER -> (Long)((TomlLongValueNode)tomlNode).getValue();
            case TomlType.DOUBLE -> Utils.validateAndGetDoubleValue((TomlDoubleValueNodeNode)tomlNode, unionType, invalidTomlLines, variableName);
            case TomlType.BOOLEAN -> (Boolean)((TomlBooleanValueNode)tomlNode).getValue();
            case TomlType.KEY_VALUE -> Utils.getBalValueFromToml((TomlNode)((TomlKeyValueNode)tomlNode).value(), visitedNodes, unionType, invalidTomlLines, variableName);
            case TomlType.ARRAY -> Utils.getAnydataArray((TomlArrayValueNode)tomlNode, visitedNodes, invalidTomlLines, variableName);
            case TomlType.TABLE -> Utils.getAnydataMap((TomlTableNode)tomlNode, visitedNodes, invalidTomlLines, variableName);
            case TomlType.TABLE_ARRAY -> Utils.getMapAnydataArray((TomlTableArrayNode)tomlNode, visitedNodes, invalidTomlLines, variableName);
            case TomlType.INLINE_TABLE -> Utils.getAnydataMap(((TomlInlineTableValueNode)tomlNode).toTable(), visitedNodes, invalidTomlLines, variableName);
            default -> null;
        };
    }

    private static Object getAnydataMap(TomlTableNode tomlNode, Set<TomlNode> visitedNodes, Set<LineRange> invalidTomlLines, String variableName) {
        BMapInitialValueEntry[] initialValues = new BMapInitialValueEntry[tomlNode.entries().size()];
        int count = 0;
        for (Map.Entry entry : tomlNode.entries().entrySet()) {
            initialValues[count++] = ValueCreator.createKeyFieldEntry(StringUtils.fromString((String)entry.getKey()), Utils.getBalValueFromToml((TomlNode)entry.getValue(), visitedNodes, (BAnydataType)PredefinedTypes.TYPE_READONLY_ANYDATA, invalidTomlLines, variableName));
        }
        return ValueCreator.createMapValue(TypeCreator.createMapType(TYPE_READONLY_ANYDATA_INTERSECTION, true), initialValues);
    }

    private static Object getAnydataArray(TomlArrayValueNode tomlNode, Set<TomlNode> visitedNodes, Set<LineRange> invalidTomlLines, String variableName) {
        BListInitialValueEntry[] arrayValues = new ListInitialValueEntry[tomlNode.elements().size()];
        List elements = tomlNode.elements();
        int count = 0;
        for (TomlValueNode tomlValueNode : elements) {
            arrayValues[count++] = new ListInitialValueEntry.ExpressionEntry(Utils.getBalValueFromToml((TomlNode)tomlValueNode, visitedNodes, (BAnydataType)PredefinedTypes.TYPE_READONLY_ANYDATA, invalidTomlLines, variableName));
        }
        return new ArrayValueImpl((Type)TypeCreator.createArrayType(TYPE_READONLY_ANYDATA_INTERSECTION, true), arrayValues);
    }

    private static Object getMapAnydataArray(TomlTableArrayNode tomlNode, Set<TomlNode> visitedNodes, Set<LineRange> invalidTomlLines, String variableName) {
        BListInitialValueEntry[] arrayValues = new ListInitialValueEntry[tomlNode.children().size()];
        List elements = tomlNode.children();
        int count = 0;
        for (TomlTableNode tomlValueNode : elements) {
            arrayValues[count++] = new ListInitialValueEntry.ExpressionEntry(Utils.getBalValueFromToml((TomlNode)tomlValueNode, visitedNodes, (BAnydataType)PredefinedTypes.TYPE_READONLY_ANYDATA, invalidTomlLines, variableName));
        }
        return new ArrayValueImpl((Type)TypeCreator.createArrayType((Type)TypeCreator.createMapType(TYPE_READONLY_ANYDATA_INTERSECTION), true), arrayValues);
    }

    static boolean checkEffectiveTomlType(TomlType kind, Type expectedType, String variableName) {
        return switch (expectedType.getTag()) {
            case 1, 2 -> {
                if (kind == TomlType.INTEGER) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (kind == TomlType.BOOLEAN) {
                    yield true;
                }
                yield false;
            }
            case 3, 4 -> {
                if (kind == TomlType.INTEGER || kind == TomlType.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case 5, 16, 18, 19, 20, 21, 33, 40 -> {
                if (kind == TomlType.STRING) {
                    yield true;
                }
                yield false;
            }
            case 32, 44 -> {
                if (kind == TomlType.ARRAY) {
                    yield true;
                }
                yield false;
            }
            case 24, 27 -> {
                if (kind == TomlType.INLINE_TABLE || kind == TomlType.TABLE) {
                    yield true;
                }
                yield false;
            }
            case 17 -> {
                if (kind == TomlType.TABLE_ARRAY || kind == TomlType.ARRAY) {
                    yield true;
                }
                yield false;
            }
            case 34 -> {
                Type effectiveType = ((IntersectionType)expectedType).getEffectiveType();
                yield Utils.checkEffectiveTomlType(kind, effectiveType, variableName);
            }
            default -> throw new ConfigException(ErrorCodes.CONFIG_TYPE_NOT_SUPPORTED, variableName, expectedType.toString());
        };
    }

    static boolean isSimpleType(int typeTag) {
        return typeTag <= 6;
    }

    static String getModuleKey(Module module) {
        return module.getOrg() + "." + module.getName();
    }

    static String getLineRange(TomlNode node) {
        if (node.location() == null) {
            return "Config.toml";
        }
        LineRange oneBasedLineRange = Utils.getOneBasedLineRange(node.location().lineRange());
        return oneBasedLineRange.fileName() + ":" + String.valueOf(oneBasedLineRange);
    }

    static LineRange getOneBasedLineRange(LineRange lineRange) {
        return LineRange.from((String)lineRange.fileName(), (LinePosition)LinePosition.from((int)(lineRange.startLine().line() + 1), (int)(lineRange.startLine().offset() + 1)), (LinePosition)LinePosition.from((int)(lineRange.endLine().line() + 1), (int)(lineRange.endLine().offset() + 1)));
    }

    public static Type getTypeFromTomlValue(TomlNode tomlNode) {
        return switch (tomlNode.kind()) {
            case TomlType.STRING -> PredefinedTypes.TYPE_STRING;
            case TomlType.INTEGER -> PredefinedTypes.TYPE_INT;
            case TomlType.DOUBLE -> PredefinedTypes.TYPE_FLOAT;
            case TomlType.BOOLEAN -> PredefinedTypes.TYPE_BOOLEAN;
            case TomlType.KEY_VALUE -> Utils.getTypeFromTomlValue((TomlNode)((TomlKeyValueNode)tomlNode).value());
            case TomlType.ARRAY -> {
                if (Utils.containsInlineTable((TomlArrayValueNode)tomlNode)) {
                    yield TypeCreator.createArrayType((Type)TypeCreator.createMapType(PredefinedTypes.TYPE_ANYDATA), true);
                }
                yield TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANYDATA, true);
            }
            case TomlType.TABLE, TomlType.INLINE_TABLE -> TypeCreator.createMapType(PredefinedTypes.TYPE_ANYDATA, true);
            case TomlType.TABLE_ARRAY -> TypeCreator.createArrayType((Type)TypeCreator.createMapType(PredefinedTypes.TYPE_ANYDATA), true);
            default -> null;
        };
    }

    private static boolean containsInlineTable(TomlArrayValueNode tomlNode) {
        for (TomlValueNode valueNode : tomlNode.elements()) {
            if (valueNode.kind() != TomlType.INLINE_TABLE) continue;
            return true;
        }
        return false;
    }

    public static Field createAdditionalField(RecordType recordType, String fieldName, TomlNode value) {
        Type restFieldType = recordType.getRestFieldType();
        if (!Utils.isAnyDataType(restFieldType)) {
            return TypeCreator.createField(restFieldType, fieldName, 32L);
        }
        return TypeCreator.createField(Utils.getTypeFromTomlValue(value), fieldName, 32L);
    }

    private static Object validateAndGetDoubleValue(TomlDoubleValueNodeNode tomlNode, BUnionType unionType, Set<LineRange> invalidTomlLines, String variableName) {
        boolean hasDecimal = Utils.containsType(unionType, 4);
        boolean hasFloat = Utils.containsType(unionType, 3);
        if (hasDecimal && hasFloat && unionType.getTag() != 23) {
            Utils.throwMemberAmbiguityError(unionType, invalidTomlLines, variableName, (TomlNode)tomlNode);
        }
        Double value = (Double)tomlNode.getValue();
        if (hasFloat) {
            return value;
        }
        return ValueCreator.createDecimalValue(BigDecimal.valueOf(value));
    }

    private static Object validateAndGetFiniteDoubleValue(TomlDoubleValueNodeNode tomlNode, BFiniteType finiteType, Set<LineRange> invalidTomlLines, String variableName) {
        Double value = (Double)tomlNode.getValue();
        boolean decimalValueFound = Utils.checkDoubleValue(finiteType, 4, value);
        boolean floatValueFound = Utils.checkDoubleValue(finiteType, 3, value);
        if (decimalValueFound && floatValueFound) {
            Utils.throwMemberAmbiguityError(finiteType, invalidTomlLines, variableName, (TomlNode)tomlNode);
        }
        if (floatValueFound) {
            return value;
        }
        return ValueCreator.createDecimalValue(BigDecimal.valueOf(value));
    }

    private static boolean checkDoubleValue(BFiniteType type, int tag, double doubleValue) {
        for (Object value : type.getValueSpace()) {
            if (TypeUtils.getImpliedType(TypeChecker.getType(value)).getTag() != tag) continue;
            if (tag == 4) {
                return doubleValue == ((DecimalValue)value).floatValue();
            }
            return doubleValue == (Double)value;
        }
        return false;
    }

    private static Object validateAndGetStringValue(TomlStringValueNode tomlNode, BUnionType unionType, Set<LineRange> invalidTomlLines, String variableName) {
        boolean hasString = Utils.containsType(unionType, 5);
        boolean hasXml = Utils.containsXMLType(unionType);
        if (hasString && hasXml && unionType.getTag() != 23) {
            Utils.throwMemberAmbiguityError(unionType, invalidTomlLines, variableName, (TomlNode)tomlNode);
        }
        String value = (String)tomlNode.getValue();
        if (hasString || SymbolFlags.isFlagOn(unionType.getFlags(), 0x200000000L) || Utils.containsType(unionType, 46)) {
            return StringUtils.fromString(value);
        }
        return ValueUtils.createReadOnlyXmlValue(value);
    }

    private static void throwMemberAmbiguityError(Type type, Set<LineRange> invalidTomlLines, String variableName, TomlNode tomlNode) {
        invalidTomlLines.add(tomlNode.location().lineRange());
        throw new ConfigException(ErrorCodes.CONFIG_UNION_VALUE_AMBIGUOUS_TARGET, Utils.getLineRange(tomlNode), variableName, io.ballerina.identifier.Utils.decodeIdentifier((String)type.toString()));
    }

    private static boolean containsType(BUnionType unionType, int tag) {
        for (Type type : unionType.getMemberTypes()) {
            Type effectiveType = Utils.getEffectiveType(type);
            int typeTag = effectiveType.getTag();
            if (typeTag == 46) {
                for (Object obj : ((FiniteType)effectiveType).getValueSpace()) {
                    if (TypeUtils.getImpliedType(TypeChecker.getType(obj)).getTag() != tag) continue;
                    return true;
                }
            }
            if (typeTag != tag) continue;
            return true;
        }
        return false;
    }

    private static boolean containsXMLType(BUnionType unionType) {
        for (Type type : unionType.getMemberTypes()) {
            if (!Utils.isXMLType(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnyDataType(Type restFieldType) {
        return Utils.getEffectiveType(restFieldType).getTag() == 23;
    }

    static boolean isXMLType(Type type) {
        return TypeTags.isXMLTypeTag(Utils.getEffectiveType(type).getTag());
    }

    static Type getEffectiveType(Type type) {
        return switch (type.getTag()) {
            case 34 -> ((IntersectionType)type).getEffectiveType();
            case 53 -> Utils.getEffectiveType(((ReferenceType)type).getReferredType());
            default -> type;
        };
    }

    private static boolean isMappingType(int typeTag) {
        return typeTag == 27 || typeTag == 24;
    }

    static boolean containsMapType(List<Type> memberTypes) {
        for (Type type : memberTypes) {
            if (!Utils.isMappingType(Utils.getEffectiveType(type).getTag())) continue;
            return true;
        }
        return false;
    }

    public static Object getFiniteBalValue(TomlNode tomlNode, Set<TomlNode> visitedNodes, BFiniteType finiteType, Set<LineRange> invalidTomlLines, String variableName) {
        visitedNodes.add(tomlNode);
        return switch (tomlNode.kind()) {
            case TomlType.STRING -> StringUtils.fromString((String)((TomlStringValueNode)tomlNode).getValue());
            case TomlType.INTEGER -> {
                Long val = (Long)((TomlLongValueNode)tomlNode).getValue();
                if (TypeUtils.getType(val).getTag() == 1) {
                    yield val.intValue();
                }
                yield val;
            }
            case TomlType.DOUBLE -> Utils.validateAndGetFiniteDoubleValue((TomlDoubleValueNodeNode)tomlNode, finiteType, invalidTomlLines, variableName);
            case TomlType.BOOLEAN -> (Boolean)((TomlBooleanValueNode)tomlNode).getValue();
            case TomlType.KEY_VALUE -> Utils.getFiniteBalValue((TomlNode)((TomlKeyValueNode)tomlNode).value(), visitedNodes, finiteType, invalidTomlLines, variableName);
            default -> null;
        };
    }

    static Type getTupleElementType(List<Type> tupleTypes, int i, TupleType tupleType) {
        Type restType = tupleType.getRestType();
        if (i >= tupleTypes.size() && restType != null) {
            return restType;
        }
        return tupleTypes.get(i);
    }

    static TomlNode getValueFromKeyValueNode(TomlNode value) {
        if (value.kind() == TomlType.KEY_VALUE) {
            return ((TomlKeyValueNode)value).value();
        }
        return value;
    }
}

