/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.clauses;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class Collect
implements QueryClause {
    private final BArray nonGroupingKeys;
    private final BFunctionPointer collectFunc;
    private final Environment env;
    private final ArrayType arrayType = TypeCreator.createArrayType(TypeCreator.createUnionType(List.of(PredefinedTypes.TYPE_ANY, PredefinedTypes.TYPE_ERROR)));

    private Collect(Environment env, BArray nonGroupingKeys, BFunctionPointer collectFunc) {
        this.nonGroupingKeys = nonGroupingKeys;
        this.collectFunc = collectFunc;
        this.env = env;
    }

    public static Collect initCollectClause(Environment env, BArray nonGroupingKeys, BFunctionPointer collectFunc) {
        return new Collect(env, nonGroupingKeys, collectFunc);
    }

    @Override
    public Stream<BMap<BString, Object>> process(Stream<BMap<BString, Object>> inputStream) {
        BMap<BString, Object> groupedRecord = ValueCreator.createMapValue();
        for (int i = 0; i < this.nonGroupingKeys.size(); ++i) {
            BString key = (BString)this.nonGroupingKeys.get(i);
            groupedRecord.put(key, new ArrayValueImpl(this.arrayType));
        }
        inputStream.forEach(frame -> {
            for (int i = 0; i < this.nonGroupingKeys.size(); ++i) {
                BString key = (BString)this.nonGroupingKeys.get(i);
                if (!frame.containsKey(key) || frame.get(key) == null) continue;
                BArray existingValues = (BArray)groupedRecord.get(key);
                existingValues.append(frame.get(key));
            }
        });
        return Stream.of(groupedRecord).map(frame -> {
            Object result;
            Object object = result = this.collectFunc.call(this.env.getRuntime(), groupedRecord);
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BError.class, BMap.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    BError error = (BError)selector0$temp;
                    throw error;
                }
                case 1 -> {
                    BMap map;
                    yield map = (BMap)selector0$temp;
                }
                default -> frame;
            };
        });
    }
}

