/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.query.pipeline;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.query.clauses.QueryClause;
import io.ballerina.runtime.internal.query.utils.IteratorUtils;
import io.ballerina.runtime.internal.query.utils.QueryException;
import io.ballerina.runtime.internal.values.ErrorValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class StreamPipeline {
    private Stream<BMap<BString, Object>> stream;
    private final List<QueryClause> clauseList;
    private final BTypedesc constraintType;
    private final BTypedesc completionType;
    private final boolean isLazyLoading;
    private final Environment env;
    private final Iterator<?> itr;

    private StreamPipeline(Environment env, Object collection, BTypedesc constraintType, BTypedesc completionType, boolean isLazyLoading) {
        this.env = env;
        this.clauseList = new ArrayList<QueryClause>();
        this.constraintType = constraintType;
        this.completionType = completionType;
        this.isLazyLoading = isLazyLoading;
        this.itr = IteratorUtils.getIterator(env, collection);
        this.stream = this.initializeFrameStream(this.itr);
    }

    public static Object initStreamPipeline(Environment env, Object collection, BTypedesc constraintType, BTypedesc completionType, boolean isLazyLoading) {
        try {
            return new StreamPipeline(env, collection, constraintType, completionType, isLazyLoading);
        }
        catch (ErrorValue e) {
            return e;
        }
    }

    public static void addStreamFunction(StreamPipeline streamPipeline, QueryClause clause) {
        streamPipeline.addStage(clause);
    }

    public static Object getStreamFromPipeline(StreamPipeline pipeline) {
        try {
            pipeline.execute();
        }
        catch (QueryException e) {
            return e.getError();
        }
        return pipeline;
    }

    public void addStage(QueryClause clause) {
        this.clauseList.add(clause);
    }

    public void execute() {
        for (QueryClause clause : this.clauseList) {
            this.stream = clause.process(this.stream);
        }
    }

    private Stream<BMap<BString, Object>> initializeFrameStream(Iterator<?> itr) throws ErrorValue {
        return IteratorUtils.toStream(itr);
    }

    public void reset() {
    }

    public BTypedesc getConstraintType() {
        return this.constraintType;
    }

    public BTypedesc getCompletionType() {
        return this.completionType;
    }

    public Stream<BMap<BString, Object>> getStream() {
        return this.stream;
    }
}

