/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.regexp;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.regexp.CharReader;
import io.ballerina.runtime.internal.regexp.ParserMode;
import io.ballerina.runtime.internal.regexp.Token;
import io.ballerina.runtime.internal.regexp.TokenKind;
import java.util.ArrayDeque;

public class TreeTraverser {
    private final CharReader reader;
    private ParserMode mode;
    private final ArrayDeque<ParserMode> modeStack = new ArrayDeque();

    public TreeTraverser(CharReader charReader) {
        this.reader = charReader;
        this.mode = ParserMode.RE_DISJUNCTION;
        this.modeStack.add(this.mode);
    }

    public Token nextToken() {
        return switch (this.mode) {
            case ParserMode.RE_DISJUNCTION -> this.readTokenInReDisjunction();
            case ParserMode.RE_UNICODE_PROP_ESCAPE, ParserMode.RE_UNICODE_GENERAL_CATEGORY_NAME -> this.readTokenInReUnicodePropertyEscape();
            case ParserMode.RE_UNICODE_PROPERTY_VALUE -> this.readTokenInReUnicodePropertyValue();
            default -> null;
        };
    }

    private Token readTokenInReDisjunction() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getRegExpToken(TokenKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        this.reader.advance();
        return switch (nextChar) {
            case 94 -> this.getRegExpToken(TokenKind.BITWISE_XOR_TOKEN);
            case 36 -> this.getRegExpToken(TokenKind.DOLLAR_TOKEN);
            case 46 -> this.getRegExpToken(TokenKind.DOT_TOKEN);
            case 42 -> this.getRegExpToken(TokenKind.ASTERISK_TOKEN);
            case 43 -> this.getRegExpToken(TokenKind.PLUS_TOKEN);
            case 63 -> this.getRegExpToken(TokenKind.QUESTION_MARK_TOKEN);
            case 92 -> this.processEscape();
            case 91 -> this.getRegExpToken(TokenKind.OPEN_BRACKET_TOKEN);
            case 93 -> this.getRegExpToken(TokenKind.CLOSE_BRACKET_TOKEN);
            case 123 -> this.getRegExpToken(TokenKind.OPEN_BRACE_TOKEN);
            case 125 -> this.getRegExpToken(TokenKind.CLOSE_BRACE_TOKEN);
            case 40 -> this.getRegExpToken(TokenKind.OPEN_PAREN_TOKEN);
            case 41 -> this.getRegExpToken(TokenKind.CLOSE_PAREN_TOKEN);
            case 44 -> this.getRegExpToken(TokenKind.COMMA_TOKEN);
            case 45 -> this.getRegExpToken(TokenKind.MINUS_TOKEN);
            case 58 -> this.getRegExpToken(TokenKind.COLON_TOKEN);
            case 124 -> this.getRegExpToken(TokenKind.PIPE_TOKEN);
            default -> TreeTraverser.isDigit(nextChar) ? this.getRegExpText(TokenKind.DIGIT) : this.getRegExpText(TokenKind.RE_LITERAL_CHAR);
        };
    }

    private Token readTokenInReUnicodePropertyEscape() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getRegExpToken(TokenKind.EOF_TOKEN);
        }
        int nextChar = this.peek();
        switch (nextChar) {
            case 80: 
            case 112: {
                if (this.mode == ParserMode.RE_UNICODE_GENERAL_CATEGORY_NAME) break;
                this.reader.advance();
                return this.getRegExpText(TokenKind.RE_PROPERTY);
            }
            case 123: {
                this.reader.advance();
                this.switchMode(ParserMode.RE_UNICODE_GENERAL_CATEGORY_NAME);
                return this.getRegExpToken(TokenKind.OPEN_BRACE_TOKEN);
            }
            case 115: {
                if (this.reader.peek(1) != 'c' || this.reader.peek(2) != '=') break;
                this.reader.advance(3);
                this.switchMode(ParserMode.RE_UNICODE_PROPERTY_VALUE);
                return this.getRegExpText(TokenKind.RE_UNICODE_SCRIPT_START);
            }
            case 103: {
                if (this.reader.peek(1) != 'c' || this.reader.peek(2) != '=') break;
                this.reader.advance(3);
                return this.getRegExpText(TokenKind.RE_UNICODE_GENERAL_CATEGORY_START);
            }
            case 125: {
                this.reader.advance();
                this.endMode();
                return this.getRegExpToken(TokenKind.CLOSE_BRACE_TOKEN);
            }
        }
        return this.processReUnicodeGeneralCategoryAbbr();
    }

    private Token processReUnicodeGeneralCategoryAbbr() {
        switch (this.peek()) {
            case 76: {
                this.reader.advance();
                this.processAbbrWithLetter();
                break;
            }
            case 77: {
                this.reader.advance();
                this.processAbbrWithMark();
                break;
            }
            case 78: {
                this.reader.advance();
                this.processAbbrWithNumber();
                break;
            }
            case 83: {
                this.reader.advance();
                this.processAbbrWithSymbol();
                break;
            }
            case 80: {
                this.reader.advance();
                this.processAbbrWithPunctuation();
                break;
            }
            case 90: {
                this.reader.advance();
                this.processAbbrWithSeparator();
                break;
            }
            case 67: {
                this.reader.advance();
                this.processAbbrWithOther();
                break;
            }
            default: {
                while (!this.isEndOfUnicodePropertyEscape()) {
                    this.reader.advance();
                }
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_GENERAL_CATEGORY_VALUE.messageKey(), this.getMarkedChars()));
            }
        }
        return this.getRegExpText(TokenKind.RE_UNICODE_GENERAL_CATEGORY_NAME);
    }

    private void processAbbrWithLetter() {
        switch (this.peek()) {
            case 108: 
            case 109: 
            case 111: 
            case 116: 
            case 117: {
                this.reader.advance();
                break;
            }
            default: {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_GENERAL_CATEGORY_VALUE.messageKey(), this.getMarkedChars()));
            }
        }
    }

    private void processAbbrWithMark() {
        switch (this.peek()) {
            case 99: 
            case 101: 
            case 110: {
                this.reader.advance();
                break;
            }
            default: {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_GENERAL_CATEGORY_VALUE.messageKey(), this.getMarkedChars()));
            }
        }
    }

    private void processAbbrWithNumber() {
        switch (this.peek()) {
            case 100: 
            case 108: 
            case 111: {
                this.reader.advance();
                break;
            }
            default: {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_GENERAL_CATEGORY_VALUE.messageKey(), this.getMarkedChars()));
            }
        }
    }

    private void processAbbrWithSymbol() {
        switch (this.peek()) {
            case 99: 
            case 107: 
            case 109: 
            case 111: {
                this.reader.advance();
                break;
            }
            default: {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_GENERAL_CATEGORY_VALUE.messageKey(), this.getMarkedChars()));
            }
        }
    }

    private void processAbbrWithPunctuation() {
        switch (this.peek()) {
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 111: 
            case 115: {
                this.reader.advance();
                break;
            }
            default: {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_GENERAL_CATEGORY_VALUE.messageKey(), this.getMarkedChars()));
            }
        }
    }

    private void processAbbrWithSeparator() {
        switch (this.peek()) {
            case 108: 
            case 112: 
            case 115: {
                this.reader.advance();
                break;
            }
            default: {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_GENERAL_CATEGORY_VALUE.messageKey(), this.getMarkedChars()));
            }
        }
    }

    private void processAbbrWithOther() {
        switch (this.peek()) {
            case 99: 
            case 102: 
            case 110: 
            case 111: {
                this.reader.advance();
                break;
            }
            default: {
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_GENERAL_CATEGORY_VALUE.messageKey(), this.getMarkedChars()));
            }
        }
    }

    private Token readTokenInReUnicodePropertyValue() {
        this.reader.mark();
        if (this.reader.isEOF()) {
            return this.getRegExpToken(TokenKind.EOF_TOKEN);
        }
        this.processReUnicodePropertyValue();
        this.endMode();
        if (this.peek() == 125) {
            this.startMode(ParserMode.RE_UNICODE_PROP_ESCAPE);
        }
        return this.getRegExpText(TokenKind.RE_UNICODE_PROPERTY_VALUE);
    }

    private void processReUnicodePropertyValue() {
        if (!this.isReUnicodePropertyValueChar(this.peek())) {
            this.reader.advance();
            throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_PROPERTY_VALUE.messageKey(), this.getMarkedChars()));
        }
        while (!this.isEndOfUnicodePropertyEscape()) {
            if (!this.isReUnicodePropertyValueChar(this.peek())) {
                this.reader.advance();
                throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_UNICODE_PROPERTY_VALUE.messageKey(), this.getMarkedChars()));
            }
            this.reader.advance();
        }
    }

    private boolean isEndOfUnicodePropertyEscape() {
        return this.peek() == 125 || this.reader.isEOF();
    }

    private boolean isReUnicodePropertyValueChar(int nextChar) {
        return TreeTraverser.isDigit(nextChar) || this.isAsciiLetter(nextChar) || nextChar == 95;
    }

    private static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private boolean isAsciiLetter(int nextChar) {
        return 65 <= nextChar && nextChar <= 90 || 97 <= nextChar && nextChar <= 122;
    }

    private Token processEscape() {
        switch (this.peek()) {
            case 117: {
                if (this.reader.peek(1) != '{') break;
                this.processNumericEscape();
                return this.getRegExpText(TokenKind.RE_NUMERIC_ESCAPE);
            }
            case 110: 
            case 114: 
            case 116: {
                this.reader.advance();
                return this.getRegExpText(TokenKind.RE_CONTROL_ESCAPE);
            }
            case 80: 
            case 112: {
                this.startMode(ParserMode.RE_UNICODE_PROP_ESCAPE);
                break;
            }
        }
        return this.getRegExpToken(TokenKind.BACK_SLASH_TOKEN);
    }

    private void processNumericEscape() {
        this.reader.advance(2);
        if (!TreeTraverser.isHexDigit(this.reader.peek())) {
            throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_INVALID_HEX_DIGIT.messageKey(), new Object[0]));
        }
        this.reader.advance();
        while (TreeTraverser.isHexDigit(this.reader.peek())) {
            this.reader.advance();
        }
        if (this.reader.peek() != '}') {
            throw ErrorCreator.createError(ErrorHelper.getErrorMessage(ErrorCodes.REGEXP_MISSING_CLOSE_BRACE.messageKey(), new Object[0]));
        }
        this.reader.advance();
    }

    private String getMarkedChars() {
        return this.reader.getMarkedChars();
    }

    private Token getRegExpToken(TokenKind kind) {
        return new Token(kind);
    }

    private Token getRegExpText(TokenKind kind) {
        return new Token(kind, this.getMarkedChars());
    }

    private int peek() {
        return this.reader.peek();
    }

    public void startMode(ParserMode mode) {
        this.mode = mode;
        this.modeStack.push(mode);
    }

    public void switchMode(ParserMode mode) {
        this.modeStack.pop();
        this.mode = mode;
        this.modeStack.push(mode);
    }

    public void endMode() {
        this.modeStack.pop();
        this.mode = this.modeStack.peek();
    }

    private static boolean isReSyntaxChar(int c) {
        return switch (c) {
            case 36, 40, 41, 42, 43, 46, 63, 91, 92, 93, 94, 123, 124, 125 -> true;
            default -> false;
        };
    }

    private static boolean isReSimpleCharClassCode(int c) {
        return switch (c) {
            case 68, 83, 87, 100, 115, 119 -> true;
            default -> false;
        };
    }

    private static boolean isHexDigit(int c) {
        return 97 <= c && c <= 102 || 65 <= c && c <= 70 || TreeTraverser.isDigit(c);
    }
}

